/*
 * Decompiled with CFR 0.152.
 */
package com.JLex;

import com.JLex.CDTrans;
import com.JLex.CSpec;
import com.JLex.CUtility;
import com.JLex.JavaLexBitSet;
import java.util.Vector;

class CMinimize {
    CSpec m_spec;
    Vector m_group;
    int[] m_ingroup;

    CMinimize() {
        this.reset();
    }

    private void reset() {
        this.m_spec = null;
        this.m_group = null;
        this.m_ingroup = null;
    }

    private void set(CSpec spec) {
        CUtility.cuassert(spec != null);
        this.m_spec = spec;
        this.m_group = null;
        this.m_ingroup = null;
    }

    void min_dfa(CSpec spec) {
        this.set(spec);
        this.minimize();
        this.reduce();
        this.reset();
    }

    private void col_copy(int dest, int src) {
        int n = this.m_spec.m_dtrans_vector.size();
        int i = 0;
        while (i < n) {
            CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i);
            dtrans.m_dtrans[dest] = dtrans.m_dtrans[src];
            ++i;
        }
    }

    private void row_copy(int dest, int src) {
        CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(src);
        this.m_spec.m_dtrans_vector.setElementAt(dtrans, dest);
    }

    private boolean col_equiv(int col1, int col2) {
        int n = this.m_spec.m_dtrans_vector.size();
        int i = 0;
        while (i < n) {
            CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i);
            if (dtrans.m_dtrans[col1] != dtrans.m_dtrans[col2]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean row_equiv(int row1, int row2) {
        CDTrans dtrans1 = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(row1);
        CDTrans dtrans2 = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(row2);
        int i = 0;
        while (i < this.m_spec.m_dtrans_ncols) {
            if (dtrans1.m_dtrans[i] != dtrans2.m_dtrans[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void reduce() {
        int j;
        JavaLexBitSet set = new JavaLexBitSet();
        int size = this.m_spec.m_dtrans_vector.size();
        this.m_spec.m_anchor_array = new int[size];
        this.m_spec.m_accept_vector = new Vector();
        int i = 0;
        while (i < size) {
            CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i);
            this.m_spec.m_accept_vector.addElement(dtrans.m_accept);
            this.m_spec.m_anchor_array[i] = dtrans.m_anchor;
            dtrans.m_accept = null;
            ++i;
        }
        this.m_spec.m_col_map = new int[this.m_spec.m_dtrans_ncols];
        i = 0;
        while (i < this.m_spec.m_dtrans_ncols) {
            this.m_spec.m_col_map[i] = -1;
            ++i;
        }
        int reduced_ncols = 0;
        while (true) {
            i = 0;
            while (i < reduced_ncols) {
                CUtility.cuassert(-1 != this.m_spec.m_col_map[i]);
                ++i;
            }
            i = reduced_ncols;
            while (i < this.m_spec.m_dtrans_ncols) {
                if (-1 == this.m_spec.m_col_map[i]) break;
                ++i;
            }
            if (i >= this.m_spec.m_dtrans_ncols) break;
            CUtility.cuassert(!set.get(i));
            CUtility.cuassert(-1 == this.m_spec.m_col_map[i]);
            set.set(i);
            this.m_spec.m_col_map[i] = reduced_ncols;
            j = i + 1;
            while (j < this.m_spec.m_dtrans_ncols) {
                if (-1 == this.m_spec.m_col_map[j] && this.col_equiv(i, j)) {
                    this.m_spec.m_col_map[j] = reduced_ncols;
                }
                ++j;
            }
            ++reduced_ncols;
        }
        int k = 0;
        i = 0;
        while (i < this.m_spec.m_dtrans_ncols) {
            if (set.get(i)) {
                ++k;
                set.clear(i);
                j = this.m_spec.m_col_map[i];
                CUtility.cuassert(j <= i);
                if (j != i) {
                    this.col_copy(j, i);
                }
            }
            ++i;
        }
        this.m_spec.m_dtrans_ncols = reduced_ncols;
        CUtility.cuassert(k == reduced_ncols);
        int nrows = this.m_spec.m_dtrans_vector.size();
        this.m_spec.m_row_map = new int[nrows];
        i = 0;
        while (i < nrows) {
            this.m_spec.m_row_map[i] = -1;
            ++i;
        }
        int reduced_nrows = 0;
        while (true) {
            i = 0;
            while (i < reduced_nrows) {
                CUtility.cuassert(-1 != this.m_spec.m_row_map[i]);
                ++i;
            }
            i = reduced_nrows;
            while (i < nrows) {
                if (-1 == this.m_spec.m_row_map[i]) break;
                ++i;
            }
            if (i >= nrows) break;
            CUtility.cuassert(!set.get(i));
            CUtility.cuassert(-1 == this.m_spec.m_row_map[i]);
            set.set(i);
            this.m_spec.m_row_map[i] = reduced_nrows;
            j = i + 1;
            while (j < nrows) {
                if (-1 == this.m_spec.m_row_map[j] && this.row_equiv(i, j)) {
                    this.m_spec.m_row_map[j] = reduced_nrows;
                }
                ++j;
            }
            ++reduced_nrows;
        }
        k = 0;
        i = 0;
        while (i < nrows) {
            if (set.get(i)) {
                ++k;
                set.clear(i);
                j = this.m_spec.m_row_map[i];
                CUtility.cuassert(j <= i);
                if (j != i) {
                    this.row_copy(j, i);
                }
            }
            ++i;
        }
        this.m_spec.m_dtrans_vector.setSize(reduced_nrows);
        CUtility.cuassert(k == reduced_nrows);
    }

    private void fix_dtrans() {
        Vector<CDTrans> new_vector = new Vector<CDTrans>();
        int size = this.m_spec.m_state_dtrans.length;
        int i = 0;
        while (i < size) {
            if (-1 != this.m_spec.m_state_dtrans[i]) {
                this.m_spec.m_state_dtrans[i] = this.m_ingroup[this.m_spec.m_state_dtrans[i]];
            }
            ++i;
        }
        size = this.m_group.size();
        i = 0;
        while (i < size) {
            Vector dtrans_group = (Vector)this.m_group.elementAt(i);
            CDTrans first = (CDTrans)dtrans_group.elementAt(0);
            new_vector.addElement(first);
            int c = 0;
            while (c < this.m_spec.m_dtrans_ncols) {
                if (-1 != first.m_dtrans[c]) {
                    first.m_dtrans[c] = this.m_ingroup[first.m_dtrans[c]];
                }
                ++c;
            }
            ++i;
        }
        this.m_group = null;
        this.m_spec.m_dtrans_vector = new_vector;
    }

    private void minimize() {
        this.init_groups();
        int group_count = this.m_group.size();
        int old_group_count = group_count - 1;
        while (old_group_count != group_count) {
            old_group_count = group_count;
            CUtility.cuassert(this.m_group.size() == group_count);
            int i = 0;
            while (i < group_count) {
                Vector dtrans_group = (Vector)this.m_group.elementAt(i);
                int group_size = dtrans_group.size();
                if (group_size > 1) {
                    Vector<CDTrans> new_group = new Vector<CDTrans>();
                    boolean added = false;
                    CDTrans first = (CDTrans)dtrans_group.elementAt(0);
                    int j = 1;
                    while (j < group_size) {
                        CDTrans next = (CDTrans)dtrans_group.elementAt(j);
                        int c = 0;
                        while (c < this.m_spec.m_dtrans_ncols) {
                            int goto_first = first.m_dtrans[c];
                            int goto_next = next.m_dtrans[c];
                            if (goto_first != goto_next && (goto_first == -1 || goto_next == -1 || this.m_ingroup[goto_next] != this.m_ingroup[goto_first])) {
                                CUtility.cuassert(dtrans_group.elementAt(j) == next);
                                dtrans_group.removeElementAt(j);
                                --j;
                                --group_size;
                                new_group.addElement(next);
                                if (!added) {
                                    added = true;
                                    ++group_count;
                                    this.m_group.addElement(new_group);
                                }
                                this.m_ingroup[next.m_label] = this.m_group.size() - 1;
                                CUtility.cuassert(this.m_group.contains(new_group));
                                CUtility.cuassert(this.m_group.contains(dtrans_group));
                                CUtility.cuassert(dtrans_group.contains(first));
                                CUtility.cuassert(!dtrans_group.contains(next));
                                CUtility.cuassert(!new_group.contains(first));
                                CUtility.cuassert(new_group.contains(next));
                                CUtility.cuassert(dtrans_group.size() == group_size);
                                CUtility.cuassert(i == this.m_ingroup[first.m_label]);
                                CUtility.cuassert(this.m_group.size() - 1 == this.m_ingroup[next.m_label]);
                                break;
                            }
                            ++c;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        System.out.println(String.valueOf(this.m_group.size()) + " states after removal of redundant states.");
        boolean cfr_ignored_0 = this.m_spec.m_verbose;
        this.fix_dtrans();
    }

    private void init_groups() {
        this.m_group = new Vector();
        int group_count = 0;
        int size = this.m_spec.m_dtrans_vector.size();
        this.m_ingroup = new int[size];
        int i = 0;
        while (i < size) {
            Vector dtrans_group;
            boolean group_found = false;
            CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i);
            CUtility.cuassert(i == dtrans.m_label);
            CUtility.cuassert(!group_found);
            CUtility.cuassert(group_count == this.m_group.size());
            int j = 0;
            while (j < group_count) {
                dtrans_group = (Vector)this.m_group.elementAt(j);
                CUtility.cuassert(!group_found);
                CUtility.cuassert(dtrans_group.size() > 0);
                CDTrans first = (CDTrans)dtrans_group.elementAt(0);
                int s = dtrans_group.size();
                CUtility.cuassert(s > 0);
                int k = 1;
                while (k < s) {
                    CDTrans check = (CDTrans)dtrans_group.elementAt(k);
                    CUtility.cuassert(check.m_accept == first.m_accept);
                    ++k;
                }
                if (first.m_accept == dtrans.m_accept) {
                    dtrans_group.addElement(dtrans);
                    this.m_ingroup[i] = j;
                    group_found = true;
                    CUtility.cuassert(j == this.m_ingroup[dtrans.m_label]);
                    break;
                }
                ++j;
            }
            if (!group_found) {
                dtrans_group = new Vector();
                dtrans_group.addElement(dtrans);
                this.m_ingroup[i] = this.m_group.size();
                this.m_group.addElement(dtrans_group);
                ++group_count;
            }
            ++i;
        }
        boolean cfr_ignored_0 = this.m_spec.m_verbose;
    }

    private void pset(Vector dtrans_group) {
        int size = dtrans_group.size();
        int i = 0;
        while (i < size) {
            CDTrans dtrans = (CDTrans)dtrans_group.elementAt(i);
            System.out.print(String.valueOf(dtrans.m_label) + " ");
            ++i;
        }
    }

    private void pgroups() {
        int group_size = this.m_group.size();
        int i = 0;
        while (i < group_size) {
            System.out.print("\tGroup " + i + " {");
            this.pset((Vector)this.m_group.elementAt(i));
            System.out.println("}\n");
            ++i;
        }
        System.out.println("");
        int dtrans_size = this.m_spec.m_dtrans_vector.size();
        i = 0;
        while (i < dtrans_size) {
            System.out.println("\tstate " + i + " is in group " + this.m_ingroup[i]);
            ++i;
        }
    }
}

