/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.ParseException;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.ETCLComponentName;
import org.jacorb.notification.filter.etcl.TCLCleanUp;
import org.jacorb.notification.filter.etcl.TCLParser;
import org.jacorb.notification.filter.etcl.VisitorException;
import org.jacorb.notification.interfaces.Message;

public class PropertyShorthandNode
extends AbstractTCLNode {
    String value_;
    ETCLComponentName shorthandVariableHeader_;
    ETCLComponentName shorthandFilterableData_;
    ETCLComponentName shorthandDefault_;
    ETCLComponentName shorthandDefaultAny_;

    public PropertyShorthandNode(String string) {
        try {
            this.value_ = string;
            this.shorthandVariableHeader_ = (ETCLComponentName)TCLParser.parse("$.header.variable_header(" + string + ")");
            this.shorthandVariableHeader_.acceptInOrder(new TCLCleanUp());
            this.shorthandFilterableData_ = (ETCLComponentName)TCLParser.parse("$.filterable_data(" + string + ")");
            this.shorthandFilterableData_.acceptInOrder(new TCLCleanUp());
            this.shorthandDefault_ = (ETCLComponentName)TCLParser.parse("$." + string);
            this.shorthandDefault_.acceptInOrder(new TCLCleanUp());
            this.shorthandDefaultAny_ = (ETCLComponentName)TCLParser.parse("$(" + string + ")");
            this.shorthandDefaultAny_.acceptInOrder(new TCLCleanUp());
        }
        catch (ParseException parseException) {
            throw new RuntimeException();
        }
        catch (VisitorException visitorException) {
            throw new RuntimeException();
        }
    }

    public EvaluationResult evaluate(EvaluationContext evaluationContext) throws EvaluationException {
        Message message = evaluationContext.getCurrentMessage();
        EvaluationResult evaluationResult = null;
        try {
            evaluationResult = message.extractVariableHeader(evaluationContext, this.shorthandVariableHeader_, this.value_);
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        if (evaluationResult == null) {
            try {
                evaluationResult = message.extractFilterableData(evaluationContext, this.shorthandFilterableData_, this.value_);
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
            if (evaluationResult == null) {
                evaluationResult = this.extractDefaultValue(evaluationContext);
            }
            if (evaluationResult == null) {
                evaluationResult = this.extractDefaultAnyValue(evaluationContext);
            }
        }
        return evaluationResult;
    }

    public EvaluationResult extractDefaultValue(EvaluationContext evaluationContext) {
        try {
            return evaluationContext.getCurrentMessage().extractValue(evaluationContext, this.shorthandDefault_);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public EvaluationResult extractDefaultAnyValue(EvaluationContext evaluationContext) {
        try {
            return evaluationContext.getCurrentMessage().extractValue(evaluationContext, this.shorthandDefaultAny_);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        return "PropertyShorthandNode: " + this.value_;
    }

    public void acceptPostOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        if (this.getFirstChild() != null) {
            ((AbstractTCLNode)this.getFirstChild()).acceptPostOrder(abstractTCLVisitor);
        }
    }

    public void acceptPreOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        ((AbstractTCLNode)this.getFirstChild()).acceptPreOrder(abstractTCLVisitor);
    }

    public void acceptInOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        ((AbstractTCLNode)this.getFirstChild()).acceptInOrder(abstractTCLVisitor);
    }
}

