/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.RetryException;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CosEventComm.Disconnected;

public abstract class RetryStrategy
implements Disposable {
    protected PushOperation pushOperation_;
    protected MessageConsumer messageConsumer_;

    public RetryStrategy(MessageConsumer messageConsumer, PushOperation pushOperation) {
        this.messageConsumer_ = messageConsumer;
        this.pushOperation_ = pushOperation;
    }

    public void dispose() {
        this.pushOperation_.dispose();
    }

    public boolean shouldRetry() {
        return !this.messageConsumer_.isDisposed() && this.messageConsumer_.getErrorCounter() < this.messageConsumer_.getErrorThreshold();
    }

    public void remoteExceptionOccured(Throwable throwable) throws RetryException {
        if (RetryStrategy.isFatalException(throwable)) {
            this.messageConsumer_.dispose();
            this.dispose();
            throw new RetryException("fatal exception caused while retrying push");
        }
        this.messageConsumer_.incErrorCounter();
        if (!this.shouldRetry()) {
            this.messageConsumer_.dispose();
            this.dispose();
            throw new RetryException("no more retries. giving up.");
        }
        this.waitUntilNextTry();
    }

    public static boolean isFatalException(Throwable throwable) {
        if (throwable instanceof OBJECT_NOT_EXIST) {
            return true;
        }
        return throwable instanceof Disconnected;
    }

    protected abstract long getTimeToWait();

    public abstract void retry() throws RetryException;

    private void waitUntilNextTry() {
        long l = this.getTimeToWait();
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

