/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pf.text.StringUtil;

public class Version {
    private static final int LESS = -1;
    private static final int EQUAL = 0;
    private static final int GREATER = 1;
    private static final Integer NOT_SET = new Integer(-1);
    public static final String SEPARATOR = ".";
    private List elements = null;

    protected List getElements() {
        return this.elements;
    }

    protected void setElements(List newValue) {
        this.elements = newValue;
    }

    public static boolean isValidVersion(String str) {
        if (str == null) {
            return false;
        }
        Version version = new Version(str);
        return version.isValid();
    }

    public Version(String versionString) {
        this.setElements(new ArrayList());
        this.parse(versionString);
    }

    public boolean isGreaterThan(Version version) {
        return this.compareTo(version) == 1;
    }

    public boolean isLessThan(Version version) {
        return this.compareTo(version) == -1;
    }

    public boolean isGreaterThan(String version) {
        return this.isGreaterThan(new Version(version));
    }

    public boolean isLessThan(String version) {
        return this.isLessThan(new Version(version));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            return this.compareTo(obj) == 0;
        }
        if (obj instanceof String) {
            return this.compareTo(new Version((String)obj)) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.getElements().size()) {
            hash ^= this.getElements().get(i).hashCode();
            ++i;
        }
        return hash;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        int i = 0;
        while (i < this.getElements().size()) {
            if (i > 0) {
                buffer.append(SEPARATOR);
            }
            buffer.append(this.getElements().get(i));
            ++i;
        }
        return buffer.toString();
    }

    public int compareTo(Object obj) {
        if (obj instanceof Version) {
            Version otherVersion = (Version)obj;
            List otherElemets = otherVersion.getElements();
            int i = 0;
            while (i < otherElemets.size()) {
                if (i >= this.getElements().size()) {
                    return -1;
                }
                Comparable element = (Comparable)this.getElements().get(i);
                Comparable otherElement = (Comparable)otherElemets.get(i);
                int compResult = element.getClass().equals(otherElement.getClass()) ? element.compareTo(otherElement) : element.toString().compareTo(otherElement.toString());
                if (compResult != 0) {
                    return compResult < 0 ? -1 : 1;
                }
                ++i;
            }
            return i == this.getElements().size() ? 0 : 1;
        }
        throw new IllegalArgumentException("The object to compare is not a Version");
    }

    public boolean isNumeric() {
        if (this.getElements().isEmpty()) {
            return false;
        }
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            VersionElement element = (VersionElement)iter.next();
            if (element.isNumeric()) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        if (this.getElements().isEmpty()) {
            return false;
        }
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            VersionElement element = (VersionElement)iter.next();
            if (element.isValid()) continue;
            return false;
        }
        return true;
    }

    protected void parse(String versionString) {
        String[] parts = this.str().parts(versionString, SEPARATOR);
        int i = 0;
        while (i < parts.length) {
            VersionElement element = new VersionElement(parts[i]);
            this.getElements().add(element);
            ++i;
        }
    }

    protected StringUtil str() {
        return StringUtil.current();
    }

    private class VersionElement
    implements Comparable {
        private Integer intPart = Version.access$0();
        private String strPart = "";

        VersionElement(String versionPart) {
            this.parse(versionPart);
        }

        public String toString() {
            if (this.intPart.equals(NOT_SET)) {
                return this.strPart;
            }
            return String.valueOf(this.intPart.toString()) + this.strPart;
        }

        public int compareTo(Object otherElement) {
            return this.compareTo((VersionElement)otherElement);
        }

        protected void parse(String versionPart) {
            boolean isNumber = true;
            StringBuffer numBuffer = new StringBuffer(20);
            StringBuffer strBuffer = new StringBuffer(20);
            int i = 0;
            while (i < versionPart.length()) {
                char ch = versionPart.charAt(i);
                boolean bl = isNumber = isNumber && Character.isDigit(ch);
                if (isNumber) {
                    numBuffer.append(ch);
                } else {
                    strBuffer.append(ch);
                }
                ++i;
            }
            try {
                if (numBuffer.length() > 0) {
                    int value = Integer.parseInt(numBuffer.toString());
                    this.intPart = new Integer(value);
                }
            }
            catch (NumberFormatException e) {
                this.intPart = NOT_SET;
            }
            this.strPart = strBuffer.toString();
        }

        protected int compareTo(VersionElement otherElement) {
            int compResult = this.intPart.compareTo(otherElement.intPart);
            if (compResult == 0) {
                compResult = this.strPart.compareTo(otherElement.strPart);
            }
            return compResult;
        }

        protected boolean isValid() {
            return !this.intPart.equals(NOT_SET);
        }

        protected boolean isNumeric() {
            return this.isValid() && Version.this.str().isNullOrEmpty(this.strPart);
        }
    }
}

