/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi.inspectors;

import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.pf.joi.BasicInspector;
import org.pf.joi.Inspector;
import org.pf.joi.Spy;
import org.pf.joi.inspectors.AssociationSpy;

public abstract class KeyValueInspector
extends BasicInspector {
    protected static final String actKeyInspectWindow = "actionInspectKeyInWindow";
    protected static final String actKeyInspectTab = "actionInspectKeyInTab";

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(actKeyInspectWindow)) {
            this.inspectCurrentKey(3);
        } else if (e.getActionCommand().equals(actKeyInspectTab)) {
            this.inspectCurrentKey(2);
        } else {
            super.actionPerformed(e);
        }
    }

    protected void inspectCurrentKey(int where) {
        Spy spy = this.getCurrentElement();
        if (spy != null) {
            try {
                if (spy instanceof AssociationSpy) {
                    AssociationSpy associationSpy = (AssociationSpy)spy;
                    if (where == 3) {
                        Inspector.inspect(associationSpy.getKey());
                    } else {
                        Inspector.inspectIn(this.getController(), where, null, associationSpy.getKey());
                    }
                } else if (where == 3) {
                    Inspector.inspect(spy.getValue());
                } else {
                    Inspector.inspectIn(this.getController(), where, null, spy.getValue());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(BasicInspector.errorDevice);
            }
        }
    }

    protected JPopupMenu createElementPopupMenu() {
        JMenuItem menuItem = null;
        JPopupMenu popup = null;
        popup = super.createElementPopupMenu();
        popup.addSeparator();
        menuItem = this.createMenuItem("Inspect key in new tab", actKeyInspectTab);
        popup.add(menuItem);
        menuItem = this.createMenuItem("Inspect key in new window", actKeyInspectWindow);
        popup.add(menuItem);
        return popup;
    }
}

