/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.pf.joi.BasicInspector;
import org.pf.swing.DynamicPanel;
import org.pf.swing.DynamicPanelSlot;
import org.pf.swing.TakeAllLayoutManager;

public class ObjectValuePanel
extends DynamicPanel {
    protected static final String BUTTON_LABEL_SAVE = "Apply changes";
    protected static final String BUTTON_LABEL_RESET = "Reset";
    protected static final String BUTTON_LABEL_NULL = "Set to null";
    protected static final String SLOT_OBJECT_VALUE = "slot.object.value";
    private JTextArea readOnlyTextArea = null;
    private JTextArea editableTextArea = null;
    private DynamicPanelSlot readOnlyTextPanel = null;
    private DynamicPanelSlot editableTextPanel = null;
    private DynamicPanelSlot componentPanel = null;
    private JButton nullButton = null;

    protected JTextArea getReadOnlyTextArea() {
        return this.readOnlyTextArea;
    }

    protected void setReadOnlyTextArea(JTextArea newValue) {
        this.readOnlyTextArea = newValue;
    }

    protected JTextArea getEditableTextArea() {
        return this.editableTextArea;
    }

    protected void setEditableTextArea(JTextArea newValue) {
        this.editableTextArea = newValue;
    }

    protected DynamicPanelSlot getReadOnlyTextPanel() {
        return this.readOnlyTextPanel;
    }

    protected void setReadOnlyTextPanel(DynamicPanelSlot newValue) {
        this.readOnlyTextPanel = newValue;
    }

    protected DynamicPanelSlot getEditableTextPanel() {
        return this.editableTextPanel;
    }

    protected void setEditableTextPanel(DynamicPanelSlot newValue) {
        this.editableTextPanel = newValue;
    }

    protected DynamicPanelSlot getComponentPanel() {
        return this.componentPanel;
    }

    protected void setComponentPanel(DynamicPanelSlot newValue) {
        this.componentPanel = newValue;
    }

    protected JButton getNullButton() {
        return this.nullButton;
    }

    protected void setNullButton(JButton newValue) {
        this.nullButton = newValue;
    }

    public ObjectValuePanel(BasicInspector inspector) {
        super(new TakeAllLayoutManager());
        this.init(inspector);
    }

    public void activateText(String text, boolean editable, boolean isPrimitive) {
        if (editable) {
            this.getNullButton().setEnabled(!isPrimitive);
            this.setEditableText(text);
            this.activateEditableTextView();
        } else {
            this.getReadOnlyTextArea().setText(text);
            this.activateReadOnlyTextView();
        }
    }

    public void setEditableText(String text) {
        this.getEditableTextArea().setText(text);
    }

    public void activateComponent(Component comp) {
        this.getComponentPanel().removeAll();
        this.getComponentPanel().add(comp);
        this.activateComponentView();
    }

    public String getEditedText() {
        return this.getEditableTextArea().getText();
    }

    protected void init(BasicInspector inspector) {
        this.addDynamicSlot(SLOT_OBJECT_VALUE);
        this.setReadOnlyTextPanel(new DynamicPanelSlot());
        this.setReadOnlyTextArea(this.createTextArea(false));
        JScrollPane scrollPane = this.createScrollPane(this.getReadOnlyTextArea());
        this.getReadOnlyTextPanel().add(scrollPane);
        this.setEditableTextPanel(new DynamicPanelSlot());
        this.setEditableTextArea(this.createTextArea(true));
        this.getEditableTextPanel().setLayout(new BorderLayout());
        this.getEditableTextPanel().add((Component)this.createButtons(inspector), "North");
        scrollPane = this.createScrollPane(this.getEditableTextArea());
        this.getEditableTextPanel().add((Component)scrollPane, "Center");
        this.setComponentPanel(new DynamicPanelSlot());
        this.activateReadOnlyTextView();
    }

    protected JPanel createButtons(BasicInspector inspector) {
        JPanel panel = new JPanel(new FlowLayout());
        JButton button = new JButton(BUTTON_LABEL_SAVE);
        button.setActionCommand("save.modified.value");
        button.addActionListener(inspector);
        panel.add(button);
        button = new JButton(BUTTON_LABEL_RESET);
        button.setActionCommand("reset.modified.value");
        button.addActionListener(inspector);
        panel.add(button);
        button = new JButton(BUTTON_LABEL_NULL);
        button.setActionCommand("set.value.to.null");
        button.addActionListener(inspector);
        this.setNullButton(button);
        panel.add(button);
        return panel;
    }

    protected JTextArea createTextArea(boolean editable) {
        JTextArea textArea = null;
        textArea = new JTextArea();
        textArea.setEditable(editable);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(false);
        return textArea;
    }

    protected JScrollPane createScrollPane(Component comp) {
        JScrollPane pane = new JScrollPane(comp);
        return pane;
    }

    protected void activateReadOnlyTextView() {
        this.setSlot(SLOT_OBJECT_VALUE, this.getReadOnlyTextPanel());
    }

    protected void activateEditableTextView() {
        this.setSlot(SLOT_OBJECT_VALUE, this.getEditableTextPanel());
    }

    protected void activateComponentView() {
        this.setSlot(SLOT_OBJECT_VALUE, this.getComponentPanel());
    }
}

