/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.volimage;

import java.io.BufferedInputStream;
import java.net.Socket;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;

public class ImageStreamReader
implements Runnable {
    private Image streamImage = null;
    private ImageData imgData;
    private BufferedInputStream bIn = null;
    private Socket socket;
    private byte[] dataBlock = null;
    private boolean terminate = false;
    private boolean hasFinished = false;
    private boolean isConnected = false;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private GC offImageGC = null;
    private Canvas canvas;
    private Color testColour;

    public ImageStreamReader(String string, int n, GC gC, Canvas canvas) {
        this.offImageGC = gC;
        this.canvas = canvas;
        try {
            this.socket = new Socket(string, n);
            if (this.socket.isConnected()) {
                this.bIn = new BufferedInputStream(this.socket.getInputStream());
                this.isConnected = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.imgData = new ImageData(640, 480, 24, new PaletteData(0xFF0000, 65280, 0xF0000FF));
        this.testColour = new Color((Device)this.canvas.getDisplay(), new RGB(0, 0, 255));
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void stop() {
        this.terminate = true;
        try {
            this.bIn.close();
            this.socket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void run() {
        if (this.bIn != null) {
            byte[] byArray = new byte[4];
            while (!this.terminate) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                try {
                    this.bIn.read(byArray, 0, 4);
                    int n6 = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
                    n5 = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
                    if (n6 != this.imgData.width || n5 != this.imgData.height) {
                        while (n6 != this.imgData.width || n5 != this.imgData.height) {
                            this.bIn.read(byArray, 0, 4);
                            n6 = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
                            n5 = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
                        }
                    }
                    if (this.imageWidth == 0) {
                        this.imageWidth = n6;
                    }
                    if (this.imageHeight == 0) {
                        this.imageHeight = n5;
                    }
                    if ((n4 = this.imageWidth * this.imageHeight * 4) != 1228800) {
                        System.err.println("# bytes " + n4 + " width " + n6 + " height " + n5);
                    }
                    n3 = 0;
                    n2 = n4;
                    if (this.dataBlock == null) {
                        this.dataBlock = new byte[n4];
                    }
                    while (n3 < n4) {
                        n = this.bIn.read(this.dataBlock, n3, n2);
                        n3 += n;
                        n2 -= n;
                    }
                }
                catch (Exception exception) {
                    this.isConnected = false;
                    exception.printStackTrace();
                }
                int n7 = 0;
                while (n7 < this.imageHeight) {
                    n5 = 0;
                    while (n5 < this.imageWidth) {
                        n4 = this.dataBlock[(n5 + n7 * this.imageWidth) * 4];
                        n3 = this.dataBlock[(n5 + n7 * this.imageWidth) * 4 + 1];
                        n2 = this.dataBlock[(n5 + n7 * this.imageWidth) * 4 + 2];
                        n = ((n2 & 0xFF) << 16) + ((n3 & 0xFF) << 8) + (n4 & 0xFF);
                        this.imgData.setPixel(n5, this.imageHeight - 1 - n7, n);
                        ++n5;
                    }
                    ++n7;
                }
                if (!(this.canvas.isDisposed() || this.offImageGC.isDisposed() || this.canvas.getDisplay().isDisposed())) {
                    this.canvas.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ImageStreamReader.this.streamImage != null && !ImageStreamReader.this.streamImage.isDisposed()) {
                                ImageStreamReader.this.streamImage.dispose();
                            }
                            ImageStreamReader.this.streamImage = new Image((Device)ImageStreamReader.this.canvas.getDisplay(), ImageStreamReader.this.imgData);
                            ImageStreamReader.this.offImageGC.drawImage(ImageStreamReader.this.streamImage, 0, 0);
                            ImageStreamReader.this.canvas.redraw();
                        }
                    });
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        this.hasFinished = true;
    }
}

