/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views.plot;

import gda.analysis.DataSet;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.slf4j.Logger;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DUIAdapter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotDataTableDialog;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionComplexEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.views.plot.PlotBean;
import uk.ac.diamond.scisoft.analysis.rcp.views.plot.PlotView;
import uk.ac.diamond.scisoft.analysis.rcp.views.plot.StaticScanPlotView;
import uk.ac.gda.common.rcp.util.GridUtils;

public class SashFormPlotComposite
implements PlotView {
    protected final IWorkbenchPart part;
    protected final ScrolledComposite leftScroll;
    protected final ScrolledComposite rightScroll;
    protected final Composite left;
    protected final Composite right;
    protected final DataSetPlotter plotter;
    protected final SashForm sashForm;
    protected DataSet[] dataSets;
    protected String xAxisLabel;
    protected String yAxisLabel;
    private ToolBarManager rightHandToolbarManager;
    private Label rightHandToolbarManagerLabel;
    private SashForm rightSash;
    private Text statusLabel;
    private Plot1DUIAdapter plotUI;

    public SashFormPlotComposite(Composite composite, IWorkbenchPart iWorkbenchPart, final IAction ... iActionArray) {
        this.part = iWorkbenchPart;
        this.sashForm = new SashForm(composite, 256);
        this.leftScroll = new ScrolledComposite((Composite)this.sashForm, 768);
        this.leftScroll.setExpandHorizontal(true);
        this.leftScroll.setExpandVertical(true);
        this.left = new Composite((Composite)this.leftScroll, 0);
        this.left.setLayout((Layout)new GridLayout());
        this.rightScroll = new ScrolledComposite((Composite)this.sashForm, 768);
        this.rightScroll.setExpandHorizontal(true);
        this.rightScroll.setExpandVertical(true);
        this.rightSash = new SashForm((Composite)this.rightScroll, 512);
        this.right = new Composite((Composite)this.rightSash, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 1;
        gridLayout.verticalSpacing = 0;
        this.right.setLayout((Layout)gridLayout);
        Composite composite2 = new Composite(this.right, 0);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout2 = new GridLayout(3, false);
        gridLayout2.verticalSpacing = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout2);
        ToolBar toolBar = new ToolBar(composite2, 0x800000);
        toolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.rightHandToolbarManagerLabel = new Label(composite2, 0);
        this.rightHandToolbarManagerLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        ToolBar toolBar2 = new ToolBar(composite2, 0x800000);
        toolBar2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.rightHandToolbarManager = new ToolBarManager(toolBar2);
        this.plotter = new DataSetPlotter(PlottingMode.ONED, this.right, false);
        Composite composite3 = this.plotter.getComposite();
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.plotter.setPlotActionEnabled(true);
        this.plotter.setPlotRightClickActionEnabled(true);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        this.plotUI = new Plot1DUIAdapter((IToolBarManager)toolBarManager, this.plotter, this.right, this.getPartName()){

            @Override
            public void buildToolActions(IToolBarManager iToolBarManager) {
                iToolBarManager.add(StaticScanPlotView.getOpenStaticPlotAction(SashFormPlotComposite.this));
                iToolBarManager.add((IAction)this.addToHistory);
                iToolBarManager.add((IAction)this.removeFromHistory);
                super.buildToolActions(iToolBarManager);
                iToolBarManager.add(this.createShowLegend());
                if (iActionArray != null) {
                    int n = 0;
                    while (n < iActionArray.length) {
                        iToolBarManager.add(iActionArray[n]);
                        ++n;
                    }
                }
            }

            @Override
            public void plotActionPerformed(final PlotActionEvent plotActionEvent) {
                if (plotActionEvent instanceof PlotActionComplexEvent) {
                    this.parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PlotDataTableDialog plotDataTableDialog = new PlotDataTableDialog(parent.getShell(), (PlotActionComplexEvent)plotActionEvent);
                            plotDataTableDialog.open();
                        }
                    });
                } else {
                    this.parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            plotter.getComposite().setToolTipText(String.valueOf(plotActionEvent.toString()) + "\nRight click to view data.");
                        }
                    });
                }
            }
        };
        this.plotter.registerUI(this.plotUI);
        toolBarManager.update(true);
        this.statusLabel = new Text((Composite)this.rightSash, 576);
        this.statusLabel.setEditable(false);
        this.rightSash.setWeights(new int[]{100, 10});
    }

    public void addZoomListener(IPropertyChangeListener iPropertyChangeListener) {
        this.plotUI.addZoomListener(iPropertyChangeListener);
    }

    @Override
    public PlotBean getPlotBean() {
        PlotBean plotBean = new PlotBean();
        HashMap<String, DataSet> hashMap = new HashMap<String, DataSet>(1);
        if (this.dataSets != null) {
            int n = 0;
            while (n < this.dataSets.length) {
                String string = "Plot " + n;
                if (this.dataSets[n].getName() != null) {
                    string = this.dataSets[n].getName();
                }
                hashMap.put(string, this.dataSets[n]);
                ++n;
            }
        }
        plotBean.setDataSets(hashMap);
        plotBean.setCurrentPlotName("Plot");
        plotBean.setXAxisMode(1);
        plotBean.setYAxisMode(1);
        plotBean.setXAxis(this.getXAxisLabel());
        plotBean.setYAxis(this.getYAxisLabel());
        return plotBean;
    }

    public void computeSizes() {
        this.leftScroll.setContent((Control)this.left);
        this.leftScroll.setMinSize(this.left.computeSize(-1, -1));
        this.rightScroll.setContent((Control)this.rightSash);
        this.rightScroll.setMinSize(this.rightSash.computeSize(-1, -1));
    }

    @Override
    public String getPartName() {
        return this.part.getTitle();
    }

    @Override
    public IWorkbenchPartSite getSite() {
        return this.part.getSite();
    }

    public ScrolledComposite getLeftScroll() {
        return this.leftScroll;
    }

    public ScrolledComposite getRightScroll() {
        return this.rightScroll;
    }

    public Composite getLeft() {
        return this.left;
    }

    public Composite getRight() {
        return this.right;
    }

    public DataSetPlotter getPlotter() {
        return this.plotter;
    }

    public void setWeights(int[] nArray) {
        this.sashForm.setWeights(nArray);
    }

    public void setXAxisLabel(String string) {
        this.xAxisLabel = string;
        this.plotter.setXAxisLabel(string);
    }

    public void setYAxisLabel(String string) {
        this.yAxisLabel = string;
        this.plotter.setYAxisLabel(string);
    }

    public void setDataSets(DataSet ... dataSetArray) {
        this.dataSets = dataSetArray;
    }

    public String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public SashForm getSashForm() {
        return this.sashForm;
    }

    public void dispose() {
        if (this.plotter != null) {
            this.plotter.cleanUp();
        }
    }

    public void setRightHandToolBarLabel(String string) {
        this.rightHandToolbarManagerLabel.setText(string);
    }

    public void add(IAction iAction) {
        this.rightHandToolbarManager.add(iAction);
        this.rightHandToolbarManager.update(true);
    }

    public void add(IContributionItem iContributionItem) {
        this.rightHandToolbarManager.add(iContributionItem);
        this.rightHandToolbarManager.update(true);
    }

    public void setRightHandToolBarLabelEnabled(boolean bl) {
        this.rightHandToolbarManagerLabel.setEnabled(bl);
    }

    public void appendStatus(final String string, Logger logger) {
        if (logger != null) {
            logger.info(string);
        }
        if (this.getSite().getShell() == null) {
            return;
        }
        if (this.getSite().getShell().isDisposed()) {
            return;
        }
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SashFormPlotComposite.this.statusLabel.append(DateFormat.getDateTimeInstance().format(new Date()));
                SashFormPlotComposite.this.statusLabel.append(" ");
                SashFormPlotComposite.this.statusLabel.append(string);
                SashFormPlotComposite.this.statusLabel.append("\n");
            }
        });
    }

    public void layout() {
        GridUtils.startMultiLayout((Control)this.sashForm);
        try {
            GridUtils.layoutFull((Composite)this.sashForm);
            GridUtils.layoutFull((Composite)this.left);
            this.leftScroll.setMinSize(this.left.computeSize(-1, -1));
        }
        finally {
            GridUtils.endMultiLayout();
        }
    }
}

