/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views.nexus;

import com.swtdesigner.ResourceManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.services.IServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.util.PlotMode;
import uk.ac.diamond.scisoft.analysis.rcp.util.PlotUtils;
import uk.ac.diamond.scisoft.analysis.rcp.util.SDAUtils;
import uk.ac.diamond.scisoft.analysis.rcp.views.PlotView;
import uk.ac.diamond.scisoft.analysis.rcp.views.nexus.DataSetProvider;
import uk.ac.diamond.scisoft.analysis.rcp.views.nexus.ExpressionObject;
import uk.ac.gda.monitor.IMonitor;
import uk.ac.gda.monitor.ProgressMonitorWrapper;
import uk.ac.gda.ui.modifiers.DoubleClickModifier;
import uk.ac.gda.util.io.PropUtils;
import uk.ac.gda.util.io.SortingUtils;
import uk.ac.gda.util.list.SortNatural;

public class DataSetPlotView
extends ViewPart
implements ICheckStateListener,
DataSetProvider {
    private static final Logger logger = LoggerFactory.getLogger(DataSetPlotView.class);
    public static final String ID = "uk.ac.gda.views.nexus.NexusPlotView";
    protected CheckboxTableViewer dataViewer;
    protected List<Object> data;
    protected String filePath;
    protected String fileName;
    protected Map<String, Integer> datasetSizes;
    protected final boolean isDialogMode;
    protected final boolean requireToolbar;
    protected final DataSetProvider providerDeligate;
    private List<Object> selections = new ArrayList<Object>(7);
    private boolean checkStateLocked = false;
    private List<ISelectionChangedListener> listeners;
    private PlotMode plotMode = PlotMode.PM1D;
    private List<PlotModeListener> plotModeListeners;
    private PlotWindow plotWindow;

    public DataSetPlotView() {
        this(false, false, null);
    }

    public DataSetPlotView(boolean bl, boolean bl2, DataSetProvider dataSetProvider) {
        this.data = new ArrayList<Object>(7);
        this.isDialogMode = bl;
        this.requireToolbar = bl2;
        this.providerDeligate = dataSetProvider;
        AnalysisRCPActivator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("ignore.data.set.filters")) {
                    if (DataSetPlotView.this.filePath == null) {
                        return;
                    }
                    IProgressService iProgressService = (IProgressService)PlatformUI.getWorkbench().getService(IProgressService.class);
                    try {
                        iProgressService.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    DataSetPlotView.this.setFile((this).DataSetPlotView.this.filePath, iProgressMonitor);
                                }
                                catch (Exception exception) {
                                    throw new InvocationTargetException(exception);
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        logger.error("Unable to refresh data set list", (Throwable)exception);
                    }
                }
            }
        });
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite);
    }

    public void createPartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        if (composite.getLayout() instanceof GridLayout) {
            composite2.setLayoutData((Object)new GridData(1808));
        }
        GridLayout gridLayout = new GridLayout(1, false);
        if (this.requireToolbar) {
            ToolBarManager toolBarManager = new ToolBarManager(0x820000);
            this.createDimensionalActions((IContributionManager)toolBarManager, true);
            toolBarManager.createControl(composite2);
            toolBarManager.getControl().setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        } else {
            gridLayout.verticalSpacing = 0;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.horizontalSpacing = 0;
        }
        composite2.setLayout((Layout)gridLayout);
        this.dataViewer = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2818);
        this.dataViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.dataViewer.addCheckStateListener((ICheckStateListener)this);
        this.dataViewer.getTable().setLinesVisible(true);
        this.dataViewer.getTable().setHeaderVisible(true);
        this.createColumns();
        this.dataViewer.setUseHashlookup(true);
        this.dataViewer.setColumnProperties(new String[]{"Data", "Length"});
        this.dataViewer.setCellEditors(this.createCellEditors((TableViewer)this.dataViewer));
        this.dataViewer.setCellModifier(this.createModifier((TableViewer)this.dataViewer));
        this.dataViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                return DataSetPlotView.this.data.toArray(new Object[DataSetPlotView.this.data.size()]);
            }
        });
        this.dataViewer.setInput((Object)new String());
        this.createRightClickMenu();
        this.initializeToolBar();
    }

    private void saveExpressions() {
        try {
            Properties properties = new Properties();
            for (Object object : this.data) {
                if (!(object instanceof ExpressionObject)) continue;
                ExpressionObject expressionObject = (ExpressionObject)object;
                properties.setProperty(expressionObject.getMementoKey(), expressionObject.getExpression());
            }
            String string = String.valueOf(SDAUtils.getSdaHome()) + this.getFileName() + ".properties";
            PropUtils.storeProperties((Properties)properties, (String)string);
        }
        catch (Exception exception) {
            logger.error("Cannot save expression", (Throwable)exception);
        }
    }

    private void readExpressions() throws Exception {
        String string = String.valueOf(SDAUtils.getSdaHome()) + this.getFileName() + ".properties";
        Properties properties = PropUtils.loadProperties((String)string);
        if (properties != null) {
            try {
                for (Object object : properties.keySet()) {
                    String string2 = object.toString();
                    if (!ExpressionObject.isExpressionKey(string2)) continue;
                    this.data.add(new ExpressionObject(this, properties.getProperty(string2), string2));
                }
            }
            catch (Exception exception) {
                throw new PartInitException(exception.getMessage());
            }
        }
    }

    private void createRightClickMenu() {
        MenuManager menuManager = new MenuManager();
        this.dataViewer.getControl().setMenu(menuManager.createContextMenu(this.dataViewer.getControl()));
        if (this.getSite() != null) {
            this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.dataViewer);
        }
        this.createDimensionalActions((IContributionManager)menuManager, false);
    }

    private void createColumns() {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.dataViewer, (int)2);
        TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this.dataViewer, 16384, 0);
        tableViewerColumn.getColumn().setText("Data");
        tableViewerColumn.getColumn().setWidth(150);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new DataSetColumnLabelProvider(0));
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn((TableViewer)this.dataViewer, 16384, 1);
        tableViewerColumn2.getColumn().setText(" ");
        tableViewerColumn2.getColumn().setWidth(24);
        tableViewerColumn2.setLabelProvider((CellLabelProvider)new DataSetColumnLabelProvider(1));
        TableViewerColumn tableViewerColumn3 = new TableViewerColumn((TableViewer)this.dataViewer, 16384, 2);
        tableViewerColumn3.getColumn().setText("Size");
        tableViewerColumn3.getColumn().setWidth(this.requireToolbar ? 0 : 150);
        tableViewerColumn3.getColumn().setResizable(!this.requireToolbar);
        tableViewerColumn3.setLabelProvider((CellLabelProvider)new DataSetColumnLabelProvider(2));
    }

    private CellEditor[] createCellEditors(TableViewer tableViewer) {
        CellEditor[] cellEditorArray = new CellEditor[1];
        TextCellEditor textCellEditor = new TextCellEditor((Composite)tableViewer.getTable());
        ((Text)textCellEditor.getControl()).setTextLimit(60);
        cellEditorArray[0] = textCellEditor;
        return cellEditorArray;
    }

    private ICellModifier createModifier(TableViewer tableViewer) {
        return new DoubleClickModifier((ColumnViewer)tableViewer){

            public boolean canModify(Object object, String string) {
                if (!this.enabled) {
                    return false;
                }
                return object instanceof ExpressionObject && "Data".equalsIgnoreCase(string);
            }

            public Object getValue(Object object, String string) {
                String string2 = ((ExpressionObject)object).getExpression();
                return string2 != null ? string2 : "";
            }

            public void modify(Object object, String string, Object object2) {
                try {
                    try {
                        DataSetPlotView dataSetPlotView;
                        ExpressionObject expressionObject = (ExpressionObject)((IStructuredSelection)DataSetPlotView.this.dataViewer.getSelection()).getFirstElement();
                        expressionObject.setExpression((String)object2);
                        DataSetPlotView.this.dataViewer.setChecked((Object)expressionObject, true);
                        DataSetPlotView.this.dataViewer.refresh();
                        if (DataSetPlotView.this.isDialogMode && (dataSetPlotView = (DataSetPlotView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(DataSetPlotView.ID)) != null) {
                            dataSetPlotView.addExpression(new ExpressionObject(dataSetPlotView, expressionObject.getExpression(), expressionObject.getMementoKey()));
                        }
                        DataSetPlotView.this.saveExpressions();
                    }
                    catch (Exception exception) {
                        logger.error("Cannot set " + string, (Throwable)exception);
                        this.setEnabled(false);
                    }
                }
                finally {
                    this.setEnabled(false);
                }
            }
        };
    }

    private void initializeToolBar() {
        if (this.getViewSite() != null) {
            IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
            this.createDimensionalActions((IContributionManager)iToolBarManager, true);
        }
    }

    private void createDimensionalActions(IContributionManager iContributionManager, boolean bl) {
        Object object;
        final ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)new Action("XY Plot", 2){

            public void run() {
                DataSetPlotView.this.setPlotMode(PlotMode.PM1D);
            }
        });
        actionContributionItem.getAction().setImageDescriptor(ResourceManager.getImageDescriptor(this.getClass(), "/icons/chart_curve.png"));
        actionContributionItem.getAction().setToolTipText("XY Graph of Data, overlayed for multiple data.");
        final ActionContributionItem actionContributionItem2 = new ActionContributionItem((IAction)new Action("XY Staggered in Z", 2){

            public void run() {
                DataSetPlotView.this.setPlotMode(PlotMode.PMSTACKED);
            }
        });
        actionContributionItem2.getAction().setImageDescriptor(ResourceManager.getImageDescriptor(this.getClass(), "/icons/chart_curve_staggered.png"));
        actionContributionItem2.getAction().setToolTipText("XY Graph of Data, staggered in Z for multiple data.");
        final ActionContributionItem actionContributionItem3 = new ActionContributionItem((IAction)new Action("XYZ", 2){

            public void run() {
                DataSetPlotView.this.setPlotMode(PlotMode.PM3D);
            }
        });
        actionContributionItem3.getAction().setImageDescriptor(ResourceManager.getImageDescriptor(this.getClass(), "/icons/chart_curve_3D.png"));
        actionContributionItem3.getAction().setToolTipText("XYZ, X is the first chosen data and Z the last.");
        iContributionManager.add((IContributionItem)new Separator());
        iContributionManager.add((IContributionItem)actionContributionItem);
        iContributionManager.add((IContributionItem)actionContributionItem2);
        iContributionManager.add((IContributionItem)actionContributionItem3);
        iContributionManager.add((IContributionItem)new Separator());
        if (this.getSite() == null) {
            iContributionManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench(), null, "uk.ac.diamond.scisoft.analysis.rcp.addExpression", null, ResourceManager.getImageDescriptor(this.getClass(), "/icons/calculator_add.png"), null, null, "Add Expression", null, "Adds an expression which can be plotted. Must be function of other data sets.", 8, null, false)));
            iContributionManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench(), null, "uk.ac.diamond.scisoft.analysis.rcp.deleteExpression", null, ResourceManager.getImageDescriptor(this.getClass(), "/icons/calculator_delete.png"), null, null, "Delete Expression", null, "Deletes an expression.", 8, null, false)));
        }
        this.addPlotModeListener(new PlotModeListener(){

            @Override
            public void plotChangePerformed(PlotMode plotMode) {
                DataSetPlotView.this.updatePlotDimenionsSelected(actionContributionItem, actionContributionItem2, actionContributionItem3, plotMode);
                DataSetPlotView.this.updateSelection();
            }
        });
        if (this.isDialogMode && (object = (DataSetPlotView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(ID)) != null) {
            this.setPlotMode(((DataSetPlotView)object).getPlotMode());
        }
        Object object2 = object = this.getSite() != null ? this.getSite().getShell().getDisplay() : PlatformUI.getWorkbench().getDisplay();
        if (bl) {
            object.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataSetPlotView.this.updatePlotDimenionsSelected(actionContributionItem, actionContributionItem2, actionContributionItem3, DataSetPlotView.this.getPlotMode());
                }
            });
        } else {
            MenuManager menuManager = (MenuManager)iContributionManager;
            menuManager.addMenuListener(new IMenuListener((Display)object, actionContributionItem, actionContributionItem2, actionContributionItem3){
                private final /* synthetic */ Display val$dis;
                private final /* synthetic */ ActionContributionItem val$xyAction;
                private final /* synthetic */ ActionContributionItem val$staggeredAction;
                private final /* synthetic */ ActionContributionItem val$xyzAction;
                {
                    this.val$dis = display;
                    this.val$xyAction = actionContributionItem;
                    this.val$staggeredAction = actionContributionItem2;
                    this.val$xyzAction = actionContributionItem3;
                }

                public void menuAboutToShow(IMenuManager iMenuManager) {
                    this.val$dis.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DataSetPlotView.this.updatePlotDimenionsSelected(val$xyAction, val$staggeredAction, val$xyzAction, DataSetPlotView.this.getPlotMode());
                        }
                    });
                }
            });
        }
    }

    protected void updatePlotDimenionsSelected(ActionContributionItem actionContributionItem, ActionContributionItem actionContributionItem2, ActionContributionItem actionContributionItem3, PlotMode plotMode) {
        this.setActionSelected(actionContributionItem, PlotMode.PM1D.equals((Object)plotMode));
        this.setActionSelected(actionContributionItem2, PlotMode.PMSTACKED.equals((Object)plotMode));
        this.setActionSelected(actionContributionItem3, PlotMode.PM3D.equals((Object)plotMode));
    }

    protected void setActionSelected(ActionContributionItem actionContributionItem, boolean bl) {
        if (actionContributionItem.getWidget() instanceof ToolItem) {
            ((ToolItem)actionContributionItem.getWidget()).setSelection(bl);
        } else if (actionContributionItem.getWidget() instanceof MenuItem) {
            ((MenuItem)actionContributionItem.getWidget()).setSelection(bl);
        }
    }

    public void setFocus() {
    }

    public void setFile(final String string, IProgressMonitor iProgressMonitor) throws Exception {
        Object object2;
        iProgressMonitor.beginTask("Opening file " + string, 10);
        iProgressMonitor.worked(1);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        IMetaData iMetaData = LoaderFactory.getMetaData((String)string, (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
        ArrayList arrayList = new ArrayList(iMetaData.getDataNames());
        SortingUtils.removeIgnoredNames(arrayList, DataSetPlotView.getIgnored());
        Collections.sort(arrayList, new SortNatural(true));
        this.datasetSizes = iMetaData.getDataSizes();
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        Iterator<Object> iterator = this.data.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (object2 instanceof String) {
                iterator.remove();
                continue;
            }
            ((ExpressionObject)object2).clear();
        }
        int n = 0;
        for (Object object2 : arrayList) {
            this.data.add(n, object2);
            ++n;
        }
        this.filePath = string;
        try {
            this.readExpressions();
        }
        catch (Exception exception) {
            logger.error("Cannot read expressions for file.", (Throwable)exception);
        }
        object2 = this.getSite() != null ? this.getSite().getShell().getDisplay() : PlatformUI.getWorkbench().getDisplay();
        object2.asyncExec(new Runnable(){

            @Override
            public void run() {
                DataSetPlotView.this.setPartName(new File(string).getName());
                DataSetPlotView.this.dataViewer.refresh();
            }
        });
    }

    public List<Object> getSelections() {
        return this.selections;
    }

    public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
        if (this.checkStateLocked) {
            return;
        }
        try {
            this.checkStateLocked = true;
            if (this.selections == null) {
                this.selections = new ArrayList<Object>(7);
            }
            if (!checkStateChangedEvent.getChecked()) {
                this.selections.remove(checkStateChangedEvent.getElement());
            } else if (!this.selections.contains(checkStateChangedEvent.getElement())) {
                this.selections.add(checkStateChangedEvent.getElement());
            }
            this.updateSelection();
            this.dataViewer.refresh();
        }
        finally {
            this.checkStateLocked = false;
        }
    }

    private void updateSelection() {
        if (this.selections == null || this.selections.isEmpty()) {
            return;
        }
        this.fireSelectionListeners(this.selections);
        IProgressService iProgressService = this.getSite() != null ? (IProgressService)this.getSite().getService(IProgressService.class) : (IProgressService)PlatformUI.getWorkbench().getService(IProgressService.class);
        try {
            iProgressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    iProgressMonitor.beginTask("Updating selected DataSets", 100);
                    if (iProgressMonitor.isCanceled()) {
                        return;
                    }
                    if (DataSetPlotView.this.isDialogMode) {
                        return;
                    }
                    IDataset iDataset = DataSetPlotView.this.getDataSet(DataSetPlotView.this.selections.get(0), iProgressMonitor);
                    if (iDataset == null) {
                        return;
                    }
                    iProgressMonitor.worked(1);
                    ArrayList<IDataset> arrayList = new ArrayList<IDataset>(3);
                    int n = 1;
                    while (n < DataSetPlotView.this.selections.size()) {
                        arrayList.add(DataSetPlotView.this.getDataSet(DataSetPlotView.this.selections.get(n), iProgressMonitor));
                        if (iProgressMonitor.isCanceled()) {
                            return;
                        }
                        iProgressMonitor.worked(1);
                        ++n;
                    }
                    if (arrayList.isEmpty()) {
                        arrayList.add(iDataset);
                        iDataset = AbstractDataset.toDataSet((IDataset)((IDataset)arrayList.get(0))).getIndexDataSet();
                        iDataset.setName("Index");
                    }
                    PlotUtils.createPlot(iDataset, arrayList, DataSetPlotView.this.getPlotMode(), DataSetPlotView.this.getPlotWindow(), iProgressMonitor);
                    iProgressMonitor.done();
                }
            });
        }
        catch (Exception exception) {
            logger.error("Cannot create plot required.", (Throwable)exception);
        }
    }

    public void addSelectionListener(ISelectionChangedListener iSelectionChangedListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ISelectionChangedListener>(7);
        }
        this.listeners.add(iSelectionChangedListener);
    }

    public void removeSelectionListener(ISelectionChangedListener iSelectionChangedListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(iSelectionChangedListener);
    }

    private void fireSelectionListeners(List<Object> list) {
        if (this.listeners == null) {
            return;
        }
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this.dataViewer, (ISelection)new StructuredSelection(list));
        for (ISelectionChangedListener iSelectionChangedListener : this.listeners) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }

    public GuiPlotMode getGuiPlotMode() {
        return this.plotMode.getGuiPlotMode();
    }

    public PlotMode getPlotMode() {
        return this.plotMode;
    }

    public void setPlotMode(PlotMode plotMode) {
        this.plotMode = plotMode;
        if (this.plotModeListeners != null) {
            for (PlotModeListener plotModeListener : this.plotModeListeners) {
                plotModeListener.plotChangePerformed(plotMode);
            }
        }
    }

    protected void addPlotModeListener(PlotModeListener plotModeListener) {
        if (this.plotModeListeners == null) {
            this.plotModeListeners = new ArrayList<PlotModeListener>(7);
        }
        this.plotModeListeners.add(plotModeListener);
    }

    protected void removePlotModeListener(PlotModeListener plotModeListener) {
        if (this.plotModeListeners == null) {
            return;
        }
        this.plotModeListeners.remove(plotModeListener);
    }

    private List<String> getStringSelections(List<Object> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Object object : list) {
            if (!(object instanceof String)) continue;
            arrayList.add((String)object);
        }
        return arrayList;
    }

    @Override
    public IDataset getDataSet(String string, IProgressMonitor iProgressMonitor) {
        block5: {
            if (this.providerDeligate != null) {
                return this.providerDeligate.getDataSet(string, iProgressMonitor);
            }
            if (this.filePath != null) break block5;
            return null;
        }
        try {
            return LoaderFactory.getDataSet((String)this.filePath, (String)string, (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (Exception exception) {
            logger.error("Cannot get data set " + string + " from " + this.filePath + ". Currently expressions can only contain existing Data Sets.", (Throwable)exception);
            return null;
        }
    }

    @Override
    public boolean isDataSetName(String string, IProgressMonitor iProgressMonitor) {
        List<String> list = this.getStringSelections(this.data);
        return list.contains(string);
    }

    private IDataset getDataSet(Object object, IProgressMonitor iProgressMonitor) {
        if (object instanceof ExpressionObject) {
            try {
                return ((ExpressionObject)object).getDataSet(iProgressMonitor);
            }
            catch (Exception exception) {
                return new DoubleDataset();
            }
        }
        return this.getDataSet((String)object, iProgressMonitor);
    }

    public void dispose() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
        if (this.data != null) {
            this.data.clear();
        }
        if (this.plotModeListeners != null) {
            this.plotModeListeners.clear();
        }
        this.dataViewer.removeCheckStateListener((ICheckStateListener)this);
        super.dispose();
    }

    public void addExpression() {
        ExpressionObject expressionObject = new ExpressionObject(this);
        this.data.add(expressionObject);
        this.dataViewer.refresh();
        ((DoubleClickModifier)this.dataViewer.getCellModifier()).setEnabled(true);
        this.dataViewer.editElement((Object)expressionObject, 0);
    }

    protected void addExpression(ExpressionObject expressionObject) {
        this.data.add(expressionObject);
        this.dataViewer.refresh();
    }

    public void deleteExpression() {
        Object object = ((IStructuredSelection)this.dataViewer.getSelection()).getFirstElement();
        if (object == null || !(object instanceof ExpressionObject)) {
            return;
        }
        this.data.remove(object);
        this.dataViewer.refresh();
        this.saveExpressions();
    }

    public static List<Pattern> getIgnored() {
        IConfigurationElement[] iConfigurationElementArray;
        if (AnalysisRCPActivator.getDefault().getPreferenceStore().getBoolean("ignore.data.set.filters")) {
            return null;
        }
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>(5);
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("uk.ac.diamond.scisoft.analysis.data.set.filter");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            String string = iConfigurationElement.getAttribute("regularExpression");
            arrayList.add(Pattern.compile(string));
            ++n2;
        }
        return arrayList;
    }

    public void setData(List<Object> list, Map<String, Integer> map) {
        this.data.clear();
        this.data.addAll(list);
        if (map != null) {
            if (this.datasetSizes == null) {
                this.datasetSizes = new HashMap<String, Integer>(7);
            }
            this.datasetSizes.clear();
            this.datasetSizes.putAll(map);
        }
        try {
            this.readExpressions();
        }
        catch (Exception exception) {
            logger.error("Cannot read expressions for file.", (Throwable)exception);
        }
    }

    public void refresh() {
        this.dataViewer.refresh();
    }

    public List<Object> getExpressions(DataSetProvider dataSetProvider) {
        if (this.data == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        for (Object object : this.data) {
            if (!(object instanceof ExpressionObject)) continue;
            ExpressionObject expressionObject = (ExpressionObject)object;
            expressionObject = new ExpressionObject(dataSetProvider, expressionObject.getExpression(), expressionObject.getMementoKey());
            arrayList.add(expressionObject);
        }
        return arrayList;
    }

    public void setPlotWindow(PlotWindow plotWindow) {
        this.plotWindow = plotWindow;
    }

    protected PlotWindow getPlotWindow() {
        if (this.plotWindow != null) {
            return this.plotWindow;
        }
        try {
            PlotView plotView = (PlotView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("uk.ac.diamond.scisoft.analysis.rcp.plotViewNT1");
            return plotView.getPlotWindow();
        }
        catch (PartInitException partInitException) {
            logger.error("Cannot open uk.ac.diamond.scisoft.analysis.rcp.plotViewNT1", (Throwable)partInitException);
            return null;
        }
    }

    public String getFileName() {
        if (this.filePath != null) {
            return new File(this.filePath).getName();
        }
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    private class DataSetColumnLabelProvider
    extends ColumnLabelProvider {
        private Color RED = PlatformUI.getWorkbench().getDisplay().getSystemColor(3);
        private Color BLUE = PlatformUI.getWorkbench().getDisplay().getSystemColor(9);
        private Color BLACK = PlatformUI.getWorkbench().getDisplay().getSystemColor(2);
        private int columnIndex;

        DataSetColumnLabelProvider(int n) {
            this.columnIndex = n;
        }

        public String getText(Object object) {
            switch (this.columnIndex) {
                case 0: {
                    return object.toString();
                }
                case 1: {
                    if (DataSetPlotView.this.selections != null && !DataSetPlotView.this.selections.isEmpty()) {
                        if (DataSetPlotView.this.selections.size() > 1 && DataSetPlotView.this.selections.contains(object)) {
                            if (DataSetPlotView.this.selections.indexOf(object) == 0) {
                                return "X";
                            }
                            if (DataSetPlotView.this.selections.size() > 2) {
                                return "Y" + DataSetPlotView.this.selections.indexOf(object);
                            }
                            return "Y";
                        }
                        if (DataSetPlotView.this.selections.size() == 1 && DataSetPlotView.this.selections.contains(object)) {
                            return "Y";
                        }
                    }
                    return "";
                }
                case 2: {
                    if (object instanceof String || DataSetPlotView.this.requireToolbar) {
                        String string = object.toString();
                        if (DataSetPlotView.this.datasetSizes == null) {
                            IDataset iDataset = DataSetPlotView.this.getDataSet(string, null);
                            if (iDataset != null) {
                                return String.valueOf(iDataset.getSize());
                            }
                            return "Unknown";
                        }
                        return "" + DataSetPlotView.this.datasetSizes.get(string);
                    }
                    return String.valueOf(((ExpressionObject)object).getSize((IProgressMonitor)new NullProgressMonitor()));
                }
            }
            return object.toString();
        }

        public String getToolTipText(Object object) {
            return "With one data set selected it is plotted versus index of data with two or more the first set selected is the x-axis.";
        }

        public Color getForeground(Object object) {
            switch (this.columnIndex) {
                case 0: {
                    if (object instanceof ExpressionObject) {
                        ExpressionObject expressionObject = (ExpressionObject)object;
                        return expressionObject.isValid((IProgressMonitor)new NullProgressMonitor()) ? this.BLUE : this.RED;
                    }
                    return this.BLACK;
                }
            }
            return this.BLACK;
        }
    }

    protected static interface PlotModeListener
    extends EventListener {
        public void plotChangePerformed(PlotMode var1);
    }
}

