/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import gda.observable.IObservable;
import gda.observable.IObserver;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.PlotServer;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IGuiInfoManager;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IUpdateNotificationListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotJob;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotJobType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.views.PlotServerProvider;
import uk.ac.diamond.scisoft.analysis.rcp.views.PlotViewConfig;

public class PlotView
extends ViewPart
implements IObserver,
IObservable,
IGuiInfoManager,
IUpdateNotificationListener {
    private static final Logger logger = LoggerFactory.getLogger(PlotView.class);
    public static final String ID = "uk.ac.diamond.scisoft.analysis.rcp.plotView";
    private String id;
    private PlotWindow plotWindow;
    private PlotServer plotServer;
    private ExecutorService execSvc = null;
    private PlotConsumer plotConsumer = null;
    protected String plotViewName = "Plot View";
    private IPlotUI plotUI = null;
    private UUID plotID = null;
    private GuiBean guiBean = null;
    private Set<IObserver> dataObservers = Collections.synchronizedSet(new LinkedHashSet());
    private List<IObserver> observers = Collections.synchronizedList(new LinkedList());

    public String getId() {
        return this.id;
    }

    public IPlotUI getPlotUI() {
        return this.plotUI;
    }

    public PlotView() {
        this.init();
    }

    public PlotView(String string) {
        this.id = string;
        this.init();
    }

    private void init() {
        this.plotID = UUID.randomUUID();
        logger.info("Plot view uuid: {}", (Object)this.plotID);
        this.plotServer = PlotServerProvider.getPlotServer();
        this.plotServer.addIObserver((IObserver)this);
        this.execSvc = Executors.newFixedThreadPool(2);
    }

    public void createPartControl(Composite composite) {
        PlotViewConfig plotViewConfig;
        if (this.id != null) {
            logger.info("ID: {}", (Object)this.id);
            plotViewConfig = new PlotViewConfig(this.id);
            this.plotViewName = plotViewConfig.getName();
            this.setPartName(plotViewConfig.getName());
        } else {
            this.plotViewName = this.getViewSite().getRegisteredName();
        }
        logger.info("View name is {}", (Object)this.plotViewName);
        this.plotConsumer = new PlotConsumer(this.plotServer, this.plotViewName);
        composite.setLayout((Layout)new FillLayout());
        plotViewConfig = this.getGUIInfo();
        this.plotWindow = new PlotWindow(composite, (GuiPlotMode)plotViewConfig.get(GuiParameters.PLOTMODE), this, this, this.getViewSite().getActionBars(), this.getSite().getPage(), this.plotViewName);
        this.plotWindow.updatePlotMode((GuiBean)plotViewConfig, false);
        this.plotConsumer.addIObserver(this);
        this.execSvc.execute(this.plotConsumer);
        this.plotConsumer.addJob(new PlotJob(PlotJobType.Data));
    }

    public void setFocus() {
    }

    public void update(Object object, Object object2) {
        if (object.equals(this.plotConsumer)) {
            if (object2 instanceof DataBean) {
                this.plotWindow.processPlotUpdate((DataBean)object2);
                this.notifyDataObservers((DataBean)object2);
            } else if (object2 instanceof GuiBean) {
                this.plotWindow.processGUIUpdate((GuiBean)object2);
            }
        } else {
            GuiBean guiBean;
            UUID uUID;
            GuiUpdate guiUpdate;
            if (object2 instanceof String && object2.equals(this.plotViewName)) {
                this.plotConsumer.addJob(new PlotJob(PlotJobType.Data));
            }
            if (object2 instanceof GuiUpdate && (guiUpdate = (GuiUpdate)object2).getGuiName().contains(this.plotViewName) && ((uUID = (UUID)(guiBean = guiUpdate.getGuiData()).get((Object)GuiParameters.PLOTID)) == null || this.plotID.compareTo(uUID) != 0)) {
                if (this.guiBean == null) {
                    this.guiBean = guiBean.copy();
                } else {
                    this.guiBean.merge(guiBean);
                }
                PlotJob plotJob = new PlotJob(PlotJobType.GUI);
                plotJob.setGuiBean(guiBean);
                this.plotConsumer.addJob(plotJob);
            }
        }
    }

    public void addIObserver(IObserver iObserver) {
        this.observers.add(iObserver);
    }

    public void deleteIObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
    }

    public void deleteIObservers() {
        this.observers.clear();
    }

    public void addDataObserver(IObserver iObserver) {
        this.dataObservers.add(iObserver);
    }

    public void deleteDataObserver(IObserver iObserver) {
        this.dataObservers.remove(iObserver);
    }

    public void deleteDataObservers() {
        this.dataObservers.clear();
    }

    private void notifyDataObservers(DataBean dataBean) {
        for (IObserver iObserver : this.dataObservers) {
            iObserver.update((Object)this, (Object)dataBean);
        }
    }

    @Override
    public GuiBean getGUIInfo() {
        this.getGUIState();
        return this.guiBean;
    }

    private void getGUIState() {
        if (this.guiBean == null) {
            try {
                this.guiBean = this.plotServer.getGuiState(this.plotViewName);
            }
            catch (Exception exception) {
                logger.warn("Problem with getting GUI data from plot server");
            }
            if (this.guiBean == null) {
                this.guiBean = new GuiBean();
            }
        }
    }

    private void pushGUIState() {
        try {
            this.plotServer.updateGui(this.plotViewName, this.guiBean);
        }
        catch (Exception exception) {
            logger.warn("Problem with updating plot server with GUI data");
            exception.printStackTrace();
        }
    }

    @Override
    public void putGUIInfo(GuiParameters guiParameters, Serializable serializable) {
        this.getGUIState();
        this.guiBean.put((Object)GuiParameters.PLOTID, (Object)this.plotID);
        this.guiBean.put((Object)guiParameters, (Object)serializable);
        this.pushGUIState();
    }

    public void removeGUIInfo(String string) {
        this.getGUIState();
        this.guiBean.put((Object)GuiParameters.PLOTID, (Object)this.plotID);
        this.guiBean.remove((Object)string);
        this.pushGUIState();
    }

    public void dispose() {
        this.plotWindow.dispose();
        this.plotConsumer.stop();
        this.execSvc.shutdown();
        this.deleteIObservers();
        this.deleteDataObservers();
        System.gc();
    }

    @Override
    public void removeGUIInfo(GuiParameters guiParameters) {
        this.guiBean.remove((Object)guiParameters);
    }

    public String getPlotViewName() {
        return this.plotViewName;
    }

    public void updatePlotMode(GuiPlotMode guiPlotMode) {
        this.plotWindow.updatePlotMode(guiPlotMode);
    }

    public void processPlotUpdate(DataBean dataBean) {
        this.plotWindow.processPlotUpdate(dataBean);
    }

    public void processGUIUpdate(GuiBean guiBean) {
        this.plotWindow.processGUIUpdate(guiBean);
    }

    public DataSetPlotter getMainPlotter() {
        return this.plotWindow.getMainPlotter();
    }

    public PlotWindow getPlotWindow() {
        return this.plotWindow;
    }

    @Override
    public void updateProcessed() {
        if (this.plotConsumer != null) {
            this.plotConsumer.dataUpdateFinished();
        }
    }
}

