/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import gda.observable.IObservable;
import gda.observable.IObserver;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Stats;
import uk.ac.diamond.scisoft.analysis.dataset.function.Histogram;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramDataUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramUI;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.AbstractMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.ConstMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.CosMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.CubicMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.CustomAPieceWiseLinearMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.FourthRootMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.GeoBlueMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.GeoGreenMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.GeoRedMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.LinearMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.NCDGamma2BlueFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.NCDGamma2GreenFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.NCDGamma2RedFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.QuarticMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.SinMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.SpecialExposureFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.SquareMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.SquareRootMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.SquareScaleOffsetMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.Plot1DStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.ScaleType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;

public class HistogramView
extends ViewPart
implements SelectionListener,
IObservable,
IObserver {
    private static final Logger logger = LoggerFactory.getLogger(HistogramView.class);
    protected List<IDataset> histograms = null;
    protected List<IObserver> observers = Collections.synchronizedList(new LinkedList());
    protected LinkedList<AbstractMapFunction> mappingFunctions = null;
    protected DataSetPlotter histogramPlotter;
    protected AxisValues xAxis = null;
    protected Composite parent;
    protected int histogramSize = 128;
    protected static final double MINIMUMPIXELTHRESHOLD = 0.01;
    protected IDataset data = null;
    protected CCombo cmbAlpha;
    protected CCombo cmbRedColour;
    protected CCombo cmbGreenColour;
    protected CCombo cmbBlueColour;
    protected Button btnGreenInverse;
    protected Button btnBlueInverse;
    protected Button btnAlphaInverse;
    protected Button btnRedInverse;
    protected float specialMinThreshold = 0.1f;
    protected float specialMaxThreshold = 0.9f;
    protected int curRedSelect = 3;
    protected int curGreenSelect = 3;
    protected int curBlueSelect = 3;
    protected int curAlphaSelect = 3;
    protected boolean curRedInverse = false;
    protected boolean curGreenInverse = false;
    protected boolean curBlueInverse = false;
    protected boolean curAlphaInverse = false;
    private CCombo cmbColourMap;
    private Composite composite;
    private Composite container;
    private FormData formData_1;
    private FormData formData_2;
    private FormData formData_3;
    private FormData formData_4;
    private FormData formData_5;
    private FormData spnMinFormData;
    private FormData spnMaxFormData;
    private HashMap<String, Integer> indexOfMappingFunctions = null;
    private Spinner spnMinValue;
    private Spinner spnMaxValue;
    private Label lblMinValue;
    private Label lblMaxValue;
    private Histogram histogramFunc;
    protected IPlotUI histogramUI = null;
    private ArrayList<Integer> colourSelectList = new ArrayList();
    private double colourTableMin;
    private double colourTableMax;
    private boolean autoHistogram = true;
    private boolean lockRange = false;
    private boolean initialStart = true;
    private String id;
    private String sId;

    public HistogramView() {
        this.mappingFunctions = new LinkedList();
        this.histogramFunc = new Histogram(this.histogramSize);
        this.xAxis = new AxisValues();
    }

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        this.id = iViewSite.getId();
        this.sId = iViewSite.getSecondaryId();
        try {
            this.setPartName("Histogram " + new File(this.sId).getName());
        }
        catch (Exception exception) {
            this.setPartName("Histogram");
        }
    }

    protected void buildToolbar() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.histogramUI = new HistogramUI(this, iActionBars, this.histogramPlotter);
        this.histogramUI.addIObserver(this);
        this.histogramPlotter.registerUI(this.histogramUI);
    }

    public void createPartControl(Composite composite) {
        this.parent = composite;
        this.mappingFunctions.clear();
        this.container = new Composite(composite, 0);
        this.container.setLayout((Layout)new FormLayout());
        this.cmbColourMap = new CCombo(this.container, 2056);
        Object object = new FormData();
        ((FormData)object).top = new FormAttachment(0, 10);
        ((FormData)object).left = new FormAttachment(0, 44);
        ((FormData)object).width = 337;
        this.cmbColourMap.setLayoutData(object);
        this.spnMinValue = new Spinner(this.container, 2048);
        this.spnMinFormData = new FormData();
        this.spnMinFormData.top = new FormAttachment(0, 10);
        this.spnMinFormData.left = new FormAttachment((Control)this.cmbColourMap, 10);
        this.spnMinFormData.width = 50;
        this.spnMinValue.setLayoutData((Object)this.spnMinFormData);
        this.spnMaxValue = new Spinner(this.container, 2048);
        this.spnMaxFormData = new FormData();
        this.spnMaxFormData.top = new FormAttachment((Control)this.spnMinValue, 10);
        this.spnMaxFormData.left = new FormAttachment((Control)this.cmbColourMap, 10);
        this.spnMaxFormData.width = 50;
        this.spnMaxValue.setLayoutData((Object)this.spnMaxFormData);
        this.cmbRedColour = new CCombo(this.container, 2056);
        this.formData_3 = new FormData();
        this.formData_3.top = new FormAttachment((Control)this.cmbColourMap, 19);
        this.formData_3.left = new FormAttachment(0, 123);
        this.formData_3.width = 124;
        this.cmbRedColour.setLayoutData((Object)this.formData_3);
        this.cmbGreenColour = new CCombo(this.container, 2056);
        this.formData_2 = new FormData();
        this.formData_2.left = new FormAttachment((Control)this.cmbRedColour, 0, 16384);
        this.cmbGreenColour.setLayoutData((Object)this.formData_2);
        this.cmbBlueColour = new CCombo(this.container, 2056);
        this.formData_4 = new FormData();
        this.formData_4.right = new FormAttachment((Control)this.cmbRedColour, 0, 131072);
        this.formData_4.left = new FormAttachment((Control)this.cmbRedColour, 0, 16384);
        this.cmbBlueColour.setLayoutData((Object)this.formData_4);
        this.btnRedInverse = new Button(this.container, 32);
        this.formData_1 = new FormData();
        this.formData_1.top = new FormAttachment((Control)this.cmbColourMap, 19);
        this.formData_1.width = 98;
        this.btnRedInverse.setLayoutData((Object)this.formData_1);
        this.btnRedInverse.setText("Inverse");
        this.btnRedInverse.addSelectionListener((SelectionListener)this);
        this.cmbAlpha = new CCombo(this.container, 2056);
        this.formData_5 = new FormData();
        this.formData_5.left = new FormAttachment((Control)this.cmbRedColour, 0, 16384);
        this.cmbAlpha.setLayoutData((Object)this.formData_5);
        this.btnGreenInverse = new Button(this.container, 32);
        this.formData_2.bottom = new FormAttachment((Control)this.btnGreenInverse, 0, 1024);
        this.formData_2.right = new FormAttachment((Control)this.btnGreenInverse, -20);
        this.formData_1.left = new FormAttachment((Control)this.btnGreenInverse, 0, 16384);
        object = new FormData();
        ((FormData)object).top = new FormAttachment((Control)this.btnRedInverse, 21);
        ((FormData)object).left = new FormAttachment(0, 271);
        this.btnGreenInverse.setLayoutData(object);
        this.btnGreenInverse.setText("Inverse");
        this.btnGreenInverse.addSelectionListener((SelectionListener)this);
        this.btnBlueInverse = new Button(this.container, 32);
        this.formData_4.top = new FormAttachment((Control)this.btnBlueInverse, 0, 128);
        object = new FormData();
        ((FormData)object).top = new FormAttachment((Control)this.btnGreenInverse, 18);
        ((FormData)object).left = new FormAttachment((Control)this.btnRedInverse, 0, 16384);
        this.btnBlueInverse.setLayoutData(object);
        this.btnBlueInverse.setText("Inverse");
        this.btnBlueInverse.addSelectionListener((SelectionListener)this);
        this.btnAlphaInverse = new Button(this.container, 32);
        this.formData_5.top = new FormAttachment((Control)this.btnAlphaInverse, 0, 128);
        this.formData_5.right = new FormAttachment((Control)this.btnAlphaInverse, -20);
        object = new FormData();
        ((FormData)object).top = new FormAttachment((Control)this.btnBlueInverse, 21);
        ((FormData)object).left = new FormAttachment((Control)this.btnRedInverse, 0, 16384);
        this.btnAlphaInverse.setLayoutData(object);
        this.btnAlphaInverse.setText("Inverse");
        this.btnAlphaInverse.addSelectionListener((SelectionListener)this);
        this.composite = new Composite(this.container, 0);
        this.composite.setLayout((Layout)new FillLayout());
        object = new FormData();
        ((FormData)object).top = new FormAttachment((Control)this.cmbAlpha, 2);
        ((FormData)object).bottom = new FormAttachment(100, -10);
        ((FormData)object).right = new FormAttachment(100, -10);
        ((FormData)object).height = 167;
        ((FormData)object).width = 422;
        ((FormData)object).left = new FormAttachment((Control)this.cmbColourMap, 0, 16384);
        this.composite.setLayoutData(object);
        this.histogramPlotter = new DataSetPlotter(PlottingMode.BARCHART, this.composite, false);
        this.histogramPlotter.setXAxisLabel("Intensity Value");
        this.histogramPlotter.setYAxisLabel("Count");
        this.histogramPlotter.setAxisModes(AxisMode.CUSTOM, AxisMode.LINEAR, AxisMode.LINEAR);
        this.histogramPlotter.setXTickLabelFormat(TickFormatting.plainMode);
        this.histogramPlotter.setXAxisValues(this.xAxis, 1);
        object = this.histogramPlotter.getColourTable();
        Plot1DAppearance plot1DAppearance = new Plot1DAppearance(Color.RED, Plot1DStyles.SOLID, "");
        ((Plot1DGraphTable)object).addEntryOnLegend(plot1DAppearance);
        plot1DAppearance = new Plot1DAppearance(Color.GREEN, Plot1DStyles.SOLID, "");
        ((Plot1DGraphTable)object).addEntryOnLegend(plot1DAppearance);
        plot1DAppearance = new Plot1DAppearance(Color.BLUE, Plot1DStyles.SOLID, "");
        ((Plot1DGraphTable)object).addEntryOnLegend(plot1DAppearance);
        plot1DAppearance = new Plot1DAppearance(Color.ORANGE, Plot1DStyles.SOLID, "");
        ((Plot1DGraphTable)object).addEntryOnLegend(plot1DAppearance);
        object = new Label(this.container, 0);
        plot1DAppearance = new FormData();
        ((FormData)plot1DAppearance).top = new FormAttachment((Control)this.cmbRedColour, 0, 128);
        ((FormData)plot1DAppearance).right = new FormAttachment((Control)this.cmbRedColour, -19);
        object.setLayoutData((Object)plot1DAppearance);
        object.setText("Red");
        plot1DAppearance = new Label(this.container, 0);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.cmbGreenColour, 0, 128);
        formData.left = new FormAttachment((Control)object, 0, 16384);
        plot1DAppearance.setLayoutData(formData);
        plot1DAppearance.setText("Green");
        plot1DAppearance = new Label(this.container, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.cmbBlueColour, 0, 128);
        formData.left = new FormAttachment((Control)object, 0, 16384);
        plot1DAppearance.setLayoutData(formData);
        plot1DAppearance.setText("Blue");
        plot1DAppearance = new Label(this.container, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.cmbAlpha, 0, 128);
        formData.left = new FormAttachment((Control)object, 0, 16384);
        plot1DAppearance.setLayoutData(formData);
        plot1DAppearance.setText("Alpha");
        this.spnMinValue.dispose();
        this.spnMaxValue.dispose();
        this.spnMinValue = null;
        this.spnMaxValue = null;
        this.cmbColourMap.addSelectionListener((SelectionListener)this);
        this.cmbRedColour.addSelectionListener((SelectionListener)this);
        this.cmbGreenColour.addSelectionListener((SelectionListener)this);
        this.cmbBlueColour.addSelectionListener((SelectionListener)this);
        this.cmbAlpha.addSelectionListener((SelectionListener)this);
        this.buildToolbar();
        this.fillupColourComboBoxes();
        this.fillupColourMapBox();
        this.buildGradientImage();
    }

    public void addToColourMapBox(String string, String string2, boolean bl, String string3, boolean bl2, String string4, boolean bl3, String string5, boolean bl4) {
        this.cmbColourMap.add(string);
        Integer n = this.indexOfMappingFunctions.get(string2);
        if (n == null) {
            logger.warn("Cannot find mapping function {}, resorting to x");
            n = this.indexOfMappingFunctions.get("x");
        }
        if (bl) {
            n = n * -1;
        }
        this.colourSelectList.add(n);
        n = this.indexOfMappingFunctions.get(string3);
        if (n == null) {
            logger.warn("Cannot find mapping function {}, resorting to x");
            n = this.indexOfMappingFunctions.get("x");
        }
        if (bl2) {
            n = n * -1;
        }
        this.colourSelectList.add(n);
        n = this.indexOfMappingFunctions.get(string4);
        if (n == null) {
            logger.warn("Cannot find mapping function {}, resorting to x");
            n = this.indexOfMappingFunctions.get("x");
        }
        if (bl3) {
            n = n * -1;
        }
        this.colourSelectList.add(n);
        n = this.indexOfMappingFunctions.get(string5);
        if (n == null) {
            logger.warn("Cannot find mapping function {}, resorting to 1.0");
            n = this.indexOfMappingFunctions.get("1.0");
        }
        if (bl4) {
            n = n * -1;
        }
        this.colourSelectList.add(n);
    }

    public void clearColourMapBox() {
        this.cmbColourMap.removeAll();
        this.colourSelectList.clear();
    }

    public void addToMappings(AbstractMapFunction abstractMapFunction) {
        int n;
        if (this.indexOfMappingFunctions == null) {
            this.indexOfMappingFunctions = new HashMap();
            n = 0;
        } else {
            n = this.mappingFunctions.size();
        }
        String string = abstractMapFunction.getMapFunctionName();
        if (this.indexOfMappingFunctions.containsKey(string)) {
            logger.warn("Adding a mapping function whose name, {}, already exists", (Object)string);
            logger.warn("Overwriting the index");
        }
        this.cmbRedColour.add(string);
        this.cmbGreenColour.add(string);
        this.cmbBlueColour.add(string);
        this.cmbAlpha.add(string);
        this.mappingFunctions.add(abstractMapFunction);
        this.indexOfMappingFunctions.put(string, n);
    }

    private void fillupColourMapBox() {
        this.addToColourMapBox("Grey", "x", false, "x", false, "x", false, "1.0", false);
        this.addToColourMapBox("Film negative", "x", true, "x", true, "x", true, "1.0", false);
        this.addToColourMapBox("Traditional pm3d (black-blue-red-yellow)", "sqrt(x)", false, "x^3", false, "sin(x*360)", false, "1.0", false);
        this.addToColourMapBox("Ncd Colour", "NCD Gamma II Red", false, "NCD Gamma II Green", false, "NCD Gamma II Blue", false, "1.0", false);
        this.addToColourMapBox("Green-red-violet", "x", false, "|x-0.5|", false, "x^4", false, "1.0", false);
        this.addToColourMapBox("Ocean (green-blue-white)", "3x-2", false, "|3x-1|/2", false, "x", false, "1.0", false);
        this.addToColourMapBox("Hot (black-red-yellow-white)", "3x", false, "3x-1", false, "3x-2", false, "1.0", false);
        this.addToColourMapBox("Colour printable on gray (black-blue-violet-yellow-white)", "x/0.32-0.78125", false, "2x-0.84", false, "4x;1;-2x+1.84;12.5x-11.5", false, "1.0", false);
        this.addToColourMapBox("Rainbow (blue-green-yellow-red)", "|2x-0.5|", false, "sin(x*180)", false, "cos(x*90)", false, "1.0", false);
        this.addToColourMapBox("AFM hot (black-red-yellow-white)", "2x", false, "2x-0.5", false, "2x-1", false, "1.0", false);
        this.addToColourMapBox("Low Skewed Grayscale (black-white)", "sqrt(x)", false, "sqrt(x)", false, "sqrt(x)", false, "1.0", false);
        this.addToColourMapBox("High Skewed Grayscale (black-white)", "x^2", false, "x^2", false, "x^2", false, "1.0", false);
        this.addToColourMapBox("Geographical", "GeoRed", false, "GeoGreen", false, "GeoBlue", false, "1.0", false);
        this.addToColourMapBox("Mark's special", "RedSpecial", false, "GreenSpecial", false, "BlueSpecial", false, "1.0", false);
        this.cmbColourMap.select(0);
    }

    protected void fillupColourComboBoxes() {
        ConstMapFunction constMapFunction = new ConstMapFunction(0.0, "0");
        this.addToMappings(constMapFunction);
        ConstMapFunction constMapFunction2 = new ConstMapFunction(0.5, "0.5");
        this.addToMappings(constMapFunction2);
        ConstMapFunction constMapFunction3 = new ConstMapFunction(1.0, "1.0");
        this.addToMappings(constMapFunction3);
        LinearMapFunction linearMapFunction = new LinearMapFunction();
        this.addToMappings(linearMapFunction);
        this.cmbRedColour.select(3);
        this.cmbGreenColour.select(3);
        this.cmbBlueColour.select(3);
        this.cmbAlpha.select(2);
        SquareMapFunction squareMapFunction = new SquareMapFunction();
        this.addToMappings(squareMapFunction);
        CubicMapFunction cubicMapFunction = new CubicMapFunction();
        this.addToMappings(cubicMapFunction);
        QuarticMapFunction quarticMapFunction = new QuarticMapFunction();
        this.addToMappings(quarticMapFunction);
        SquareRootMapFunction squareRootMapFunction = new SquareRootMapFunction();
        this.addToMappings(squareRootMapFunction);
        FourthRootMapFunction fourthRootMapFunction = new FourthRootMapFunction();
        this.addToMappings(fourthRootMapFunction);
        SinMapFunction sinMapFunction = new SinMapFunction("sin(x*90)", 1.5707963267948966, false);
        this.addToMappings(sinMapFunction);
        CosMapFunction cosMapFunction = new CosMapFunction("cos(x*90)", 1.5707963267948966, false);
        this.addToMappings(cosMapFunction);
        LinearMapFunction linearMapFunction2 = new LinearMapFunction("|x-0.5|", -0.5, true);
        this.addToMappings(linearMapFunction2);
        SquareScaleOffsetMapFunction squareScaleOffsetMapFunction = new SquareScaleOffsetMapFunction("(2x-1)^2", 2.0, -1.0);
        this.addToMappings(squareScaleOffsetMapFunction);
        SinMapFunction sinMapFunction2 = new SinMapFunction("sin(x*180)", Math.PI, false);
        this.addToMappings(sinMapFunction2);
        CosMapFunction cosMapFunction2 = new CosMapFunction("|cos(x*180)|", Math.PI, true);
        this.addToMappings(cosMapFunction2);
        SinMapFunction sinMapFunction3 = new SinMapFunction("sin(x*360)", Math.PI * 2, false);
        this.addToMappings(sinMapFunction3);
        CosMapFunction cosMapFunction3 = new CosMapFunction("cos(x*360)", Math.PI * 2, false);
        this.addToMappings(cosMapFunction3);
        SinMapFunction sinMapFunction4 = new SinMapFunction("|sin(x*360)|", Math.PI * 2, true);
        this.addToMappings(sinMapFunction4);
        CosMapFunction cosMapFunction4 = new CosMapFunction("|cos(x*360)|", Math.PI * 2, true);
        this.addToMappings(cosMapFunction4);
        SinMapFunction sinMapFunction5 = new SinMapFunction("|sin(x*720)|", Math.PI * 4, true);
        this.addToMappings(sinMapFunction5);
        CosMapFunction cosMapFunction5 = new CosMapFunction("|cos(x*720)|", Math.PI * 4, true);
        this.addToMappings(cosMapFunction5);
        LinearMapFunction linearMapFunction3 = new LinearMapFunction("3x", 3.0, false);
        this.addToMappings(linearMapFunction3);
        LinearMapFunction linearMapFunction4 = new LinearMapFunction("3x-1", 3.0, -1.0, false);
        this.addToMappings(linearMapFunction4);
        LinearMapFunction linearMapFunction5 = new LinearMapFunction("3x-2", 3.0, -2.0, false);
        this.addToMappings(linearMapFunction5);
        LinearMapFunction linearMapFunction6 = new LinearMapFunction("|3x-1|", 3.0, -1.0, true);
        this.addToMappings(linearMapFunction6);
        LinearMapFunction linearMapFunction7 = new LinearMapFunction("|3x-2|", 3.0, -2.0, true);
        this.addToMappings(linearMapFunction7);
        LinearMapFunction linearMapFunction8 = new LinearMapFunction("(3x-1)/2", 1.5, -0.5, false);
        this.addToMappings(linearMapFunction8);
        LinearMapFunction linearMapFunction9 = new LinearMapFunction("(3x-2)/2", 1.5, -1.0, false);
        this.addToMappings(linearMapFunction9);
        LinearMapFunction linearMapFunction10 = new LinearMapFunction("|3x-1|/2", 1.5, -0.5, true);
        this.addToMappings(linearMapFunction10);
        LinearMapFunction linearMapFunction11 = new LinearMapFunction("|3x-2|/2", 1.5, -1.0, true);
        this.addToMappings(linearMapFunction11);
        LinearMapFunction linearMapFunction12 = new LinearMapFunction("2x", 2.0, false);
        this.addToMappings(linearMapFunction12);
        LinearMapFunction linearMapFunction13 = new LinearMapFunction("2x-0.5", 2.0, -0.5, false);
        this.addToMappings(linearMapFunction13);
        LinearMapFunction linearMapFunction14 = new LinearMapFunction("2x-1", 2.0, -1.0, false);
        this.addToMappings(linearMapFunction14);
        LinearMapFunction linearMapFunction15 = new LinearMapFunction("|2x-0.5|", 2.0, -0.5, true);
        this.addToMappings(linearMapFunction15);
        LinearMapFunction linearMapFunction16 = new LinearMapFunction("x/0.32-0.78125", 3.125, -0.78125, false);
        this.addToMappings(linearMapFunction16);
        LinearMapFunction linearMapFunction17 = new LinearMapFunction("2x-0.84", 2.0, -0.84, false);
        this.addToMappings(linearMapFunction17);
        CustomAPieceWiseLinearMapFunction customAPieceWiseLinearMapFunction = new CustomAPieceWiseLinearMapFunction();
        this.addToMappings(customAPieceWiseLinearMapFunction);
        NCDGamma2RedFunction nCDGamma2RedFunction = new NCDGamma2RedFunction();
        this.addToMappings(nCDGamma2RedFunction);
        NCDGamma2GreenFunction nCDGamma2GreenFunction = new NCDGamma2GreenFunction();
        this.addToMappings(nCDGamma2GreenFunction);
        NCDGamma2BlueFunction nCDGamma2BlueFunction = new NCDGamma2BlueFunction();
        this.addToMappings(nCDGamma2BlueFunction);
        GeoBlueMapFunction geoBlueMapFunction = new GeoBlueMapFunction();
        GeoGreenMapFunction geoGreenMapFunction = new GeoGreenMapFunction();
        GeoRedMapFunction geoRedMapFunction = new GeoRedMapFunction();
        this.addToMappings(geoRedMapFunction);
        this.addToMappings(geoGreenMapFunction);
        this.addToMappings(geoBlueMapFunction);
        SpecialExposureFunction specialExposureFunction = new SpecialExposureFunction("RedSpecial", this.specialMinThreshold, this.specialMaxThreshold, 'r');
        this.addToMappings(specialExposureFunction);
        SpecialExposureFunction specialExposureFunction2 = new SpecialExposureFunction("GreenSpecial", this.specialMinThreshold, this.specialMaxThreshold, 'g');
        this.addToMappings(specialExposureFunction2);
        SpecialExposureFunction specialExposureFunction3 = new SpecialExposureFunction("BlueSpecial", this.specialMinThreshold, this.specialMaxThreshold, 'b');
        this.addToMappings(specialExposureFunction3);
    }

    protected void buildGradientImage() {
        AbstractMapFunction abstractMapFunction = this.mappingFunctions.get(this.cmbRedColour.getSelectionIndex());
        AbstractMapFunction abstractMapFunction2 = this.mappingFunctions.get(this.cmbGreenColour.getSelectionIndex());
        AbstractMapFunction abstractMapFunction3 = this.mappingFunctions.get(this.cmbBlueColour.getSelectionIndex());
        AbstractMapFunction abstractMapFunction4 = this.mappingFunctions.get(this.cmbAlpha.getSelectionIndex());
        boolean bl = this.btnRedInverse.getSelection();
        boolean bl2 = this.btnGreenInverse.getSelection();
        boolean bl3 = this.btnBlueInverse.getSelection();
        boolean bl4 = this.btnAlphaInverse.getSelection();
        this.histogramPlotter.applyColorCast(abstractMapFunction, abstractMapFunction2, abstractMapFunction3, abstractMapFunction4, bl, bl2, bl3, bl4, 0.0, 256.0);
        this.histogramPlotter.refresh(false);
    }

    private void notifyObservers(HistogramUpdate histogramUpdate) {
        for (IObserver iObserver : this.observers) {
            iObserver.update((Object)this, (Object)histogramUpdate);
        }
    }

    public void setFocus() {
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    protected boolean hasData() {
        return this.data != null;
    }

    protected void handleChange(int n) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource().equals(this.cmbRedColour) || selectionEvent.getSource().equals(this.cmbGreenColour) || selectionEvent.getSource().equals(this.cmbBlueColour) || selectionEvent.getSource().equals(this.cmbAlpha) || selectionEvent.getSource().equals(this.btnRedInverse) || selectionEvent.getSource().equals(this.btnGreenInverse) || selectionEvent.getSource().equals(this.btnBlueInverse) || selectionEvent.getSource().equals(this.btnAlphaInverse)) {
            this.curAlphaSelect = this.cmbAlpha.getSelectionIndex();
            this.curRedSelect = this.cmbRedColour.getSelectionIndex();
            this.curGreenSelect = this.cmbGreenColour.getSelectionIndex();
            this.curBlueSelect = this.cmbBlueColour.getSelectionIndex();
            this.curAlphaInverse = this.btnAlphaInverse.getSelection();
            this.curRedInverse = this.btnRedInverse.getSelection();
            this.curGreenInverse = this.btnGreenInverse.getSelection();
            this.curBlueInverse = this.btnBlueInverse.getSelection();
            if (this.hasData()) {
                if (selectionEvent.getSource().equals(this.cmbRedColour)) {
                    this.handleChange(0);
                } else if (selectionEvent.getSource().equals(this.cmbGreenColour)) {
                    this.handleChange(1);
                } else if (selectionEvent.getSource().equals(this.cmbBlueColour)) {
                    this.handleChange(2);
                } else if (selectionEvent.getSource().equals(this.cmbAlpha)) {
                    this.handleChange(3);
                }
                this.updateChannelGraphs();
                this.generateHistogramUpdate();
            }
            if (selectionEvent.getSource().equals(this.cmbGreenColour) || selectionEvent.getSource().equals(this.cmbRedColour) || selectionEvent.getSource().equals(this.btnRedInverse) || selectionEvent.getSource().equals(this.btnGreenInverse) || selectionEvent.getSource().equals(this.btnBlueInverse) || selectionEvent.getSource().equals(this.btnAlphaInverse)) {
                this.histogramPlotter.refresh(true);
            }
            this.buildGradientImage();
        } else if (selectionEvent.getSource().equals(this.cmbColourMap)) {
            int n = this.cmbColourMap.getSelectionIndex();
            int n2 = this.colourSelectList.get(n * 4);
            int n3 = this.colourSelectList.get(n * 4 + 1);
            int n4 = this.colourSelectList.get(n * 4 + 2);
            int n5 = this.colourSelectList.get(n * 4 + 3);
            this.cmbRedColour.select(Math.abs(n2));
            this.cmbGreenColour.select(Math.abs(n3));
            this.cmbBlueColour.select(Math.abs(n4));
            this.curAlphaSelect = this.cmbAlpha.getSelectionIndex();
            this.curRedSelect = this.cmbRedColour.getSelectionIndex();
            this.curGreenSelect = this.cmbGreenColour.getSelectionIndex();
            this.curBlueSelect = this.cmbBlueColour.getSelectionIndex();
            if (n2 < 0) {
                this.btnRedInverse.setSelection(true);
            } else {
                this.btnRedInverse.setSelection(false);
            }
            if (n3 < 0) {
                this.btnGreenInverse.setSelection(true);
            } else {
                this.btnGreenInverse.setSelection(false);
            }
            if (n4 < 0) {
                this.btnBlueInverse.setSelection(true);
            } else {
                this.btnBlueInverse.setSelection(false);
            }
            if (n5 < 0) {
                this.btnAlphaInverse.setSelection(false);
            }
            this.curAlphaInverse = this.btnAlphaInverse.getSelection();
            this.curRedInverse = this.btnRedInverse.getSelection();
            this.curGreenInverse = this.btnGreenInverse.getSelection();
            this.curBlueInverse = this.btnBlueInverse.getSelection();
            this.handleChange(0);
            this.handleChange(1);
            this.handleChange(2);
            this.updateChannelGraphs();
            this.generateHistogramUpdate();
            this.histogramPlotter.refresh(true);
            this.buildGradientImage();
            if (this.cmbColourMap.getItem(this.cmbColourMap.getSelectionIndex()).equals("Mark's special")) {
                this.spnMinValue = new Spinner(this.container, 2048);
                this.spnMinValue.setLayoutData((Object)this.spnMinFormData);
                this.spnMinValue.setMinimum(0);
                this.spnMinValue.setMaximum(100);
                this.spnMinValue.setSelection((int)(this.specialMinThreshold * 100.0f));
                this.spnMinValue.addSelectionListener((SelectionListener)this);
                this.spnMaxValue = new Spinner(this.container, 2048);
                this.spnMaxValue.setLayoutData((Object)this.spnMaxFormData);
                this.spnMaxValue.setMinimum(0);
                this.spnMaxValue.setMaximum(100);
                this.spnMaxValue.setSelection((int)(this.specialMaxThreshold * 100.0f));
                this.spnMaxFormData = new FormData();
                this.spnMaxFormData.top = new FormAttachment((Control)this.spnMinValue, 10);
                this.spnMaxFormData.left = new FormAttachment((Control)this.cmbColourMap, 10);
                this.spnMaxFormData.width = 50;
                this.spnMaxValue.addSelectionListener((SelectionListener)this);
                this.spnMaxValue.setLayoutData((Object)this.spnMaxFormData);
                this.lblMinValue = new Label(this.container, 0);
                this.lblMinValue.setText("Min threshold");
                FormData formData = new FormData();
                formData.top = new FormAttachment(0, 10);
                formData.left = new FormAttachment((Control)this.spnMinValue, 10);
                formData.width = 75;
                this.lblMinValue.setLayoutData((Object)formData);
                this.lblMaxValue = new Label(this.container, 0);
                this.lblMaxValue.setText("Max threshold");
                formData = new FormData();
                formData.top = new FormAttachment((Control)this.spnMinValue, 10);
                formData.left = new FormAttachment((Control)this.spnMaxValue, 10);
                formData.width = 75;
                this.lblMaxValue.setLayoutData((Object)formData);
                this.container.layout();
            } else {
                if (this.spnMinValue != null) {
                    this.spnMinValue.removeSelectionListener((SelectionListener)this);
                    this.spnMinValue.dispose();
                    this.spnMinValue = null;
                    this.lblMinValue.dispose();
                    this.lblMinValue = null;
                }
                if (this.spnMaxValue != null) {
                    this.spnMaxValue.removeSelectionListener((SelectionListener)this);
                    this.spnMaxValue.dispose();
                    this.spnMaxValue = null;
                    this.lblMaxValue.dispose();
                    this.lblMaxValue = null;
                }
            }
        } else if (selectionEvent.getSource().equals(this.spnMinValue) || selectionEvent.getSource().equals(this.spnMaxValue)) {
            SpecialExposureFunction specialExposureFunction = (SpecialExposureFunction)this.mappingFunctions.get(this.cmbRedColour.getSelectionIndex());
            SpecialExposureFunction specialExposureFunction2 = (SpecialExposureFunction)this.mappingFunctions.get(this.cmbGreenColour.getSelectionIndex());
            SpecialExposureFunction specialExposureFunction3 = (SpecialExposureFunction)this.mappingFunctions.get(this.cmbBlueColour.getSelectionIndex());
            specialExposureFunction.setThresholds((float)this.spnMinValue.getSelection() / 100.0f, (float)this.spnMaxValue.getSelection() / 100.0f);
            specialExposureFunction2.setThresholds((float)this.spnMinValue.getSelection() / 100.0f, (float)this.spnMaxValue.getSelection() / 100.0f);
            specialExposureFunction3.setThresholds((float)this.spnMinValue.getSelection() / 100.0f, (float)this.spnMaxValue.getSelection() / 100.0f);
            this.specialMaxThreshold = (float)this.spnMaxValue.getSelection() / 100.0f;
            this.specialMinThreshold = (float)this.spnMinValue.getSelection() / 100.0f;
            this.updateChannelGraphs();
            this.generateHistogramUpdate();
            this.histogramPlotter.refresh(true);
        }
    }

    protected void generateHistogramUpdate() {
        HistogramUpdate histogramUpdate = new HistogramUpdate(this.mappingFunctions.get(this.curRedSelect), this.mappingFunctions.get(this.curGreenSelect), this.mappingFunctions.get(this.curBlueSelect), this.mappingFunctions.get(this.curAlphaSelect), this.btnRedInverse.getSelection(), this.btnGreenInverse.getSelection(), this.btnBlueInverse.getSelection(), this.btnAlphaInverse.getSelection(), this.colourTableMin, this.colourTableMax);
        this.notifyObservers(histogramUpdate);
    }

    protected void updateChannelGraphs() {
        if (this.histograms != null && this.histograms.size() > 1) {
            this.histograms.remove(0);
            this.histograms.remove(0);
            this.histograms.remove(0);
            this.histograms.remove(0);
        }
        AbstractMapFunction abstractMapFunction = this.mappingFunctions.get(this.curRedSelect);
        AbstractMapFunction abstractMapFunction2 = this.mappingFunctions.get(this.curGreenSelect);
        AbstractMapFunction abstractMapFunction3 = this.mappingFunctions.get(this.curBlueSelect);
        AbstractMapFunction abstractMapFunction4 = this.mappingFunctions.get(this.curAlphaSelect);
        double d = this.histograms.get(0).max().doubleValue();
        int n = this.histograms.get(0).getSize();
        DoubleDataset doubleDataset = new DoubleDataset(new int[]{n});
        DoubleDataset doubleDataset2 = new DoubleDataset(new int[]{n});
        DoubleDataset doubleDataset3 = new DoubleDataset(new int[]{n});
        DoubleDataset doubleDataset4 = new DoubleDataset(new int[]{n});
        int n2 = 0;
        while (n2 < n) {
            double d2 = (double)n2 / (double)n;
            double d3 = abstractMapFunction.clippedMapToDouble(d2);
            if (this.curRedInverse) {
                d3 = 1.0 - d3;
            }
            d3 *= d;
            double d4 = abstractMapFunction2.clippedMapToDouble(d2);
            if (this.curGreenInverse) {
                d4 = 1.0 - d4;
            }
            d4 *= d;
            double d5 = abstractMapFunction3.clippedMapToDouble(d2);
            if (this.curBlueInverse) {
                d5 = 1.0 - d5;
            }
            d5 *= d;
            double d6 = abstractMapFunction4.clippedMapToDouble(d2);
            if (this.curAlphaInverse) {
                d6 = 1.0 - d6;
            }
            doubleDataset.set((Object)Math.max(d3, 0.0), new int[]{n2});
            doubleDataset2.set((Object)Math.max(d4, 0.0), new int[]{n2});
            doubleDataset3.set((Object)Math.max(d5, 0.0), new int[]{n2});
            doubleDataset4.set((Object)Math.max(d6 *= d, 0.0), new int[]{n2++});
        }
        this.histograms.add(0, (IDataset)doubleDataset4);
        this.histograms.add(0, (IDataset)doubleDataset3);
        this.histograms.add(0, (IDataset)doubleDataset2);
        this.histograms.add(0, (IDataset)doubleDataset);
        try {
            this.histogramPlotter.replaceAllPlots(this.histograms);
        }
        catch (PlotException plotException) {
            plotException.printStackTrace();
        }
    }

    private void updateHistogramGraph(double d, double d2) {
        this.xAxis.clear();
        this.colourTableMin = d;
        this.colourTableMax = d2;
        this.histogramFunc.setMinMax(d, d2);
        this.histogramFunc.setIgnoreOutliers(true);
        List list = this.histogramFunc.value(new IDataset[]{this.data});
        AbstractDataset abstractDataset = (AbstractDataset)list.get(0);
        if (this.histograms != null && this.histograms.size() > 1) {
            this.histograms.set(this.histograms.size() - 1, (IDataset)abstractDataset);
        } else {
            this.histograms = new ArrayList<IDataset>();
            this.histograms.add((IDataset)abstractDataset);
        }
        int n = 0;
        while (n < abstractDataset.getSize() + 1) {
            double d3 = d + (double)n * (d2 - d) / (double)Math.max(1, abstractDataset.getSize());
            this.xAxis.addValue(d3);
            ++n;
        }
        this.histogramPlotter.setXAxisValues(this.xAxis, 1);
        this.generateHistogramUpdate();
        this.updateChannelGraphs();
        this.histogramPlotter.refresh(true);
    }

    private void autoRangeHistogram() {
        this.histogramPlotter.clearZoomHistory();
        this.colourTableMax = this.autoHistogram ? Stats.quantile((AbstractDataset)DatasetUtils.convertToAbstractDataset((IDataset)this.data), (double)0.99) : this.data.max().doubleValue();
        this.colourTableMin = this.data.min().doubleValue();
    }

    public void createInitialHistogram() {
        if (this.data != null) {
            if (this.initialStart || !this.lockRange) {
                this.autoRangeHistogram();
            }
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    HistogramView.this.updateHistogramGraph(HistogramView.this.colourTableMin, HistogramView.this.colourTableMax);
                    HistogramView.this.buildGradientImage();
                }
            });
        }
    }

    public void update(Object object, Object object2) {
        if (object.equals(this.histogramUI) && object2 instanceof AreaSelectEvent) {
            AreaSelectEvent areaSelectEvent = (AreaSelectEvent)object2;
            final double d = areaSelectEvent.getPosition()[0];
            final double d2 = areaSelectEvent.getPosition()[1];
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    HistogramView.this.updateHistogramGraph(d, d2);
                }
            });
        }
        if (object instanceof PlotWindow && object2 instanceof HistogramDataUpdate && this.parent != null) {
            this.data = ((HistogramDataUpdate)object2).getDataSet();
            this.createInitialHistogram();
            this.initialStart = false;
        }
    }

    public String getId() {
        return this.id;
    }

    public void addIObserver(IObserver iObserver) {
        this.observers.add(iObserver);
    }

    public void deleteIObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
    }

    public void deleteIObservers() {
        this.observers.clear();
    }

    public void dispose() {
        this.deleteIObservers();
        if (this.histogramPlotter != null) {
            this.histogramPlotter.cleanUp();
        }
        this.data = null;
        if (this.histogramUI != null) {
            this.histogramUI.deactivate(false);
        }
        if (this.indexOfMappingFunctions != null) {
            this.indexOfMappingFunctions.clear();
        }
        this.colourSelectList.clear();
        System.gc();
        if (!this.cmbAlpha.isDisposed()) {
            this.cmbAlpha.removeSelectionListener((SelectionListener)this);
        }
        if (!this.cmbRedColour.isDisposed()) {
            this.cmbRedColour.removeSelectionListener((SelectionListener)this);
        }
        if (!this.cmbGreenColour.isDisposed()) {
            this.cmbGreenColour.removeSelectionListener((SelectionListener)this);
        }
        if (!this.cmbBlueColour.isDisposed()) {
            this.cmbBlueColour.removeSelectionListener((SelectionListener)this);
        }
        if (!this.btnGreenInverse.isDisposed()) {
            this.btnGreenInverse.removeSelectionListener((SelectionListener)this);
        }
        if (!this.btnBlueInverse.isDisposed()) {
            this.btnBlueInverse.removeSelectionListener((SelectionListener)this);
        }
        if (!this.btnAlphaInverse.isDisposed()) {
            this.btnAlphaInverse.removeSelectionListener((SelectionListener)this);
        }
        if (!this.btnRedInverse.isDisposed()) {
            this.btnRedInverse.removeSelectionListener((SelectionListener)this);
        }
        super.dispose();
    }

    public void setAutoHistogramScaling(boolean bl) {
        this.autoHistogram = bl;
    }

    public void setHistogramLock(boolean bl) {
        this.lockRange = bl;
    }

    public void setGraphLines(boolean bl) {
        if (this.histogramPlotter != null) {
            Plot1DGraphTable plot1DGraphTable = this.histogramPlotter.getColourTable();
            int n = 0;
            while (n < 4) {
                plot1DGraphTable.getLegendEntry(n).setVisible(bl);
                ++n;
            }
        }
        this.histogramPlotter.updateAllAppearance();
        this.histogramPlotter.refresh(false);
    }

    public void setScaling(ScaleType scaleType) {
        this.histogramPlotter.setYAxisScaling(scaleType);
    }
}

