/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.util;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBeanException;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.util.PlotMode;
import uk.ac.diamond.scisoft.analysis.rcp.views.nexus.DataSetProvider;
import uk.ac.diamond.scisoft.analysis.rcp.views.nexus.ExpressionObject;
import uk.ac.gda.monitor.IMonitor;
import uk.ac.gda.monitor.ProgressMonitorWrapper;

public class PlotUtils {
    private static final Logger logger = LoggerFactory.getLogger(PlotUtils.class);

    public static void createComparisionPlot(Object[] objectArray, List<Object> list, PlotMode plotMode, PlotWindow plotWindow, IProgressMonitor iProgressMonitor) throws Exception {
        Object object = list.get(0);
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        int n = 1;
        while (n < list.size()) {
            arrayList.add(list.get(n));
            ++n;
        }
        File[] fileArray = PlotUtils.getFiles(objectArray);
        IDataset iDataset = PlotUtils.getLargestDataSet(fileArray, object, iProgressMonitor);
        List<IDataset> list2 = PlotUtils.getDataSets(fileArray, arrayList, true, iProgressMonitor);
        if (list2.isEmpty()) {
            list2.add(iDataset);
            iDataset = AbstractDataset.toDataSet((IDataset)list2.get(0)).getIndexDataSet();
            iDataset.setName("Index");
        }
        PlotUtils.createPlot(iDataset, list2, plotMode, plotWindow, iProgressMonitor);
    }

    private static List<IDataset> getDataSets(File[] fileArray, List<Object> list, boolean bl, IProgressMonitor iProgressMonitor) throws Exception {
        ArrayList<IDataset> arrayList = new ArrayList<IDataset>(fileArray.length * list.size());
        int n = 0;
        while (n < fileArray.length) {
            for (Object object : list) {
                arrayList.add(PlotUtils.getDataSet(fileArray[n], object, bl, iProgressMonitor));
            }
            ++n;
        }
        return arrayList;
    }

    private static IDataset getLargestDataSet(File[] fileArray, Object object, IProgressMonitor iProgressMonitor) throws Exception {
        IDataset iDataset = null;
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        while (n2 < fileArray.length) {
            try {
                IDataset iDataset2 = PlotUtils.getDataSet(fileArray[n2], object, false, iProgressMonitor);
                if (iDataset2 != null && iDataset2.getSize() > n) {
                    n = iDataset2.getSize();
                    iDataset = iDataset2;
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        return iDataset;
    }

    private static IDataset getDataSet(final File file, Object object, boolean bl, IProgressMonitor iProgressMonitor) throws Exception {
        Object object2;
        IDataset iDataset = null;
        if (object instanceof String) {
            iDataset = LoaderFactory.getDataSet((String)file.getAbsolutePath(), (String)((String)object), (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
        } else if (object instanceof ExpressionObject) {
            object2 = new DataSetProvider(){

                @Override
                public IDataset getDataSet(String string, IProgressMonitor iProgressMonitor) {
                    try {
                        return LoaderFactory.getDataSet((String)file.getAbsolutePath(), (String)string, (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
                    }
                    catch (Exception exception) {
                        return new DoubleDataset();
                    }
                }

                @Override
                public boolean isDataSetName(String string, IProgressMonitor iProgressMonitor) {
                    return true;
                }
            };
            ((ExpressionObject)object).setProvider((DataSetProvider)object2);
            iDataset = ((ExpressionObject)object).getDataSet(iProgressMonitor);
        }
        if (iDataset != null && bl && (object2 = iDataset.getName()) != null) {
            iDataset.setName(String.valueOf(object2) + " (" + file.getName() + ")");
        }
        return iDataset;
    }

    private static File[] getFiles(Object[] objectArray) {
        File[] fileArray = new File[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof File) {
                fileArray[n] = (File)objectArray[n];
            } else if (objectArray[n] instanceof IFile) {
                fileArray[n] = ((IFile)objectArray[n]).getLocation().toFile();
            }
            ++n;
        }
        return fileArray;
    }

    public static void createPlot(IDataset iDataset, List<IDataset> list, final PlotMode plotMode, final PlotWindow plotWindow, final IProgressMonitor iProgressMonitor) {
        IDataset iDataset2;
        List<IDataset> list2;
        if (iDataset.getRank() != 1) {
            return;
        }
        if (list == null) {
            list2 = new ArrayList<IDataset>(1);
            list2.add(iDataset);
            iDataset2 = AbstractDataset.toDataSet((IDataset)list2.get(0)).getIndexDataSet();
        } else {
            iDataset2 = iDataset;
            list2 = list;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    plotWindow.updatePlotMode(plotMode.getGuiPlotMode());
                    if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                        return;
                    }
                    GuiBean guiBean = new GuiBean();
                    guiBean.put((Object)GuiParameters.PLOTMODE, (Object)plotMode.getGuiPlotMode());
                    guiBean.put((Object)GuiParameters.TITLE, (Object)PlotUtils.getTitle(iDataset2, list2, true));
                    plotWindow.processGUIUpdate(guiBean);
                    if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                        return;
                    }
                    DataBean dataBean = new DataBean();
                    dataBean.addAxis("x-axis", iDataset2);
                    if (PlotMode.PM3D == plotMode) {
                        DoubleDataset doubleDataset = new DoubleDataset(new double[]{-15.0, 1.0, 200.0}, new int[0]);
                        dataBean.addAxis("z-axis", (IDataset)doubleDataset);
                    }
                    int n = 0;
                    while (n < list2.size()) {
                        try {
                            dataBean.addData(DataSetWithAxisInformation.createAxisDataSet((IDataset)((IDataset)list2.get(n))));
                            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                                return;
                            }
                        }
                        catch (DataBeanException dataBeanException) {
                            logger.error("Problem adding data to bean as axis key does not exist", (Throwable)dataBeanException);
                        }
                        ++n;
                    }
                    if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                        return;
                    }
                    plotWindow.processPlotUpdate(dataBean);
                }
                catch (Exception exception) {
                    logger.error("Cannot create plot required.", (Throwable)exception);
                }
            }
        });
    }

    private static Serializable getTitle(IDataset iDataset, List<IDataset> list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Plot of");
        HashSet<String> hashSet = new HashSet<String>(7);
        for (IDataset iDataset2 : list) {
            Matcher matcher;
            String string = iDataset2.getName();
            if (bl && (matcher = Pattern.compile("(.*) \\(.*\\)").matcher(string)).matches()) {
                string = matcher.group(1);
            }
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            stringBuilder.append(" ");
            stringBuilder.append(string);
            stringBuilder.append(",");
        }
        int n = stringBuilder.length() - 1;
        stringBuilder.delete(n, n + 1);
        stringBuilder.append(" against ");
        stringBuilder.append(iDataset.getName());
        return stringBuilder.toString();
    }
}

