/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.results.navigator.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.results.navigator.search.DataSearchQuery;

public class DataSearch
extends DialogPage
implements ISearchPage {
    private static final Logger logger = LoggerFactory.getLogger(DataSearch.class);
    public static String ID = "uk.ac.diamond.scisoft.analysis.rcp.results.navigator.search.dataSearch";
    private ISearchPageContainer container;
    private ComboViewer searchViewer;
    protected String searchString;
    protected boolean isCaseSensitive = true;
    protected boolean isRegularExpression = false;
    protected static List<String> previousSearches;

    public DataSearch() {
        super("Data");
        if (previousSearches == null) {
            previousSearches = new ArrayList<String>(7);
        }
    }

    public boolean performAction() {
        NewSearchUI.runQueryInBackground((ISearchQuery)this.createQuery());
        return true;
    }

    public void setContainer(ISearchPageContainer iSearchPageContainer) {
        this.container = iSearchPageContainer;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setText("Nexus File Name:");
        new Label(composite2, 0);
        this.searchViewer = new ComboViewer(composite2, 2048);
        this.searchViewer.add((Object[])previousSearches.toArray(new String[previousSearches.size()]));
        Combo combo = this.searchViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.searchViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                DataSearch.this.searchString = DataSearch.this.searchViewer.getCombo().getText();
            }
        });
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                DataSearch.this.searchString = DataSearch.this.searchViewer.getCombo().getText();
            }
        });
        final Button button = new Button(composite2, 32);
        button.setSelection(true);
        button.setText("Case sensitive");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DataSearch.this.isCaseSensitive = button.getSelection();
            }
        });
        Label label2 = new Label(composite2, 0);
        label2.setText("(* = any string, ? = any character, \\ = escape for literals)");
        final Button button2 = new Button(composite2, 32);
        button2.setSelection(false);
        button2.setText("Regular Expression");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DataSearch.this.isRegularExpression = button2.getSelection();
            }
        });
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    private ISearchQuery createQuery() {
        this.saveSearchString();
        return new DataSearchQuery(this.getSearchString(), this.isCaseSensitive(), this.isRegularExpression());
    }

    private void saveSearchString() {
        this.searchViewer.add((Object)this.searchString);
        if (previousSearches.contains(this.searchString)) {
            return;
        }
        previousSearches.add(this.searchString);
        if (previousSearches.size() > 50) {
            previousSearches.remove(previousSearches.size() - 1);
        }
    }

    private String getSearchString() {
        return this.searchString;
    }

    private boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    private boolean isRegularExpression() {
        return this.isRegularExpression;
    }
}

