/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.ISidePlot;

public class SidePlotManager {
    private static final Logger logger = LoggerFactory.getLogger(SidePlotManager.class);
    private static final String SIDEPLOT_EXTENSION_ID = "uk.ac.diamond.scisoft.analysis.rcp.sidePlot";
    private static final String ATT_CLASS = "class";
    private static final String ATT_MODE = "plotMode";
    private static SidePlotManager SIDEPLOT_MANAGER;
    private Map<String, Map<GuiPlotMode, List<ISidePlot>>> sidePlotsMap = new HashMap<String, Map<GuiPlotMode, List<ISidePlot>>>();
    private static Map<String, GuiPlotMode> plotModeMap;

    static {
        plotModeMap = null;
    }

    private SidePlotManager() {
    }

    public static SidePlotManager getDefault() {
        if (SIDEPLOT_MANAGER == null) {
            SIDEPLOT_MANAGER = new SidePlotManager();
        }
        return SIDEPLOT_MANAGER;
    }

    private void initializeSidePlots(String string) {
        HashMap hashMap = new HashMap();
        IExtension[] iExtensionArray = this.getExtensions(SIDEPLOT_EXTENSION_ID);
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                try {
                    GuiPlotMode guiPlotMode;
                    ISidePlot iSidePlot = (ISidePlot)iConfigurationElement.createExecutableExtension(ATT_CLASS);
                    String string2 = iConfigurationElement.getAttribute(ATT_MODE);
                    GuiPlotMode guiPlotMode2 = guiPlotMode = string2 == null ? GuiPlotMode.TWOD : SidePlotManager.getMode(string2);
                    if (!hashMap.containsKey(guiPlotMode)) {
                        hashMap.put(guiPlotMode, new ArrayList());
                    }
                    ((List)hashMap.get(guiPlotMode)).add(iSidePlot);
                }
                catch (CoreException coreException) {
                    logger.error("Unable to instantiate side plot" + coreException.getMessage());
                }
                ++n2;
            }
            ++n;
        }
        this.sidePlotsMap.put(string, hashMap);
    }

    private IExtension[] getExtensions(String string) {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        return iExtensionArray;
    }

    public List<ISidePlot> getSidePlots(GuiPlotMode guiPlotMode, String string) {
        if (this.sidePlotsMap.get(string) == null) {
            this.initializeSidePlots(string);
        }
        return this.sidePlotsMap.get(string).get(guiPlotMode);
    }

    public static GuiPlotMode getMode(String string) {
        if (plotModeMap == null) {
            plotModeMap = new HashMap<String, GuiPlotMode>();
            plotModeMap.put("1D", GuiPlotMode.ONED);
            plotModeMap.put("1D_stack", GuiPlotMode.ONED_THREED);
            plotModeMap.put("2D_image", GuiPlotMode.TWOD);
            plotModeMap.put("2D_surface", GuiPlotMode.SURF2D);
            plotModeMap.put("2D_multi", GuiPlotMode.MULTI2D);
            plotModeMap.put("3D_volume", GuiPlotMode.VOLUME);
        }
        return plotModeMap.get(string);
    }
}

