/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.coords.SectorCoords;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.function.Centroid;
import uk.ac.diamond.scisoft.analysis.plotserver.AxisMapBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBeanException;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotColorUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.Plot1DStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIDataList;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.SectorROIData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.SectorROIHandler;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.SectorROITableViewer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.SidePlotProfile;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.IImagePositionEvent;
import uk.ac.diamond.scisoft.analysis.roi.ROIBase;
import uk.ac.diamond.scisoft.analysis.roi.ROIList;
import uk.ac.diamond.scisoft.analysis.roi.SectorROI;
import uk.ac.gda.richbeans.components.wrappers.FloatSpinnerWrapper;

public class SectorProfile
extends SidePlotProfile {
    private static Logger logger = LoggerFactory.getLogger(SectorProfile.class);
    private DataSetPlotter radPlotter;
    private DataSetPlotter aziPlotter;
    private HandleStatus hStatus = HandleStatus.NONE;
    private FloatSpinnerWrapper spsx;
    private FloatSpinnerWrapper spsy;
    private FloatSpinnerWrapper spsr;
    private FloatSpinnerWrapper sper;
    private FloatSpinnerWrapper spsang;
    private FloatSpinnerWrapper speang;
    private Text txSum;
    private Spinner spgrn;
    private Spinner spgrs;
    private int grNumber = 2;
    private int grSpacing = 40;
    List<Button> radioButtons;
    private Button combine;
    private Button centreLock;
    private Button centreReset;
    private Button centreCentroid;
    private boolean lockCentre;
    private SelectionListener clippingButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            SectorROI sectorROI = (SectorROI)SectorProfile.this.roi;
            if (sectorROI != null) {
                if (((Button)selectionEvent.widget).getSelection()) {
                    sectorROI.setClippingCompensation(true);
                } else {
                    sectorROI.setClippingCompensation(false);
                }
                SectorProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SectorProfile.this.updatePlot();
                    }
                });
            }
        }
    };
    private SelectionListener centreListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.widget;
            if (button == SectorProfile.this.centreLock) {
                if (button.getSelection()) {
                    SectorProfile.this.lockCentre = true;
                    SectorProfile.this.spsx.setEnabled(false);
                    SectorProfile.this.spsy.setEnabled(false);
                    SectorProfile.this.centreReset.setEnabled(false);
                    SectorProfile.this.centreCentroid.setEnabled(false);
                    SectorProfile.this.spsx.removeSelectionListener(SectorProfile.this.spinnerListener);
                    SectorProfile.this.spsy.removeSelectionListener(SectorProfile.this.spinnerListener);
                } else {
                    SectorProfile.this.lockCentre = false;
                    SectorProfile.this.spsx.addSelectionListener(SectorProfile.this.spinnerListener);
                    SectorProfile.this.spsy.addSelectionListener(SectorProfile.this.spinnerListener);
                    SectorProfile.this.spsx.setEnabled(true);
                    SectorProfile.this.spsy.setEnabled(true);
                    SectorProfile.this.centreReset.setEnabled(true);
                    SectorProfile.this.centreCentroid.setEnabled(true);
                }
            } else if (button == SectorProfile.this.centreReset) {
                if (!SectorProfile.this.lockCentre) {
                    SectorProfile.this.getDataset();
                    int[] nArray = SectorProfile.this.data.getShape();
                    SectorProfile.this.roi.setPoint(nArray[1] / 2, nArray[0] / 2);
                    SectorProfile.this.updateAllSpinners(SectorProfile.this.roi);
                    SectorProfile.this.sendCurrentROI(SectorProfile.this.roi);
                }
            } else if (button == SectorProfile.this.centreCentroid && !SectorProfile.this.lockCentre) {
                SectorProfile.this.getDataset();
                Centroid centroid = new Centroid(new AbstractDataset[0]);
                List list = centroid.value(new IDataset[]{SectorProfile.this.data});
                AbstractDataset abstractDataset = (AbstractDataset)list.get(0);
                SectorProfile.this.roi.setPoint(abstractDataset.getDouble(new int[]{1}), abstractDataset.getDouble(new int[]{0}));
                SectorProfile.this.updateAllSpinners(SectorProfile.this.roi);
                SectorProfile.this.sendCurrentROI(SectorProfile.this.roi);
            }
            SectorProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SectorProfile.this.drawCurrentOverlay();
                    SectorProfile.this.updatePlot();
                }
            });
        }
    };
    private SelectionListener radioListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            SectorROI sectorROI = (SectorROI)SectorProfile.this.roi;
            Button button = (Button)selectionEvent.widget;
            if (!button.getSelection()) {
                button.setSelection(false);
                return;
            }
            if (SectorProfile.this.validateSymButtons(button)) {
                button.setSelection(true);
            } else {
                SectorProfile.this.radioButtons.get(sectorROI.getSymmetry()).setSelection(true);
                button.setSelection(false);
            }
            if (sectorROI.getSymmetry() == 0 || sectorROI.getSymmetry() == 1) {
                sectorROI.setCombineSymmetry(false);
                SectorProfile.this.combine.setSelection(false);
                SectorProfile.this.combine.setEnabled(false);
            } else {
                SectorProfile.this.combine.setEnabled(true);
            }
            SectorProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SectorProfile.this.drawCurrentOverlay();
                    SectorProfile.this.updatePlot();
                }
            });
        }
    };
    private SelectionListener combineButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            SectorROI sectorROI = (SectorROI)SectorProfile.this.roi;
            Button button = (Button)selectionEvent.widget;
            if (button.getSelection()) {
                if (sectorROI.getSymmetry() == 0 || sectorROI.getSymmetry() == 1) {
                    button.setSelection(false);
                    return;
                }
                sectorROI.setCombineSymmetry(true);
            } else {
                sectorROI.setCombineSymmetry(false);
            }
            SectorProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SectorProfile.this.drawCurrentOverlay();
                    SectorProfile.this.updatePlot();
                }
            });
        }
    };
    private SelectionListener spinnerListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            SectorROI sectorROI = (SectorROI)SectorProfile.this.roi;
            if (sectorROI != null) {
                sectorROI.setPoint(SectorProfile.this.spsx.getFloat(), SectorProfile.this.spsy.getFloat());
                sectorROI.setRadii(SectorProfile.this.spsr.getFloat(), SectorProfile.this.sper.getFloat());
                sectorROI.setAnglesDegrees(SectorProfile.this.spsang.getFloat(), SectorProfile.this.speang.getFloat());
                SectorProfile.this.sendCurrentROI(SectorProfile.this.roi);
                SectorProfile.this.updateAllSpinners(SectorProfile.this.roi);
                SectorProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SectorProfile.this.updatePlot();
                        SectorProfile.this.drawCurrentOverlay();
                    }
                });
            }
        }
    };
    private SelectionListener grSpinnerListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            SectorProfile.this.grNumber = SectorProfile.this.spgrn.getSelection();
            SectorProfile.this.grSpacing = SectorProfile.this.spgrs.getSelection();
            SectorProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SectorProfile.this.drawCurrentOverlay();
                }
            });
        }
    };

    @Override
    public void createPartControl(Composite composite) {
        this.container = new Composite(composite, 0);
        this.container.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(this.container, 512);
        sashForm.setLayout((Layout)new FillLayout());
        this.radPlotter = new DataSetPlotter(PlottingMode.ONED, (Composite)sashForm, false);
        this.radPlotter.setAxisModes(AxisMode.CUSTOM, AxisMode.LINEAR, AxisMode.LINEAR);
        this.radPlotter.setXAxisLabel("Distance along radial axis");
        this.aziPlotter = new DataSetPlotter(PlottingMode.ONED, (Composite)sashForm, false);
        this.aziPlotter.setAxisModes(AxisMode.CUSTOM, AxisMode.LINEAR, AxisMode.LINEAR);
        this.aziPlotter.setXAxisLabel("Azimuthal angle, degrees");
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)sashForm, 768);
        Composite composite2 = new Composite((Composite)scrolledComposite, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.heightHint = 200;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(6, false));
        group.setText("Current ROI");
        new Label((Composite)group, 0).setText("Centre x:");
        this.spsx = new FloatSpinnerWrapper((Composite)group, 2048, 6, 2);
        this.spsx.addSelectionListener(this.spinnerListener);
        new Label((Composite)group, 0).setText("Start radius:");
        this.spsr = new FloatSpinnerWrapper((Composite)group, 2048, 6, 2);
        this.spsr.addSelectionListener(this.spinnerListener);
        new Label((Composite)group, 0).setText("End radius:");
        this.sper = new FloatSpinnerWrapper((Composite)group, 2048, 6, 2);
        this.sper.addSelectionListener(this.spinnerListener);
        new Label((Composite)group, 0).setText("Centre y:");
        this.spsy = new FloatSpinnerWrapper((Composite)group, 2048, 6, 2);
        this.spsy.addSelectionListener(this.spinnerListener);
        new Label((Composite)group, 0).setText("Start angle:");
        this.spsang = new FloatSpinnerWrapper((Composite)group, 2048, 7, 2);
        this.spsang.setMinimum(-361.0);
        this.spsang.setMaximum(361.0);
        this.spsang.addSelectionListener(this.spinnerListener);
        new Label((Composite)group, 0).setText("End angle:");
        this.speang = new FloatSpinnerWrapper((Composite)group, 2048, 7, 2);
        this.speang.setMinimum(-1.0);
        this.speang.setMaximum(721.0);
        this.speang.addSelectionListener(this.spinnerListener);
        new Label((Composite)group, 0).setText("Sum:");
        this.txSum = new Text((Composite)group, 2056);
        this.txSum.setTextLimit(10);
        Object object = new GridData();
        object.horizontalSpan = 2;
        this.combine = new Button((Composite)group, 32);
        this.combine.setLayoutData(object);
        this.combine.setText("Combine symmetry");
        this.combine.setToolTipText("Add symmetric sector to profile");
        this.combine.addSelectionListener(this.combineButtonListener);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        Button button = new Button((Composite)group, 32);
        button.setLayoutData((Object)gridData2);
        button.setText("Clipping comp");
        button.setToolTipText("Compensate for clipping of region of interests");
        button.addSelectionListener(this.clippingButtonListener);
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 2;
        Button button2 = new Button((Composite)group, 8);
        button2.setLayoutData((Object)gridData3);
        button2.setText("Copy current to table");
        button2.addSelectionListener(this.copyButtonListener);
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        GridData gridData4 = new GridData();
        gridData4.horizontalSpan = 2;
        Button button3 = new Button((Composite)group, 32);
        button3.setLayoutData((Object)gridData4);
        button3.setText("Invert brightness");
        button3.setToolTipText("Invert overlay brightness");
        button3.addSelectionListener(this.brightnessButtonListener);
        object = new Group(composite2, 0);
        gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.heightHint = 200;
        group.setLayoutData((Object)gridData);
        object.setLayout((Layout)new GridLayout(8, false));
        object.setText("Guide and Centring");
        new Label((Composite)object, 0).setText("Rings:");
        this.spgrn = new Spinner((Composite)object, 2048);
        this.spgrn.setMinimum(0);
        this.spgrn.setMaximum(8);
        this.spgrn.setIncrement(1);
        this.spgrn.setPageIncrement(2);
        this.spgrn.setSelection(this.grNumber);
        this.spgrn.addSelectionListener(this.grSpinnerListener);
        new Label((Composite)object, 0).setText("Spacing:");
        this.spgrs = new Spinner((Composite)object, 2048);
        this.spgrs.setMinimum(10);
        this.spgrs.setMaximum(500);
        this.spgrs.setIncrement(10);
        this.spgrs.setPageIncrement(50);
        this.spgrs.setSelection(this.grSpacing);
        this.spgrs.addSelectionListener(this.grSpinnerListener);
        new Label((Composite)object, 0).setText("      ");
        this.centreLock = new Button((Composite)object, 32);
        this.centreLock.setText("Lock centre");
        this.centreLock.setToolTipText("Lock position of sector centre");
        this.centreLock.addSelectionListener(this.centreListener);
        this.centreReset = new Button((Composite)object, 8);
        this.centreReset.setText("Reset");
        this.centreReset.setToolTipText("Reset sector centre to image centre");
        this.centreReset.addSelectionListener(this.centreListener);
        this.centreCentroid = new Button((Composite)object, 8);
        this.centreCentroid.setText("Centroid");
        this.centreCentroid.setToolTipText("Set sector centre to image centroid");
        this.centreCentroid.addSelectionListener(this.centreListener);
        gridData2 = new Group(composite2, 0);
        gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.heightHint = 200;
        group.setLayoutData((Object)gridData);
        gridData2.setLayout((Layout)new RowLayout());
        gridData2.setText("Symmetry");
        this.radioButtons = new ArrayList<Button>();
        button = new Button((Composite)gridData2, 16);
        button.setText("None");
        button.setToolTipText("Do nothing");
        button.setSelection(true);
        button.addSelectionListener(this.radioListener);
        this.radioButtons.add(0, button);
        button = new Button((Composite)gridData2, 16);
        button.setText("Full");
        button.setToolTipText("Use full circle");
        button.addSelectionListener(this.radioListener);
        this.radioButtons.add(1, button);
        button = new Button((Composite)gridData2, 16);
        button.setText("L/R reflect");
        button.setToolTipText("Reflect in y-axis");
        button.addSelectionListener(this.radioListener);
        this.radioButtons.add(2, button);
        button = new Button((Composite)gridData2, 16);
        button.setText("U/D reflect");
        button.setToolTipText("Reflect in x-axis");
        button.addSelectionListener(this.radioListener);
        this.radioButtons.add(3, button);
        button = new Button((Composite)gridData2, 16);
        button.setText("+90");
        button.setToolTipText("Rotate by +90");
        button.addSelectionListener(this.radioListener);
        this.radioButtons.add(4, button);
        button = new Button((Composite)gridData2, 16);
        button.setText("-90");
        button.setToolTipText("Rotate by -90");
        button.addSelectionListener(this.radioListener);
        this.radioButtons.add(5, button);
        button = new Button((Composite)gridData2, 16);
        button.setText("Invert");
        button.setToolTipText("Invert through centre");
        button.addSelectionListener(this.radioListener);
        this.radioButtons.add(6, button);
        group = new Composite((Composite)sashForm, 0);
        sashForm.setWeights(new int[]{25, 25, 30, 20});
        group.setLayout((Layout)new FillLayout());
        this.tViewer = new SectorROITableViewer((Composite)group, this, this);
        scrolledComposite.setContent((Control)composite2);
        composite2.setSize(composite2.computeSize(-1, -1));
        this.radPlotter.refresh(false);
        this.aziPlotter.refresh(false);
        this.combine.setEnabled(false);
        this.updateAllSpinners(this.roi);
        this.roiIDs = new ArrayList();
        this.dragIDs = new ArrayList();
        if (this.roiDataList == null) {
            this.roiDataList = new ROIDataList();
        }
        this.roisIDs = new ArrayList();
        this.tViewer.setInput(this.roiDataList);
        this.roiHandler = new SectorROIHandler((SectorROI)this.roi);
        this.dColour = new Color(255, 0, 0);
        object = Color.RGBtoHSB(this.dColour.getRed(), this.dColour.getGreen(), this.dColour.getBlue(), null);
        this.cColour = Color.getHSBColor((float)object[0], (float)object[1], (float)(1.0 - 0.7 * (double)object[2]));
        this.oColour = this.dColour;
    }

    @Override
    public void dispose() {
        if (this.radPlotter != null) {
            this.radPlotter.cleanUp();
        }
        if (this.aziPlotter != null) {
            this.aziPlotter.cleanUp();
        }
    }

    @Override
    protected void updatePlot(ROIBase rOIBase) {
        SectorROIData sectorROIData;
        Plot1DAppearance plot1DAppearance;
        SectorROI sectorROI = (SectorROI)rOIBase;
        this.setRadioButtons(sectorROI);
        this.getDataset();
        if (this.data == null) {
            logger.warn("No data");
            return;
        }
        if (sectorROI != null) {
            this.roiData = this.dragging && this.subData != null ? new SectorROIData(sectorROI, this.subData, this.subFactor, true) : new SectorROIData(sectorROI, this.data, true);
            if (!this.roiData.isPlot()) {
                return;
            }
            this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SectorProfile.this.txSum.setText(String.format("%.3e", SectorProfile.this.roiData.getProfileSum()));
                }
            });
        }
        ArrayList<IDataset> arrayList = new ArrayList<IDataset>();
        ArrayList<AxisValues> arrayList2 = new ArrayList<AxisValues>();
        int n = 0;
        int n2 = 0;
        Plot1DGraphTable plot1DGraphTable = this.radPlotter.getColourTable();
        int n3 = this.radPlotter.getNumHistory();
        if (sectorROI != null) {
            if (n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(n), Plot1DStyles.SOLID, "Line 1");
                plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
            } else {
                plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n));
                plot1DAppearance.setStyle(Plot1DStyles.SOLID);
                plot1DAppearance.setName("Line 1");
            }
            arrayList.add((IDataset)this.roiData.getProfileData(0));
            arrayList2.add(this.roiData.getXAxis(0));
            if (sectorROI.hasSeparateRegions()) {
                if (++n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                    plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(n), Plot1DStyles.DASHED, "Symmetry Line 1");
                    plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
                } else {
                    plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                    plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n));
                    plot1DAppearance.setStyle(Plot1DStyles.DASHED);
                    plot1DAppearance.setName("Symmetry Line 1");
                }
                arrayList.add((IDataset)this.roiData.getProfileData(2));
                arrayList2.add(this.roiData.getXAxis(2));
            }
            ++n2;
            ++n;
        }
        int n4 = 0;
        int n5 = this.roiDataList.size();
        while (n4 < n5) {
            sectorROIData = (SectorROIData)this.roiDataList.get(n4);
            Color color = PlotColorUtility.getDefaultColour(n4 + 1);
            RGB rGB = new RGB(color.getRed(), color.getGreen(), color.getBlue());
            sectorROIData.setPlotColourRGB(rGB);
            if (sectorROIData.isPlot()) {
                arrayList.add((IDataset)sectorROIData.getProfileData(0));
                arrayList2.add(sectorROIData.getXAxis(0));
                if (n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                    plot1DAppearance = new Plot1DAppearance(color, Plot1DStyles.SOLID, "Line " + (n + 1));
                    plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
                } else {
                    plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                    plot1DAppearance.setColour(color);
                    plot1DAppearance.setStyle(Plot1DStyles.SOLID);
                    plot1DAppearance.setName("Line " + (n + 1));
                }
                if (sectorROIData.getROI().hasSeparateRegions()) {
                    if (++n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                        plot1DAppearance = new Plot1DAppearance(color, Plot1DStyles.DASHED, "Symmetry Line " + (n + 1));
                        plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
                    } else {
                        plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                        plot1DAppearance.setColour(color);
                        plot1DAppearance.setStyle(Plot1DStyles.DASHED);
                        plot1DAppearance.setName("Symmetry Line " + (n + 1));
                    }
                    arrayList.add((IDataset)sectorROIData.getProfileData(2));
                    arrayList2.add(sectorROIData.getXAxis(2));
                }
                ++n2;
                ++n;
            }
            ++n4;
        }
        while (n3-- > 0) {
            plot1DAppearance = plot1DGraphTable.getLegendEntry(n2++);
            plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n++));
        }
        try {
            this.radPlotter.replaceAllPlots(arrayList, arrayList2);
        }
        catch (PlotException plotException) {
            plotException.printStackTrace();
        }
        arrayList.clear();
        arrayList2.clear();
        n = 0;
        n2 = 0;
        plot1DGraphTable = this.aziPlotter.getColourTable();
        n3 = this.aziPlotter.getNumHistory();
        if (sectorROI != null) {
            if (n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(n), Plot1DStyles.SOLID, "Line 1");
                plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
            } else {
                plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n));
                plot1DAppearance.setStyle(Plot1DStyles.SOLID);
                plot1DAppearance.setName("Line 1");
            }
            arrayList.add((IDataset)this.roiData.getProfileData(1));
            arrayList2.add(this.roiData.getXAxis(1));
            if (sectorROI.hasSeparateRegions()) {
                if (++n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                    plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(n), Plot1DStyles.DASHED, "Symmetry Line 1");
                    plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
                } else {
                    plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                    plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n));
                    plot1DAppearance.setStyle(Plot1DStyles.DASHED);
                    plot1DAppearance.setName("Symmetry Line 1");
                }
                arrayList.add((IDataset)this.roiData.getProfileData(3));
                arrayList2.add(this.roiData.getXAxis(3));
            }
            ++n2;
            ++n;
        }
        int n6 = 0;
        n5 = this.roiDataList.size();
        while (n6 < n5) {
            sectorROIData = (SectorROIData)this.roiDataList.get(n6);
            if (sectorROIData.isPlot()) {
                arrayList.add((IDataset)sectorROIData.getProfileData(1));
                arrayList2.add(sectorROIData.getXAxis(1));
                if (n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                    plot1DAppearance = new Plot1DAppearance(sectorROIData.getPlotColour(), Plot1DStyles.SOLID, "Line " + (n + 1));
                    plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
                } else {
                    plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                    plot1DAppearance.setColour(sectorROIData.getPlotColour());
                    plot1DAppearance.setStyle(Plot1DStyles.SOLID);
                    plot1DAppearance.setName("Line " + (n + 1));
                }
                if (sectorROIData.getROI().hasSeparateRegions()) {
                    if (++n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                        plot1DAppearance = new Plot1DAppearance(sectorROIData.getPlotColour(), Plot1DStyles.DASHED, "Symmetry Line " + (n + 1));
                        plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
                    } else {
                        plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                        plot1DAppearance.setColour(sectorROIData.getPlotColour());
                        plot1DAppearance.setStyle(Plot1DStyles.DASHED);
                        plot1DAppearance.setName("Symmetry Line " + (n + 1));
                    }
                    arrayList.add((IDataset)sectorROIData.getProfileData(3));
                    arrayList2.add(sectorROIData.getXAxis(3));
                }
                ++n2;
                ++n;
            }
            ++n6;
        }
        while (n3-- > 0) {
            plot1DAppearance = plot1DGraphTable.getLegendEntry(n2++);
            plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n++));
        }
        try {
            this.aziPlotter.replaceAllPlots(arrayList, arrayList2);
        }
        catch (PlotException plotException) {
            plotException.printStackTrace();
        }
        this.radPlotter.updateAllAppearance();
        this.radPlotter.refresh(false);
        this.aziPlotter.updateAllAppearance();
        this.aziPlotter.refresh(false);
    }

    private void drawDraggedOverlay(ROIBase rOIBase) {
        int n;
        int n2;
        if (this.oProvider == null) {
            return;
        }
        if (this.dragIDs.isEmpty()) {
            this.dragIDs.add(-1);
            this.dragIDs.add(-1);
            this.dragIDs.add(-1);
            this.dragIDs.add(-1);
        }
        if ((n2 = ((Integer)this.dragIDs.get(n = 0)).intValue()) == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.SECTOR);
            this.dragIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        SectorROI sectorROI = (SectorROI)rOIBase;
        int[] nArray = sectorROI.getIntPoint();
        int[] nArray2 = sectorROI.getIntRadii();
        double[] dArray = sectorROI.getAnglesDegrees();
        this.oProvider.begin(OverlayType.VECTOR2D);
        this.oProvider.drawSector(n2, nArray[0], nArray[1], nArray2[0], nArray2[1], -dArray[1], -dArray[0]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        this.getDataset();
        int n3 = this.calcHandleSize(this.data.getShape());
        n2 = (Integer)this.dragIDs.get(n);
        if (n2 == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.CIRCLE);
            this.dragIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        this.oProvider.drawCircle(n2, nArray[0], nArray[1], n3 / 2);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        n2 = (Integer)this.dragIDs.get(++n);
        if (n2 == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.LINE);
            this.dragIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        this.oProvider.drawLine(n2, nArray[0] - n3 / 2, nArray[1], nArray[0] + n3 / 2, nArray[1]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        n2 = (Integer)this.dragIDs.get(++n);
        if (n2 == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.LINE);
            this.dragIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        this.oProvider.drawLine(n2, nArray[0], nArray[1] - n3 / 2, nArray[0], nArray[1] + n3 / 2);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    @Override
    protected void drawCurrentOverlay() {
        int n;
        int n2;
        if (this.oProvider == null || this.roi == null) {
            return;
        }
        if (this.roiIDs.isEmpty()) {
            this.roiIDs.add(-1);
            this.roiIDs.add(-1);
            this.roiIDs.add(-1);
            this.roiIDs.add(-1);
        }
        if ((n2 = ((Integer)this.roiIDs.get(n = 0)).intValue()) == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.SECTOR);
            this.roiIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        SectorROI sectorROI = (SectorROI)this.roi;
        int[] nArray = this.roi.getIntPoint();
        int[] nArray2 = sectorROI.getIntRadii();
        double[] dArray = sectorROI.getAnglesDegrees();
        this.oProvider.begin(OverlayType.VECTOR2D);
        this.oProvider.drawSector(n2, nArray[0], nArray[1], nArray2[0], nArray2[1], -dArray[1], -dArray[0]);
        this.oProvider.setStyle(n2, VectorOverlayStyles.FILLED_WITH_OUTLINE);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setOutlineColour(n2, this.oColour);
        this.oProvider.setLineThickness(n2, this.oThickness);
        this.oProvider.setTransparency(n2, 0.9);
        this.oProvider.setOutlineTransparency(n2, this.oTransparency);
        n2 = (Integer)this.roiIDs.get(n);
        if (n2 == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.SECTOR);
            this.roiIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        if (sectorROI.getSymmetry() == 0) {
            this.oProvider.setPrimitiveVisible(n2, false);
        } else {
            double[] dArray2 = sectorROI.getSymmetryAngles();
            this.oProvider.drawSector(n2, nArray[0], nArray[1], nArray2[0], nArray2[1], -Math.toDegrees(dArray2[1]), -Math.toDegrees(dArray2[0]));
            this.oProvider.setStyle(n2, VectorOverlayStyles.OUTLINE);
            this.oProvider.setColour(n2, this.oColour);
            this.oProvider.setOutlineColour(n2, this.oColour);
            this.oProvider.setLineThickness(n2, this.oThickness);
            this.oProvider.setTransparency(n2, 0.9);
            this.oProvider.setOutlineTransparency(n2, this.oTransparency);
        }
        this.getDataset();
        int n3 = this.calcHandleSize(this.data.getShape());
        n2 = (Integer)this.roiIDs.get(n);
        if (n2 == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.LINE, true);
            this.roiIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        this.oProvider.drawLine(n2, nArray[0] - n3 / 2, nArray[1], nArray[0] + n3 / 2, nArray[1]);
        this.oProvider.setAnchorPoints(n2, nArray[0], nArray[1]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        n2 = (Integer)this.roiIDs.get(n);
        if (n2 == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.LINE, true);
            this.roiIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        this.oProvider.drawLine(n2, nArray[0], nArray[1] - n3 / 2, nArray[0], nArray[1] + n3 / 2);
        this.oProvider.setAnchorPoints(n2, nArray[0], nArray[1]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        int n4 = 1;
        while (n4 <= this.grNumber) {
            if (n == this.roiIDs.size()) {
                this.roiIDs.add(-1);
            } else if (n > this.roiIDs.size()) {
                logger.debug("Guide ring: primitive IDs list out of synch!");
                break;
            }
            n2 = (Integer)this.roiIDs.get(n);
            if (n2 == -1) {
                n2 = this.oProvider.registerPrimitive(PrimitiveType.CIRCLE);
                this.roiIDs.set(n, n2);
                if (n2 == -1) {
                    return;
                }
            } else {
                this.oProvider.setPrimitiveVisible(n2, true);
            }
            ++n;
            this.oProvider.drawCircle(n2, nArray[0], nArray[1], n4 * this.grSpacing);
            this.oProvider.setStyle(n2, VectorOverlayStyles.OUTLINE);
            this.oProvider.setColour(n2, this.oColour);
            this.oProvider.setTransparency(n2, this.oTransparency);
            ++n4;
        }
        if (n < this.roiIDs.size()) {
            while (n < this.roiIDs.size()) {
                n2 = (Integer)this.roiIDs.get(n);
                if (n2 != -1) {
                    this.oProvider.setPrimitiveVisible(n2, false);
                }
                this.roiIDs.set(n, -1);
                ++n;
            }
        }
        double d = (double)n3 / sectorROI.getRadius(1);
        int n5 = 0;
        int n6 = this.roiHandler.size() - 1;
        while (n5 < n6) {
            int n7 = (Integer)this.roiHandler.get(n5);
            if (n7 == -1) {
                n7 = this.oProvider.registerPrimitive(PrimitiveType.SECTOR, true);
                this.roiHandler.set(n5, n7);
            } else {
                this.oProvider.setPrimitiveVisible(n7, true);
            }
            double[] dArray3 = ((SectorROIHandler)this.roiHandler).getSectorPoint(n5, n3, d);
            this.oProvider.drawSector(n7, nArray[0], nArray[1], (int)dArray3[0], (int)(dArray3[0] + (double)n3), -Math.toDegrees(dArray3[1] + d), -Math.toDegrees(dArray3[1]));
            int[] nArray3 = this.roiHandler.getAnchorPoint(n5, n3);
            this.oProvider.setAnchorPoints(n7, nArray3[0], nArray3[1]);
            this.oProvider.setStyle(n7, VectorOverlayStyles.FILLED_WITH_OUTLINE);
            this.oProvider.setColour(n7, this.oColour);
            this.oProvider.setOutlineColour(n7, this.oColour);
            this.oProvider.setLineThickness(n7, this.oThickness);
            this.oProvider.setTransparency(n7, 0.9);
            this.oProvider.setOutlineTransparency(n7, this.oTransparency);
            ++n5;
        }
        n5 = this.roiHandler.size() - 1;
        n6 = (Integer)this.roiHandler.get(n5);
        if (n6 == -1) {
            n6 = this.oProvider.registerPrimitive(PrimitiveType.CIRCLE, true);
            this.roiHandler.set(n5, n6);
        } else {
            this.oProvider.setPrimitiveVisible(n6, true);
        }
        this.oProvider.drawCircle(n6, nArray[0], nArray[1], n3 / 2);
        this.oProvider.setAnchorPoints(n6, nArray[0], nArray[1]);
        this.oProvider.setStyle(n6, VectorOverlayStyles.FILLED_WITH_OUTLINE);
        this.oProvider.setColour(n6, this.oColour);
        this.oProvider.setOutlineColour(n6, this.oColour);
        this.oProvider.setLineThickness(n6, this.oThickness);
        this.oProvider.setTransparency(n6, 0.9);
        this.oProvider.setOutlineTransparency(n6, this.oTransparency);
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    @Override
    protected void drawOverlays() {
        if (this.oProvider == null) {
            return;
        }
        if (this.roiDataList.size() == 0) {
            return;
        }
        if (this.roisIDs.size() != this.roiDataList.size()) {
            logger.warn("Mismatch in number of primitives and ROIs!");
        }
        this.oProvider.begin(OverlayType.VECTOR2D);
        int n = 0;
        int n2 = this.roiDataList.size();
        while (n < n2) {
            int n3 = -1;
            try {
                n3 = (Integer)this.roisIDs.get(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.roisIDs.add(n, -1);
            }
            if (n3 == -1) {
                n3 = this.oProvider.registerPrimitive(PrimitiveType.SECTOR);
                this.roisIDs.set(n, n3);
            } else {
                this.oProvider.setPrimitiveVisible(n3, true);
            }
            SectorROI sectorROI = (SectorROI)((ROIData)this.roiDataList.get(n)).getROI();
            int[] nArray = sectorROI.getIntPoint();
            int[] nArray2 = sectorROI.getIntRadii();
            double[] dArray = sectorROI.getAnglesDegrees();
            this.oProvider.drawSector(n3, nArray[0], nArray[1], nArray2[0], nArray2[1], -dArray[1], -dArray[0]);
            this.oProvider.setColour(n3, this.oColour);
            this.oProvider.setTransparency(n3, this.oTransparency);
            ++n;
        }
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void imageStart(IImagePositionEvent iImagePositionEvent) {
        this.hStatus = HandleStatus.NONE;
        if (this.roi == null) {
            this.roi = new SectorROI();
            this.roiHandler.setROI(this.roi);
        }
        int n = iImagePositionEvent.getPrimitiveID();
        short s = iImagePositionEvent.getFlags();
        this.cpt = iImagePositionEvent.getImagePosition();
        if ((s & 1) != 0) {
            if (n == -1 || !this.roiHandler.contains(n)) {
                if (!this.lockCentre) {
                    this.roi.setPoint(this.cpt);
                    this.hideCurrent();
                    this.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SectorProfile.this.spsx.setFloat((double)SectorProfile.this.roi.getIntPoint()[0]);
                            SectorProfile.this.spsy.setFloat((double)SectorProfile.this.roi.getIntPoint()[1]);
                        }
                    });
                    this.hStatus = HandleStatus.CMOVE;
                    this.oProvider.setPlotAreaCursor(2);
                    this.dragging = true;
                    this.dragHandle = this.roiHandler.size() - 1;
                    return;
                } else {
                    this.hideCurrent();
                    this.hStatus = HandleStatus.RESIZE;
                    this.oProvider.setPlotAreaCursor(5);
                    this.dragging = true;
                }
                return;
            } else {
                if (!this.roiHandler.contains(n)) return;
                int n2 = this.roiHandler.indexOf(n);
                if (n2 == this.roiHandler.size() - 1) {
                    if (this.lockCentre) return;
                    this.hStatus = HandleStatus.CMOVE;
                    this.oProvider.setPlotAreaCursor(2);
                } else if (n2 == 4) {
                    if ((s & 8) != 0) {
                        this.hStatus = HandleStatus.ROTATE;
                        this.oProvider.setPlotAreaCursor(3);
                    } else {
                        this.hStatus = HandleStatus.RMOVE;
                        this.oProvider.setPlotAreaCursor(21);
                    }
                } else if ((s & 8) != 0) {
                    this.hStatus = HandleStatus.CRMOVE;
                    this.oProvider.setPlotAreaCursor(19);
                } else {
                    this.hStatus = HandleStatus.RESIZE;
                    this.oProvider.setPlotAreaCursor(5);
                }
                this.hideCurrent();
                this.drawDraggedOverlay(this.roi);
                this.dragging = true;
                this.dragHandle = n2;
            }
            return;
        } else {
            if ((s & 2) == 0 || !this.roiHandler.contains(n)) return;
            int n3 = this.roiHandler.indexOf(n);
            if (n3 == 4) {
                this.hStatus = HandleStatus.ROTATE;
                this.oProvider.setPlotAreaCursor(3);
            } else if (n3 != this.roiHandler.size() - 1) {
                this.hStatus = HandleStatus.CRMOVE;
                this.oProvider.setPlotAreaCursor(19);
            }
            this.hideCurrent();
            this.drawDraggedOverlay(this.roi);
            this.dragging = true;
            this.dragHandle = n3;
            logger.debug("Selected handle {}", (Object)n3);
        }
    }

    private SectorROI interpretMouseDragging(int[] nArray) {
        SectorROI sectorROI = null;
        SectorROI sectorROI2 = (SectorROI)this.roi;
        SectorCoords sectorCoords = null;
        SectorCoords sectorCoords2 = null;
        double[] dArray = null;
        double[] dArray2 = null;
        switch (this.hStatus) {
            case CMOVE: {
                sectorROI = sectorROI2.copy();
                nArray[0] = nArray[0] - this.cpt[0];
                nArray[1] = nArray[1] - this.cpt[1];
                sectorROI.addPoint(nArray);
                break;
            }
            case RMOVE: {
                sectorROI = sectorROI2.copy();
                sectorCoords = new SectorCoords(this.roi.getIntPoint(), this.cpt);
                sectorCoords2 = new SectorCoords(this.roi.getIntPoint(), nArray);
                dArray = sectorCoords.getPolarRadians();
                dArray2 = sectorCoords2.getPolarRadians();
                sectorROI.addRadii(dArray2[0] - dArray[0]);
                sectorROI.addAngles(dArray2[1] - dArray[1]);
                break;
            }
            case NONE: {
                sectorROI = sectorROI2.copy();
                break;
            }
            case RESIZE: {
                sectorCoords = new SectorCoords(this.roi.getIntPoint(), this.cpt);
                sectorCoords2 = new SectorCoords(this.roi.getIntPoint(), nArray);
                dArray = sectorCoords.getPolarRadians();
                dArray2 = sectorCoords2.getPolarRadians();
                sectorROI = ((SectorROIHandler)this.roiHandler).resize(this.dragHandle, dArray, dArray2);
                break;
            }
            case ROTATE: {
                sectorROI = sectorROI2.copy();
                sectorCoords = new SectorCoords(this.roi.getIntPoint(), this.cpt);
                sectorCoords2 = new SectorCoords(this.roi.getIntPoint(), nArray);
                dArray = sectorCoords.getPolarRadians();
                dArray2 = sectorCoords2.getPolarRadians();
                sectorROI.addAngles(dArray2[1] - dArray[1]);
                break;
            }
            case CRMOVE: {
                sectorCoords = new SectorCoords(this.roi.getIntPoint(), this.cpt);
                sectorCoords2 = new SectorCoords(this.roi.getIntPoint(), nArray);
                dArray = sectorCoords.getPolarRadians();
                dArray2 = sectorCoords2.getPolarRadians();
                sectorROI = ((SectorROIHandler)this.roiHandler).crmove(this.dragHandle, dArray, dArray2);
            }
        }
        return sectorROI;
    }

    @Override
    public void imageDragged(IImagePositionEvent iImagePositionEvent) {
        SectorROI sectorROI;
        if (this.dragging && (sectorROI = this.interpretMouseDragging(iImagePositionEvent.getImagePosition())) != null) {
            this.drawDraggedOverlay((ROIBase)sectorROI);
            if (System.currentTimeMillis() >= this.nextTime) {
                this.nextTime = System.currentTimeMillis() + this.updateInterval;
                this.updatePlot((ROIBase)sectorROI);
                this.sendCurrentROI((ROIBase)sectorROI);
                this.updateAllSpinners((ROIBase)sectorROI);
            }
        }
    }

    @Override
    public void imageFinished(IImagePositionEvent iImagePositionEvent) {
        if (this.dragging) {
            this.dragging = false;
            this.hideIDs(this.dragIDs);
            this.oProvider.restoreDefaultPlotAreaCursor();
            this.roi = this.interpretMouseDragging(iImagePositionEvent.getImagePosition());
            this.roiHandler.setROI(this.roi);
            this.dragHandle = -1;
            this.hStatus = HandleStatus.NONE;
            this.drawCurrentOverlay();
            this.sendCurrentROI(this.roi);
            this.updateAllSpinners(this.roi);
            this.updatePlot();
        }
    }

    private boolean validateSymButtons(Button button) {
        int n = this.radioButtons.lastIndexOf(button);
        SectorROI sectorROI = (SectorROI)this.roi;
        if (sectorROI != null && sectorROI.checkSymmetry(n)) {
            sectorROI.setSymmetry(n);
            this.sendCurrentROI(this.roi);
            return true;
        }
        return false;
    }

    private void setRadioButtons(final SectorROI sectorROI) {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (sectorROI == null) {
                    return;
                }
                for (Button button : SectorProfile.this.radioButtons) {
                    button.setEnabled(sectorROI.checkSymmetry(SectorProfile.this.radioButtons.indexOf(button)));
                }
            }
        });
    }

    @Override
    protected void updateAllSpinners(ROIBase rOIBase) {
        if (rOIBase == null) {
            return;
        }
        final SectorROI sectorROI = (SectorROI)rOIBase;
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SectorProfile.this.spsx.setFloat(sectorROI.getPoint()[0]);
                SectorProfile.this.spsy.setFloat(sectorROI.getPoint()[1]);
                SectorProfile.this.spsr.setFloat(sectorROI.getRadii()[0]);
                SectorProfile.this.sper.setFloat(sectorROI.getRadii()[1]);
                SectorProfile.this.spsang.setFloat(sectorROI.getAnglesDegrees()[0]);
                SectorProfile.this.speang.setFloat(sectorROI.getAnglesDegrees()[1]);
            }
        });
    }

    @Override
    public int updateGUI(GuiBean guiBean) {
        ROIList rOIList;
        Object object;
        int n = 0;
        if (guiBean == null) {
            return n;
        }
        logger.debug("Bean: {}", (Object)guiBean);
        if (guiBean.containsKey((Object)GuiParameters.ROIDATA) && (object = guiBean.get((Object)GuiParameters.ROIDATA)) instanceof SectorROI) {
            this.hideCurrent();
            this.roi = (SectorROI)object;
            this.roiHandler.setROI(this.roi);
            this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SectorProfile.this.updatePlot();
                    SectorProfile.this.drawOverlays();
                    SectorProfile.this.drawCurrentOverlay();
                }
            });
            this.updateAllSpinners(this.roi);
            rOIList = (SectorROI)this.roi;
            if (rOIList.getSymmetry() == 0 || rOIList.getSymmetry() == 1) {
                this.combine.setEnabled(false);
            } else {
                this.combine.setEnabled(true);
            }
            n |= 1;
        }
        if (guiBean.containsKey((Object)GuiParameters.ROIDATALIST)) {
            object = guiBean.get((Object)GuiParameters.ROIDATALIST);
            if (this.data != null && object instanceof ROIList) {
                rOIList = (ROIList)object;
                boolean bl = false;
                for (ROIBase rOIBase : rOIList) {
                    if (!(rOIBase instanceof SectorROI)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.getDataset();
                    this.removeIDs(this.roisIDs);
                    this.roisIDs.clear();
                    this.roiDataList.clear();
                    for (ROIBase rOIBase : rOIList) {
                        if (!(rOIBase instanceof SectorROI)) continue;
                        this.roiDataList.add(new SectorROIData((SectorROI)rOIBase, this.data, false));
                        this.roisIDs.add(-1);
                    }
                    this.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SectorProfile.this.updatePlot();
                            SectorProfile.this.tViewer.setInput(SectorProfile.this.roiDataList);
                            SectorProfile.this.hideCurrent();
                            SectorProfile.this.removeIDs(SectorProfile.this.roiIDs);
                            SectorProfile.this.removeHandles();
                            SectorProfile.this.drawOverlays();
                            SectorProfile.this.drawCurrentOverlay();
                        }
                    });
                    n |= 2;
                }
            }
        }
        return n;
    }

    @Override
    public Action createSwitchAction(int n, IPlotUI iPlotUI) {
        Action action = super.createSwitchAction(n, iPlotUI);
        action.setText("Sector profile");
        action.setToolTipText("Switch side plot to sector profile mode");
        action.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/ProfileSector.png"));
        return action;
    }

    @Override
    protected void updateDataList() {
        if (this.getDataset()) {
            int n = 0;
            int n2 = this.roiDataList.size();
            while (n < n2) {
                SectorROIData sectorROIData = (SectorROIData)this.roiDataList.get(n);
                SectorROI sectorROI = sectorROIData.getROI();
                this.roiDataList.set(n, new SectorROIData(sectorROI, this.data, sectorROIData.isPlot()));
                ++n;
            }
        }
    }

    @Override
    public void addToHistory() {
        Plot1DAppearance plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(this.radPlotter.getColourTable().getLegendSize()), Plot1DStyles.SOLID, "History " + this.radPlotter.getNumHistory());
        this.radPlotter.getColourTable().addEntryOnLegend(plot1DAppearance);
        this.radPlotter.pushGraphOntoHistory();
        plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(this.aziPlotter.getColourTable().getLegendSize()), Plot1DStyles.SOLID, "History " + this.aziPlotter.getNumHistory());
        this.aziPlotter.getColourTable().addEntryOnLegend(plot1DAppearance);
        this.aziPlotter.pushGraphOntoHistory();
    }

    @Override
    public void removeFromHistory() {
        if (this.radPlotter.getNumHistory() > 0) {
            this.radPlotter.getColourTable().deleteLegendEntry(this.radPlotter.getColourTable().getLegendSize() - 1);
            this.radPlotter.popGraphFromHistory();
            this.radPlotter.refresh(true);
        }
        if (this.aziPlotter.getNumHistory() > 0) {
            this.aziPlotter.getColourTable().deleteLegendEntry(this.aziPlotter.getColourTable().getLegendSize() - 1);
            this.aziPlotter.popGraphFromHistory();
            this.aziPlotter.refresh(true);
        }
    }

    @Override
    DataBean getPlottingData(int n) {
        DataBean dataBean = null;
        if (this.roiData != null && this.roiData.getProfileData().length > n) {
            dataBean = new DataBean();
            DataSetWithAxisInformation dataSetWithAxisInformation = new DataSetWithAxisInformation();
            AxisMapBean axisMapBean = new AxisMapBean(AxisMapBean.DIRECT);
            dataBean.addAxis("x-axis", (IDataset)this.roiData.getXAxis(n).toDataset());
            axisMapBean.setAxisID(new String[]{"x-axis"});
            dataSetWithAxisInformation.setData((IDataset)this.roiData.getProfileData(n));
            dataSetWithAxisInformation.setAxisMap(axisMapBean);
            try {
                dataBean.addData(dataSetWithAxisInformation);
            }
            catch (DataBeanException dataBeanException) {
                logger.debug("Could not add data to bean");
                dataBeanException.printStackTrace();
                dataBean = null;
            }
        }
        return dataBean;
    }

    @Override
    public void generateMenuActions(IMenuManager iMenuManager, final IWorkbenchPartSite iWorkbenchPartSite) {
        Action action = new Action(){

            public void run() {
                SectorProfile.this.pushPlottingData(iWorkbenchPartSite, "2", 0);
            }
        };
        action.setText("Push radial datasets to plot 2");
        action.setToolTipText("Push radial datasets to plot 2");
        Action action2 = new Action(){

            public void run() {
                SectorProfile.this.pushPlottingData(iWorkbenchPartSite, "2", 1);
            }
        };
        action2.setText("Push azimuth datasets to plot 2");
        action2.setToolTipText("Push azimuth datasets to plot 2");
        iMenuManager.add((IAction)action);
        iMenuManager.add((IAction)action2);
    }

    private static enum HandleStatus {
        NONE,
        CMOVE,
        RMOVE,
        RESIZE,
        ROTATE,
        CRMOVE;

    }
}

