/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.DiffractionViewer;
import uk.ac.gda.richbeans.components.wrappers.LabelWrapper;

public class DiffractionViewerMetadata
extends Composite {
    private Map<String, ? extends Object> metadata;
    public static int NUM_DEC_PLACES = 4;
    private LabelWrapper detectorSizeX;
    private LabelWrapper detectorSizeY;
    private LabelWrapper PixelSizeX;
    private LabelWrapper PixelSizeY;
    private LabelWrapper wavelength;
    private LabelWrapper phiStart;
    private DiffractionViewer diffView;
    private LabelWrapper phiStop;
    private LabelWrapper phiRange;
    private LabelWrapper distanceToDetector;
    private LabelWrapper ExposureTime;
    private LabelWrapper maxPxVal;
    private LabelWrapper minPxVal;
    private LabelWrapper meanPxVal;

    public DiffractionViewerMetadata(Composite composite, int n, DiffractionViewer diffractionViewer) {
        super(composite, n);
        this.diffView = diffractionViewer;
        this.setLayoutData(new GridData(4, 128, true, false));
        this.setLayout((Layout)new GridLayout(2, false));
        Group group = new Group((Composite)this, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("Experimental Information");
        Label label = new Label((Composite)group, 0);
        label.setText("Wavelength");
        this.wavelength = new LabelWrapper((Composite)group, 0);
        this.wavelength.setUnit("\u00c5");
        this.wavelength.setDecimalPlaces(NUM_DEC_PLACES);
        label = new Label((Composite)group, 0);
        label.setText("Start");
        this.phiStart = new LabelWrapper((Composite)group, 0);
        this.phiStart.setUnit("\u00b0");
        this.phiStart.setDecimalPlaces(NUM_DEC_PLACES);
        label = new Label((Composite)group, 0);
        label.setText("Stop");
        this.phiStop = new LabelWrapper((Composite)group, 0);
        this.phiStop.setUnit("\u00b0");
        this.phiStop.setDecimalPlaces(NUM_DEC_PLACES);
        label = new Label((Composite)group, 0);
        label.setText("Oscillation Range");
        this.phiRange = new LabelWrapper((Composite)group, 0);
        this.phiRange.setUnit("\u00b0");
        this.phiRange.setDecimalPlaces(NUM_DEC_PLACES);
        label = new Group((Composite)this, 0);
        label.setLayout((Layout)new GridLayout(2, true));
        label.setText("Detector Metadata");
        Label label2 = new Label((Composite)label, 0);
        label2.setText("Distance");
        this.distanceToDetector = new LabelWrapper((Composite)label, 0);
        this.distanceToDetector.setUnit("mm ");
        label2 = new Label((Composite)label, 0);
        label2.setText("Size (x)");
        this.detectorSizeX = new LabelWrapper((Composite)label, 0);
        this.detectorSizeX.setUnit("mm ");
        label2 = new Label((Composite)label, 0);
        label2.setText("Size (y)");
        this.detectorSizeY = new LabelWrapper((Composite)label, 0);
        this.detectorSizeY.setUnit("mm ");
        label2 = new Label((Composite)label, 0);
        label2.setText("Pixel Size (x)");
        this.PixelSizeX = new LabelWrapper((Composite)label, 0);
        this.PixelSizeX.setUnit("mm ");
        label2 = new Label((Composite)label, 0);
        label2.setText("Pixel Size (y)");
        this.PixelSizeY = new LabelWrapper((Composite)label, 0);
        this.PixelSizeY.setUnit("mm ");
        label2 = new Label((Composite)label, 0);
        label2.setText("Exposure Time");
        this.ExposureTime = new LabelWrapper((Composite)label, 0);
        this.ExposureTime.setUnit("s");
        label2 = new Label((Composite)label, 0);
        label2.setText("Maximum Value");
        label2.setToolTipText("Maximum pixel value of the dataset being plotted.");
        this.maxPxVal = new LabelWrapper((Composite)label, 0);
        label2 = new Label((Composite)label, 0);
        label2.setText("Minimum Value");
        label2.setToolTipText("Minimum pixel value of the dataset being plotted.");
        this.minPxVal = new LabelWrapper((Composite)label, 0);
        label2 = new Label((Composite)label, 0);
        label2.setText("Mean Value");
        label2.setToolTipText("Mean pixel value of the dataset being plotted.");
        this.meanPxVal = new LabelWrapper((Composite)label, 0);
    }

    protected void checkSubclass() {
    }

    public void dispose() {
    }

    public void setMetadata(Map<String, ? extends Object> map) {
        this.metadata = map;
        this.setMetadata();
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                double d = DiffractionViewerMetadata.this.getDoubleFromMetadata("NXSample:rotation_start");
                double d2 = DiffractionViewerMetadata.this.getDoubleFromMetadata("NXSample:rotation_range");
                DiffractionViewerMetadata.this.phiStart.setValue((Object)d);
                DiffractionViewerMetadata.this.phiRange.setValue((Object)d2);
                DiffractionViewerMetadata.this.phiStop.setValue((Object)(d + d2));
                DiffractionViewerMetadata.this.ExposureTime.setValue((Object)DiffractionViewerMetadata.this.getDoubleFromMetadata("NXSample:exposure_time"));
            }
        });
    }

    public void setMetadata() {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiffractionViewerMetadata.this.detectorSizeX.setValue((Object)((DiffractionViewerMetadata)DiffractionViewerMetadata.this).diffView.detConfig.getDetectorSizeH());
                DiffractionViewerMetadata.this.detectorSizeY.setValue((Object)((DiffractionViewerMetadata)DiffractionViewerMetadata.this).diffView.detConfig.getDetectorSizeV());
                DiffractionViewerMetadata.this.wavelength.setValue((Object)((DiffractionViewerMetadata)DiffractionViewerMetadata.this).diffView.diffEnv.getWavelength());
                DiffractionViewerMetadata.this.PixelSizeX.setValue((Object)((DiffractionViewerMetadata)DiffractionViewerMetadata.this).diffView.detConfig.getHPxSize());
                DiffractionViewerMetadata.this.PixelSizeY.setValue((Object)((DiffractionViewerMetadata)DiffractionViewerMetadata.this).diffView.detConfig.getVPxSize());
                DiffractionViewerMetadata.this.distanceToDetector.setValue((Object)((DiffractionViewerMetadata)DiffractionViewerMetadata.this).diffView.detConfig.getOrigin().length());
            }
        });
    }

    private double getDoubleFromMetadata(String string) {
        Object object = this.metadata.get(string);
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        return 0.0;
    }

    public void setDatasetInformation(final Number number, final Number number2, final Number number3) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiffractionViewerMetadata.this.minPxVal.setValue((Object)number2);
                DiffractionViewerMetadata.this.maxPxVal.setValue((Object)number);
                DiffractionViewerMetadata.this.meanPxVal.setValue((Object)number3);
            }
        });
    }
}

