/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.roi;

import java.awt.Color;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIData;
import uk.ac.diamond.scisoft.analysis.roi.ResolutionRing;

public final class ResolutionRingTableViewer {
    private TableViewer tViewer;
    private static final int CHECKCOLNUM = 0;
    private Menu contextMenu;
    public MenuItem deleteItem;
    public MenuItem editItem;
    public static final int ROITABLEMENU_DELETE = 2;

    public ResolutionRingTableViewer(Composite composite, SelectionListener selectionListener, ICellEditorListener iCellEditorListener) {
        this.tViewer = new TableViewer(composite, 2564);
        String[] stringArray = this.getTitles();
        String[] stringArray2 = this.getTipTexts();
        int[] nArray = this.getWidths();
        int n = 0;
        while (n < stringArray.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(stringArray[n]);
            tableColumn.setToolTipText(stringArray2[n]);
            tableColumn.setWidth(nArray[n]);
            tableColumn.setMoveable(true);
            tableViewerColumn.setEditingSupport((EditingSupport)new ResRingEditingSupport((ColumnViewer)this.tViewer, n, iCellEditorListener));
            ++n;
        }
        Table table = this.tViewer.getTable();
        table.setHeaderVisible(true);
        this.tViewer.setContentProvider((IContentProvider)new ResRingContentProvider());
        this.tViewer.setLabelProvider((IBaseLabelProvider)new ResRingLabelProvider());
        this.contextMenu = new Menu(this.tViewer.getControl());
        this.deleteItem = new MenuItem(this.contextMenu, 8);
        this.deleteItem.addSelectionListener(selectionListener);
        this.deleteItem.setText("Delete");
        table.setMenu(this.contextMenu);
    }

    String content(Object object, int n) {
        String string = null;
        ResolutionRing resolutionRing = (ResolutionRing)object;
        if (resolutionRing != null) {
            switch (n) {
                case 1: {
                    string = String.format("%.2f", resolutionRing.getWavelength());
                    break;
                }
                case 2: {
                    string = Integer.toHexString(resolutionRing.getColour().getRGB());
                }
            }
        }
        return string;
    }

    String[] getTitles() {
        return new String[]{"Visible", "Resolution", "Colour"};
    }

    int[] getWidths() {
        return new int[]{50, 80, 60};
    }

    String[] getTipTexts() {
        return new String[]{"Visible", "Resolution in Angstrom", "Colour of ring"};
    }

    public Menu getContextMenu() {
        return this.contextMenu;
    }

    public final void refresh() {
        this.tViewer.refresh();
    }

    public final void setInput(Object object) {
        this.tViewer.setInput(object);
    }

    public final ISelection getSelection() {
        return this.tViewer.getSelection();
    }

    public final int getSelectionIndex() {
        return this.tViewer.getTable().getSelectionIndex();
    }

    private final class ResRingContentProvider
    implements IStructuredContentProvider {
        private ResRingContentProvider() {
        }

        public Object[] getElements(Object object) {
            if (object == null) {
                return null;
            }
            return ((List)object).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private final class ResRingEditingSupport
    extends EditingSupport {
        private CheckboxCellEditor editor;
        private int column;

        public ResRingEditingSupport(ColumnViewer columnViewer, int n, ICellEditorListener iCellEditorListener) {
            super(columnViewer);
            if (n == 0) {
                this.editor = new CheckboxCellEditor(null, 32);
                this.editor.addListener(iCellEditorListener);
            }
            this.column = n;
        }

        protected boolean canEdit(Object object) {
            return true;
        }

        protected CellEditor getCellEditor(Object object) {
            return this.editor;
        }

        protected Object getValue(Object object) {
            ROIData rOIData = (ROIData)object;
            if (this.column == 0) {
                return rOIData.isPlot();
            }
            return null;
        }

        protected void setValue(Object object, Object object2) {
            ResolutionRing resolutionRing = (ResolutionRing)object;
            if (this.column == 0) {
                resolutionRing.setVisible(((Boolean)object2).booleanValue());
            }
            this.getViewer().update(object, null);
        }
    }

    private final class ResRingLabelProvider
    implements ITableLabelProvider {
        private final Image CROSSED = AnalysisRCPActivator.getImageDescriptor("icons/cross.png").createImage();
        private final int height;
        private final int width;
        private final int linehalfthickness = 2;
        private final RGB white;

        private ResRingLabelProvider() {
            this.height = this.CROSSED.getImageData().height;
            this.width = this.CROSSED.getImageData().width;
            this.linehalfthickness = 2;
            this.white = new RGB(255, 255, 255);
        }

        private Image drawImage(RGB rGB) {
            int n;
            PaletteData paletteData = new PaletteData(new RGB[]{this.white, rGB});
            ImageData imageData = new ImageData(this.width, this.height, 2, paletteData);
            int n2 = 0;
            while (n2 < this.height) {
                n = 0;
                while (n < this.width) {
                    imageData.setAlpha(n, n2, 0);
                    ++n;
                }
                ++n2;
            }
            n2 = -2;
            while (n2 < 2) {
                n = 0;
                while (n < this.width) {
                    imageData.setPixel(n, this.height / 2 + n2, 1);
                    imageData.setAlpha(n, this.height / 2 + n2, 255);
                    ++n;
                }
                ++n2;
            }
            Image image = new Image(this.CROSSED.getDevice(), imageData);
            return image;
        }

        public Image getColumnImage(Object object, int n) {
            ResolutionRing resolutionRing = (ResolutionRing)object;
            if (resolutionRing != null && n == 0) {
                if (resolutionRing.isVisible()) {
                    Color color = resolutionRing.getColour();
                    return this.drawImage(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
                }
                return this.CROSSED;
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            return ResolutionRingTableViewer.this.content(object, n);
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }
}

