/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.roi;

import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIHandles;
import uk.ac.diamond.scisoft.analysis.roi.LinearROI;

public class LinearROIHandler
extends ROIHandles {
    private static final int NHANDLE = 3;

    public LinearROIHandler(LinearROI linearROI) {
        int n = 0;
        while (n < 3) {
            this.add(-1);
            ++n;
        }
        this.roi = linearROI;
    }

    public LinearROI getROI() {
        return (LinearROI)this.roi;
    }

    @Override
    public int[] getHandlePoint(int n, int n2) {
        int[] nArray = this.getAnchorPoint(n, n2);
        if (nArray != null) {
            nArray[0] = nArray[0] - n2 / 2;
            nArray[1] = nArray[1] - n2 / 2;
        }
        return nArray;
    }

    @Override
    public int[] getAnchorPoint(int n, int n2) {
        LinearROI linearROI = (LinearROI)this.roi;
        int[] nArray = null;
        switch (n) {
            case 0: {
                nArray = linearROI.getIntPoint();
                break;
            }
            case 1: {
                nArray = new int[]{(int)linearROI.getMidPoint()[0], (int)linearROI.getMidPoint()[1]};
                break;
            }
            case 2: {
                nArray = linearROI.getIntEndPoint();
            }
        }
        return nArray;
    }

    public LinearROI reorient(int n, int[] nArray) {
        LinearROI linearROI = (LinearROI)this.roi;
        LinearROI linearROI2 = null;
        switch (n) {
            case 0: {
                linearROI2 = linearROI.copy();
                double d = linearROI2.getLength();
                linearROI2.setPointKeepEndPoint(nArray);
                linearROI2.translateAlongLength(linearROI2.getLength() - d);
                linearROI2.setLength(d);
                break;
            }
            case 2: {
                linearROI2 = linearROI.copy();
                double d = linearROI2.getLength();
                linearROI2.setEndPoint(nArray);
                linearROI2.setLength(d);
            }
        }
        return linearROI2;
    }

    public LinearROI resize(int n, int[] nArray) {
        LinearROI linearROI = (LinearROI)this.roi;
        LinearROI linearROI2 = null;
        switch (n) {
            case 0: {
                linearROI2 = linearROI.copy();
                ((LinearROI)this.roi).setPointKeepEndPoint(nArray);
                break;
            }
            case 2: {
                linearROI2 = linearROI.copy();
                linearROI2.setEndPoint(nArray);
            }
        }
        return linearROI2;
    }
}

