/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay;

import de.jreality.geometry.PointSetFactory;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.ShaderUtility;
import java.awt.Color;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayPrimitive;

public class PointPrimitive
extends OverlayPrimitive {
    private double[][] coords = new double[1][3];
    private double pointSize = 1.0;
    protected PointSetFactory pFactory = null;
    private DefaultPointShader dps = null;

    public PointPrimitive(SceneGraphComponent sceneGraphComponent) {
        this(sceneGraphComponent, false);
    }

    public PointPrimitive(SceneGraphComponent sceneGraphComponent, boolean bl) {
        super(sceneGraphComponent, bl);
        this.ap = new Appearance();
        sceneGraphComponent.setAppearance(this.ap);
        this.ap.setAttribute("pointShader.spheresDraw", false);
        this.ap.setAttribute("lineShader.tubeDraw", false);
        this.ap.setAttribute("lightingEnabled", false);
        this.ap.setAttribute("attenuatePointSize", false);
        this.ap.setAttribute("useGLSL", false);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)this.ap, (boolean)true);
        this.dps = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
        this.dps.setDiffuseColor(Color.RED);
        this.dps.setPointSize(Double.valueOf(this.pointSize));
        this.dps.setSpheresDraw(Boolean.valueOf(false));
        this.colour = Color.RED;
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        this.pFactory = new PointSetFactory();
    }

    protected PointSet createPointGeometry() {
        this.pFactory.setVertexCount(1);
        this.pFactory.setVertexCoordinates(this.coords);
        this.pFactory.update();
        return this.pFactory.getPointSet();
    }

    @Override
    public void setLineThickness(double d) {
    }

    @Override
    public void setOutlineColour(Color color) {
    }

    @Override
    public void setOutlineTransparency(double d) {
    }

    @Override
    public void setStyle(VectorOverlayStyles vectorOverlayStyles) {
    }

    @Override
    public void setTransparency(double d) {
        if (d > 0.0) {
            this.ap.setAttribute("pointShader.transparencyEnabled", true);
            this.ap.setAttribute("transparencyEnabled", true);
        } else {
            this.ap.setAttribute("pointShader.transparencyEnabled", false);
            this.ap.setAttribute("transparencyEnabled", false);
        }
        this.ap.setAttribute("pointShader.transparency", d);
    }

    public void setPoint(double d, double d2) {
        this.needToUpdateGeom = true;
        this.coords[0][0] = d;
        this.coords[0][1] = d2;
        this.coords[0][2] = 0.005;
    }

    public void setPhat(boolean bl) {
        this.needToUpdateApp = true;
        this.pointSize = bl ? 5.0 : 1.0;
    }

    @Override
    public void updateNode() {
        if (this.needToUpdateTrans) {
            MatrixBuilder.euclidean((Matrix)this.transformMatrix).assignTo(this.comp);
        }
        if (this.needToUpdateGeom) {
            this.comp.setGeometry((Geometry)this.createPointGeometry());
        }
        if (this.needToUpdateApp) {
            this.dps.setDiffuseColor(this.colour);
            this.dps.setPointSize(Double.valueOf(this.pointSize));
        }
        this.needToUpdateApp = false;
        this.needToUpdateGeom = false;
        this.needToUpdateTrans = false;
        this.transformMatrix = null;
    }
}

