/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay;

import java.awt.Color;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.IImagePositionEvent;

public class DemoOverlay
implements Overlay2DConsumer {
    private Overlay2DProvider provider = null;
    private int sx = 0;
    private int sy = 0;
    private int ex = 0;
    private int ey = 0;
    private boolean drawing = false;
    int primID = -1;
    int primID2 = -1;

    @Override
    public void registerProvider(OverlayProvider overlayProvider) {
        this.provider = (Overlay2DProvider)overlayProvider;
        this.primID = overlayProvider.registerPrimitive(PrimitiveType.RING);
        this.primID2 = overlayProvider.registerPrimitive(PrimitiveType.ELLIPSE);
        this.drawOverlay();
    }

    private void drawOverlay() {
        this.provider.begin(OverlayType.VECTOR2D);
        if (this.primID != -1) {
            this.provider.drawRing(this.primID, 50.0, 50.0, 20.0, 40.0);
            this.provider.setStyle(this.primID, VectorOverlayStyles.FILLED_WITH_OUTLINE);
            this.provider.setColour(this.primID, Color.blue);
            this.provider.setLineThickness(this.primID, 4.0);
        }
        if (this.primID2 != -1) {
            this.provider.drawEllipse(this.primID2, 120.0, 120.0, 30.0, 15.0, 0.0);
            this.provider.setStyle(this.primID2, VectorOverlayStyles.FILLED_WITH_OUTLINE);
            this.provider.setOutlineColour(this.primID2, Color.black);
            this.provider.setLineThickness(this.primID2, 4.0);
            this.provider.setColour(this.primID2, Color.red);
        }
        this.provider.end(OverlayType.VECTOR2D);
    }

    @Override
    public void imageDragged(IImagePositionEvent iImagePositionEvent) {
        this.ex = iImagePositionEvent.getImagePosition()[0];
        this.ey = iImagePositionEvent.getImagePosition()[1];
        this.provider.setPlotAreaCursor(2);
    }

    @Override
    public void imageFinished(IImagePositionEvent iImagePositionEvent) {
        this.provider.restoreDefaultPlotAreaCursor();
    }

    @Override
    public void imageStart(IImagePositionEvent iImagePositionEvent) {
        this.sx = iImagePositionEvent.getImagePosition()[0];
        this.sy = iImagePositionEvent.getImagePosition()[1];
        System.out.println(iImagePositionEvent.getPrimitiveID());
        this.provider.setPlotAreaCursor(4);
    }

    @Override
    public void unregisterProvider() {
        this.provider = null;
    }

    @Override
    public void hideOverlays() {
        if (this.provider != null) {
            this.provider.setPrimitiveVisible(this.primID, false);
        }
    }

    @Override
    public void showOverlays() {
        if (this.provider != null) {
            this.provider.setPrimitiveVisible(this.primID, true);
        }
    }

    @Override
    public void removePrimitives() {
        this.primID = -1;
    }
}

