/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay;

import de.jreality.geometry.QuadMeshFactory;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPolygonShader;
import de.jreality.shader.ShaderUtility;
import java.awt.Color;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayPrimitive;

public class BoxPrimitive
extends OverlayPrimitive {
    private double[][][] coords = new double[2][2][3];
    private double[][] dataPoints = new double[2][2];
    private DefaultLineShader dls = null;
    private DefaultGeometryShader dgs = null;
    private DefaultPolygonShader dps = null;
    private QuadMeshFactory factory;
    private VectorOverlayStyles currentStyle = VectorOverlayStyles.FILLED;
    private Color outlineColour;
    private double lineThickness = 1.0;

    public BoxPrimitive(SceneGraphComponent sceneGraphComponent) {
        this(sceneGraphComponent, false);
    }

    public BoxPrimitive(SceneGraphComponent sceneGraphComponent, boolean bl) {
        super(sceneGraphComponent, bl);
        this.ap = new Appearance();
        sceneGraphComponent.setAppearance(this.ap);
        this.ap.setAttribute("pointShader.spheresDraw", false);
        this.ap.setAttribute("lineShader.tubeDraw", false);
        this.ap.setAttribute("lightingEnabled", false);
        this.ap.setAttribute("polygonShader.texture2d", Appearance.DEFAULT);
        this.ap.setAttribute("polygonShader.texture2d[1]", Appearance.DEFAULT);
        this.ap.setAttribute("polygonShader.texture2d[2]", Appearance.DEFAULT);
        this.ap.setAttribute("useGLSL", false);
        this.dgs = ShaderUtility.createDefaultGeometryShader((Appearance)this.ap, (boolean)true);
        this.dls = (DefaultLineShader)this.dgs.createLineShader("default");
        this.dls.setDiffuseColor(Color.WHITE);
        this.dps = (DefaultPolygonShader)this.dgs.createPolygonShader("default");
        this.dps.setDiffuseColor(Color.WHITE);
        this.dgs.setShowFaces(Boolean.valueOf(true));
        this.dgs.setShowLines(Boolean.valueOf(false));
        this.dgs.setShowPoints(Boolean.valueOf(false));
        this.factory = new QuadMeshFactory();
    }

    public void setBoxPoints(double d, double d2, double d3, double d4) {
        this.coords[0][0][0] = d;
        this.coords[0][0][1] = d4;
        this.coords[0][0][2] = 5.0E-4;
        this.coords[0][1][0] = d3;
        this.coords[0][1][1] = d4;
        this.coords[0][1][2] = 5.0E-4;
        this.coords[1][0][0] = d;
        this.coords[1][0][1] = d2;
        this.coords[1][0][2] = 5.0E-4;
        this.coords[1][1][0] = d3;
        this.coords[1][1][1] = d2;
        this.coords[1][1][2] = 5.0E-4;
        this.needToUpdateGeom = true;
    }

    public void setDataPoints(double d, double d2, double d3, double d4) {
        this.dataPoints[0][0] = d;
        this.dataPoints[0][1] = d2;
        this.dataPoints[1][0] = d3;
        this.dataPoints[1][1] = d4;
    }

    public double[][] getDataPoints() {
        return this.dataPoints;
    }

    private IndexedFaceSet createBoxGeometry() {
        this.factory.setVLineCount(2);
        this.factory.setULineCount(2);
        this.factory.setClosedInUDirection(false);
        this.factory.setClosedInVDirection(false);
        this.factory.setVertexCoordinates(this.coords);
        this.factory.setGenerateFaceNormals(true);
        this.factory.setEdgeFromQuadMesh(true);
        this.factory.setGenerateEdgesFromFaces(true);
        this.factory.update();
        return this.factory.getIndexedFaceSet();
    }

    @Override
    public void updateNode() {
        if (this.needToUpdateTrans) {
            MatrixBuilder.euclidean((Matrix)this.transformMatrix).assignTo(this.comp);
        }
        if (this.needToUpdateGeom) {
            this.comp.setGeometry((Geometry)this.createBoxGeometry());
        }
        if (this.needToUpdateApp) {
            this.dls.setDiffuseColor(this.colour);
            this.dls.setLineWidth(Double.valueOf(this.lineThickness));
            this.dps.setDiffuseColor(this.colour);
            switch (this.currentStyle) {
                case FILLED: {
                    this.dgs.setShowFaces(Boolean.valueOf(true));
                    this.dgs.setShowLines(Boolean.valueOf(false));
                    break;
                }
                case OUTLINE: {
                    this.dgs.setShowFaces(Boolean.valueOf(false));
                    this.dgs.setShowLines(Boolean.valueOf(true));
                    break;
                }
                case FILLED_WITH_OUTLINE: {
                    this.dgs.setShowFaces(Boolean.valueOf(true));
                    this.dgs.setShowLines(Boolean.valueOf(true));
                    this.dls.setDiffuseColor(this.outlineColour);
                }
            }
        }
        this.needToUpdateApp = false;
        this.needToUpdateGeom = false;
        this.needToUpdateTrans = false;
        this.transformMatrix = null;
    }

    @Override
    public void setStyle(VectorOverlayStyles vectorOverlayStyles) {
        if (this.currentStyle != vectorOverlayStyles) {
            this.needToUpdateApp = true;
            this.currentStyle = vectorOverlayStyles;
        }
    }

    @Override
    public void setOutlineColour(Color color) {
        if (this.outlineColour != color) {
            this.outlineColour = color;
            this.needToUpdateApp = true;
        }
    }

    @Override
    public void setLineThickness(double d) {
        this.needToUpdateApp = true;
        this.lineThickness = d;
    }

    @Override
    public void setOutlineTransparency(double d) {
        if (d > 0.0) {
            this.ap.setAttribute("lineShader.transparencyEnabled", true);
        } else {
            this.ap.setAttribute("lineShader.transparencyEnabled", false);
        }
        this.ap.setAttribute("lineShader.transparency", d);
        this.ap.setAttribute("additiveBlendingEnabled", true);
    }

    @Override
    public void setTransparency(double d) {
        if (d > 0.0) {
            this.ap.setAttribute("transparencyEnabled", true);
        } else {
            this.ap.setAttribute("transparencyEnabled", false);
        }
        this.ap.setAttribute("polygonShader.transparency", d);
        this.ap.setAttribute("additiveBlendingEnabled", true);
    }
}

