/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.ScaleType;

public class ScalingUtility {
    private static boolean smallLogFlag = true;
    private static final double LOG2 = Math.log10(2.0);

    public static void setSmallLogFlag(boolean bl) {
        smallLogFlag = bl;
    }

    public static double valueScaler(double d, ScaleType scaleType) {
        double d2 = d;
        switch (scaleType) {
            case LINEAR: {
                break;
            }
            case LOG2: {
                boolean bl;
                if (smallLogFlag) {
                    d2 = Math.log10(d) / LOG2;
                    break;
                }
                boolean bl2 = bl = d < 0.0;
                if (bl) {
                    d = -d;
                }
                if (d < 2.0) {
                    d += (2.0 - d) / 2.0;
                }
                d2 = Math.log10(d) / LOG2;
                d2 = bl ? -d2 : d2;
                break;
            }
            case LOG10: {
                boolean bl;
                if (smallLogFlag) {
                    d2 = Math.log10(d);
                    break;
                }
                boolean bl3 = bl = d < 0.0;
                if (bl) {
                    d = -d;
                }
                if (d < 10.0) {
                    d += (10.0 - d) / 10.0;
                }
                d2 = Math.log10(d);
                d2 = bl ? -d2 : d2;
                break;
            }
            case LN: {
                boolean bl;
                if (smallLogFlag) {
                    d2 = Math.log(d);
                    break;
                }
                boolean bl4 = bl = d < 0.0;
                if (bl) {
                    d = -d;
                }
                if (d < Math.E) {
                    d += (Math.E - d) / Math.E;
                }
                d2 = Math.log(d);
                d2 = bl ? -d2 : d2;
            }
        }
        return d2;
    }

    public static double inverseScaler(double d, ScaleType scaleType) {
        double d2 = d;
        switch (scaleType) {
            case LINEAR: {
                break;
            }
            case LOG2: {
                boolean bl;
                if (smallLogFlag) {
                    d2 = Math.pow(2.0, d);
                    break;
                }
                boolean bl2 = bl = d < 0.0;
                if (bl) {
                    d = -d;
                }
                d2 = d < 1.0 ? Math.pow(2.0, d + 1.0) - 2.0 : Math.pow(2.0, d);
                d2 = bl ? -d2 : d2;
                break;
            }
            case LOG10: {
                boolean bl;
                if (smallLogFlag) {
                    d2 = Math.pow(10.0, d);
                    break;
                }
                boolean bl3 = bl = d < 0.0;
                if (bl) {
                    d = -d;
                }
                d2 = d < 1.0 ? (Math.pow(10.0, d + 1.0) - 10.0) / 9.0 : Math.pow(10.0, d);
                d2 = bl ? -d2 : d2;
                break;
            }
            case LN: {
                boolean bl;
                if (smallLogFlag) {
                    d2 = Math.exp(d);
                    break;
                }
                boolean bl4 = bl = d < 0.0;
                if (bl) {
                    d = -d;
                }
                d2 = d < 1.0 ? (Math.exp(d + 1.0) - Math.E) / 1.718281828459045 : Math.exp(d);
                d2 = bl ? -d2 : d2;
            }
        }
        return d2;
    }
}

