/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import gda.observable.IObservable;
import gda.observable.IObserver;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramDataUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IGuiInfoManager;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IUpdateNotificationListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DStackUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DUIComplete;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot2DUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotScatter2DUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotScatter3DUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotSurf3DUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView;

public class PlotWindow
implements IObserver,
IObservable {
    private DataSetPlotter mainPlotter;
    private IPlotUI plotUI = null;
    private boolean isUpdatePlot = false;
    private Composite parentComp;
    private boolean isBlocking = false;
    private IWorkbenchPage page = null;
    private IActionBars bars;
    private String name;
    private List<IObserver> observers = Collections.synchronizedList(new LinkedList());
    private IGuiInfoManager manager = null;
    private IUpdateNotificationListener notifyListener = null;
    private boolean exclusiveToolars = false;

    public PlotWindow(Composite composite, GuiPlotMode guiPlotMode, IActionBars iActionBars, IWorkbenchPage iWorkbenchPage, String string) {
        this(composite, guiPlotMode, null, null, iActionBars, iWorkbenchPage, string);
    }

    public PlotWindow(Composite composite, GuiPlotMode guiPlotMode, IGuiInfoManager iGuiInfoManager, IUpdateNotificationListener iUpdateNotificationListener, IActionBars iActionBars, IWorkbenchPage iWorkbenchPage, String string) {
        this.manager = iGuiInfoManager;
        this.notifyListener = iUpdateNotificationListener;
        this.parentComp = composite;
        this.page = iWorkbenchPage;
        if (guiPlotMode == null) {
            guiPlotMode = GuiPlotMode.ONED;
        }
        this.mainPlotter = new DataSetPlotter(PlottingMode.ONED, composite, true);
        this.mainPlotter.setAxisModes(AxisMode.LINEAR, AxisMode.LINEAR, AxisMode.LINEAR);
        this.parentComp = composite;
        this.bars = iActionBars;
        this.name = string;
        composite.setLayout((Layout)new FillLayout());
        this.mainPlotter.setXAxisLabel("X-Axis");
        this.mainPlotter.setYAxisLabel("Y-Axis");
        this.mainPlotter.setZAxisLabel("Z-Axis");
        if (guiPlotMode.equals((Object)GuiPlotMode.ONED)) {
            this.setup1D();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.ONED_THREED)) {
            this.setupMulti1DPlot();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.TWOD)) {
            this.setup2D();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SURF2D)) {
            this.setup2DSurface();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SCATTER2D)) {
            this.setupScatter2DPlot();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SCATTER3D)) {
            this.setupScatter3DPlot();
        }
    }

    public IPlotUI getPlotUI() {
        return this.plotUI;
    }

    public void processPlotUpdate(DataBean dataBean) {
        this.doBlock();
        this.plotUI.processPlotUpdate(dataBean, this.isUpdatePlot);
        this.undoBlock();
    }

    private synchronized void doBlock() {
        if (this.isBlocking) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.isBlocking = true;
    }

    private synchronized void undoBlock() {
        this.isBlocking = false;
        this.notifyAll();
    }

    private void removePreviousActions() {
        IContributionItem[] iContributionItemArray = this.bars.getToolBarManager().getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            iContributionItemArray[n].dispose();
            ++n;
        }
        this.bars.getToolBarManager().removeAll();
        this.bars.getMenuManager().removeAll();
        this.bars.getStatusLineManager().removeAll();
    }

    private void cleanUpFromOldMode(boolean bl) {
        this.mainPlotter.unregisterUI(this.plotUI);
        if (this.plotUI != null) {
            this.plotUI.deleteIObservers();
            this.plotUI.deactivate(bl);
            this.removePreviousActions();
        }
    }

    private void setup1D() {
        this.mainPlotter.setMode(PlottingMode.ONED);
        this.plotUI = new Plot1DUIComplete(this, this.manager, this.bars, this.parentComp, this.page, this.name);
        this.bars.updateActionBars();
    }

    private void setup2D() {
        this.mainPlotter.setMode(PlottingMode.TWOD);
        this.plotUI = new Plot2DUI(this, this.mainPlotter, this.manager, this.parentComp, this.page, this.bars, this.name);
        this.bars.updateActionBars();
    }

    private void setup2DSurface() {
        this.mainPlotter.useWindow(true);
        this.mainPlotter.setMode(PlottingMode.SURF2D);
        this.plotUI = new PlotSurf3DUI(this, this.mainPlotter, this.parentComp, this.page, this.bars, this.name);
        this.bars.updateActionBars();
    }

    private void setupMulti1DPlot() {
        this.mainPlotter.setMode(PlottingMode.ONED_THREED);
        this.plotUI = new Plot1DStackUI(this, this.bars, this.mainPlotter, this.parentComp);
        this.bars.updateActionBars();
    }

    private void setupScatter2DPlot() {
        this.mainPlotter.setMode(PlottingMode.SCATTER2D);
        this.plotUI = new PlotScatter2DUI(this, this.bars, this.mainPlotter, this.parentComp);
        this.bars.updateActionBars();
    }

    private void setupScatter3DPlot() {
        this.mainPlotter.setMode(PlottingMode.SCATTER3D);
        this.plotUI = new PlotScatter3DUI(this, this.mainPlotter, this.parentComp, this.page, this.bars, this.name);
        this.bars.updateActionBars();
    }

    public void updatePlotMode(GuiPlotMode guiPlotMode) {
        if (guiPlotMode.equals((Object)GuiPlotMode.ONED) && this.mainPlotter.getMode() != PlottingMode.ONED) {
            this.cleanUpFromOldMode(true);
            this.setup1D();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.ONED_THREED) && this.mainPlotter.getMode() != PlottingMode.ONED_THREED) {
            this.cleanUpFromOldMode(true);
            this.setupMulti1DPlot();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.TWOD) && this.mainPlotter.getMode() != PlottingMode.TWOD) {
            this.cleanUpFromOldMode(true);
            this.setup2D();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SURF2D) && this.mainPlotter.getMode() != PlottingMode.SURF2D) {
            this.cleanUpFromOldMode(true);
            this.setup2DSurface();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SCATTER2D) && this.mainPlotter.getMode() != PlottingMode.SCATTER2D) {
            this.cleanUpFromOldMode(true);
            this.setupScatter2DPlot();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SCATTER3D) && this.mainPlotter.getMode() != PlottingMode.SCATTER3D) {
            this.cleanUpFromOldMode(true);
            this.setupScatter3DPlot();
        }
    }

    private void updatePlotModeAsync(GuiPlotMode guiPlotMode) {
        if (guiPlotMode.equals((Object)GuiPlotMode.ONED) && this.mainPlotter.getMode() != PlottingMode.ONED) {
            this.doBlock();
            this.parentComp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlotWindow.this.cleanUpFromOldMode(true);
                    PlotWindow.this.setup1D();
                    PlotWindow.this.undoBlock();
                }
            });
        } else if (guiPlotMode.equals((Object)GuiPlotMode.ONED_THREED) && this.mainPlotter.getMode() != PlottingMode.ONED_THREED) {
            this.doBlock();
            this.parentComp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlotWindow.this.cleanUpFromOldMode(true);
                    PlotWindow.this.setupMulti1DPlot();
                    PlotWindow.this.undoBlock();
                }
            });
        } else if (guiPlotMode.equals((Object)GuiPlotMode.TWOD) && this.mainPlotter.getMode() != PlottingMode.TWOD) {
            this.doBlock();
            this.parentComp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlotWindow.this.cleanUpFromOldMode(true);
                    PlotWindow.this.setup2D();
                    PlotWindow.this.undoBlock();
                }
            });
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SURF2D) && this.mainPlotter.getMode() != PlottingMode.SURF2D) {
            this.doBlock();
            this.parentComp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlotWindow.this.cleanUpFromOldMode(true);
                    PlotWindow.this.setup2DSurface();
                    PlotWindow.this.undoBlock();
                }
            });
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SCATTER2D) && this.mainPlotter.getMode() != PlottingMode.SCATTER2D) {
            this.doBlock();
            this.parentComp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlotWindow.this.cleanUpFromOldMode(true);
                    PlotWindow.this.setupScatter2DPlot();
                    PlotWindow.this.undoBlock();
                }
            });
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SCATTER3D) && this.mainPlotter.getMode() != PlottingMode.SCATTER3D) {
            this.doBlock();
            this.parentComp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlotWindow.this.cleanUpFromOldMode(true);
                    PlotWindow.this.setupScatter3DPlot();
                    PlotWindow.this.undoBlock();
                }
            });
        }
    }

    public void updatePlotMode(GuiBean guiBean, boolean bl) {
        if (guiBean != null && guiBean.containsKey((Object)GuiParameters.PLOTMODE)) {
            GuiPlotMode guiPlotMode = (GuiPlotMode)guiBean.get((Object)GuiParameters.PLOTMODE);
            if (bl) {
                this.updatePlotModeAsync(guiPlotMode);
            } else {
                this.updatePlotMode(guiPlotMode);
            }
        }
    }

    public void processGUIUpdate(GuiBean guiBean) {
        String string;
        this.isUpdatePlot = false;
        if (guiBean.containsKey((Object)GuiParameters.PLOTMODE)) {
            this.updatePlotMode(guiBean, true);
        }
        if (guiBean.containsKey((Object)GuiParameters.TITLE)) {
            string = (String)guiBean.get((Object)GuiParameters.TITLE);
            this.parentComp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlotWindow.this.doBlock();
                    PlotWindow.this.mainPlotter.setTitle(string);
                    PlotWindow.this.undoBlock();
                    PlotWindow.this.mainPlotter.refresh(true);
                }
            });
        }
        if (guiBean.containsKey((Object)GuiParameters.PLOTOPERATION) && (string = (String)guiBean.get((Object)GuiParameters.PLOTOPERATION)).equals("UPDATE")) {
            this.isUpdatePlot = true;
        }
        if (guiBean.containsKey((Object)GuiParameters.ROIDATA)) {
            this.plotUI.processGUIUpdate(guiBean);
        }
        if (guiBean.containsKey((Object)GuiParameters.ROIDATALIST)) {
            this.plotUI.processGUIUpdate(guiBean);
        }
    }

    public void notifyHistogramChange(HistogramDataUpdate histogramDataUpdate) {
        for (IObserver iObserver : this.observers) {
            iObserver.update((Object)this, (Object)histogramDataUpdate);
        }
    }

    public void update(Object object, Object object2) {
        if (object instanceof HistogramView) {
            HistogramUpdate histogramUpdate = (HistogramUpdate)object2;
            this.mainPlotter.applyColorCast(histogramUpdate.getRedMapFunction(), histogramUpdate.getGreenMapFunction(), histogramUpdate.getBlueMapFunction(), histogramUpdate.getAlphaMapFunction(), histogramUpdate.inverseRed(), histogramUpdate.inverseGreen(), histogramUpdate.inverseBlue(), histogramUpdate.inverseAlpha(), histogramUpdate.getMinValue(), histogramUpdate.getMaxValue());
            this.mainPlotter.refresh(false);
            if (this.plotUI instanceof Plot2DUI) {
                Plot2DUI plot2DUI = (Plot2DUI)this.plotUI;
                plot2DUI.getSidePlotView().sendHistogramUpdate(histogramUpdate);
            }
        }
    }

    public DataSetPlotter getMainPlotter() {
        return this.mainPlotter;
    }

    public void dispose() {
        if (this.plotUI != null) {
            this.plotUI.deactivate(false);
        }
        if (this.mainPlotter != null) {
            this.mainPlotter.cleanUp();
        }
        this.deleteIObservers();
        this.mainPlotter = null;
        this.plotUI = null;
        System.gc();
    }

    public void addIObserver(IObserver iObserver) {
        this.observers.add(iObserver);
    }

    public void deleteIObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
    }

    public void deleteIObservers() {
        this.observers.clear();
    }

    public void notifyUpdateFinished() {
        if (this.notifyListener != null) {
            this.notifyListener.updateProcessed();
        }
    }

    public boolean isExclusiveToolars() {
        return this.exclusiveToolars;
    }

    public void setExclusiveToolars(boolean bl) {
        this.exclusiveToolars = bl;
    }
}

