/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Camera;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.Viewer;
import de.jreality.scene.event.TransformationListener;
import de.jreality.scene.tool.Tool;
import de.jreality.softviewer.PSRenderer;
import de.jreality.softviewer.SVGRenderer;
import de.jreality.softviewer.SoftViewer;
import de.jreality.tools.ClickWheelCameraZoomTool;
import de.jreality.tools.DraggingTool;
import de.jreality.tools.RotateTool;
import de.jreality.ui.viewerapp.AbstractViewerApp;
import de.jreality.ui.viewerapp.ViewerApp;
import de.jreality.ui.viewerapp.ViewerAppSwt;
import de.jreality.ui.viewerapp.actions.file.ExportImage;
import de.jreality.util.CameraUtility;
import de.jreality.util.SceneGraphUtility;
import de.jreality.util.Secure;
import de.jreality.util.SystemProperties;
import gda.analysis.DataSet;
import gda.observable.IObserver;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JPanel;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.diffraction.DetectorProperties;
import uk.ac.diamond.scisoft.analysis.diffraction.DiffractionCrystalEnvironment;
import uk.ac.diamond.scisoft.analysis.diffraction.DiffractionImage;
import uk.ac.diamond.scisoft.analysis.diffraction.QSpace;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.ColourImageData;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.ColourLookupTable;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramChartPlot1D;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.AbstractMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot1D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot1DStack;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot2D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot3D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetScatterPlot2D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetScatterPlot3D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IDataSet3DCorePlot;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IMainPlot;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.InfoBoxComponent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotColorUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.ScaleType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.SurfPlotStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.legend.LegendChangeEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.legend.LegendChangeEventListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.legend.LegendComponent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.legend.LegendTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.SurfacePlotROI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.CameraRotationTool;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.ClickWheelZoomTool;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PanningTool;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEventListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.SceneDragTool;
import uk.ac.gda.common.rcp.util.GridUtils;

public class DataSetPlotter
extends JPanel
implements ComponentListener,
IObserver,
Listener,
PaintListener,
LegendChangeEventListener,
PlotActionEventListener,
IMainPlot {
    private SceneGraphComponent root = null;
    private SceneGraphComponent graph = null;
    private SceneGraphComponent coordAxes = null;
    private SceneGraphComponent bbox = null;
    private SceneGraphComponent coordTicks = null;
    private SceneGraphComponent coordXLabels = null;
    private SceneGraphComponent coordYLabels = null;
    private SceneGraphComponent coordZLabels = null;
    private SceneGraphComponent coordGrid = null;
    private SceneGraphComponent toolNode = null;
    private SceneGraphComponent cameraNode = null;
    private IDataSet3DCorePlot plotter = null;
    private int maxDataSingleDim = 256;
    private int maxDataTotalDim = this.maxDataSingleDim * this.maxDataSingleDim;
    private boolean hasJOGL = false;
    private AbstractViewerApp viewerApp = null;
    private PanningTool panTool = null;
    private SceneDragTool dragTool = null;
    private ClickWheelCameraZoomTool cameraZoomTool = null;
    private ClickWheelZoomTool zoomTool = null;
    private CameraRotationTool cameraRotateTool = null;
    private PlottingMode currentMode = PlottingMode.SURF2D;
    private List<IDataset> currentDataSets = Collections.synchronizedList(new LinkedList());
    private Plot1DGraphTable graphColourTable;
    private Cursor defaultCursor = null;
    private LegendComponent legendTable = null;
    private InfoBoxComponent infoBox = null;
    private Composite container = null;
    private Composite plotArea = null;
    IDataset currentDataSet = null;
    private boolean useWindow = false;
    private boolean hasData = false;
    private boolean xGridActive = true;
    private boolean yGridActive = true;
    private boolean zGridActive = true;
    private double perspFOV = 56.5;
    private double orthoFOV = 140.0;
    private int historyCounter = 0;
    String xAxisLabel = "";
    String yAxisLabel = "";
    String zAxisLabel = "";
    private boolean useLegend = true;
    private boolean isInExporting = false;
    private QSpace qSpace = null;
    private static final String RENDER_PROPERTY_STRING = "uk.ac.diamond.analysis.rcp.plotting.useSoftware";
    private static final String ERROR_MESG = "DataSet contains either NaNs or Infs can not plot";
    private static final Logger logger = LoggerFactory.getLogger(DataSetPlotter.class);
    private AbstractMapFunction cacheRedFunc;
    private AbstractMapFunction cacheGreenFunc;
    private AbstractMapFunction cacheBlueFunc;
    private AbstractMapFunction cacheAlphaFunc;
    private boolean cacheInverseRed;
    private boolean cacheInverseGreen;
    private boolean cacheInverseBlue;
    private boolean cacheInverseAlpha;
    private double cacheMinValue;
    private double cacheMaxValue;
    public static final double HANDNESS = 1.0;
    private boolean isZoomEnabled = false;
    public static final String[] FILE_TYPES = new String[]{"PNG File", "Postscript File", "SVG File"};

    private void removeInitialTools() {
        Tool tool2;
        List list = this.viewerApp.getSceneRoot().getChildComponents();
        List list2 = this.viewerApp.getSceneRoot().getTools();
        for (Tool tool2 : list2) {
            if (!(tool2 instanceof ClickWheelCameraZoomTool)) continue;
            this.cameraZoomTool = (ClickWheelCameraZoomTool)tool2;
        }
        tool2 = null;
        Tool tool3 = null;
        for (SceneGraphComponent sceneGraphComponent : list) {
            List list3 = sceneGraphComponent.getTools();
            for (Tool tool4 : list3) {
                if (tool4 instanceof RotateTool) {
                    this.cameraNode = sceneGraphComponent;
                    tool2 = tool4;
                }
                if (!(tool4 instanceof DraggingTool)) continue;
                this.toolNode = sceneGraphComponent;
                tool3 = tool4;
            }
        }
        if (this.toolNode != null && tool3 != null) {
            this.toolNode.removeTool(tool3);
            this.cameraNode.removeTool(tool2);
            this.panTool = new PanningTool(this.toolNode);
            this.cameraRotateTool = new CameraRotationTool();
            this.dragTool = new SceneDragTool();
            this.toolNode.addTool((Tool)this.panTool);
        }
        this.zoomTool = new ClickWheelZoomTool(this.root, this.toolNode);
    }

    private void init(Composite composite) {
        this.graphColourTable = new Plot1DGraphTable();
        Secure.setProperty((String)"de.jreality.ui.viewerapp.autoRender", (String)"false");
        this.root = SceneGraphUtility.createFullSceneGraphComponent((String)"world");
        this.graph = SceneGraphUtility.createFullSceneGraphComponent((String)"graph");
        this.coordAxes = SceneGraphUtility.createFullSceneGraphComponent((String)"axis");
        this.coordXLabels = SceneGraphUtility.createFullSceneGraphComponent((String)"xLabels");
        this.coordYLabels = SceneGraphUtility.createFullSceneGraphComponent((String)"yLabels");
        this.coordZLabels = SceneGraphUtility.createFullSceneGraphComponent((String)"zLabels");
        this.root.addChild(this.coordAxes);
        this.root.addChild(this.coordXLabels);
        this.root.addChild(this.coordYLabels);
        this.root.addChild(this.coordZLabels);
        this.root.addChild(this.graph);
        this.hasJOGL = true;
        String string = System.getProperty(RENDER_PROPERTY_STRING);
        if (string != null && string.toLowerCase().equals("true")) {
            logger.warn("Force software render");
            this.hasJOGL = false;
        } else {
            String string2 = Secure.getProperty((String)SystemProperties.VIEWER, (String)"de.jreality.jogl.ViewerAwt");
            try {
                Class.forName(string2).newInstance();
                GLData gLData = new GLData();
                gLData.doubleBuffer = true;
                gLData.depthSize = 24;
                gLData.redSize = 8;
                gLData.greenSize = 8;
                gLData.blueSize = 8;
                gLData.alphaSize = 8;
                GLCanvas gLCanvas = new GLCanvas(composite, 262144, gLData);
                gLCanvas.dispose();
            }
            catch (Exception exception) {
                logger.warn("No JOGL using software render");
                this.hasJOGL = false;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                logger.warn("No class found for JOGL hardware acceleration");
                this.hasJOGL = false;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                logger.warn("JOGL linking error");
                this.hasJOGL = false;
            }
        }
        this.hasData = false;
    }

    public void setUseLegend(boolean bl) {
        this.useLegend = bl;
        if (this.useLegend) {
            if (this.legendTable == null) {
                this.buildLegendTable();
            }
            GridUtils.setVisibleAndLayout((Control)this.legendTable, (boolean)true);
            this.legendTable.updateTable(this.graphColourTable);
        } else if (this.legendTable != null) {
            GridUtils.setVisibleAndLayout((Control)this.legendTable, (boolean)false);
        }
        this.legendTable.getParent().layout();
    }

    private void buildLegendTable() {
        if (this.legendTable == null || this.legendTable.isDisposed()) {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.heightHint = 75;
            this.legendTable = new LegendTable(this.container, 0x20000000);
            this.legendTable.setLayoutData(gridData);
        }
        this.legendTable.addIObserver(this);
        this.legendTable.addLegendChangeEventListener(this);
    }

    private void buildInfoBox() {
        if (this.infoBox == null || this.infoBox.isDisposed()) {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.heightHint = 55;
            this.infoBox = new InfoBoxComponent(this.container, 0x20000000);
            this.infoBox.setLayoutData(gridData);
        }
    }

    public Composite getComposite() {
        return this.container;
    }

    private Composite createSWTGUI(Composite composite) {
        this.container = new Composite(composite, 0);
        this.container.addPaintListener((PaintListener)this);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        this.container.setLayout((Layout)gridLayout);
        this.plotArea = this.hasJOGL ? new Composite(this.container, 0x20000000) : new Composite(this.container, 0x1000000);
        this.defaultCursor = this.plotArea.getCursor();
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.plotArea.setLayoutData((Object)gridData);
        if (this.hasJOGL) {
            this.plotArea.setLayout((Layout)new FillLayout());
            this.plotArea.addListener(11, (Listener)this);
            this.viewerApp = new ViewerAppSwt((SceneGraphNode)this.root, this.plotArea);
        } else {
            this.viewerApp = new ViewerApp((SceneGraphNode)this.root, true);
            BoxLayout boxLayout = new BoxLayout(this, 1);
            this.setLayout(boxLayout);
            Component component = ((ViewerApp)this.viewerApp).getContent();
            this.add(component);
            component.addComponentListener(this);
            Frame frame = SWT_AWT.new_Frame((Composite)this.plotArea);
            JApplet jApplet = new JApplet();
            frame.add(jApplet);
            jApplet.add(this);
        }
        this.viewerApp.setBackgroundColor(new Color[]{Color.white});
        if (this.useLegend) {
            this.buildLegendTable();
        }
        this.removeInitialTools();
        return this.container;
    }

    public DataSetPlotter(PlottingMode plottingMode, Composite composite) {
        this(plottingMode, composite, true);
    }

    public DataSetPlotter(PlottingMode plottingMode, Composite composite, boolean bl) {
        this.useLegend = bl;
        this.currentMode = plottingMode;
        this.init(composite);
        this.createSWTGUI(composite);
        this.setInitPlotMode();
    }

    public DataSetPlotter(PlottingMode plottingMode, Composite composite, LegendComponent legendComponent) {
        this.useLegend = true;
        this.legendTable = legendComponent;
        this.legendTable.addLegendChangeEventListener(this);
        this.currentMode = plottingMode;
        this.init(composite);
        this.createSWTGUI(composite);
        this.setInitPlotMode();
    }

    private void setInitPlotMode() {
        switch (this.currentMode) {
            case ONED: {
                this.plotter = new DataSet3DPlot1D(this.viewerApp, this.plotArea, this.defaultCursor, this.graphColourTable, this.hasJOGL);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.toolNode.removeTool((Tool)this.panTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.cameraZoomTool);
                break;
            }
            case ONED_THREED: {
                this.plotter = new DataSet3DPlot1DStack(this.viewerApp, this.plotArea, this.defaultCursor, this.graphColourTable, this.hasJOGL);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.plotter.buildZCoordLabeling(this.coordZLabels);
                break;
            }
            case SCATTER2D: {
                this.plotter = new DataSetScatterPlot2D(this.viewerApp, this.plotArea, this.defaultCursor, this.graphColourTable, this.hasJOGL);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.toolNode.removeTool((Tool)this.panTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.cameraZoomTool);
                break;
            }
            case TWOD: {
                this.plotter = new DataSet3DPlot2D(this.viewerApp, this.plotArea, this.defaultCursor, this.panTool, this.hasJOGL);
                this.coordTicks = this.plotter.buildCoordAxesTicks();
                this.root.addChild(this.coordTicks);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                break;
            }
            case MULTI2D: {
                break;
            }
            case SURF2D: {
                this.plotter = new DataSet3DPlot3D(this.viewerApp, this.hasJOGL, this.useWindow);
                this.coordTicks = this.plotter.buildCoordAxesTicks();
                this.root.addChild(this.coordTicks);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.plotter.buildZCoordLabeling(this.coordZLabels);
                this.toolNode.addTool((Tool)this.dragTool);
                this.cameraNode.addTool((Tool)this.cameraRotateTool);
                break;
            }
            case SCATTER3D: {
                this.plotter = new DataSetScatterPlot3D(this.viewerApp, this.hasJOGL, this.useWindow);
                this.coordTicks = this.plotter.buildCoordAxesTicks();
                this.root.addChild(this.coordTicks);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.plotter.buildZCoordLabeling(this.coordZLabels);
                this.toolNode.addTool((Tool)this.dragTool);
                this.cameraNode.addTool((Tool)this.cameraRotateTool);
                break;
            }
            case BARCHART: {
                this.toolNode.removeTool((Tool)this.panTool);
                this.toolNode.removeTool((Tool)this.dragTool);
                this.cameraNode.removeTool((Tool)this.cameraRotateTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.zoomTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.cameraZoomTool);
                this.plotter = new HistogramChartPlot1D(this.viewerApp, this.graphColourTable, this.hasJOGL);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
            }
        }
    }

    public int getMaximumSingleDimension() {
        return this.maxDataSingleDim;
    }

    public int getMaximumTotalDimension() {
        return this.maxDataTotalDim;
    }

    private void removeOldSceneNodes() {
        if (this.bbox != null) {
            this.root.removeChild(this.bbox);
            this.bbox = null;
        }
        if (this.coordTicks != null) {
            this.root.removeChild(this.coordTicks);
            this.coordTicks = null;
        }
        if (this.coordGrid != null) {
            this.root.removeChild(this.coordGrid);
            this.coordGrid = null;
        }
        if (this.currentMode == PlottingMode.TWOD && this.root.getTransformation() != null) {
            this.root.getTransformation().removeTransformationListener((TransformationListener)((DataSet3DPlot2D)this.plotter));
        }
        this.graph.setGeometry(null);
        this.plotter.cleanUpGraphNode();
        System.gc();
    }

    public void applyColorCast(AbstractMapFunction abstractMapFunction, AbstractMapFunction abstractMapFunction2, AbstractMapFunction abstractMapFunction3, AbstractMapFunction abstractMapFunction4, boolean bl, boolean bl2, boolean bl3, boolean bl4, double d, double d2) {
        if (this.currentDataSets.size() > 0 && this.graph != null) {
            ColourImageData colourImageData = null;
            if (this.hasJOGL || this.currentMode == PlottingMode.SCATTER3D) {
                colourImageData = ColourLookupTable.generateColourLookupTable(abstractMapFunction, abstractMapFunction2, abstractMapFunction3, abstractMapFunction4, bl, bl2, bl3, bl4);
            } else {
                this.cacheRedFunc = abstractMapFunction;
                this.cacheGreenFunc = abstractMapFunction2;
                this.cacheBlueFunc = abstractMapFunction3;
                this.cacheAlphaFunc = abstractMapFunction4;
                this.cacheInverseAlpha = bl4;
                this.cacheInverseRed = bl;
                this.cacheInverseGreen = bl2;
                this.cacheInverseBlue = bl3;
                this.cacheMinValue = d;
                this.cacheMaxValue = d2;
                colourImageData = this.currentMode != PlottingMode.BARCHART ? ColourLookupTable.generateColourTable(this.currentDataSets.get(0), abstractMapFunction, abstractMapFunction2, abstractMapFunction3, abstractMapFunction4, bl, bl2, bl3, bl4, d, d2, this.plotter.getScaling() != ScaleType.LINEAR) : ColourLookupTable.generateColourLookupTable(abstractMapFunction, abstractMapFunction2, abstractMapFunction3, abstractMapFunction4, bl, bl2, bl3, bl4);
            }
            this.plotter.handleColourCast(colourImageData, this.graph, d, d2);
        }
    }

    public void setPlot(IDataset iDataset) {
        if (this.currentDataSet != null) {
            this.currentDataSets.remove(0);
            this.currentDataSets.add(0, iDataset);
            this.plotter.updateGraph(iDataset);
        } else {
            this.currentDataSets.add(iDataset);
            this.graph = this.plotter.buildGraph(this.currentDataSets, this.graph);
            this.coordAxes = this.plotter.buildCoordAxis(this.coordAxes);
            this.hasData = true;
            this.plotter.setXAxisLabel(this.xAxisLabel);
            this.plotter.setYAxisLabel(this.yAxisLabel);
        }
    }

    @Deprecated
    public void addPlot(IDataset ... iDatasetArray) {
        if (this.currentMode == PlottingMode.SURF2D) {
            logger.info("Plot3D is currently in 2D mode but 1D plot has been added switching to Multi 1D");
            this.currentDataSets.clear();
            int n = 0;
            while (n < iDatasetArray.length) {
                this.currentDataSets.add(iDatasetArray[n]);
                ++n;
            }
            if (iDatasetArray.length > 1) {
                this.setMode(PlottingMode.ONED_THREED);
            } else {
                this.setMode(PlottingMode.ONED);
                this.currentDataSet = iDatasetArray[0];
            }
        } else {
            int n = 0;
            while (n < iDatasetArray.length) {
                this.currentDataSets.add(iDatasetArray[n]);
                ++n;
            }
            this.checkAndAddLegend(this.currentDataSets);
            if (this.currentDataSet == null) {
                this.graph = this.plotter.buildGraph(this.currentDataSets, this.graph);
                this.coordAxes = this.plotter.buildCoordAxis(this.coordAxes);
                this.hasData = true;
                this.plotter.setXAxisLabel(this.xAxisLabel);
                this.plotter.setYAxisLabel(this.yAxisLabel);
                this.currentDataSet = iDatasetArray[0];
            } else {
                this.plotter.updateGraph(this.currentDataSets);
            }
        }
    }

    public void addToCurrentPlot(double[] dArray) throws PlotException {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            ((DataSet3DPlot1D)this.plotter).addDataPoints(dArray);
        }
    }

    public void addToCurrentPlots(List<double[]> list) throws PlotException {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            ((DataSet3DPlot1D)this.plotter).addDataPoints(list);
        }
    }

    public void addToCurrentPlot(double[] dArray, double[] dArray2) throws PlotException {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            if (dArray.length != dArray2.length) {
                throw new PlotException("Length of values doesn't match length of axisValues");
            }
            ((DataSet3DPlot1D)this.plotter).addDataPoints(dArray, dArray2);
        }
    }

    public void addToCurrentPlot(IDataset iDataset, AxisValues axisValues, AxisValues axisValues2) throws PlotException {
        if (this.currentMode == PlottingMode.SCATTER2D) {
            if (this.currentDataSets.size() == 0) {
                throw new PlotException("There is no data in the scatter plot so far");
            }
            this.currentDataSets.add(iDataset);
            this.checkAndAddLegend(this.currentDataSets);
            if (iDataset.getSize() != axisValues.size()) {
                throw new PlotException("Length of values doesn't match length of axisValues");
            }
            ((DataSetScatterPlot2D)this.plotter).addAxises(axisValues, axisValues2);
            this.plotter.updateGraph(this.currentDataSets);
        }
    }

    public void addToCurrentPlots(List<double[]> list, List<double[]> list2) throws PlotException {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            if (list.size() != list2.size()) {
                throw new PlotException("Lenght of value list doesn't match length of axis value list");
            }
            ((DataSet3DPlot1D)this.plotter).addDataPoints(list, list2);
        }
    }

    public void setXAxisLabel(String string) {
        this.xAxisLabel = string;
        if (this.hasData) {
            this.plotter.setXAxisLabel(this.xAxisLabel);
        }
    }

    public void setYAxisLabel(String string) {
        this.yAxisLabel = string;
        if (this.hasData) {
            this.plotter.setYAxisLabel(this.yAxisLabel);
        }
    }

    public void setZAxisLabel(String string) {
        this.zAxisLabel = string;
        if (this.hasData) {
            this.plotter.setZAxisLabel(this.zAxisLabel);
        }
    }

    public void replaceAllPlots(List<IDataset> list, List<AxisValues> list2) throws PlotException {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            if (list.size() > list2.size()) {
                throw new PlotException("Number of DataSets is larger than Axis values");
            }
            ((DataSet3DPlot1D)this.plotter).setXAxisValues(list2, this.historyCounter);
            this.replaceAllPlots(list);
        }
    }

    private void checkAndAddLegend(Collection<? extends IDataset> collection) {
        if ((this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.SCATTER2D) && collection != null && collection.size() > this.graphColourTable.getLegendSize()) {
            logger.info("# graphs > # of entries in the legend will auto add entries");
            int n = this.graphColourTable.getLegendSize();
            while (n < collection.size()) {
                this.graphColourTable.addEntryOnLegend(new Plot1DAppearance(PlotColorUtility.getDefaultColour(n), PlotColorUtility.getDefaultStyle(n), ""));
                ++n;
            }
        }
    }

    private boolean checkForNan(IDataset iDataset) {
        if (iDataset instanceof DataSet) {
            return ((DataSet)iDataset).containsNans();
        }
        if (iDataset instanceof AbstractDataset) {
            return ((AbstractDataset)iDataset).containsNans();
        }
        int n = 0;
        while (n < iDataset.getShape()[0]) {
            if (!Double.isNaN(iDataset.getDouble(new int[]{n++}))) continue;
            return true;
        }
        return false;
    }

    private boolean checkForInf(IDataset iDataset) {
        if (iDataset instanceof DataSet) {
            return ((DataSet)iDataset).containsInfs();
        }
        if (iDataset instanceof AbstractDataset) {
            return ((AbstractDataset)iDataset).containsInfs();
        }
        int n = 0;
        while (n < iDataset.getShape()[0]) {
            if (!Double.isInfinite(iDataset.getDouble(new int[]{n++}))) continue;
            return true;
        }
        return false;
    }

    private void sanityCheckDataSets(Collection<? extends IDataset> collection) throws PlotException {
        for (IDataset iDataset : collection) {
            if (!this.checkForNan(iDataset) && !this.checkForInf(iDataset)) continue;
            throw new PlotException(ERROR_MESG);
        }
    }

    public void replaceAllPlots(Collection<? extends IDataset> collection) throws PlotException {
        this.checkAndAddLegend(collection);
        this.sanityCheckDataSets(collection);
        if (this.currentDataSets.size() > 0) {
            int n;
            int n2 = this.currentDataSets.size() - this.historyCounter;
            if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.SCATTER2D) {
                if (n2 > collection.size()) {
                    n = 0;
                    while (n < n2 - collection.size()) {
                        ((DataSet3DPlot1D)this.plotter).removeLastGraphNode();
                        ++n;
                    }
                }
                if (n2 < collection.size()) {
                    n = 0;
                    while (n < collection.size() - n2) {
                        ((DataSet3DPlot1D)this.plotter).addGraphNode();
                        ++n;
                    }
                }
            }
            n = this.currentDataSets.size() - (this.historyCounter + 1);
            while (n >= 0) {
                this.currentDataSets.remove(n);
                --n;
            }
            this.currentDataSets.addAll(0, collection);
            this.plotter.updateGraph(this.currentDataSets);
        } else {
            this.currentDataSets.addAll(collection);
            this.graph = this.plotter.buildGraph(this.currentDataSets, this.graph);
            this.coordAxes = this.plotter.buildCoordAxis(this.coordAxes);
            this.hasData = true;
            this.plotter.setXAxisLabel(this.xAxisLabel);
            this.plotter.setYAxisLabel(this.yAxisLabel);
            this.plotter.setZAxisLabel(this.zAxisLabel);
        }
        if (this.currentMode == PlottingMode.SURF2D || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER3D) {
            this.root.removeChild(this.bbox);
            this.bbox = this.plotter.buildBoundingBox();
            this.root.addChild(this.bbox);
        }
        if (this.currentDataSets.size() > 0) {
            this.currentDataSet = this.currentDataSets.get(0);
            this.checkForDiffractionImage(this.currentDataSet);
        }
    }

    public void replaceCurrentPlot(IDataset iDataset) throws PlotException {
        if (this.checkForNan(iDataset) || this.checkForInf(iDataset)) {
            throw new PlotException(ERROR_MESG);
        }
        if (this.currentDataSet != null) {
            this.currentDataSets.remove(0);
            this.currentDataSets.add(0, iDataset);
            this.checkAndAddLegend(this.currentDataSets);
            this.plotter.updateGraph(iDataset);
        } else {
            this.currentDataSets.add(iDataset);
            this.checkAndAddLegend(this.currentDataSets);
            this.graph = this.plotter.buildGraph(this.currentDataSets, this.graph);
            this.coordAxes = this.plotter.buildCoordAxis(this.coordAxes);
            this.hasData = true;
            this.plotter.setXAxisLabel(this.xAxisLabel);
            this.plotter.setYAxisLabel(this.yAxisLabel);
            this.plotter.setZAxisLabel(this.zAxisLabel);
        }
        if (this.currentMode == PlottingMode.SURF2D || this.currentMode == PlottingMode.SCATTER3D) {
            this.root.removeChild(this.bbox);
            this.bbox = this.plotter.buildBoundingBox();
            this.root.addChild(this.bbox);
        }
        this.currentDataSet = iDataset;
        this.checkForDiffractionImage(iDataset);
    }

    public void replaceAPlot(IDataset iDataset, int n) throws PlotException {
        if (this.checkForNan(iDataset) || this.checkForInf(iDataset)) {
            throw new PlotException(ERROR_MESG);
        }
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            if (n < this.currentDataSets.size()) {
                ((DataSet3DPlot1D)this.plotter).updateAGraph(iDataset, n);
            } else {
                throw new PlotException("This plotNumber doesn't exist");
            }
        }
    }

    public void replaceAPlot(IDataset iDataset, AxisValues axisValues, int n) throws PlotException {
        if (this.checkForNan(iDataset) || this.checkForInf(iDataset)) {
            throw new PlotException(ERROR_MESG);
        }
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            if (n < this.currentDataSets.size()) {
                ((DataSet3DPlot1D)this.plotter).replaceXAxisValue(axisValues, n);
                ((DataSet3DPlot1D)this.plotter).updateAGraph(iDataset, n);
            } else {
                throw new PlotException("This plotNumber doesn't exist");
            }
        }
    }

    private void checkForDiffractionImage(IDataset iDataset) {
        if (this.currentMode == PlottingMode.TWOD || this.currentMode == PlottingMode.SURF2D) {
            this.qSpace = null;
            if (iDataset instanceof AbstractDataset) {
                AbstractDataset abstractDataset = (AbstractDataset)iDataset;
                try {
                    DetectorProperties detectorProperties = DiffractionImage.createDetectorProperties((AbstractDataset)abstractDataset);
                    DiffractionCrystalEnvironment diffractionCrystalEnvironment = DiffractionImage.createDiffractionCrystalEnvironment((AbstractDataset)abstractDataset);
                    this.qSpace = new QSpace(detectorProperties, diffractionCrystalEnvironment);
                }
                catch (Exception exception) {
                    logger.info("Could not create a detector properties object from metadata");
                }
            }
        }
    }

    public void setMode(PlottingMode plottingMode) {
        this.currentDataSets.clear();
        this.removeOldSceneNodes();
        if (plottingMode != this.currentMode) {
            this.hasData = false;
        }
        this.currentMode = plottingMode;
        if (this.hasJOGL) {
            this.plotArea.setFocus();
        }
        if (this.legendTable != null) {
            this.legendTable.removeAllLegendChangeEventListener();
            this.legendTable.dispose();
            this.legendTable = null;
        }
        if (this.infoBox != null) {
            this.infoBox.dispose();
            this.infoBox = null;
        }
        switch (this.currentMode) {
            case ONED: {
                this.toolNode.removeTool((Tool)this.panTool);
                this.toolNode.removeTool((Tool)this.dragTool);
                this.cameraNode.removeTool((Tool)this.cameraRotateTool);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.toolNode);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.root);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.zoomTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.cameraZoomTool);
                this.plotter = new DataSet3DPlot1D(this.viewerApp, this.plotArea, this.defaultCursor, this.graphColourTable, this.hasJOGL);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.buildLegendTable();
                this.container.layout();
                this.setPerspectiveCamera(true);
                break;
            }
            case ONED_THREED: {
                this.toolNode.removeTool((Tool)this.panTool);
                this.toolNode.removeTool((Tool)this.dragTool);
                this.cameraNode.removeTool((Tool)this.cameraRotateTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.zoomTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.cameraZoomTool);
                this.plotter = new DataSet3DPlot1DStack(this.viewerApp, this.plotArea, this.defaultCursor, this.graphColourTable, this.hasJOGL);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.plotter.buildZCoordLabeling(this.coordZLabels);
                this.buildLegendTable();
                this.container.layout();
                this.toolNode.addTool((Tool)this.panTool);
                this.cameraNode.addTool((Tool)this.cameraRotateTool);
                this.viewerApp.getSceneRoot().addTool((Tool)this.cameraZoomTool);
                break;
            }
            case SCATTER2D: {
                this.toolNode.removeTool((Tool)this.panTool);
                this.toolNode.removeTool((Tool)this.dragTool);
                this.cameraNode.removeTool((Tool)this.cameraRotateTool);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.toolNode);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.root);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.zoomTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.cameraZoomTool);
                this.plotter = new DataSetScatterPlot2D(this.viewerApp, this.plotArea, this.defaultCursor, this.graphColourTable, this.hasJOGL);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.buildLegendTable();
                this.container.layout();
                this.setPerspectiveCamera(true);
                break;
            }
            case TWOD: {
                this.toolNode.removeTool((Tool)this.panTool);
                this.toolNode.removeTool((Tool)this.dragTool);
                this.cameraNode.removeTool((Tool)this.cameraRotateTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.cameraZoomTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.zoomTool);
                this.plotter = new DataSet3DPlot2D(this.viewerApp, this.plotArea, this.defaultCursor, this.panTool, this.hasJOGL);
                this.root.removeChild(this.coordTicks);
                this.coordTicks = this.plotter.buildCoordAxesTicks();
                this.root.addChild(this.coordTicks);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.plotter.buildZCoordLabeling(this.coordZLabels);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.toolNode);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.root);
                this.toolNode.addTool((Tool)this.panTool);
                this.viewerApp.getSceneRoot().addTool((Tool)this.zoomTool);
                if (this.useLegend) {
                    this.buildInfoBox();
                }
                this.container.layout();
                this.root.getTransformation().addTransformationListener((TransformationListener)((DataSet3DPlot2D)this.plotter));
                this.setPerspectiveCamera(true);
                break;
            }
            case MULTI2D: {
                break;
            }
            case SURF2D: {
                this.toolNode.removeTool((Tool)this.panTool);
                this.toolNode.removeTool((Tool)this.dragTool);
                this.cameraNode.removeTool((Tool)this.cameraRotateTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.zoomTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.cameraZoomTool);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.toolNode);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.root);
                this.plotter = new DataSet3DPlot3D(this.viewerApp, this.hasJOGL, this.useWindow);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.plotter.buildZCoordLabeling(this.coordZLabels);
                this.coordTicks = this.plotter.buildCoordAxesTicks();
                this.root.addChild(this.coordTicks);
                this.plotter.buildCoordAxis(this.coordAxes);
                this.container.layout();
                this.toolNode.addTool((Tool)this.dragTool);
                this.cameraNode.addTool((Tool)this.cameraRotateTool);
                this.viewerApp.getSceneRoot().addTool((Tool)this.cameraZoomTool);
                this.setPerspectiveCamera(true);
                break;
            }
            case SCATTER3D: {
                this.toolNode.removeTool((Tool)this.panTool);
                this.toolNode.removeTool((Tool)this.dragTool);
                this.cameraNode.removeTool((Tool)this.cameraRotateTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.zoomTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.cameraZoomTool);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.toolNode);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.root);
                this.plotter = new DataSetScatterPlot3D(this.viewerApp, this.hasJOGL, this.useWindow);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.plotter.buildZCoordLabeling(this.coordZLabels);
                this.coordTicks = this.plotter.buildCoordAxesTicks();
                this.root.addChild(this.coordTicks);
                this.plotter.buildCoordAxis(this.coordAxes);
                this.container.layout();
                this.toolNode.addTool((Tool)this.dragTool);
                this.cameraNode.addTool((Tool)this.cameraRotateTool);
                this.viewerApp.getSceneRoot().addTool((Tool)this.cameraZoomTool);
                this.setPerspectiveCamera(true);
                break;
            }
            case BARCHART: {
                this.toolNode.removeTool((Tool)this.panTool);
                this.toolNode.removeTool((Tool)this.dragTool);
                this.cameraNode.removeTool((Tool)this.cameraRotateTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.zoomTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.cameraZoomTool);
                this.plotter = new HistogramChartPlot1D(this.viewerApp, this.graphColourTable, this.hasJOGL);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.toolNode);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.root);
                this.toolNode.removeTool((Tool)this.panTool);
                this.toolNode.removeTool((Tool)this.dragTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.cameraZoomTool);
                this.setPerspectiveCamera(true);
            }
        }
    }

    public PlottingMode getMode() {
        return this.currentMode;
    }

    private void cleanUpViewers() {
        Viewer[] viewerArray = this.viewerApp.getViewerSwitch().getViewers();
        int n = 0;
        while (n < viewerArray.length) {
            if (viewerArray[n] instanceof SoftViewer) {
                ((SoftViewer)viewerArray[n]).dispose();
            }
            ++n;
        }
    }

    public void cleanUp() {
        this.removeOldSceneNodes();
        if (this.bbox != null) {
            this.root.removeChild(this.bbox);
        }
        if (this.coordGrid != null) {
            this.root.removeChild(this.coordGrid);
        }
        if (this.coordXLabels != null) {
            this.root.removeChild(this.coordXLabels);
        }
        if (this.coordYLabels != null) {
            this.root.removeChild(this.coordYLabels);
        }
        if (this.coordZLabels != null) {
            this.root.removeChild(this.coordZLabels);
        }
        if (this.coordTicks != null) {
            this.root.removeChild(this.coordTicks);
        }
        this.bbox = null;
        this.coordTicks = null;
        this.coordXLabels = null;
        this.coordYLabels = null;
        this.coordZLabels = null;
        this.coordGrid = null;
        this.root = null;
        this.currentDataSets.clear();
        this.currentDataSet = null;
        this.plotter = null;
        if (this.graphColourTable != null) {
            this.graphColourTable.clearLegend();
        }
        this.graphColourTable = null;
        this.cleanUpViewers();
        try {
            this.viewerApp.dispose();
        }
        catch (Exception exception) {
            logger.debug("oh no", (Throwable)exception);
        }
        if (this.plotArea != null) {
            this.plotArea.dispose();
        }
        if (this.container != null) {
            this.container.dispose();
        }
        if (this.legendTable != null) {
            this.legendTable.removeAllLegendChangeEventListener();
            this.legendTable.dispose();
        }
        if (this.infoBox != null && !this.infoBox.isDisposed()) {
            this.infoBox.dispose();
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.plotter != null) {
            Component component = ((ViewerApp)this.viewerApp).getViewingComponent();
            this.plotter.notifyComponentResize(component.getWidth(), component.getHeight());
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    public void setCurrentGraphColour(int n) {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            ((DataSet3DPlot1D)this.plotter).updateGraphAppearance(n);
            if (this.legendTable != null) {
                this.legendTable.updateTable(this.graphColourTable);
            }
        }
    }

    public void updateAllAppearance() {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.BARCHART) {
            ((DataSet3DPlot1D)this.plotter).updateAllGraphAppearances();
            if (this.legendTable != null) {
                this.legendTable.updateTable(this.graphColourTable);
            }
        }
    }

    public void undoZoom() {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            ((DataSet3DPlot1D)this.plotter).undoZoom();
        } else if (this.currentMode == PlottingMode.BARCHART) {
            ((HistogramChartPlot1D)this.plotter).undoZoom();
        }
    }

    public void resetZoom() {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            ((DataSet3DPlot1D)this.plotter).resetZoom();
        }
    }

    public void pushGraphOntoHistory() {
        if (this.currentMode == PlottingMode.ONED) {
            AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset((IDataset)this.currentDataSets.get(0)).clone();
            this.currentDataSets.add((IDataset)abstractDataset);
            ((DataSet3DPlot1D)this.plotter).addGraphNode();
            ++this.historyCounter;
        }
    }

    public void popGraphFromHistory() {
        if (this.currentMode == PlottingMode.ONED && this.currentDataSets.size() > 1) {
            ((DataSet3DPlot1D)this.plotter).removeLastGraphNode();
            this.currentDataSets.remove(this.currentDataSets.size() - 1);
            --this.historyCounter;
            if (this.useLegend) {
                this.legendTable.updateTable(this.graphColourTable);
            }
        }
    }

    public int getNumHistory() {
        return this.historyCounter;
    }

    public void setAxisModes(AxisMode axisMode, AxisMode axisMode2, AxisMode axisMode3) {
        this.plotter.setAxisModes(axisMode, axisMode2, axisMode3);
    }

    public void setAxisOffset(double d, double d2, double d3) {
        if (this.plotter != null) {
            this.plotter.setXAxisOffset(d);
            this.plotter.setYAxisOffset(d2);
            this.plotter.setZAxisOffset(d3);
        }
    }

    public void setXAxisValues(AxisValues axisValues, int n) {
        if (this.plotter != null) {
            this.plotter.setXAxisValues(axisValues, n);
        }
    }

    public void setYAxisValues(AxisValues axisValues) {
        if (this.plotter != null) {
            this.plotter.setYAxisValues(axisValues);
        }
    }

    public void setZAxisValues(AxisValues axisValues) {
        if (this.plotter != null) {
            this.plotter.setZAxisValues(axisValues);
        }
    }

    public synchronized void refresh(boolean bl) {
        if (!this.isInExporting && this.viewerApp != null) {
            if (!bl) {
                this.viewerApp.getCurrentViewer().render();
            } else {
                this.viewerApp.getCurrentViewer().renderAsync();
            }
        }
        if ((this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER2D) && this.legendTable != null) {
            this.legendTable.updateTable(this.graphColourTable);
        }
    }

    public Plot1DGraphTable getColourTable() {
        return this.graphColourTable;
    }

    public void registerUI(IPlotUI iPlotUI) {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER2D) {
            ((DataSet3DPlot1D)this.plotter).addPlotActionEventListener(iPlotUI);
        } else if (this.currentMode == PlottingMode.TWOD) {
            ((DataSet3DPlot2D)this.plotter).addPlotActionEventListener(this);
        } else if (this.currentMode == PlottingMode.BARCHART) {
            ((HistogramChartPlot1D)this.plotter).addAreaSelectEventListener(iPlotUI);
        }
    }

    public void unregisterUI(IPlotUI iPlotUI) {
        iPlotUI.disposeOverlays();
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            ((DataSet3DPlot1D)this.plotter).removePlotActionEventListener(iPlotUI);
        } else if (this.currentMode == PlottingMode.TWOD) {
            ((DataSet3DPlot2D)this.plotter).removePlotActionEventListener(this);
        } else if (this.currentMode == PlottingMode.BARCHART) {
            ((HistogramChartPlot1D)this.plotter).removeAreaSelectEventListener(iPlotUI);
        }
    }

    public void registerOverlay(OverlayConsumer overlayConsumer) {
        switch (this.currentMode) {
            case ONED: {
                ((DataSet3DPlot1D)this.plotter).registerOverlay((Overlay1DConsumer)overlayConsumer);
                break;
            }
            case TWOD: {
                ((DataSet3DPlot2D)this.plotter).registerOverlay((Overlay2DConsumer)overlayConsumer);
                break;
            }
            case ONED_THREED: {
                break;
            }
            case SCATTER2D: {
                break;
            }
            case SURF2D: {
                break;
            }
            case SCATTER3D: {
                break;
            }
            case BARCHART: {
                ((DataSet3DPlot1D)this.plotter).registerOverlay((Overlay1DConsumer)overlayConsumer);
                break;
            }
        }
    }

    public void unRegisterOverlay(OverlayConsumer overlayConsumer) {
        switch (this.currentMode) {
            case ONED: {
                ((DataSet3DPlot1D)this.plotter).unRegisterOverlay((Overlay1DConsumer)overlayConsumer);
                break;
            }
            case TWOD: {
                ((DataSet3DPlot2D)this.plotter).unRegisterOverlay((Overlay2DConsumer)overlayConsumer);
                break;
            }
            case ONED_THREED: {
                break;
            }
            case SCATTER2D: {
                break;
            }
            case SURF2D: {
                break;
            }
            case SCATTER3D: {
                break;
            }
            case BARCHART: {
                break;
            }
        }
    }

    public void setZoomEnabled(boolean bl) {
        this.isZoomEnabled = bl;
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.BARCHART) {
            ((DataSet3DPlot1D)this.plotter).enableZoomTool(bl);
        }
    }

    public boolean isZoomEnabled() {
        return this.isZoomEnabled;
    }

    public void setZoomMode(boolean bl) {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.BARCHART || this.currentMode == PlottingMode.ONED_THREED) {
            ((DataSet3DPlot1D)this.plotter).setZoomMode(bl);
        }
    }

    public void setPlotActionEnabled(boolean bl) {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER2D) {
            ((DataSet3DPlot1D)this.plotter).enablePlotActionTool(bl);
        } else if (this.currentMode == PlottingMode.TWOD) {
            ((DataSet3DPlot2D)this.plotter).enablePlotActionTool(bl);
        }
    }

    public void setPlotRightClickActionEnabled(boolean bl) {
        if (this.currentMode == PlottingMode.ONED) {
            ((DataSet3DPlot1D)this.plotter).enableRightClickActionTool(bl);
        }
    }

    public void setXTickLabelFormat(TickFormatting tickFormatting) {
        this.plotter.setXAxisLabelMode(tickFormatting);
    }

    public void setYTickLabelFormat(TickFormatting tickFormatting) {
        this.plotter.setYAxisLabelMode(tickFormatting);
    }

    public void setZTickLabelFormat(TickFormatting tickFormatting) {
        this.plotter.setZAxisLabelMode(tickFormatting);
    }

    public void setTitle(String string) {
        this.plotter.setTitle(string);
    }

    public void setTickGridLines(boolean bl, boolean bl2, boolean bl3) {
        this.xGridActive = bl;
        this.yGridActive = bl2;
        this.zGridActive = bl3;
        this.plotter.setTickGridLinesActive(bl, bl2, bl3);
    }

    public boolean getXGridActive() {
        return this.xGridActive;
    }

    public boolean getYGridActive() {
        return this.yGridActive;
    }

    public boolean getZGridActive() {
        return this.zGridActive;
    }

    public void useWindow(boolean bl) {
        this.useWindow = bl;
    }

    @Override
    public IDataset getCurrentDataSet() {
        return this.currentDataSet;
    }

    @Override
    public List<IDataset> getCurrentDataSets() {
        return this.currentDataSets;
    }

    public void enableBoundingBox(boolean bl) {
        if (this.currentMode == PlottingMode.SURF2D || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER3D) {
            if (bl) {
                this.bbox = this.plotter.buildBoundingBox();
                this.root.addChild(this.bbox);
            } else {
                this.root.removeChild(this.bbox);
            }
        }
    }

    public void setPlot2DSurfStyle(SurfPlotStyles surfPlotStyles) {
        if (this.currentMode == PlottingMode.SURF2D) {
            ((DataSet3DPlot3D)this.plotter).setStyle(surfPlotStyles);
        }
    }

    public void resetView() {
        MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.toolNode);
        MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.root);
        if (this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SURF2D) {
            Camera camera = CameraUtility.getCamera((Viewer)this.viewerApp.getCurrentViewer());
            if (camera.isPerspective()) {
                camera.setFieldOfView(56.5);
            } else {
                camera.setFieldOfView(140.0);
            }
        }
        this.plotter.resetView();
    }

    private void savePostScript(File file) {
        Dimension dimension = this.viewerApp.getCurrentViewer().getViewingComponentSize();
        try {
            PSRenderer pSRenderer = new PSRenderer(new PrintWriter(file), dimension.width, dimension.height);
            pSRenderer.setCameraPath(this.viewerApp.getCurrentViewer().getCameraPath());
            pSRenderer.setSceneRoot(this.viewerApp.getCurrentViewer().getSceneRoot());
            pSRenderer.setAuxiliaryRoot(this.viewerApp.getCurrentViewer().getAuxiliaryRoot());
            pSRenderer.render();
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.warn("File " + file.getAbsolutePath() + " could not be found ");
        }
    }

    private void saveSVG(File file) {
        Dimension dimension = this.viewerApp.getCurrentViewer().getViewingComponentSize();
        try {
            SVGRenderer sVGRenderer = new SVGRenderer(new PrintWriter(file), dimension.width, dimension.height);
            sVGRenderer.setCameraPath(this.viewerApp.getCurrentViewer().getCameraPath());
            sVGRenderer.setSceneRoot(this.viewerApp.getCurrentViewer().getSceneRoot());
            sVGRenderer.setAuxiliaryRoot(this.viewerApp.getCurrentViewer().getAuxiliaryRoot());
            sVGRenderer.render();
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.warn("File " + file.getAbsolutePath() + " could not be found ");
        }
    }

    public synchronized void saveGraph(String string, String string2) {
        if (!Arrays.asList(FILE_TYPES).contains(string2)) {
            throw new RuntimeException("Cannot deal with file type " + string2);
        }
        this.isInExporting = true;
        if (string.toLowerCase().endsWith(".png")) {
            string2 = FILE_TYPES[0];
        }
        if (string.toLowerCase().endsWith(".ps") || string.toLowerCase().endsWith(".eps")) {
            string2 = FILE_TYPES[1];
        }
        if (string.toLowerCase().endsWith(".svg")) {
            string2 = FILE_TYPES[2];
        }
        if (string2.equals(FILE_TYPES[0])) {
            if (!string.toLowerCase().endsWith(".png")) {
                string = String.valueOf(string) + ".png";
            }
            ExportImage.exportImage((Viewer)this.viewerApp.getCurrentViewer(), (File)new File(string), (int)1);
        } else if (string2.equals(FILE_TYPES[1])) {
            if (!string.toLowerCase().endsWith(".ps") && !string.toLowerCase().endsWith(".eps")) {
                string = String.valueOf(string) + ".ps";
            }
            this.savePostScript(new File(string));
        } else if (string2.equals(FILE_TYPES[2])) {
            if (!string.toLowerCase().endsWith(".svg")) {
                string = String.valueOf(string) + ".svg";
            }
            this.saveSVG(new File(string));
        } else {
            throw new RuntimeException("Cannot process " + string2);
        }
        this.isInExporting = false;
    }

    public synchronized void printGraph(PrinterData printerData) {
        if (printerData != null) {
            this.isInExporting = true;
            File file = null;
            try {
                file = File.createTempFile("test", ".png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (file != null) {
                ExportImage.exportImage((Viewer)this.viewerApp.getCurrentViewer(), (File)file, (int)4);
                ImageLoader imageLoader = new ImageLoader();
                ImageData[] imageDataArray = imageLoader.load(file.getAbsolutePath());
                if (imageDataArray[0].width > (int)((float)imageDataArray[0].height * 1.125f)) {
                    printerData.orientation = 2;
                }
                Printer printer = new Printer(printerData);
                Rectangle rectangle = printer.computeTrim(0, 0, 0, 0);
                Rectangle rectangle2 = printer.getClientArea();
                if (printer.startJob("Graph print")) {
                    if (printer.startPage()) {
                        GC gC = new GC((Drawable)printer);
                        Image image = new Image((Device)printer, imageDataArray[0]);
                        gC.drawImage(image, 0, 0, imageDataArray[0].width, imageDataArray[0].height, -rectangle.x, -rectangle.y, rectangle2.width, rectangle2.height);
                        image.dispose();
                        gC.dispose();
                        printer.endPage();
                    }
                    printer.endJob();
                    printer.dispose();
                }
                file.delete();
                this.isInExporting = false;
            }
        }
    }

    public void update(Object object, Object object2) {
        if (object.equals((Object)this.legendTable) && (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER2D)) {
            ((DataSet3DPlot1D)this.plotter).updateAllGraphAppearances();
            this.viewerApp.getCurrentViewer().render();
        }
    }

    public void setPerspectiveCamera(boolean bl) {
        Camera camera = CameraUtility.getCamera((Viewer)this.viewerApp.getCurrentViewer());
        if (camera.isPerspective()) {
            this.perspFOV = camera.getFieldOfView();
        } else {
            this.orthoFOV = camera.getFieldOfView();
        }
        camera.setPerspective(bl);
        if (bl) {
            camera.setFieldOfView(this.perspFOV);
        } else {
            camera.setFieldOfView(this.orthoFOV);
        }
        this.viewerApp.getCurrentViewer().render();
    }

    public void clearZoomHistory() {
        if (this.currentMode == PlottingMode.BARCHART) {
            ((HistogramChartPlot1D)this.plotter).clearZoom();
        }
    }

    public void handleEvent(Event event) {
        if (this.plotter != null) {
            Rectangle rectangle = this.plotArea.getBounds();
            this.plotter.notifyComponentResize(rectangle.width, rectangle.height);
        }
    }

    public void paintControl(PaintEvent paintEvent) {
        this.viewerApp.getCurrentViewer().render();
    }

    public void setDataWindowPosition(SurfacePlotROI surfacePlotROI) {
        if (this.currentMode == PlottingMode.SURF2D) {
            ((DataSet3DPlot3D)this.plotter).setDataWindow(surfacePlotROI);
        }
    }

    @Override
    public void legendDeleted(LegendChangeEvent legendChangeEvent) {
        int n;
        if (this.currentMode == PlottingMode.ONED && (n = legendChangeEvent.getEntryNr()) < this.currentDataSets.size()) {
            ((DataSet3DPlot1D)this.plotter).removeGraphNode(n);
            this.currentDataSets.remove(n);
            this.graphColourTable.deleteLegendEntry(n);
            --this.historyCounter;
            if (this.useLegend) {
                this.legendTable.updateTable(this.graphColourTable);
            }
            this.refresh(false);
        }
    }

    public void setPlotUpdateOperation(boolean bl) {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            ((DataSet3DPlot1D)this.plotter).setUpdateOperation(bl);
        }
    }

    public void setYAxisScaling(ScaleType scaleType) {
        this.plotter.setScaling(scaleType);
    }

    public void setZAxisScaling(ScaleType scaleType) {
        if (!this.hasJOGL && this.currentMode == PlottingMode.TWOD && scaleType != this.plotter.getScaling()) {
            this.plotter.setScaling(scaleType);
            this.applyColorCast(this.cacheRedFunc, this.cacheGreenFunc, this.cacheBlueFunc, this.cacheAlphaFunc, this.cacheInverseRed, this.cacheInverseGreen, this.cacheInverseBlue, this.cacheInverseAlpha, this.cacheMinValue, this.cacheMaxValue);
        } else {
            this.plotter.setScaling(scaleType);
        }
    }

    public double stackPlotGetZAxisLengthFactor() {
        return 0.0;
    }

    public void stackPlotSetZAxisLengthFactor(double d) {
    }

    public void imagePlotSetCanvasAspectRatio(boolean bl) {
        if (this.currentMode == PlottingMode.TWOD) {
            ((DataSet3DPlot2D)this.plotter).setCanvasAspectRation(bl);
        }
    }

    @Override
    public void plotActionPerformed(final PlotActionEvent plotActionEvent) {
        if (this.currentMode == PlottingMode.TWOD) {
            if (this.infoBox != null) {
                this.container.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int n = plotActionEvent.getDataPosition()[0];
                        int n2 = plotActionEvent.getDataPosition()[1];
                        n = Math.max(n, 0);
                        n = Math.min(n, DataSetPlotter.this.currentDataSet.getShape()[1] - 1);
                        n2 = Math.max(n2, 0);
                        n2 = Math.min(n2, DataSetPlotter.this.currentDataSet.getShape()[0] - 1);
                        DataSetPlotter.this.infoBox.setPositionInfo(plotActionEvent.getPosition()[0], plotActionEvent.getPosition()[1], DataSetPlotter.this.currentDataSet.getDouble(new int[]{n2, n}));
                        if (DataSetPlotter.this.qSpace != null) {
                            DataSetPlotter.this.infoBox.setQSpaceInfo(n, n2, DataSetPlotter.this.qSpace);
                        }
                    }
                });
            }
        } else {
            logger.warn("This shouldn't be happening there should be no notifications");
        }
    }

    public void restoreDefaultPlotAreaCursor() {
        this.plotArea.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DataSetPlotter.this.plotArea.setCursor(DataSetPlotter.this.defaultCursor);
            }
        });
    }

    public void setPlotAreaCursor(final int n) {
        this.plotArea.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Cursor cursor = DataSetPlotter.this.plotArea.getDisplay().getSystemCursor(n);
                if (cursor != null) {
                    DataSetPlotter.this.plotArea.setCursor(cursor);
                }
            }
        });
    }

    public boolean isDisposed() {
        return this.getComposite().isDisposed();
    }

    @Override
    public List<AxisValues> getXAxisValues() {
        return this.plotter.getAxisValues();
    }

    public void useTransparency(boolean bl) {
        if (this.currentMode == PlottingMode.SCATTER3D) {
            ((DataSetScatterPlot3D)this.plotter).setTransparency(bl);
        }
    }

    public void useDrawOutlinesOnly(boolean bl) {
        if (this.currentMode == PlottingMode.SCATTER3D) {
            ((DataSetScatterPlot3D)this.plotter).setDrawOutlinesOnly(bl);
        }
    }

    public void setFeatureDetection(boolean bl) {
        if (this.currentMode == PlottingMode.TWOD) {
            ((DataSet3DPlot2D)this.plotter).setFeatureDetection(bl);
            this.refresh(false);
        }
    }

    public void increaseFeatureSensitivty() {
        if (this.currentMode == PlottingMode.TWOD) {
            ((DataSet3DPlot2D)this.plotter).changeFeatureSensitivity(0.9);
            this.refresh(false);
        }
    }

    public void decreaseFeatureSensitivty() {
        if (this.currentMode == PlottingMode.TWOD) {
            ((DataSet3DPlot2D)this.plotter).changeFeatureSensitivity(1.1);
            this.refresh(false);
        }
    }
}

