/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;

public class AxisValues
implements Serializable {
    private List<Double> values = Collections.synchronizedList(new LinkedList());
    private double minValue = 3.4028234663852886E38;
    private double maxValue = -3.4028234663852886E38;

    public List<Double> getValues() {
        return this.values;
    }

    public AbstractDataset toDataset() {
        return AbstractDataset.createFromList(this.values);
    }

    public AxisValues() {
    }

    public AxisValues(List<Double> list) {
        this();
        this.setValues(list);
    }

    public AxisValues(double[] dArray) {
        this();
        this.setValues(dArray);
    }

    public AxisValues(AbstractDataset abstractDataset) {
        this();
        IndexIterator indexIterator = abstractDataset.getIterator();
        while (indexIterator.hasNext()) {
            this.values.add(abstractDataset.getElementDoubleAbs(indexIterator.index));
        }
        this.minValue = abstractDataset.min().doubleValue();
        this.maxValue = abstractDataset.max().doubleValue();
    }

    public void addValue(double d) {
        this.minValue = Math.min(d, this.minValue);
        this.maxValue = Math.max(d, this.maxValue);
        this.values.add(d);
    }

    public void setValues(List<Double> list) {
        this.values.clear();
        this.values.addAll(list);
        this.minValue = Math.min(this.values.get(0), this.minValue);
        this.maxValue = Math.max(this.values.get(this.values.size() - 1), this.maxValue);
    }

    public void setValues(double[] dArray) {
        this.values.clear();
        int n = 0;
        while (n < dArray.length) {
            this.values.add(dArray[n]);
            ++n;
        }
        this.minValue = Math.min(this.values.get(0), this.minValue);
        this.maxValue = Math.max(this.values.get(this.values.size() - 1), this.maxValue);
    }

    public void setValues(IDataset iDataset) {
        if (iDataset != null) {
            this.values.clear();
            int n = 0;
            while (n < iDataset.getSize()) {
                this.values.add(iDataset.getDouble(new int[]{n++}));
            }
            this.minValue = iDataset.min().doubleValue();
            this.maxValue = iDataset.max().doubleValue();
        }
    }

    public void setLowEntry(double d) {
        boolean bl = this.values.get(0) == this.minValue;
        this.values.set(0, d);
        if (bl) {
            this.minValue = d;
        }
    }

    public void setTopEntry(double d) {
        boolean bl = this.values.get(this.values.size() - 1) == this.maxValue;
        this.values.set(this.values.size() - 1, d);
        if (bl) {
            this.maxValue = d;
        }
    }

    public double getMax() {
        this.sanityCheckMinMax();
        return this.maxValue;
    }

    public double getMin() {
        this.sanityCheckMinMax();
        return this.minValue;
    }

    public double getValue(int n) {
        if (this.values.size() > 0) {
            if (n < this.values.size()) {
                return this.values.get(n);
            }
            return this.values.get(n - 1);
        }
        return Double.NaN;
    }

    public Iterator<Double> getIterator() {
        return this.values.iterator();
    }

    public double distBetween(int n, int n2) {
        return this.values.get(n2) - this.values.get(n);
    }

    public void clear() {
        this.values.clear();
        this.maxValue = -3.4028234663852886E38;
        this.minValue = 3.4028234663852886E38;
    }

    public int nearestUpEntry(double d) {
        if (d > this.maxValue || d < this.minValue) {
            return -1;
        }
        Iterator<Double> iterator = this.values.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            double d2 = iterator.next();
            if (d2 >= d) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int nearestLowEntry(double d) {
        if (d > this.maxValue || d < this.minValue) {
            return -1;
        }
        Iterator<Double> iterator = this.values.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            double d2 = iterator.next();
            if (d2 == d) {
                return n;
            }
            if (d2 > d) {
                return n - 1;
            }
            ++n;
        }
        return -1;
    }

    public AxisValues subset(int n, int n2) {
        AxisValues axisValues = null;
        if (n < this.values.size() && n2 <= this.values.size()) {
            axisValues = new AxisValues();
            axisValues.values = this.values.subList(n, n2);
            for (double d : axisValues.values) {
                axisValues.minValue = Math.min(axisValues.minValue, d);
                axisValues.maxValue = Math.max(axisValues.maxValue, d);
            }
        }
        return axisValues;
    }

    public int size() {
        return this.values.size();
    }

    public AxisValues clone() {
        AxisValues axisValues = new AxisValues();
        axisValues.maxValue = this.maxValue;
        axisValues.minValue = this.minValue;
        axisValues.values.addAll(this.values);
        return axisValues;
    }

    public double getMinValue() {
        this.sanityCheckMinMax();
        return this.minValue;
    }

    public void setMinValue(double d) {
        this.minValue = d;
    }

    public double getMaxValue() {
        this.sanityCheckMinMax();
        return this.maxValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    private void sanityCheckMinMax() {
        if (this.minValue > this.maxValue) {
            double d = this.minValue;
            this.minValue = this.maxValue;
            this.maxValue = d;
        }
    }

    public boolean isAscending() {
        if (this.values.size() > 0) {
            return this.values.get(0) < this.values.get(this.values.size() - 1);
        }
        return true;
    }
}

