/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.imagegrid;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.RGBDataset;
import uk.ac.diamond.scisoft.analysis.dataset.SWTImageUtils;
import uk.ac.diamond.scisoft.analysis.dataset.Stats;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.AbstractGridEntry;

public class SWTGridEntry
extends AbstractGridEntry {
    private static final Logger logger = LoggerFactory.getLogger(SWTGridEntry.class);
    private Image gridImage = null;
    private Dimension imageDim;
    private Canvas canvas;
    private static Color green = null;
    private static Color red = null;
    private static Color blue = null;
    private static final float MINIMUMTHRESHOLD = 0.02f;

    public SWTGridEntry(String string) {
        super(string);
    }

    public SWTGridEntry(String string, Object object) {
        super(string, object);
    }

    public SWTGridEntry(String string, Object object, Canvas canvas) {
        this(string, object);
        this.canvas = canvas;
    }

    @Override
    public void setNewfilename(String string) {
        this.filename = string;
        this.additionalInfo = null;
        if (this.gridImage != null) {
            this.gridImage.dispose();
        }
        if (this.thumbnailFilename != null) {
            File file = new File(this.thumbnailFilename);
            file.delete();
            this.thumbnailFilename = null;
        }
    }

    @Override
    public void setStatus(int n) {
        this.status = n;
    }

    @Override
    public void deActivate() {
        if (this.gridImage != null) {
            try {
                if (this.thumbnailFilename == null) {
                    File file = File.createTempFile("tmp_thumb", ".png");
                    String string = Platform.getInstanceLocation().getURL().getPath();
                    string = string.substring(1);
                    this.thumbnailFilename = String.valueOf(string) + file.getName();
                    ImageLoader imageLoader = new ImageLoader();
                    imageLoader.data = new ImageData[]{this.gridImage.getImageData()};
                    imageLoader.save(this.thumbnailFilename, 5);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.gridImage.dispose();
            this.gridImage = null;
        }
    }

    public void loadThumbImage() {
        if (this.gridImage == null) {
            this.canvas.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SWTGridEntry.this.gridImage = new Image((Device)SWTGridEntry.this.canvas.getDisplay(), SWTGridEntry.this.thumbnailFilename);
                    SWTGridEntry.this.canvas.redraw();
                }
            });
        } else {
            logger.warn("Something is wrong");
        }
    }

    @Override
    public void createImage(final AbstractDataset abstractDataset) {
        this.canvas.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                int[] nArray = abstractDataset.getShape();
                if (nArray.length == 2) {
                    double d;
                    if (abstractDataset instanceof RGBDataset) {
                        double d2;
                        d = Stats.quantile((AbstractDataset)((RGBDataset)abstractDataset).createRedDataset(2), (double)0.9800000004470348);
                        if (d < (d2 = Stats.quantile((AbstractDataset)((RGBDataset)abstractDataset).createGreenDataset(2), (double)0.9800000004470348))) {
                            d = d2;
                        }
                        if (d < (d2 = Stats.quantile((AbstractDataset)((RGBDataset)abstractDataset).createBlueDataset(2), (double)0.9800000004470348))) {
                            d = d2;
                        }
                    } else {
                        d = Stats.quantile((AbstractDataset)abstractDataset, (double)0.9800000004470348);
                    }
                    ImageData imageData = SWTImageUtils.createImageData((AbstractDataset)abstractDataset, (Number)d);
                    SWTGridEntry.this.gridImage = new Image((Device)SWTGridEntry.this.canvas.getDisplay(), imageData);
                    SWTGridEntry.this.imageDim = new Dimension(nArray[1], nArray[0]);
                    SWTGridEntry.this.canvas.redraw();
                }
            }
        });
    }

    public void paint(GC gC, int n, int n2, int n3, int n4) {
        if (this.gridImage != null && !this.gridImage.isDisposed()) {
            gC.drawImage(this.gridImage, 0, 0, this.imageDim.width, this.imageDim.height, n, n2, n3, n4);
            switch (this.status) {
                case 1: {
                    if (green == null) {
                        green = new Color((Device)this.canvas.getDisplay(), new RGB(0, 255, 0));
                    }
                    gC.setForeground(green);
                    gC.drawRectangle(n, n2, n3, n4);
                    break;
                }
                case 2: {
                    if (red == null) {
                        red = new Color((Device)this.canvas.getDisplay(), new RGB(255, 0, 0));
                    }
                    gC.setForeground(red);
                    gC.drawRectangle(n, n2, n3, n4);
                    break;
                }
                case 666: {
                    if (blue == null) {
                        blue = new Color((Device)this.canvas.getDisplay(), new RGB(64, 64, 255));
                    }
                    gC.setAlpha(128);
                    gC.setBackground(blue);
                    gC.fillRectangle(n, n2, n3, n4);
                    gC.setAlpha(255);
                }
            }
        }
    }

    public Dimension getImageDimension() {
        return this.imageDim;
    }

    public boolean hasThumbnailImage() {
        return this.thumbnailFilename != null;
    }

    public boolean hasImage() {
        return this.gridImage != null && !this.gridImage.isDisposed();
    }

    @Override
    public void dispose() {
        if (this.gridImage != null && !this.gridImage.isDisposed()) {
            this.gridImage.dispose();
        }
        if (this.thumbnailFilename != null) {
            File file = new File(this.thumbnailFilename);
            file.delete();
        }
    }

    @Override
    public String getToolTipText() {
        String string = "";
        if (this.additionalInfo == null) {
            string = this.filename;
        }
        return string;
    }
}

