/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.imagegrid;

import java.awt.Rectangle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.AbstractGridEntry;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.AbstractImageGrid;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.ThumbnailLoadService;

public class GridEntryMonitor {
    private AbstractImageGrid grid;
    private Rectangle innerCacheArea;
    private Rectangle fullCacheArea;
    private Rectangle totalGridArea;
    private ExecutorService execSvc = null;
    private ThumbnailLoadService service = null;
    private static final int BUFFERWIDTH = 10;
    private int totalImagesNumber = 0;

    public GridEntryMonitor(AbstractImageGrid abstractImageGrid, int n, int n2, int n3, String string) {
        this.grid = abstractImageGrid;
        this.totalImagesNumber = n3;
        this.innerCacheArea = new Rectangle(0, 0, n, n2);
        this.totalGridArea = new Rectangle(0, 0, abstractImageGrid.getGridWidth(), abstractImageGrid.getGridHeight());
        float f = (float)abstractImageGrid.getGridWidth() / (float)abstractImageGrid.getGridHeight();
        int n4 = (int)Math.sqrt(n3);
        int n5 = (int)((float)n4 * f);
        int n6 = (int)((float)n4 * (1.0f / f));
        if (n5 < abstractImageGrid.getGridWidth() + 10) {
            n5 = abstractImageGrid.getGridWidth() + 10;
            n6 = n3 / n5;
        }
        this.fullCacheArea = new Rectangle(0, 0, n5, n6);
        this.execSvc = Executors.newFixedThreadPool(2);
        this.service = new ThumbnailLoadService(string);
        this.execSvc.execute(this.service);
    }

    public void resizeDisplayArea(int n, int n2) {
        this.innerCacheArea.setBounds((int)this.innerCacheArea.getX(), (int)this.innerCacheArea.getY(), n, n2);
        this.recomputeTotalCacheArea(this.grid.getGridWidth(), this.grid.getGridHeight());
    }

    public void addEntry(AbstractGridEntry abstractGridEntry, int n, int n2) {
        if (this.innerCacheArea.contains(n, n2)) {
            this.service.addLoadJob(abstractGridEntry, true);
        } else if (this.fullCacheArea.contains(n, n2)) {
            this.service.addLoadJob(abstractGridEntry, false);
        }
    }

    private Rectangle[] subtraction(Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        if (rectangle3.width == -1 && rectangle3.height == -1) {
            return new Rectangle[]{rectangle2};
        }
        if (rectangle3.height == rectangle2.height) {
            if (rectangle2.x < rectangle.x) {
                rectangle3.setLocation(rectangle2.x, rectangle2.y);
                rectangle3.setSize(rectangle2.width - rectangle3.width, rectangle2.height);
            } else {
                rectangle3.setLocation(rectangle.x + rectangle.width + 1, rectangle2.y);
                rectangle3.setSize(rectangle2.width - rectangle3.width, rectangle2.height);
            }
            return new Rectangle[]{rectangle3};
        }
        if (rectangle3.width == rectangle2.width) {
            if (rectangle2.y < rectangle.y) {
                rectangle3.setLocation(rectangle2.x, rectangle2.y);
                rectangle3.setSize(rectangle2.width, rectangle2.height - rectangle3.height);
            } else {
                rectangle3.setLocation(rectangle2.x, rectangle.y + rectangle.height);
                rectangle3.setSize(rectangle2.width, rectangle2.height - rectangle3.height);
            }
            return new Rectangle[]{rectangle3};
        }
        if (rectangle2.x < rectangle.x) {
            Rectangle rectangle4 = new Rectangle(rectangle2.x, rectangle2.y, rectangle3.x - rectangle2.x, rectangle2.height);
            Rectangle rectangle5 = null;
            rectangle5 = rectangle2.y < rectangle.y ? new Rectangle(rectangle3.x, rectangle2.y, rectangle3.width, rectangle3.y - rectangle2.y) : new Rectangle(rectangle3.x, rectangle3.y + rectangle3.height, rectangle3.width, rectangle2.height - rectangle3.height);
            return new Rectangle[]{rectangle4, rectangle5};
        }
        Rectangle rectangle6 = new Rectangle(rectangle3.x + rectangle3.width, rectangle2.y, rectangle2.width - rectangle3.width, rectangle2.height);
        Rectangle rectangle7 = null;
        rectangle7 = rectangle2.y < rectangle.y ? new Rectangle(rectangle3.x, rectangle2.y, rectangle3.width, rectangle2.height - rectangle3.height) : new Rectangle(rectangle3.x, rectangle2.y + rectangle3.height, rectangle3.width, rectangle2.height - rectangle3.height);
        return new Rectangle[]{rectangle6, rectangle7};
    }

    private void checkOnReloadPrimary() {
        Rectangle[] rectangleArray = this.subtraction(this.fullCacheArea, this.innerCacheArea);
        int n = 0;
        while (n < rectangleArray.length) {
            Rectangle rectangle = rectangleArray[n];
            int n2 = 0;
            while (n2 < rectangle.height) {
                int n3 = 0;
                while (n3 < rectangle.width) {
                    int n4 = n3 + rectangle.x;
                    int n5 = n2 + rectangle.y;
                    AbstractGridEntry abstractGridEntry = this.grid.getGridEntry(n4, n5);
                    if (abstractGridEntry != null) {
                        this.service.addLoadJob(abstractGridEntry, true);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void recomputeTotalCacheArea(int n, int n2) {
        float f = (float)n / (float)n2;
        int n3 = (int)Math.sqrt(this.totalImagesNumber);
        int n4 = (int)((float)n3 * f);
        int n5 = (int)((float)n3 * (1.0f / f));
        int n6 = Math.min(this.innerCacheArea.width, n);
        if (n4 < n6 + 10) {
            n4 = n6 + 10;
            n5 = this.totalImagesNumber / n4;
        }
        this.fullCacheArea.setBounds(this.fullCacheArea.x, this.fullCacheArea.y, n4, n5);
    }

    public void gridResize(int n, int n2) {
        this.recomputeTotalCacheArea(n, n2);
        this.totalGridArea.setBounds(0, 0, n, n2);
    }

    public void updateMonitorPosition(int n, int n2) {
        Rectangle rectangle;
        this.innerCacheArea.setLocation(n, n2);
        if (!this.fullCacheArea.contains(this.innerCacheArea)) {
            this.checkOnReloadPrimary();
        }
        int n3 = Math.min(this.fullCacheArea.width >> 1, this.fullCacheArea.width - this.innerCacheArea.width - 2);
        int n4 = Math.min(this.fullCacheArea.height >> 1, this.fullCacheArea.height - this.innerCacheArea.height - 2);
        int n5 = n - n3;
        int n6 = n2 - n4;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (!this.fullCacheArea.contains(rectangle = new Rectangle(n5, n6, this.fullCacheArea.width, this.fullCacheArea.height))) {
            int n7;
            int n8;
            int n9;
            Rectangle[] rectangleArray = this.subtraction(rectangle, this.fullCacheArea);
            int n10 = 0;
            while (n10 < rectangleArray.length) {
                Rectangle rectangle2 = rectangleArray[n10];
                int n11 = 0;
                while (n11 < rectangle2.height) {
                    n9 = 0;
                    while (n9 < rectangle2.width) {
                        n8 = n9 + rectangle2.x;
                        n7 = n11 + rectangle2.y;
                        AbstractGridEntry abstractGridEntry = this.grid.getGridEntry(n8, n7);
                        if (abstractGridEntry != null) {
                            abstractGridEntry.deActivate();
                        }
                        ++n9;
                    }
                    ++n11;
                }
                ++n10;
            }
            Rectangle[] rectangleArray2 = this.subtraction(this.fullCacheArea, rectangle);
            int n12 = 0;
            while (n12 < rectangleArray2.length) {
                Rectangle rectangle3 = rectangleArray2[n12];
                n9 = 0;
                while (n9 < rectangle3.height) {
                    n8 = 0;
                    while (n8 < rectangle3.width) {
                        n7 = n8 + rectangle3.x;
                        int n13 = n9 + rectangle3.y;
                        AbstractGridEntry abstractGridEntry = this.grid.getGridEntry(n7, n13);
                        if (abstractGridEntry != null) {
                            this.service.addLoadJob(abstractGridEntry, false);
                        }
                        ++n8;
                    }
                    ++n9;
                }
                ++n12;
            }
        }
        this.fullCacheArea = rectangle;
    }

    public Rectangle getPrimaryCacheArea() {
        return this.innerCacheArea;
    }

    public Rectangle getSecondaryCacheArea() {
        return this.fullCacheArea;
    }

    public void dispose() {
        this.service.shutdown();
    }

    public void setLocalProcessing(boolean bl) {
        this.service.setLocalProcessing(bl);
    }
}

