/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions;

import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.AbstractMapFunction;

public class UserCustomFunction
extends AbstractMapFunction {
    double[] mapTable;
    String funcname;

    public UserCustomFunction(String string, int n) {
        this.mapTable = new double[n];
        this.funcname = string;
    }

    @Override
    public String getMapFunctionName() {
        return this.funcname;
    }

    public void setValues(double[] dArray) {
        this.mapTable = (double[])dArray.clone();
    }

    public void setValue(int n, double d) {
        if (n >= 0 && n < this.mapTable.length) {
            this.mapTable[n] = d;
        }
    }

    @Override
    public double mapFunction(double d) {
        int n = (int)(d * (double)this.mapTable.length);
        int n2 = (int)Math.ceil(d * (double)this.mapTable.length);
        if (n2 > this.mapTable.length - 1) {
            n2 = this.mapTable.length - 1;
        }
        double d2 = d * (double)this.mapTable.length - (double)n;
        return this.mapTable[n] * (1.0 - d2) + d2 * this.mapTable[n2];
    }
}

