/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions;

import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.AbstractMapFunction;

public class SpecialExposureFunction
extends AbstractMapFunction {
    private char mode;
    private double minThreshold;
    private double maxThreshold;
    private String functionName;

    public SpecialExposureFunction(String string, double d, double d2, char c) {
        this.functionName = string;
        this.minThreshold = d;
        this.maxThreshold = d2;
        this.mode = c;
    }

    public void setThresholds(double d, double d2) {
        this.minThreshold = d;
        this.maxThreshold = d2;
    }

    @Override
    public String getMapFunctionName() {
        return this.functionName;
    }

    @Override
    public double mapFunction(double d) {
        double d2 = 0.0;
        switch (this.mode) {
            case 'r': {
                if (d < this.minThreshold) {
                    d2 = 0.0;
                    break;
                }
                d2 = d;
                break;
            }
            case 'g': {
                if (d < this.minThreshold || d > this.maxThreshold) {
                    d2 = 0.0;
                    break;
                }
                d2 = d;
                break;
            }
            case 'b': {
                d2 = d;
                if (d < this.minThreshold) {
                    d2 = (this.minThreshold - d) / this.minThreshold;
                }
                if (!(d > this.maxThreshold)) break;
                d2 = 0.0;
            }
        }
        return d2;
    }
}

