/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.histogram;

import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.geometry.PointSetFactory;
import de.jreality.geometry.QuadMeshFactory;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Viewer;
import de.jreality.scene.tool.Tool;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPolygonShader;
import de.jreality.shader.ImageData;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.Texture2D;
import de.jreality.shader.TextureUtility;
import de.jreality.ui.viewerapp.AbstractViewerApp;
import de.jreality.util.CameraUtility;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.ColourImageData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.ArrayPoolUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot1D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.ScalingUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Tick;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.ScaleType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEventListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.SelectedWindow;

public class HistogramChartPlot1D
extends DataSet3DPlot1D {
    private IDataset histoSet = null;
    private AxisValues axisValues = null;
    private SceneGraphComponent barGraph = null;
    private SceneGraphComponent colourTable = null;
    private Appearance colourTableApp = null;
    private boolean hasJOGL = false;
    private Texture2D tableTexture = null;
    private List<AreaSelectEventListener> selectionListeners = Collections.synchronizedList(new LinkedList());
    private ScaleType xScaling = ScaleType.LINEAR;

    public HistogramChartPlot1D(AbstractViewerApp abstractViewerApp, Plot1DGraphTable plot1DGraphTable, boolean bl) {
        super(abstractViewerApp, null, null, plot1DGraphTable, bl);
        this.hasJOGL = bl;
    }

    private IndexedFaceSet createColourTableGeom() {
        QuadMeshFactory quadMeshFactory = new QuadMeshFactory();
        double d = this.axisValues.getMax();
        ScalingUtility.setSmallLogFlag(this.graphXmin < Math.E && this.graphXmin > 0.0);
        double d2 = ScalingUtility.valueScaler(this.graphXmax, this.xScaling);
        double d3 = ScalingUtility.valueScaler(this.graphXmin, this.xScaling);
        double d4 = ScalingUtility.valueScaler(d, this.xScaling);
        double d5 = (d4 - d3) * (14.75 / (d2 - d3));
        double[][][] dArray = new double[2][2][3];
        dArray[0][0][0] = 0.0;
        dArray[0][0][1] = 15.9;
        dArray[0][0][2] = 0.0;
        dArray[0][1][0] = d5;
        dArray[0][1][1] = 15.9;
        dArray[0][1][2] = 0.0;
        dArray[1][0][0] = 0.0;
        dArray[1][0][1] = 15.4;
        dArray[1][0][2] = 0.0;
        dArray[1][1][0] = d5;
        dArray[1][1][1] = 15.4;
        dArray[1][1][2] = 0.0;
        quadMeshFactory.setVLineCount(2);
        quadMeshFactory.setULineCount(2);
        quadMeshFactory.setClosedInUDirection(false);
        quadMeshFactory.setClosedInVDirection(false);
        quadMeshFactory.setVertexCoordinates(dArray);
        quadMeshFactory.setGenerateFaceNormals(true);
        quadMeshFactory.update();
        dArray = null;
        return quadMeshFactory.getIndexedFaceSet();
    }

    private IndexedFaceSet createBarChart(IDataset iDataset) {
        QuadMeshFactory quadMeshFactory = new QuadMeshFactory();
        int n = iDataset.getSize();
        Iterator<Double> iterator = this.axisValues.getIterator();
        double[][][] dArray = new double[2][n * 2][3];
        double d = iterator.next();
        ScalingUtility.setSmallLogFlag(this.graphXmin < Math.E && this.graphXmin > 0.0);
        double d2 = ScalingUtility.valueScaler(this.graphXmax, this.xScaling);
        double d3 = ScalingUtility.valueScaler(this.graphXmin, this.xScaling);
        int n2 = 0;
        while (n2 < n) {
            double d4 = 15.0 * iDataset.getDouble(new int[]{n2}) / this.graphYmax;
            double d5 = ScalingUtility.valueScaler(d, this.xScaling);
            dArray[0][n2 * 2][0] = (d5 - d3) * (14.75 / (d2 - d3));
            dArray[0][n2 * 2][1] = d4;
            dArray[0][n2 * 2][2] = 0.0;
            dArray[1][n2 * 2][0] = (d5 - d3) * (14.75 / (d2 - d3));
            dArray[1][n2 * 2][1] = 0.0;
            dArray[1][n2 * 2][2] = 0.0;
            d = iterator.next();
            d5 = ScalingUtility.valueScaler(d, this.xScaling);
            dArray[0][n2 * 2 + 1][0] = (d5 - d3) * (14.75 / (d2 - d3));
            dArray[0][n2 * 2 + 1][1] = d4;
            dArray[0][n2 * 2 + 1][2] = 0.0;
            dArray[1][n2 * 2 + 1][0] = (d5 - d3) * (14.75 / (d2 - d3));
            dArray[1][n2 * 2 + 1][1] = 0.0;
            dArray[1][n2 * 2 + 1][2] = 0.0;
            ++n2;
        }
        quadMeshFactory.setVLineCount(2);
        quadMeshFactory.setULineCount(n * 2);
        quadMeshFactory.setClosedInUDirection(false);
        quadMeshFactory.setClosedInVDirection(false);
        quadMeshFactory.setVertexCoordinates(dArray);
        quadMeshFactory.setGenerateFaceNormals(true);
        quadMeshFactory.update();
        dArray = null;
        return quadMeshFactory.getIndexedFaceSet();
    }

    @Override
    public SceneGraphComponent buildGraph(List<IDataset> list, SceneGraphComponent sceneGraphComponent) {
        assert (list.size() > 0);
        if (sceneGraphComponent != null) {
            Object object;
            DefaultLineShader defaultLineShader;
            Object object2;
            SceneGraphComponent sceneGraphComponent2;
            IDataset iDataset;
            this.graphGroupNode = SceneGraphUtility.createFullSceneGraphComponent((String)"groupNode");
            this.sets = list;
            this.graph = sceneGraphComponent;
            this.determineRanges(list);
            this.currentSelectWindow = new SelectedWindow(0.0, (int)this.globalXmax, 0.0, 0.0);
            this.numGraphs = 0;
            int n = 0;
            while (n < list.size() - 1) {
                iDataset = list.get(n);
                sceneGraphComponent2 = SceneGraphUtility.createFullSceneGraphComponent((String)("graph.subGraph" + this.numGraphs));
                this.subGraphs.add(sceneGraphComponent2);
                sceneGraphComponent2.setGeometry((Geometry)this.createGraphGeometry(iDataset, this.axisValues));
                object2 = new Appearance();
                sceneGraphComponent2.setAppearance(object2);
                DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)object2, (boolean)true);
                object2.setAttribute("lineShader.tubeDraw", false);
                object2.setAttribute("pointShader.spheresDraw", false);
                defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
                object = this.graphColours.getLegendEntry(this.numGraphs);
                ((Plot1DAppearance)object).updateGraph(defaultLineShader, defaultGeometryShader);
                this.graphLineShaders.add(defaultLineShader);
                this.graphShaders.add(defaultGeometryShader);
                this.graphGroupNode.addChild(sceneGraphComponent2);
                ++this.numGraphs;
                ++n;
            }
            this.histoSet = list.get(list.size() - 1);
            this.barGraph = SceneGraphUtility.createFullSceneGraphComponent((String)("graph.subGraph" + this.numGraphs));
            this.barGraph.setGeometry((Geometry)this.createBarChart(this.histoSet));
            Appearance appearance = new Appearance();
            this.barGraph.setAppearance(appearance);
            iDataset = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
            sceneGraphComponent2 = (DefaultPolygonShader)iDataset.createPolygonShader("default");
            if (!this.hasJOGL) {
                appearance.setAttribute("lightingEnabled", false);
            }
            sceneGraphComponent2.setDiffuseColor(Color.GRAY);
            sceneGraphComponent2.setSpecularColor(Color.BLACK);
            iDataset.setShowFaces(Boolean.valueOf(true));
            iDataset.setShowLines(Boolean.valueOf(false));
            iDataset.setShowPoints(Boolean.valueOf(false));
            MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.barGraph);
            this.graphGroupNode.addChild(this.barGraph);
            ++this.numGraphs;
            object2 = this.app.getCurrentViewer().getViewingComponentSize();
            float f = (float)object2.width / (float)object2.height;
            if (f > 1.0f) {
                MatrixBuilder.euclidean().scale((double)f, 1.0, 1.0).translate(-6.75, -7.5, 0.0).assignTo(sceneGraphComponent);
                if (this.xTicks != null) {
                    MatrixBuilder.euclidean().scale((double)f, 1.0, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.xTicks);
                }
                if (this.yTicks != null) {
                    MatrixBuilder.euclidean().scale((double)f, 1.0, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.yTicks);
                }
            } else {
                MatrixBuilder.euclidean().scale(1.0, 1.0 / (double)f, 1.0).translate(-6.75, -7.5, 0.0).assignTo(sceneGraphComponent);
                if (this.xTicks != null) {
                    MatrixBuilder.euclidean().scale(1.0, 1.0 / (double)f, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.xTicks);
                }
                if (this.yTicks != null) {
                    MatrixBuilder.euclidean().scale(1.0, 1.0 / (double)f, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.yTicks);
                }
            }
            defaultLineShader = CameraUtility.getCamera((Viewer)this.app.getCurrentViewer());
            defaultLineShader.setFieldOfView(56.5);
            sceneGraphComponent.addChild(this.graphGroupNode);
            if (this.background == null) {
                this.buildBackground();
                sceneGraphComponent.addChild(this.background);
                sceneGraphComponent.addTool((Tool)this.tool);
            }
            if (this.colourTable == null) {
                this.colourTable = SceneGraphUtility.createFullSceneGraphComponent((String)"table");
                this.colourTable.setGeometry((Geometry)this.createColourTableGeom());
                this.colourTableApp = new Appearance();
                this.colourTableApp.setAttribute("lightingEnabled", false);
                this.colourTableApp.setAttribute("polygonShader.diffuseColor", (Object)Color.WHITE);
                object = new byte[1024];
                int n2 = 0;
                while (n2 < 256) {
                    object[n2 * 4] = 127;
                    object[n2 * 4 + 3] = -127;
                    ++n2;
                }
                ImageData imageData = new ImageData((byte[])object, 256, 1);
                this.tableTexture = TextureUtility.createTexture((Appearance)this.colourTableApp, (String)"polygonShader", (ImageData)imageData);
                this.tableTexture.setRepeatS(Integer.valueOf(33071));
                this.tableTexture.setRepeatT(Integer.valueOf(33071));
                this.tableTexture.setMagFilter(Integer.valueOf(9729));
                this.tableTexture.setMinFilter(Integer.valueOf(9729));
                this.tableTexture.setMipmapMode(Boolean.valueOf(true));
                this.colourTable.setAppearance(this.colourTableApp);
                sceneGraphComponent.addChild(this.colourTable);
            }
            if (this.areaSelection == null) {
                this.buildAreaSelection();
            }
            if (this.xTicks != null) {
                this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
            }
            if (this.yTicks != null) {
                this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
            }
        }
        return sceneGraphComponent;
    }

    private void updateGraphs(boolean bl) {
        if (this.graph != null) {
            int n = 0;
            while (n < this.sets.size() - 1) {
                IDataset iDataset = (IDataset)this.sets.get(n);
                SceneGraphComponent sceneGraphComponent = (SceneGraphComponent)this.subGraphs.get(n);
                sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(iDataset, this.axisValues));
                ++n;
            }
            if (bl) {
                this.histoSet = (IDataset)this.sets.get(this.sets.size() - 1);
                this.barGraph.setGeometry((Geometry)this.createBarChart(this.histoSet));
                if (this.colourTable != null) {
                    this.colourTable.setGeometry((Geometry)this.createColourTableGeom());
                }
            }
        }
    }

    @Override
    protected void zoomCustom(double d, double d2, double d3, double d4) {
        double d5 = this.globalRealXmax - this.globalRealXmin;
        double d6 = d5 * d / 14.75 + this.globalRealXmin;
        double d7 = d5 * d2 / 14.75 + this.globalRealXmin;
        if (d6 < this.axisValues.getMin()) {
            d6 = this.axisValues.getMin();
        }
        if (this.undoSelectStack.size() == 0) {
            this.currentSelectWindow.setStartWindowX(this.globalRealXmin);
            this.currentSelectWindow.setEndWindowX(this.globalRealXmax);
        }
        this.undoSelectStack.add(0, this.currentSelectWindow);
        this.currentSelectWindow = new SelectedWindow(d6, d7, 0.0, 0.0);
        double[] dArray = new double[]{d6, d7};
        this.notifyAreaSelect(dArray);
    }

    @Override
    protected void determineRanges(List<IDataset> list) {
        this.globalYmin = 3.4028234663852886E38;
        this.globalYmax = -3.4028234663852886E38;
        this.globalXmin = 0.0;
        this.globalXmax = -1.0;
        this.globalRealXmin = 3.4028234663852886E38;
        this.globalRealXmax = -3.4028234663852886E38;
        IDataset iDataset = list.get(list.size() - 1);
        this.globalYmin = Math.min(this.globalYmin, iDataset.min().doubleValue());
        this.globalYmax = Math.max(this.globalYmax, iDataset.max().doubleValue());
        this.globalXmax = Math.max(this.globalXmax, (double)iDataset.getShape()[0]);
        if (this.axisValues != null) {
            this.globalRealXmin = Math.min(this.globalRealXmin, this.axisValues.getMin());
            this.globalRealXmax = Math.max(this.globalRealXmax, this.axisValues.getMax());
        } else {
            this.globalRealXmin = this.globalXmin;
            this.globalRealXmax = this.globalXmax - 1.0;
        }
        this.buildTickLists();
    }

    @Override
    protected IndexedFaceSet createBackground() {
        QuadMeshFactory quadMeshFactory = new QuadMeshFactory();
        double[][][] dArray = new double[2][2][3];
        dArray[0][0][0] = -0.5;
        dArray[0][0][1] = 15.0;
        dArray[0][0][2] = 0.0;
        dArray[0][1][0] = 15.0;
        dArray[0][1][1] = 15.0;
        dArray[0][1][2] = 0.0;
        dArray[1][0][0] = -0.5;
        dArray[1][0][1] = 0.0;
        dArray[1][0][2] = 0.0;
        dArray[1][1][0] = 15.0;
        dArray[1][1][1] = 0.0;
        dArray[1][1][2] = 0.0;
        quadMeshFactory.setVLineCount(2);
        quadMeshFactory.setULineCount(2);
        quadMeshFactory.setClosedInUDirection(false);
        quadMeshFactory.setClosedInVDirection(false);
        quadMeshFactory.setVertexCoordinates(dArray);
        quadMeshFactory.setGenerateFaceNormals(true);
        quadMeshFactory.update();
        dArray = null;
        return quadMeshFactory.getIndexedFaceSet();
    }

    private void notifyAreaSelect(double[] dArray) {
        Iterator<AreaSelectEventListener> iterator = this.selectionListeners.iterator();
        AreaSelectEvent areaSelectEvent = new AreaSelectEvent(this.tool, dArray, '\u0002', -1);
        while (iterator.hasNext()) {
            AreaSelectEventListener areaSelectEventListener = iterator.next();
            areaSelectEventListener.areaSelected(areaSelectEvent);
        }
    }

    @Override
    public void undoZoom() {
        if (this.undoSelectStack.size() > 0) {
            this.currentSelectWindow = (SelectedWindow)this.undoSelectStack.get(0);
            this.undoSelectStack.remove(0);
            double[] dArray = new double[]{this.currentSelectWindow.getStartWindowX(), this.currentSelectWindow.getEndWindowX()};
            this.notifyAreaSelect(dArray);
        }
    }

    @Override
    public void updateGraph(List<IDataset> list) {
        boolean bl = false;
        if (!this.histoSet.equals(list.get(list.size() - 1))) {
            bl = true;
        }
        this.sets = list;
        this.determineRanges(this.sets);
        this.updateGraphs(bl);
        if (this.xTicks != null) {
            this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
        }
        if (this.yTicks != null) {
            this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
        }
    }

    @Override
    public void setXAxisValues(AxisValues axisValues, int n) {
        this.axisValues = axisValues;
    }

    public void addAreaSelectEventListener(AreaSelectEventListener areaSelectEventListener) {
        this.selectionListeners.add(areaSelectEventListener);
    }

    public void removeAreaSelectEventListener(AreaSelectEventListener areaSelectEventListener) {
        this.selectionListeners.remove(areaSelectEventListener);
    }

    public void clearZoom() {
        this.undoSelectStack.clear();
    }

    @Override
    public void handleColourCast(ColourImageData colourImageData, SceneGraphComponent sceneGraphComponent, double d, double d2) {
        int n = colourImageData.getWidth();
        int n2 = colourImageData.getHeight();
        byte[] byArray = new byte[n * n2 * 4];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = colourImageData.get(n4, n3);
                byte by = (byte)(n5 >> 24 & 0xFF);
                byte by2 = (byte)(n5 >> 16 & 0xFF);
                byte by3 = (byte)(n5 >> 8 & 0xFF);
                byte by4 = (byte)(n5 & 0xFF);
                byArray[(n4 + n3 * n) * 4] = by2;
                byArray[(n4 + n3 * n) * 4 + 1] = by3;
                byArray[(n4 + n3 * n) * 4 + 2] = by4;
                byArray[(n4 + n3 * n) * 4 + 3] = by;
                ++n4;
            }
            ++n3;
        }
        ImageData imageData = new ImageData(byArray, n, n2);
        this.tableTexture = TextureUtility.createTexture((Appearance)this.colourTableApp, (String)"polygonShader", (ImageData)imageData);
        this.tableTexture.setRepeatS(Integer.valueOf(33071));
        this.tableTexture.setRepeatT(Integer.valueOf(33071));
        this.tableTexture.setMagFilter(Integer.valueOf(9729));
        this.tableTexture.setMinFilter(Integer.valueOf(9729));
        this.tableTexture.setMipmapMode(Boolean.valueOf(true));
    }

    @Override
    public void cleanUpGraphNode() {
        super.cleanUpGraphNode();
        if (this.graph != null && this.colourTable != null) {
            this.graph.removeChild(this.colourTable);
        }
    }

    @Override
    protected PointSet createXLabelsGeometry(LinkedList<Tick> linkedList) {
        PointSetFactory pointSetFactory = new PointSetFactory();
        String[] stringArray = new String[linkedList.size()];
        pointSetFactory.setVertexCount(linkedList.size());
        double[][] dArray = ArrayPoolUtility.getDoubleArray(linkedList.size());
        ScalingUtility.setSmallLogFlag(this.graphXmin < Math.E && this.graphXmin > 0.0);
        double d = ScalingUtility.valueScaler(this.graphXmax, this.xScaling);
        double d2 = ScalingUtility.valueScaler(this.graphXmin, this.xScaling);
        double d3 = -10.0;
        int n = 0;
        while (n < linkedList.size()) {
            double d4 = this.xTicksUnitSize * (double)n;
            Tick tick = linkedList.get(n);
            double d5 = ScalingUtility.valueScaler(d4, this.xScaling);
            dArray[n][0] = d5 / (d - d2) * 14.75;
            dArray[n][1] = -0.275;
            dArray[n][2] = 0.0;
            if (dArray[n][0] - d3 > 1.0) {
                stringArray[n] = tick.getTickName();
                d3 = dArray[n][0];
            } else {
                stringArray[n] = "";
            }
            ++n;
        }
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    @Override
    protected IndexedLineSet createXTicksGeometry() {
        if (this.xLabels != null) {
            this.xLabels.setGeometry((Geometry)this.createXLabelsGeometry(this.xTicksLabels));
        }
        ScalingUtility.setSmallLogFlag(this.graphXmin < Math.E && this.graphXmin > 0.0);
        double d = ScalingUtility.valueScaler(this.graphXmax, this.xScaling);
        double d2 = ScalingUtility.valueScaler(this.graphXmin, this.xScaling);
        if (this.showXTicks) {
            IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
            indexedLineSetFactory.setVertexCount(this.xTicksLabels.size() * 2);
            indexedLineSetFactory.setEdgeCount(this.xTicksLabels.size());
            double[][] dArray = ArrayPoolUtility.getDoubleArray(this.xTicksLabels.size() * 2);
            int[][] nArray = ArrayPoolUtility.getIntArray(this.xTicksLabels.size());
            int n = 0;
            while (n < this.xTicksLabels.size()) {
                double d3 = this.xTicksUnitSize * (double)n;
                double d4 = ScalingUtility.valueScaler(d3, this.xScaling);
                dArray[n * 2][0] = d4 / (d - d2) * 14.75;
                dArray[n * 2][1] = -0.125;
                dArray[n * 2][2] = -1.0E-4;
                dArray[n * 2 + 1][0] = d4 / (d - d2) * 14.75;
                dArray[n * 2 + 1][1] = 15.0;
                dArray[n * 2 + 1][2] = -1.0E-4;
                nArray[n][0] = n * 2;
                nArray[n][1] = n * 2 + 1;
                ++n;
            }
            indexedLineSetFactory.setVertexCoordinates(dArray);
            indexedLineSetFactory.setEdgeIndices(nArray);
            indexedLineSetFactory.update();
            return indexedLineSetFactory.getIndexedLineSet();
        }
        return null;
    }

    @Override
    public void setScaling(ScaleType scaleType) {
        this.xScaling = scaleType;
        if (this.graph != null) {
            this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
            this.barGraph.setGeometry((Geometry)this.createBarChart(this.histoSet));
            this.colourTable.setGeometry((Geometry)this.createColourTableGeom());
            this.refresh();
        }
    }
}

