/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.editors;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.progress.IProgressService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.plotserver.AxisMapBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBeanException;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.rcp.editors.EditorUtils;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.ActionBarWrapper;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.utils.ImageThumbnailLoader;
import uk.ac.gda.monitor.IMonitor;
import uk.ac.gda.monitor.ProgressMonitorWrapper;

public class PlotEditor
extends EditorPart {
    private static final Logger logger = LoggerFactory.getLogger(PlotEditor.class);
    private PlotWindow plotWindow;
    private DataBean dataBean = null;
    private ToolBarManager toolMan;

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite composite) {
        composite.setLayout((Layout)new FillLayout());
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        this.toolMan = new ToolBarManager(0x820000);
        ToolBar toolBar = this.toolMan.createControl(composite2);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        IActionBars iActionBars = this.getEditorSite().getActionBars();
        ActionBarWrapper actionBarWrapper = new ActionBarWrapper((IToolBarManager)this.toolMan, null, null, (IActionBars2)iActionBars);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.plotWindow = new PlotWindow(composite3, GuiPlotMode.TWOD, (IActionBars)actionBarWrapper, this.getSite().getPage(), this.getPartName());
        this.plotWindow.setExclusiveToolars(true);
        Job job = new Job("Update Plot " + this.getEditorInput().getName()){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                PlotEditor.this.processData();
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.schedule();
        EditorUtils.addSidePlotActivator((IWorkbenchPart)this, this.plotWindow, this.getPartName());
    }

    private void processData() {
        while (this.dataBean == null && this.plotWindow == null && this.toolMan == null) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PlotEditor.this.dataBean != null && PlotEditor.this.plotWindow != null) {
                    PlotEditor.this.plotWindow.processPlotUpdate(PlotEditor.this.dataBean);
                }
                if (PlotEditor.this.toolMan != null) {
                    PlotEditor.this.toolMan.update(true);
                }
                if (PlotEditor.this.plotWindow != null) {
                    PlotEditor.this.plotWindow.getPlotUI().getSidePlotView().switchSidePlot(null, 0);
                }
            }
        });
    }

    public void setFocus() {
        if (this.plotWindow != null) {
            this.plotWindow.getMainPlotter().requestFocus();
        }
    }

    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (!(iEditorInput instanceof IURIEditorInput)) {
            logger.warn("Editor input cannot be used here");
            return;
        }
        this.setPartName(iEditorInput.getName());
        try {
            this.loadFile(iEditorInput);
        }
        catch (Exception exception) {
            logger.error("Cannot load " + iEditorInput.getName(), (Throwable)exception);
        }
    }

    private void loadFile(final IEditorInput iEditorInput) throws InvocationTargetException, InterruptedException {
        IProgressService iProgressService = (IProgressService)this.getSite().getService(IProgressService.class);
        iProgressService.run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                block4: {
                    iProgressMonitor.beginTask("Opening " + iEditorInput.getName(), 100);
                    iProgressMonitor.worked(1);
                    String string = ((IURIEditorInput)iEditorInput).getURI().getPath();
                    try {
                        DataHolder dataHolder = LoaderFactory.getData((String)string, (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
                        AbstractDataset abstractDataset = ImageThumbnailLoader.getSingle((String)string, (boolean)false, (DataHolder)dataHolder);
                        if (abstractDataset == null) break block4;
                        DataBean dataBean = new DataBean();
                        DataSetWithAxisInformation dataSetWithAxisInformation = new DataSetWithAxisInformation();
                        AxisMapBean axisMapBean = new AxisMapBean(AxisMapBean.DIRECT);
                        dataSetWithAxisInformation.setData((IDataset)abstractDataset);
                        dataSetWithAxisInformation.setAxisMap(axisMapBean);
                        try {
                            dataBean.addData(dataSetWithAxisInformation);
                        }
                        catch (DataBeanException dataBeanException) {
                            logger.warn("Could not package up dataBean " + dataBeanException.getMessage());
                        }
                        PlotEditor.this.dataBean = dataBean;
                        PlotEditor.this.processData();
                    }
                    catch (Exception exception) {
                        logger.error("Cannot load file " + string, (Throwable)exception);
                    }
                }
                iProgressMonitor.done();
            }
        });
    }

    public void dispose() {
        this.dataBean = null;
        if (this.plotWindow != null) {
            this.plotWindow.dispose();
        }
        super.dispose();
    }
}

