/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.progress.IProgressService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.rcp.editors.EditorUtils;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.ActionBarWrapper;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.util.PlotUtils;
import uk.ac.diamond.scisoft.analysis.rcp.views.nexus.DataSetPlotView;
import uk.ac.diamond.scisoft.analysis.rcp.views.nexus.DataSetProvider;
import uk.ac.diamond.scisoft.analysis.rcp.views.nexus.ExpressionObject;
import uk.ac.diamond.scisoft.analysis.rcp.views.nexus.IDataSetPlotViewProvider;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.monitor.IMonitor;
import uk.ac.gda.monitor.ProgressMonitorWrapper;

public class DataSetPlotEditor
extends EditorPart
implements IReusableEditor,
IDataSetPlotViewProvider,
DataSetProvider {
    private static Logger logger = LoggerFactory.getLogger(DataSetPlotEditor.class);
    private DataSetPlotView dataSetPlotView;
    private PlotWindow plotWindow;
    private DataHolder cachedDataHolder;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public void createPartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        ToolBarManager toolBarManager = new ToolBarManager(0x820000);
        ToolBar toolBar = toolBarManager.createControl(composite2);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        IActionBars iActionBars = this.getEditorSite().getActionBars();
        ActionBarWrapper actionBarWrapper = new ActionBarWrapper((IToolBarManager)toolBarManager, null, null, (IActionBars2)iActionBars);
        SashForm sashForm = new SashForm(composite2, 2048);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite3 = new Composite((Composite)sashForm, 0);
        composite3.setLayout((Layout)new FillLayout());
        this.plotWindow = new PlotWindow(composite3, GuiPlotMode.ONED, (IActionBars)actionBarWrapper, this.getSite().getPage(), this.getEditorInput().getName());
        this.plotWindow.setExclusiveToolars(true);
        Composite composite4 = new Composite((Composite)sashForm, 0);
        composite4.setLayout((Layout)new FillLayout());
        this.dataSetPlotView = new DataSetPlotView(false, false, this);
        this.dataSetPlotView.createPartControl(composite4);
        this.dataSetPlotView.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(final SelectionChangedEvent selectionChangedEvent) {
                DataSetPlotEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataSetPlotEditor.this.updatePlot(((StructuredSelection)selectionChangedEvent.getSelection()).toArray());
                    }
                });
            }
        });
        this.dataSetPlotView.setPlotWindow(this.plotWindow);
        this.dataSetPlotView.setFileName(this.getEditorInput().getName());
        sashForm.setWeights(new int[]{70, 30});
        toolBarManager.update(true);
        this.createData(this.getEditorInput());
        EditorUtils.addSidePlotActivator((IWorkbenchPart)this, this.plotWindow, this.getPartName());
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DataSetPlotEditor.this.plotWindow != null) {
                    DataSetPlotEditor.this.plotWindow.getPlotUI().getSidePlotView().switchSidePlot(null, 0);
                }
            }
        });
    }

    protected void updatePlot(final Object[] objectArray) {
        if (objectArray == null || objectArray.length < 1) {
            return;
        }
        IProgressService iProgressService = this.getEditorSite() != null ? (IProgressService)this.getSite().getService(IProgressService.class) : (IProgressService)PlatformUI.getWorkbench().getService(IProgressService.class);
        try {
            iProgressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    iProgressMonitor.beginTask("Updating selected DataSets", 100);
                    DataSetPlotEditor.this.createCachedData(iProgressMonitor);
                    IDataset iDataset = DataSetPlotEditor.this.getDataSet(objectArray[0], iProgressMonitor);
                    ArrayList<IDataset> arrayList = null;
                    if (objectArray.length > 1) {
                        arrayList = new ArrayList<IDataset>(3);
                        int n = 1;
                        while (n < objectArray.length) {
                            arrayList.add(DataSetPlotEditor.this.getDataSet(objectArray[n], iProgressMonitor));
                            if (iProgressMonitor.isCanceled()) {
                                return;
                            }
                            iProgressMonitor.worked(1);
                            ++n;
                        }
                    }
                    PlotUtils.createPlot(iDataset, arrayList, DataSetPlotEditor.this.dataSetPlotView.getPlotMode(), DataSetPlotEditor.this.plotWindow, iProgressMonitor);
                }
            });
        }
        catch (Exception exception) {
            logger.error("Cannot create plot required.", (Throwable)exception);
        }
    }

    protected void createCachedData(IProgressMonitor iProgressMonitor) {
        if (this.cachedDataHolder == null) {
            try {
                ProgressMonitorWrapper progressMonitorWrapper = iProgressMonitor != null ? new ProgressMonitorWrapper(iProgressMonitor) : null;
                this.cachedDataHolder = LoaderFactory.getData((String)EclipseUtils.getFilePath((IEditorInput)this.getEditorInput()), (IMonitor)progressMonitorWrapper);
            }
            catch (Exception exception) {
                logger.error("Cannot load data from " + this.getEditorInput().getName(), (Throwable)exception);
                return;
            }
        }
    }

    @Override
    public IDataset getDataSet(String string, IProgressMonitor iProgressMonitor) {
        this.createCachedData(iProgressMonitor);
        return this.cachedDataHolder.getDataset(string);
    }

    @Override
    public boolean isDataSetName(String string, IProgressMonitor iProgressMonitor) {
        this.createCachedData(iProgressMonitor);
        return this.cachedDataHolder.getMap().keySet().contains(string);
    }

    public IDataset getDataSet(Object object, IProgressMonitor iProgressMonitor) {
        if (object instanceof ExpressionObject) {
            try {
                return ((ExpressionObject)object).getDataSet(iProgressMonitor);
            }
            catch (Exception exception) {
                return new DoubleDataset();
            }
        }
        this.createCachedData(iProgressMonitor);
        return this.getDataSet((String)object, iProgressMonitor);
    }

    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
        this.createData(iEditorInput);
    }

    private void createData(IEditorInput iEditorInput) {
        if (this.dataSetPlotView == null) {
            return;
        }
        try {
            IMetaData iMetaData = LoaderFactory.getMetaData((String)EclipseUtils.getFilePath((IEditorInput)iEditorInput), null);
            this.dataSetPlotView.setData(new ArrayList<Object>(iMetaData.getDataNames()), iMetaData.getDataSizes());
            this.dataSetPlotView.refresh();
        }
        catch (Exception exception) {
            logger.error("Cannot open nexus", (Throwable)exception);
        }
    }

    public void setFocus() {
        this.dataSetPlotView.setFocus();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        if (this.cachedDataHolder != null) {
            this.cachedDataHolder.clear();
        }
        if (this.plotWindow != null) {
            this.plotWindow.dispose();
        }
        super.dispose();
    }

    @Override
    public DataSetPlotView getDataSetPlotView() {
        return this.dataSetPlotView;
    }
}

