/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.formattedtext;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Locale;
import org.eclipse.nebula.widgets.formattedtext.AbstractFormatter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.VerifyEvent;

public class NumberFormatter
extends AbstractFormatter {
    private static final char P_DIGIT = '#';
    private static final char P_ZERODIGIT = '0';
    private static final char P_DECIMAL_SEP = '.';
    private static final char P_GROUP_SEP = ',';
    private static final char P_MINUS = '-';
    protected static Hashtable cachedPatterns = new Hashtable();
    protected DecimalFormat nfDisplay;
    protected DecimalFormat nfEdit;
    protected StringBuffer editValue;
    protected Number value;
    protected String editPattern;
    protected Locale locale;
    protected int groupLen = 0;
    protected int intCount = 0;
    protected int intLen = 0;
    protected int decimalLen = 0;
    protected int zeroIntLen = 0;
    protected int zeroDecimalLen = 0;
    protected boolean minus = false;
    protected boolean negative = false;
    protected DecimalFormatSymbols symbols;
    protected boolean nbspSeparator;
    protected boolean alwaysShowDec;
    protected boolean modified;
    protected boolean fixedInt = true;
    protected boolean fixedDec = true;
    protected int prefixLen = 0;
    protected int suffixLen = 0;

    public NumberFormatter() {
        this(null, null, Locale.getDefault());
    }

    public NumberFormatter(Locale loc) {
        this(null, null, loc);
    }

    public NumberFormatter(String editPattern) {
        this(editPattern, null, Locale.getDefault());
    }

    public NumberFormatter(String editPattern, Locale loc) {
        this(editPattern, null, loc);
    }

    public NumberFormatter(String editPattern, String displayPattern) {
        this(editPattern, displayPattern, Locale.getDefault());
    }

    public NumberFormatter(String editPattern, String displayPattern, Locale loc) {
        this.locale = loc;
        this.alwaysShowDec = false;
        this.setPatterns(editPattern, displayPattern, loc);
    }

    protected void clearText(int start, int len) {
        int d;
        if (start < this.prefixLen) {
            len -= this.prefixLen - start;
            start = this.prefixLen;
        }
        if (start + len >= this.editValue.length() - this.suffixLen) {
            len = this.editValue.length() - this.suffixLen - start;
        }
        boolean decimal = (d = this.editValue.indexOf("" + this.symbols.getDecimalSeparator())) >= start && d < start + len;
        int i = 0;
        while (i < len) {
            char c = this.editValue.charAt(start + i);
            if (c >= '0' && c <= '9') {
                if (d < 0 || start + i < d) {
                    --this.intCount;
                }
            } else if (c == this.symbols.getMinusSign()) {
                this.negative = false;
            }
            ++i;
        }
        this.editValue.delete(start, start + len);
        if (decimal && (start < this.editValue.length() || this.alwaysShowDec)) {
            this.editValue.insert(start, this.symbols.getDecimalSeparator());
        }
    }

    /*
     * Unable to fully structure code
     */
    protected int format(int curseur) {
        block25: {
            i = this.prefixLen + (this.negative != false ? 1 : 0);
            while (this.intCount < this.zeroIntLen) {
                this.editValue.insert(i, '0');
                ++this.intCount;
                ++curseur;
            }
            while (this.intCount > this.zeroIntLen) {
                if (this.editValue.charAt(i) == '0') {
                    --this.intCount;
                } else if (this.editValue.charAt(i) != this.symbols.getGroupingSeparator()) break;
                this.editValue.deleteCharAt(i);
                if (curseur <= i) continue;
                --curseur;
            }
            if (this.groupLen > 0) {
                v0 = n = this.intCount > this.groupLen ? this.groupLen - this.intCount % this.groupLen : 0;
                if (n == this.groupLen) {
                    n = 0;
                }
                while (i < this.editValue.length() - this.suffixLen) {
                    c = this.editValue.charAt(i);
                    if (c >= '0' && c <= '9') {
                        if (n == this.groupLen) {
                            this.editValue.insert(i, this.symbols.getGroupingSeparator());
                            if (curseur >= i) {
                                ++curseur;
                            }
                            n = 0;
                        } else {
                            ++n;
                        }
                    } else if (c == this.symbols.getGroupingSeparator()) {
                        if (n != this.groupLen) {
                            this.editValue.deleteCharAt(i);
                            if (curseur >= i) {
                                --curseur;
                            }
                            --i;
                        } else {
                            n = 0;
                        }
                    } else {
                        if (c != this.symbols.getDecimalSeparator() || i <= 0 || this.editValue.charAt(i - 1) != this.symbols.getGroupingSeparator()) break;
                        this.editValue.deleteCharAt(i - 1);
                        if (curseur >= i) {
                            --curseur;
                        }
                        --i;
                        break;
                    }
                    ++i;
                }
            }
            if ((i = this.editValue.indexOf("" + this.symbols.getDecimalSeparator())) < 0 && (this.zeroDecimalLen > 0 || this.alwaysShowDec)) {
                i = this.editValue.length() - this.suffixLen;
                this.editValue.insert(i, this.symbols.getDecimalSeparator());
            }
            if (i < 0) break block25;
            j = i + 1;
            while (j < this.editValue.length() - this.suffixLen) {
                c = this.editValue.charAt(j);
                if (c == this.symbols.getGroupingSeparator()) {
                    this.editValue.deleteCharAt(j);
                    continue;
                }
                if (c < '0' || c > '9') break;
                ++j;
            }
            if (!this.fixedDec || j - i - 1 <= this.decimalLen) ** GOTO lbl76
            this.editValue.delete(i + this.decimalLen + 1, j);
            if (curseur <= i + this.decimalLen) break block25;
            curseur = i + this.decimalLen;
            break block25;
lbl-1000:
            // 1 sources

            {
                this.editValue.insert(j++, '0');
lbl76:
                // 2 sources

                ** while (j - i - 1 < this.zeroDecimalLen)
            }
        }
        return curseur;
    }

    protected String getDefaultPattern(Locale loc) {
        String edit = (String)cachedPatterns.get(loc);
        if (edit == null) {
            int i;
            NumberFormat nf = NumberFormat.getNumberInstance(loc);
            if (!(nf instanceof DecimalFormat)) {
                SWT.error((int)5);
            }
            if ((i = (edit = ((DecimalFormat)nf).toPattern()).indexOf(((DecimalFormat)nf).getDecimalFormatSymbols().getPatternSeparator())) >= 0) {
                edit = edit.substring(0, i);
            }
            cachedPatterns.put(loc, edit);
        }
        return edit;
    }

    public String getDisplayString() {
        return String.valueOf(this.editValue.substring(0, this.prefixLen)) + (this.getValue() != null ? this.nfDisplay.format(this.value) : "") + this.editValue.substring(this.editValue.length() - this.suffixLen);
    }

    public String getEditString() {
        return this.editValue.toString();
    }

    public Object getValue() {
        if (this.modified) {
            try {
                this.value = this.nfEdit.parse(this.editValue.substring(this.prefixLen, this.editValue.length() - this.suffixLen));
            }
            catch (ParseException parseException) {
                if (this.zeroIntLen + this.zeroDecimalLen == 0 && (this.editValue.length() == 0 || this.editValue.charAt(0) == this.symbols.getDecimalSeparator())) {
                    this.modified = false;
                    this.value = new Integer(0);
                }
                return null;
            }
            this.modified = false;
        }
        return this.value;
    }

    public boolean isValid() {
        return this.getValue() != null;
    }

    public void setDecimalSeparatorAlwaysShown(boolean show) {
        this.alwaysShowDec = show;
        int i = this.editValue.lastIndexOf("" + this.symbols.getDecimalSeparator());
        if (this.alwaysShowDec) {
            if (i == -1) {
                this.editValue.append(this.symbols.getDecimalSeparator());
            }
        } else if (i > -1 && i == this.editValue.length() - 1) {
            this.editValue.deleteCharAt(i);
        }
    }

    public void setFixedLengths(boolean fixedInt, boolean fixedDec) {
        this.fixedInt = fixedInt;
        this.fixedDec = fixedDec;
    }

    protected void setPatterns(String edit, String display, Locale loc) {
        this.symbols = new DecimalFormatSymbols(loc);
        boolean bl = this.nbspSeparator = this.symbols.getGroupingSeparator() == '\u00a0';
        if (edit == null) {
            edit = this.getDefaultPattern(loc);
        }
        boolean grouping = false;
        boolean decimal = false;
        this.zeroDecimalLen = 0;
        this.zeroIntLen = 0;
        this.decimalLen = 0;
        this.intLen = 0;
        this.groupLen = 0;
        this.minus = false;
        int i = 0;
        while (i < edit.length()) {
            switch (edit.charAt(i)) {
                case '-': {
                    if (i != 0) {
                        SWT.error((int)5);
                    }
                    this.minus = true;
                    break;
                }
                case ',': {
                    if (!decimal) {
                        grouping = true;
                        this.groupLen = 0;
                        break;
                    }
                    SWT.error((int)5);
                    break;
                }
                case '.': {
                    grouping = false;
                    decimal = true;
                    break;
                }
                case '0': {
                    if (decimal) {
                        ++this.zeroDecimalLen;
                    } else {
                        ++this.zeroIntLen;
                    }
                }
                case '#': {
                    if (decimal) {
                        ++this.decimalLen;
                        break;
                    }
                    ++this.intLen;
                    if (!grouping) break;
                    ++this.groupLen;
                    break;
                }
                default: {
                    SWT.error((int)5);
                }
            }
            ++i;
        }
        this.editPattern = edit;
        this.nfEdit = new DecimalFormat(this.minus ? this.editPattern.substring(1) : this.editPattern, this.symbols);
        this.editValue = new StringBuffer();
        this.nfDisplay = display != null ? new DecimalFormat(display, this.symbols) : this.nfEdit;
        this.intCount = 0;
        i = 0;
        while (i < this.zeroIntLen) {
            this.editValue.append('0');
            ++this.intCount;
            ++i;
        }
        if (this.alwaysShowDec || this.zeroDecimalLen > 0) {
            this.editValue.append(this.symbols.getDecimalSeparator());
        }
        i = 0;
        while (i < this.zeroDecimalLen) {
            this.editValue.append('0');
            ++i;
        }
        this.value = new Long(0L);
    }

    protected void setPrefix(String prefix) {
        if (this.prefixLen > 0) {
            this.editValue.delete(0, this.prefixLen);
            this.prefixLen = 0;
        }
        if (prefix != null) {
            this.editValue.insert(0, prefix);
            this.prefixLen = prefix.length();
        }
    }

    protected void setSuffix(String suffix) {
        if (this.suffixLen > 0) {
            this.editValue.delete(this.editValue.length() - this.suffixLen, this.editValue.length());
            this.suffixLen = 0;
        }
        if (suffix != null) {
            this.editValue.append(suffix);
            this.suffixLen = suffix.length();
        }
    }

    public void setValue(Object value) {
        boolean decimal = false;
        if (value instanceof Number) {
            this.value = (Number)value;
            this.editValue.delete(this.prefixLen, this.editValue.length() - this.suffixLen);
            this.editValue.insert(this.prefixLen, this.nfEdit.format(this.value));
            this.intCount = 0;
            int i = this.prefixLen;
            while (i < this.editValue.length() - this.suffixLen) {
                char c = this.editValue.charAt(i);
                if (c == this.symbols.getDecimalSeparator()) {
                    decimal = true;
                } else if (c >= '0' && c <= '9' && !decimal) {
                    ++this.intCount;
                }
                ++i;
            }
            this.modified = false;
        } else if (value == null) {
            this.clearText(0, this.editValue.length());
            this.updateText(this.editValue.toString(), this.format(0));
        } else {
            throw new IllegalArgumentException("Invalid number value");
        }
    }

    public void verifyText(VerifyEvent e) {
        int p;
        if (this.ignore) {
            return;
        }
        e.doit = false;
        if (e.keyCode == 8 || e.keyCode == 127) {
            this.clearText(e.start, e.end > e.start ? e.end - e.start : 1);
            p = e.start;
        } else {
            if (e.end > e.start) {
                this.clearText(e.start, e.end - e.start);
            }
            p = e.start;
            int d = this.editValue.indexOf("" + this.symbols.getDecimalSeparator());
            int i = 0;
            while (i < e.text.length()) {
                if (p < this.prefixLen || p > this.editValue.length() - this.suffixLen) break;
                char c = e.text.charAt(i);
                if (c >= '0' && c <= '9') {
                    if (d >= 0 && p > d) {
                        if (this.fixedDec && p > d + this.decimalLen) {
                            this.beep();
                            break;
                        }
                    } else {
                        if (this.fixedInt && this.intCount >= this.intLen) {
                            this.beep();
                            break;
                        }
                        ++d;
                        ++this.intCount;
                    }
                    this.editValue.insert(p++, c);
                } else if (this.groupLen > 0 && (c == this.symbols.getGroupingSeparator() || c == ' ' && this.nbspSeparator)) {
                    if (d >= 0 && p > d) {
                        this.beep();
                        break;
                    }
                    int n = this.editValue.indexOf("" + this.symbols.getGroupingSeparator(), p);
                    if (n > p) {
                        p = n + 1;
                    }
                } else if (c == this.symbols.getMinusSign()) {
                    if (p != this.prefixLen || !this.minus) {
                        this.beep();
                        break;
                    }
                    if (this.editValue.length() == 0 || this.editValue.charAt(0) != c) {
                        this.editValue.insert(p++, c);
                        this.negative = true;
                        ++d;
                    } else {
                        this.editValue.deleteCharAt(0);
                        this.negative = false;
                        --d;
                    }
                } else if (!(c != this.symbols.getDecimalSeparator() || this.decimalLen <= 0 && this.fixedDec)) {
                    if (d >= 0) {
                        if (d < p) {
                            this.beep();
                            break;
                        }
                        p = d + 1;
                    } else {
                        d = p;
                        this.editValue.insert(p++, c);
                        this.intCount = 0;
                        int j = 0;
                        while (j < d) {
                            char c1 = this.editValue.charAt(j);
                            if (c1 >= '0' && c1 <= '9') {
                                ++this.intCount;
                            }
                            ++j;
                        }
                    }
                } else {
                    this.beep();
                }
                ++i;
            }
        }
        p = this.format(p);
        this.modified = true;
        this.updateText(this.getEditString(), p);
    }
}

