/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.ui.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public final class FileUtils {
    private static final String NEWFOLDER = "New Folder";
    public static final char BOM;
    private static final int TESTNUM = 1;

    static {
        byte[] byArray = new byte[]{-17, -69, -65};
        String string = " ";
        try {
            string = new String(byArray, 0, 3, "UTF-8");
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not initialize byte order marker");
        }
        BOM = string.charAt(0);
    }

    public static final boolean recursiveDelete(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    if (fileArray[n].isDirectory()) {
                        FileUtils.recursiveDelete(fileArray[n]);
                    }
                    if (fileArray[n].exists()) {
                        fileArray[n].delete();
                    }
                    ++n;
                }
            }
            return file.delete();
        }
        return false;
    }

    public static final void deleteContents(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    FileUtils.recursiveDelete(fileArray[n]);
                }
                fileArray[n].delete();
                ++n;
            }
        }
    }

    public static File getUnique(File file, String string, String string2) {
        String string3 = string2 != null ? (string2.startsWith(".") ? string2 : "." + string2) : null;
        File file2 = new File(file, String.valueOf(string) + string3);
        if (!file2.exists()) {
            return file2;
        }
        return FileUtils.getUnique(file, string, string2, 1);
    }

    public static File getUnique(File file, String string, String string2, int n) {
        File file2;
        String string3 = string2 != null ? (string2.startsWith(".") ? string2 : "." + string2) : null;
        File file3 = file2 = string2 != null ? new File(file, String.valueOf(string) + n + string3) : new File(file, String.valueOf(string) + n);
        if (!file2.exists()) {
            return file2;
        }
        return FileUtils.getUnique(file, string, string2, ++n);
    }

    public static final void recursiveDeleteOnExit(File file) {
        file.deleteOnExit();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    FileUtils.recursiveDeleteOnExit(fileArray[n]);
                }
                fileArray[n].deleteOnExit();
                ++n;
            }
        }
    }

    private static final int getBufferSize() {
        String string = System.getProperty("org.diamond.util.io.fileutils.buffer.size");
        if (string == null) {
            return 4096;
        }
        return Integer.parseInt(string);
    }

    public static final void recursiveCopy(File file, File file2) throws IOException {
        FileUtils.recursiveCopy(file, file2, new byte[FileUtils.getBufferSize()]);
    }

    private static final void recursiveCopy(File file, File file2, byte[] byArray) throws IOException {
        if (file == null || file2 == null) {
            return;
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new IOException("recursiveCopy should only be used for folders!");
        }
        if (file.equals(file2)) {
            throw new IOException("Cannot copy folder on to itself!");
        }
        if (file2.exists()) {
            FileUtils.recursiveDelete(file2);
        }
        file2.mkdirs();
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file3 = fileArray[n];
            File file4 = new File(file2, file3.getName());
            if (file3.isDirectory()) {
                FileUtils.recursiveCopy(file3, file4, byArray);
            } else {
                FileUtils.copy(file3, file4, byArray);
            }
            ++n;
        }
    }

    public static final void recursiveCopyNio(File file, File file2) throws IOException {
        if (file == null || file2 == null) {
            return;
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new IOException("recursiveCopy should only be used for folders!");
        }
        if (file.equals(file2)) {
            throw new IOException("Cannot copy folder on to itself!");
        }
        if (file2.exists()) {
            FileUtils.recursiveDelete(file2);
        }
        file2.mkdirs();
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file3 = fileArray[n];
            File file4 = new File(file2, file3.getName());
            if (file3.isDirectory()) {
                FileUtils.recursiveCopyNio(file3, file4);
            } else {
                FileUtils.copyNio(file3, file4);
            }
            ++n;
        }
    }

    public static final void recursiveCopyNioNoDelete(File file, File file2) throws IOException {
        if (file == null || file2 == null) {
            return;
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new IOException("recursiveCopy should only be used for folders!");
        }
        if (file.equals(file2)) {
            throw new IOException("Cannot copy folder on to itself!");
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file3 = fileArray[n];
            File file4 = new File(file2, file3.getName());
            if (file3.isDirectory()) {
                FileUtils.recursiveCopyNioNoDelete(file3, file4);
            } else {
                FileUtils.copyNioNoCopyOver(file3, file4);
            }
            ++n;
        }
    }

    public static final void recursiveIncrementalCopy(File file, File file2) throws IOException {
        FileUtils.recursiveIncrementalCopy(file, file2, new int[3]);
    }

    public static final void recursiveIncrementalCopy(File file, File file2, int[] nArray) throws IOException {
        FileUtils.recursiveIncrementalCopy(file, file2, nArray, new byte[FileUtils.getBufferSize()]);
    }

    private static final void recursiveIncrementalCopy(File file, File file2, int[] nArray, byte[] byArray) throws IOException {
        if (nArray[2] == -1) {
            return;
        }
        if (file == null || file2 == null || nArray.length < 3) {
            return;
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new IOException("recursiveCopy should only be used for folders!");
        }
        if (file.equals(file2)) {
            throw new IOException("Cannot copy folder on to itself!");
        }
        if (file2.exists()) {
            file2.mkdirs();
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file3 = fileArray[n];
            File file4 = new File(file2, file3.getName());
            if (file3.isDirectory()) {
                FileUtils.recursiveIncrementalCopy(file3, file4, nArray, byArray);
            } else if (file3.lastModified() > file4.lastModified()) {
                FileUtils.copy(file3, file4, byArray);
                nArray[0] = nArray[0] + 1;
            } else {
                nArray[1] = nArray[1] + 1;
            }
            ++n;
        }
    }

    public static final void copy(File file, String string) throws IOException {
        File file2 = null;
        if (file.isDirectory()) {
            file2 = new File(string);
            FileUtils.recursiveCopy(file, file2);
        } else {
            String string2 = file.getName();
            file2 = new File(string, string2);
            FileUtils.copy(file, file2);
        }
    }

    public static final void copy(File file, File file2) throws IOException {
        FileUtils.copy(file, file2, new byte[FileUtils.getBufferSize()]);
    }

    public static final void copy(File file, File file2, byte[] byArray) throws IOException {
        if (!file.exists()) {
            return;
        }
        File file3 = file2.getParentFile();
        if (!file3.exists()) {
            file3.mkdirs();
        }
        if (!file2.exists()) {
            file2.createNewFile();
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = new BufferedInputStream(new FileInputStream(file));
            outputStream = new BufferedOutputStream(new FileOutputStream(file2));
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    public static final void copyNio(File file, File file2) throws IOException {
        if (!file.exists()) {
            return;
        }
        File file3 = file2.getParentFile();
        if (!file3.exists()) {
            file3.mkdirs();
        }
        if (!file2.exists()) {
            file2.createNewFile();
        }
        FileChannel fileChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            fileChannel = new FileInputStream(file).getChannel();
            abstractInterruptibleChannel = new FileOutputStream(file2).getChannel();
            ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
        }
    }

    public static final void copyNioNoCopyOver(File file, File file2) throws IOException {
        if (file2.exists()) {
            return;
        }
        FileUtils.copyNio(file, file2);
    }

    public static final void write(BufferedInputStream bufferedInputStream, File file) throws IOException {
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[FileUtils.getBufferSize()];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            bufferedInputStream.close();
            if (bufferedOutputStream != null) {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
    }

    public static final void write(InputStream inputStream, OutputStream outputStream) throws IOException {
        FilterOutputStream filterOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(inputStream);
            filterOutputStream = new BufferedOutputStream(outputStream);
            byte[] byArray = new byte[FileUtils.getBufferSize()];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    public static final byte[] getByteArrayFromStream(InputStream inputStream) throws IOException {
        return FileUtils.getByteArrayFromStream(inputStream, true);
    }

    public static final byte[] getByteArrayFromStream(InputStream inputStream, boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = FileUtils.getByteStream(inputStream, bl);
        return byteArrayOutputStream.toByteArray();
    }

    public static final ByteArrayOutputStream getByteStream(InputStream inputStream) throws IOException {
        return FileUtils.getByteStream(inputStream, true);
    }

    public static final ByteArrayOutputStream getByteStream(InputStream inputStream, boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            byte[] byArray = new byte[FileUtils.getBufferSize()];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (inputStream != null && bl) {
                inputStream.close();
            }
        }
        return byteArrayOutputStream;
    }

    public static final StringBuffer readFile(File file) throws Exception {
        return FileUtils.readFile(new FileInputStream(file));
    }

    public static final StringBuffer readFile(InputStream inputStream) throws Exception {
        return FileUtils.readFile(inputStream, null);
    }

    public static final StringBuffer readFile(InputStream inputStream, String string) throws Exception {
        BufferedReader bufferedReader = null;
        try {
            int n;
            bufferedReader = string != null ? new BufferedReader(new InputStreamReader(inputStream, string)) : new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[4096];
            while ((n = bufferedReader.read(cArray, 0, 4096)) > 0) {
                stringBuffer.append(cArray, 0, n);
            }
            StringBuffer stringBuffer2 = stringBuffer;
            return stringBuffer2;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public static final List<String> readFileAsList(File file) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            String string;
            FileReader fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return arrayList;
    }

    public static final List<String> readFileAsList(File file, String string, boolean bl, boolean bl2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string));
        ArrayList<String> arrayList = new ArrayList<String>(33);
        try {
            String string2;
            boolean bl3 = false;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (bl && !bl3) {
                    bl3 = true;
                    char c = string2.charAt(0);
                    if (c == BOM) {
                        string2 = string2.substring(1);
                    }
                }
                if (bl2) {
                    arrayList.add(string2.trim());
                    continue;
                }
                arrayList.add(string2);
            }
        }
        finally {
            ((Reader)bufferedReader).close();
            ((InputStream)fileInputStream).close();
        }
        return arrayList;
    }

    public static boolean isUnix(String string) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringBuffer.length()) {
            if (n >= 1) {
                bl = true;
                break;
            }
            if (n2 >= 1) {
                bl = false;
                break;
            }
            if (stringBuffer.charAt(n3) == '\n' && (n3 == 0 || stringBuffer.charAt(n3 - 1) != '\r')) {
                ++n;
            } else if (stringBuffer.charAt(n3) == '\n' && (n3 == 0 || stringBuffer.charAt(n3 - 1) == '\r')) {
                ++n2;
            }
            ++n3;
        }
        return bl;
    }

    public static boolean isBOM(String string) {
        if (string == null) {
            return false;
        }
        if ("".equals(string)) {
            return false;
        }
        return string.charAt(0) == BOM;
    }

    public static void write(File file, String string, String string2) throws Exception {
        BufferedWriter bufferedWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string2);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(string.toCharArray());
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    public static void write(File file, String string) throws Exception {
        FileUtils.write(file, string, "US-ASCII");
    }

    public static void write(OutputStream outputStream, String string, String string2, boolean bl) throws Exception {
        BufferedWriter bufferedWriter = null;
        try {
            if (bl && string.charAt(0) != BOM) {
                string = String.valueOf(BOM) + string;
            }
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string2));
            bufferedWriter.write(string.toCharArray());
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    public static void write(File file, List<String> list) throws Exception {
        BufferedWriter bufferedWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            int n = 0;
            while (n < list.size()) {
                String string = list.get(n);
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
                ++n;
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    public static File createNewUniqueDir(File file) {
        return FileUtils.createNewUniqueDir(file, NEWFOLDER);
    }

    public static File createNewUniqueDir(File file, String string) {
        File file2 = new File(file, string);
        if (file2.exists()) {
            int n = 2;
            while (file2.exists()) {
                file2 = new File(file, String.valueOf(string) + " (" + n + ")");
                ++n;
            }
        }
        file2.mkdirs();
        return file2;
    }

    public static final String getParentDirName(String string) {
        int n = string.lastIndexOf("/");
        String string2 = n > -1 ? string.substring(0, n) : "/";
        if (!string2.endsWith("/")) {
            string2 = String.valueOf(string2) + "/";
        }
        return string2;
    }

    public static final void writeToFile(File file, InputStream inputStream) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        try {
            int n;
            byte[] byArray = new byte[FileUtils.getBufferSize()];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
    }

    public static long getDiskSpace(File file) {
        long l = 0L;
        if (file.isDirectory()) {
            File[] fileArray;
            File[] fileArray2 = fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                l += FileUtils.getDiskSpace(file2);
                ++n2;
            }
        } else {
            l += file.length();
        }
        return l;
    }

    public static boolean isDiskSpaceAvaliableMB(File file, long l) throws IOException {
        return FileUtils.isDiskSpaceAvaliable(file, l * 1000000L);
    }

    public static boolean isDiskSpaceAvaliable(File file, long l) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.setLength(l);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            file.delete();
        }
    }

    public static long getFileSizeRecursive(File file, boolean bl) {
        long l = 0L;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                File[] fileArray2 = fileArray;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    long l2;
                    File file2 = fileArray2[n2];
                    if ((bl || !file2.isDirectory()) && (l2 = FileUtils.getFileSizeRecursive(file2, bl)) != -1L) {
                        l += l2;
                    }
                    ++n2;
                }
                return l;
            }
            return -1L;
        }
        return file.length();
    }

    public static String getFileExtension(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? "" : string.substring(n + 1);
    }

    public static String getFileExtension(File file) {
        return FileUtils.getFileExtension(file.getName());
    }

    public static String getFileNameNoExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        return n == -1 ? string : string.substring(0, n);
    }

    public static String formatSize(long l, int n) {
        double d;
        double d2;
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        if (n >= 0) {
            numberFormat.setMaximumFractionDigits(n);
        }
        if ((d2 = (d = (double)l) / 1.073741824E9) > 1.0) {
            return numberFormat.format(d2).concat(" GB");
        }
        d2 = d / 1048576.0;
        if (d2 > 1.0) {
            return numberFormat.format(d2).concat(" MB");
        }
        d2 = d / 1024.0;
        if (d2 > 10.0) {
            return numberFormat.format(d2).concat(" KB");
        }
        return numberFormat.format(d).concat(" bytes");
    }
}

