/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.Host;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.srb.SRBCommands;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import edu.sdsc.grid.io.srb.SRBProtocol;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Vector;

class SRBMetaDataCommands {
    private SRBCommands commands;

    SRBMetaDataCommands(SRBCommands commands) throws IOException {
        this.commands = commands;
    }

    protected void finalize() {
        if (this.commands != null) {
            this.commands = null;
        }
    }

    static String getOperator(MetaDataCondition condition) {
        return MetaDataCondition.getOperatorString(condition.getOperator());
    }

    static String getOperator(int condition) {
        return MetaDataCondition.getOperatorString(condition);
    }

    private String quotes(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                return "";
            }
        }
        return "'";
    }

    private String fixLIKE(String value) {
        String temp = value;
        int index = value.indexOf("*");
        while (index >= 0) {
            value = String.valueOf(value.substring(0, index)) + "%" + value.substring(index + 1);
            index = value.indexOf("*");
        }
        index = value.indexOf("?");
        while (index >= 0) {
            value = String.valueOf(value.substring(0, index)) + "_" + value.substring(index + 1);
            index = value.indexOf("?");
        }
        if (value.indexOf("%") < 0 && value.indexOf("_") < 0) {
            value = "%" + value + "%";
        }
        return value;
    }

    private MetaDataTable fixLIKE(MetaDataTable table, boolean hasLike) {
        int rowCount = table.getRowCount();
        int columnCount = table.getColumnCount();
        int index = -1;
        int i = 0;
        while (i < rowCount) {
            int j = 0;
            while (j < columnCount) {
                if (j == 1 && table.getOperator(i) == 10 || j == 0 && hasLike) {
                    String value;
                    String temp = value = table.getStringValue(i, j);
                    index = value.indexOf("*");
                    while (index >= 0) {
                        value = String.valueOf(value.substring(0, index)) + "%" + value.substring(index + 1);
                        index = value.indexOf("*");
                    }
                    index = value.indexOf("?");
                    while (index >= 0) {
                        value = String.valueOf(value.substring(0, index)) + "_" + value.substring(index + 1);
                        index = value.indexOf("?");
                    }
                    if (value.indexOf("%") < 0 && value.indexOf("_") < 0) {
                        value = "%" + value + "%";
                    }
                    if (!temp.equals(value)) {
                        table.setStringValue(i, j, value);
                    }
                }
                ++j;
            }
            ++i;
        }
        return table;
    }

    private void setTableQval(MetaDataTable table, char[][] qVal, String fieldName) {
        String queryStatement = new String(" = '" + table.getStringValue(0, 0) + "'");
        System.arraycopy(queryStatement.toCharArray(), 0, qVal[SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "0_1")], 0, queryStatement.length());
        queryStatement = new String(String.valueOf(SRBMetaDataCommands.getOperator(table.getOperator(0))) + " '" + table.getStringValue(0, 1) + "'");
        System.arraycopy(queryStatement.toCharArray(), 0, qVal[SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "1_1")], 0, queryStatement.length());
        if (table.getRowCount() >= 2) {
            queryStatement = new String(" = '" + table.getStringValue(1, 0) + "'");
            System.arraycopy(queryStatement.toCharArray(), 0, qVal[SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "0_2")], 0, queryStatement.length());
            queryStatement = new String(String.valueOf(SRBMetaDataCommands.getOperator(table.getOperator(1))) + " '" + table.getStringValue(1, 1) + "'");
            System.arraycopy(queryStatement.toCharArray(), 0, qVal[SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "1_2")], 0, queryStatement.length());
        }
        if (table.getRowCount() >= 3) {
            queryStatement = new String(" = '" + table.getStringValue(2, 0) + "'");
            System.arraycopy(queryStatement.toCharArray(), 0, qVal[SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "0_3")], 0, queryStatement.length());
            queryStatement = new String(String.valueOf(SRBMetaDataCommands.getOperator(table.getOperator(2))) + " '" + table.getStringValue(2, 1) + "'");
            System.arraycopy(queryStatement.toCharArray(), 0, qVal[SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "1_3")], 0, queryStatement.length());
        }
        if (table.getRowCount() >= 4) {
            queryStatement = new String(" = '" + table.getStringValue(3, 0) + "'");
            System.arraycopy(queryStatement.toCharArray(), 0, qVal[SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "0_4")], 0, queryStatement.length());
            queryStatement = new String(String.valueOf(SRBMetaDataCommands.getOperator(table.getOperator(3))) + " " + "'" + table.getStringValue(3, 1) + "'");
            System.arraycopy(queryStatement.toCharArray(), 0, qVal[SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "1_4")], 0, queryStatement.length());
        }
        if ((fieldName.equals("definable metadata for files") || fieldName.equals("definable metadata for directories")) && table.getRowCount() >= 5) {
            queryStatement = new String(" = '" + table.getStringValue(4, 0) + "'");
            System.arraycopy(queryStatement.toCharArray(), 0, qVal[SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "0_5")], 0, queryStatement.length());
            queryStatement = new String(String.valueOf(SRBMetaDataCommands.getOperator(table.getOperator(4))) + " '" + table.getStringValue(4, 1) + "'");
            System.arraycopy(queryStatement.toCharArray(), 0, qVal[SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "1_5")], 0, queryStatement.length());
        }
    }

    private String setTableGenQuery(MetaDataTable table, MetaDataCondition condition) {
        if (table == null) {
            return "";
        }
        String fieldName = condition.getFieldName();
        String operator = SRBMetaDataCommands.getOperator(condition);
        String queryStatement = new String("'" + table.getStringValue(0, 0) + "'\u0000");
        SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "0_1");
        queryStatement = String.valueOf(queryStatement) + new String(" " + SRBMetaDataCommands.getOperator(table.getOperator(0)) + " '" + table.getStringValue(0, 1) + "'\u0000");
        SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "1_1");
        if (table.getRowCount() >= 2) {
            queryStatement = String.valueOf(queryStatement) + new String(" " + operator + " '" + table.getStringValue(1, 0) + "'\u0000");
            SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "0_2");
            queryStatement = String.valueOf(queryStatement) + new String(" " + SRBMetaDataCommands.getOperator(table.getOperator(1)) + " '" + table.getStringValue(1, 1) + "'\u0000");
            SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "1_2");
            if (table.getRowCount() >= 3) {
                queryStatement = String.valueOf(queryStatement) + new String(" " + operator + " '" + table.getStringValue(2, 0) + "'\u0000");
                SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "0_3");
                queryStatement = String.valueOf(queryStatement) + new String(" " + SRBMetaDataCommands.getOperator(table.getOperator(2)) + " '" + table.getStringValue(2, 1) + "'\u0000");
                SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "1_3");
                if (table.getRowCount() >= 4) {
                    queryStatement = String.valueOf(queryStatement) + new String(" " + operator + " '" + table.getStringValue(3, 0) + "'\u0000");
                    SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "0_4");
                    queryStatement = String.valueOf(queryStatement) + new String(" " + SRBMetaDataCommands.getOperator(table.getOperator(3)) + " " + "'" + table.getStringValue(3, 1) + "'\u0000");
                    SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "1_4");
                    if ((fieldName.equals("definable metadata for files") || fieldName.equals("definable metadata for directories")) && table.getRowCount() >= 5) {
                        queryStatement = String.valueOf(queryStatement) + new String(" " + operator + " '" + table.getStringValue(4, 0) + "'\u0000");
                        SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "0_5");
                        queryStatement = String.valueOf(queryStatement) + new String(" " + SRBMetaDataCommands.getOperator(table.getOperator(4)) + " '" + table.getStringValue(4, 1) + "'\u0000");
                        SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "1_5");
                    }
                }
            }
        }
        return queryStatement;
    }

    private int[] setTableConditionIDs(MetaDataTable table, String fieldName) {
        int[] ids = null;
        int size = table.getRowCount();
        if (size < 5) {
            ids = new int[size * 2];
        } else if (fieldName.equals("definable metadata for files") || fieldName.equals("definable metadata for directories")) {
            ids = new int[10];
        }
        ids[0] = SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "0_1");
        ids[1] = SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "1_1");
        if (ids.length >= 4) {
            ids[2] = SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "0_2");
            ids[3] = SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "1_2");
            if (ids.length >= 6) {
                ids[4] = SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "0_3");
                ids[5] = SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "1_3");
                if (ids.length >= 8) {
                    ids[6] = SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "0_4");
                    ids[7] = SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "1_4");
                    if (ids.length >= 10) {
                        ids[8] = SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "0_5");
                        ids[9] = SRBMetaDataSet.getSRBID(String.valueOf(fieldName) + "1_5");
                    }
                }
            }
        }
        return ids;
    }

    private SRBMetaDataRecordList[] joinRecordLists(SRBMetaDataRecordList[] firstRecordList, SRBMetaDataRecordList[] secondRecordList, String comparator, String comparator2) {
        int i = 0;
        int j = 0;
        int k = 0;
        boolean[] nullValues = null;
        int totalNull = 0;
        SRBMetaDataRecordList[] totalRecordList = null;
        if (comparator != null && firstRecordList != null && secondRecordList != null) {
            nullValues = new boolean[secondRecordList.length];
            i = 0;
            while (i < firstRecordList.length) {
                int matchingID = -1;
                int matchingID2 = -1;
                j = 0;
                while (j < firstRecordList[i].getFieldCount()) {
                    if (firstRecordList[i].getField(j).equals(MetaDataSet.getField(comparator))) {
                        k = 0;
                        while (k < secondRecordList.length) {
                            int tempK = k;
                            int l = 0;
                            while (l < secondRecordList[tempK].getFieldCount()) {
                                if (firstRecordList[i].getValue(j).equals(secondRecordList[k].getValue(l)) && secondRecordList[k].getField(l).equals(MetaDataSet.getField(comparator))) {
                                    matchingID = k;
                                    if (comparator2 != null) {
                                        int jj = 0;
                                        while (jj < firstRecordList[i].getFieldCount()) {
                                            if (firstRecordList[i].getField(jj).equals(MetaDataSet.getField(comparator2))) {
                                                int ll = 0;
                                                while (ll < secondRecordList[k].getFieldCount()) {
                                                    if (firstRecordList[i].getValue(jj).equals(secondRecordList[k].getValue(ll))) {
                                                        matchingID2 = k;
                                                    }
                                                    ++ll;
                                                }
                                            }
                                            ++jj;
                                        }
                                    }
                                }
                                ++l;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                if (matchingID >= 0 && (comparator2 == null || comparator2 != null && matchingID == matchingID2)) {
                    firstRecordList[i].combineRecordLists(secondRecordList[matchingID]);
                    nullValues[matchingID] = true;
                    ++totalNull;
                }
                ++i;
            }
            if (totalNull > secondRecordList.length) {
                totalRecordList = firstRecordList;
            } else {
                totalRecordList = new SRBMetaDataRecordList[firstRecordList.length + secondRecordList.length - totalNull];
                System.arraycopy(firstRecordList, 0, totalRecordList, 0, firstRecordList.length);
                System.arraycopy(secondRecordList, 0, totalRecordList, firstRecordList.length, secondRecordList.length - totalNull);
                if (nullValues != null) {
                    i = 0;
                    k = 0;
                    while (i < secondRecordList.length) {
                        if (!nullValues[i]) {
                            totalRecordList[firstRecordList.length + k] = secondRecordList[i];
                            ++k;
                        }
                        ++i;
                    }
                }
            }
            return totalRecordList;
        }
        if (comparator == null && firstRecordList != null && secondRecordList != null) {
            totalRecordList = new SRBMetaDataRecordList[firstRecordList.length + secondRecordList.length - totalNull];
            System.arraycopy(firstRecordList, 0, totalRecordList, 0, firstRecordList.length);
            System.arraycopy(secondRecordList, 0, totalRecordList, firstRecordList.length, secondRecordList.length - totalNull);
            return totalRecordList;
        }
        if (firstRecordList == null) {
            return secondRecordList;
        }
        if (secondRecordList == null) {
            return firstRecordList;
        }
        return null;
    }

    private SRBMetaDataRecordList[] getRecordsForDefinableQueries(int catType, MetaDataCondition[] conditions, MetaDataSelect[] selects, int rowsWanted, SRBMetaDataRecordList[] firstRecordList, boolean orderBy, boolean nonDistinct) throws IOException {
        SRBMetaDataRecordList[] secondRecordList = null;
        secondRecordList = this.srbGetDataDirInfo(catType, conditions, selects, rowsWanted, orderBy, nonDistinct);
        if (secondRecordList != null) {
            int i = 0;
            while (i < secondRecordList.length) {
                secondRecordList[i].setContinuationIndex(-1);
                ++i;
            }
            if (firstRecordList != null && secondRecordList != null) {
                secondRecordList = this.joinRecordLists(firstRecordList, secondRecordList, null, null);
            }
            return secondRecordList;
        }
        return null;
    }

    static final Object[] cleanNulls(Object[] obj) {
        Vector<Object> temp = new Vector<Object>(obj.length);
        boolean add = true;
        int i = 0;
        int j = 0;
        i = 0;
        while (i < obj.length) {
            if (obj[i] != null) {
                j = i + 1;
                while (j < obj.length) {
                    if (obj[i].equals(obj[j])) {
                        add = false;
                        j = obj.length;
                    }
                    ++j;
                }
                if (add) {
                    temp.add(obj[i]);
                }
                add = true;
            }
            ++i;
        }
        i = 0;
        while (i < obj.length) {
            if (obj[i] != null) {
                return temp.toArray((Object[])Array.newInstance(obj[i].getClass(), 0));
            }
            ++i;
        }
        return null;
    }

    private String addValueByStyle(int style, MetaDataCondition condition, char[][] qVal) {
        String qValCondition = "";
        block0 : switch (style) {
            case 0: {
                switch (condition.getFieldType()) {
                    case 3: 
                    case 4: {
                        qValCondition = String.valueOf(qValCondition) + "'" + condition.getStringValue() + "'";
                        break block0;
                    }
                    case 0: {
                        qValCondition = String.valueOf(qValCondition) + condition.getIntValue();
                        break block0;
                    }
                    case 2: {
                        qValCondition = String.valueOf(qValCondition) + condition.getFloatValue();
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid value type for the metadata attribute: " + condition.getField());
            }
            case 1: {
                switch (condition.getFieldType()) {
                    case 3: 
                    case 4: {
                        qValCondition = String.valueOf(qValCondition) + "'" + condition.getStringValue(0) + "' and " + "'" + condition.getStringValue(1) + "'";
                        break block0;
                    }
                    case 0: {
                        qValCondition = String.valueOf(qValCondition) + condition.getIntValue(0) + " and " + condition.getIntValue(1);
                        break block0;
                    }
                    case 2: {
                        qValCondition = String.valueOf(qValCondition) + condition.getFloatValue(0) + " and " + condition.getFloatValue(1);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid value type for the metadata attribute: " + condition.getField());
            }
            case 2: {
                switch (condition.getFieldType()) {
                    case 3: 
                    case 4: {
                        qValCondition = String.valueOf(qValCondition) + "(";
                        int i = 0;
                        while (i < condition.getCount()) {
                            qValCondition = String.valueOf(qValCondition) + "'" + condition.getStringValue(i) + "',";
                            ++i;
                        }
                        break;
                    }
                    case 0: {
                        qValCondition = String.valueOf(qValCondition) + "(";
                        int i = 0;
                        while (i < condition.getCount()) {
                            qValCondition = String.valueOf(qValCondition) + condition.getIntValue(i) + ",";
                            ++i;
                        }
                        break;
                    }
                    case 2: {
                        qValCondition = String.valueOf(qValCondition) + "(";
                        int i = 0;
                        while (i < condition.getCount()) {
                            qValCondition = String.valueOf(qValCondition) + condition.getFloatValue(i) + ",";
                            ++i;
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid value type for the metadata attribute: " + condition.getField());
                    }
                }
                qValCondition = String.valueOf(qValCondition.substring(0, qValCondition.length() - 1)) + ")";
                break;
            }
            case 14: {
                MetaDataTable table = condition.getTableValue();
                if (qVal == null) {
                    qValCondition = String.valueOf(qValCondition) + this.setTableGenQuery(table, condition);
                } else {
                    this.setTableQval(table, qVal, condition.getFieldName());
                }
                table.getRowCount();
                break;
            }
            default: {
                throw new RuntimeException("temp SRBMetaDataCommands.getdatadir,style");
            }
        }
        return qValCondition;
    }

    synchronized SRBMetaDataRecordList[] srbGetDataDirInfo(int catType, MetaDataCondition[] metaDataConditions, MetaDataSelect[] metaDataSelects, int rowsWanted, boolean orderBy, boolean nonDistinct) throws IOException {
        if (this.commands.versionNumber >= 3.0f) {
            return this.srbGenQuery(catType, this.commands.getZone(), metaDataConditions, metaDataSelects, rowsWanted, orderBy, nonDistinct);
        }
        int i = 0;
        int j = 0;
        boolean k = false;
        int conditionsLength = metaDataConditions.length;
        int selectsLength = metaDataSelects.length;
        Object[] conditions = new MetaDataCondition[conditionsLength];
        Object[] selects = new MetaDataSelect[selectsLength];
        System.arraycopy(metaDataConditions, 0, conditions, 0, conditionsLength);
        System.arraycopy(metaDataSelects, 0, selects, 0, selectsLength);
        conditions = (MetaDataCondition[])SRBMetaDataCommands.cleanNulls(conditions);
        if (conditions == null) {
            return null;
        }
        conditionsLength = conditions.length;
        if ((selects = (MetaDataSelect[])SRBMetaDataCommands.cleanNulls(selects)) == null) {
            return null;
        }
        selectsLength = selects.length;
        try {
            int fieldID;
            char[][] qVal = new char[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES][SRBFileSystem.MAX_TOKEN];
            int[] selVal = new int[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES];
            SRBMetaDataRecordList[] firstRecordList = null;
            SRBMetaDataRecordList[] secondRecordList = null;
            SRBMetaDataRecordList[] totalRecordList = null;
            i = 0;
            while (i < conditionsLength) {
                if (conditions[i] != null) {
                    int style = ((MetaDataCondition)conditions[i]).getStyle();
                    String queryStatement = "";
                    fieldID = SRBMetaDataSet.getSRBID(((MetaDataCondition)conditions[i]).getFieldName());
                    if (style != 14) {
                        queryStatement = String.valueOf(SRBMetaDataCommands.getOperator((MetaDataCondition)conditions[i])) + " " + queryStatement;
                    }
                    queryStatement = String.valueOf(queryStatement) + this.addValueByStyle(style, (MetaDataCondition)conditions[i], qVal);
                    if (style != 14) {
                        System.arraycopy(queryStatement.toCharArray(), 0, qVal[fieldID], 0, queryStatement.length());
                    }
                }
                ++i;
            }
            int continuationIndex = -1;
            String comparator = null;
            String comparator2 = null;
            i = 0;
            while (i < selectsLength) {
                if (selects[i] != null) {
                    fieldID = SRBMetaDataSet.getSRBID(((MetaDataSelect)selects[i]).getFieldName());
                    if (fieldID == -1) {
                        selects[i] = MetaDataSet.newSelection("file name");
                        selects = MetaDataSet.mergeSelects(MetaDataSet.newSelection("directory name"), (MetaDataSelect[])selects);
                        secondRecordList = this.getRecordsForDefinableQueries(catType, (MetaDataCondition[])conditions, (MetaDataSelect[])selects, rowsWanted, firstRecordList, orderBy, nonDistinct);
                        selVal = new int[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES];
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata file0")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata file1")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata file2")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata file3")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata file4")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata file5")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata file6")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata file7")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata file8")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata file9")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"file name")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"directory name")] = 0x1000000;
                        comparator = "file name";
                        comparator2 = "directory name";
                        break;
                    }
                    if (fieldID == -2) {
                        selects[i] = MetaDataSet.newSelection("directory name");
                        secondRecordList = this.getRecordsForDefinableQueries(catType, (MetaDataCondition[])conditions, (MetaDataSelect[])selects, rowsWanted, firstRecordList, orderBy, nonDistinct);
                        selVal = new int[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES];
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata directory0")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata directory1")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata directory2")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata directory3")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata directory4")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata directory5")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata directory6")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata directory7")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata directory8")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata directory9")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"directory name")] = 0x1000000;
                        break;
                    }
                    if (fieldID == -3) {
                        selects[i] = MetaDataSet.newSelection("user name");
                        selects = MetaDataSet.mergeSelects(MetaDataSet.newSelection("user domain"), (MetaDataSelect[])selects);
                        secondRecordList = this.getRecordsForDefinableQueries(catType, (MetaDataCondition[])conditions, (MetaDataSelect[])selects, rowsWanted, firstRecordList, orderBy, nonDistinct);
                        selVal = new int[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES];
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata user0")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata user1")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata user2")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata user3")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata user4")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata user5")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata user6")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata user7")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata user8")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata user9")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"user name")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"user domain")] = 0x1000000;
                        break;
                    }
                    if (fieldID == -4) {
                        selects[i] = MetaDataSet.newSelection("resource name");
                        secondRecordList = this.getRecordsForDefinableQueries(catType, (MetaDataCondition[])conditions, (MetaDataSelect[])selects, rowsWanted, firstRecordList, orderBy, nonDistinct);
                        selVal = new int[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES];
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata resource0")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata resource1")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata resource2")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata resource3")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata resource4")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata resource5")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata resource6")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata resource7")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata resource8")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"definable metadata resource9")] = 0x1000000;
                        selVal[SRBMetaDataSet.getSRBID((String)"resource name")] = 0x1000000;
                        break;
                    }
                    selVal[fieldID] = 0x1000000;
                }
                ++i;
            }
            this.commands.startSRBCommand(2101, 4);
            this.commands.sendArg(catType);
            this.commands.sendArg(qVal);
            this.commands.sendArg(selVal);
            this.commands.sendArg(rowsWanted);
            this.commands.flush();
            this.commands.commandStatus();
            firstRecordList = this.commands.returnSRBMetaDataRecordList();
            if (secondRecordList != null) {
                if (firstRecordList != null) {
                    j = 0;
                    while (j < firstRecordList.length) {
                        if (continuationIndex < firstRecordList[j].getContinuationIndex()) {
                            continuationIndex = firstRecordList[j].getContinuationIndex();
                            firstRecordList = this.joinRecordLists(firstRecordList, this.commands.srbGetMoreRows(catType, continuationIndex, rowsWanted), comparator, comparator2);
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < firstRecordList.length) {
                        firstRecordList[j].setContinuationIndex(-1);
                        ++j;
                    }
                }
                totalRecordList = this.joinRecordLists(secondRecordList, firstRecordList, comparator, comparator2);
            } else {
                totalRecordList = firstRecordList;
            }
            return totalRecordList;
        }
        catch (SRBException e) {
            if (e.getType() == -3005) {
                return null;
            }
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SRBMetaDataRecordList[] srbGenQuery(int catType, String myMcatZone, MetaDataCondition[] metaDataConditions, MetaDataSelect[] metaDataSelects, int rowsWanted, boolean orderBy, boolean nonDistinct) throws IOException {
        String banana;
        if (SRBCommands.DEBUG > 0) {
            System.out.println("\n srbGenQuery");
        }
        int i = 0;
        int j = 0;
        int temp = 0;
        int fieldID = Integer.MIN_VALUE;
        boolean extensible = false;
        SRBMetaDataRecordList[] firstRecordList = null;
        SRBMetaDataRecordList[] secondRecordList = null;
        SRBMetaDataRecordList[] totalRecordList = null;
        byte[] packedQuery = new byte[999];
        int conditionsLength = 0;
        if (metaDataConditions != null) {
            metaDataConditions = (MetaDataCondition[])SRBMetaDataCommands.cleanNulls(metaDataConditions);
            conditionsLength = metaDataConditions.length;
            i = 0;
            while (i < conditionsLength) {
                if (metaDataConditions[i].getStyle() == 14) {
                    metaDataConditions[i] = metaDataConditions[i].getOperator() == 10 ? MetaDataSet.newCondition(metaDataConditions[i].getFieldName(), metaDataConditions[i].getOperator(), this.fixLIKE(metaDataConditions[i].getTableValue(), true)) : MetaDataSet.newCondition(metaDataConditions[i].getFieldName(), metaDataConditions[i].getOperator(), this.fixLIKE(metaDataConditions[i].getTableValue(), false));
                } else if (metaDataConditions[i].getOperator() == 10) {
                    metaDataConditions[i] = MetaDataSet.newCondition(metaDataConditions[i].getFieldName(), 10, this.fixLIKE(metaDataConditions[i].getStringValue()));
                }
                ++i;
            }
        }
        int selectsLength = metaDataSelects.length;
        Object[] conditions = null;
        Object[] selects = new MetaDataSelect[selectsLength];
        int[] conditionIDs = null;
        if (conditionsLength > 0) {
            conditions = new MetaDataCondition[conditionsLength];
            System.arraycopy(metaDataConditions, 0, conditions, 0, conditionsLength);
        }
        System.arraycopy(metaDataSelects, 0, selects, 0, selectsLength);
        if (conditions != null) {
            conditions = (MetaDataCondition[])SRBMetaDataCommands.cleanNulls(conditions);
            conditionsLength = conditions.length;
            i = 0;
            while (i < conditions.length) {
                if (SRBCommands.DEBUG > 3) {
                    System.out.println("conditions\t\t " + ((MetaDataCondition)conditions[i]).getFieldName() + " " + ((MetaDataCondition)conditions[i]).getStringValue());
                }
                if (((MetaDataCondition)conditions[i]).getStyle() == 14) {
                    int rowCount = ((MetaDataCondition)conditions[i]).getTableValue().getRowCount();
                    conditionsLength = rowCount >= 5 ? (((MetaDataCondition)conditions[i]).getFieldName().equals("definable metadata for files") || ((MetaDataCondition)conditions[i]).getFieldName().equals("definable metadata for directories") ? (conditionsLength += 5 * ((MetaDataCondition)conditions[i]).getTableValue().getColumnCount() - 1) : (conditionsLength += 4 * ((MetaDataCondition)conditions[i]).getTableValue().getColumnCount() - 1)) : (conditionsLength += rowCount * ((MetaDataCondition)conditions[i]).getTableValue().getColumnCount() - 1);
                }
                ++i;
            }
            if (conditionsLength > 0) {
                temp = 0;
                conditionIDs = new int[conditionsLength];
                i = 0;
                while (i < conditions.length) {
                    if (conditions[i] != null) {
                        if (((MetaDataCondition)conditions[i]).getStyle() == 14) {
                            int[] conIDs = this.setTableConditionIDs(((MetaDataCondition)conditions[i]).getTableValue(), ((MetaDataCondition)conditions[i]).getFieldName());
                            System.arraycopy(conIDs, 0, conditionIDs, temp, conIDs.length);
                            temp += conIDs.length;
                        } else {
                            conditionIDs[i] = SRBMetaDataSet.getSRBID(((MetaDataCondition)conditions[i]).getFieldName());
                            if (conditionIDs[i] == -5) {
                                extensible = true;
                            }
                            ++temp;
                        }
                    }
                    ++i;
                }
            }
        } else {
            conditionsLength = 0;
        }
        if ((selects = (MetaDataSelect[])SRBMetaDataCommands.cleanNulls(selects)) == null) {
            return null;
        }
        selectsLength = selects.length;
        int[] selectsIDs = new int[selectsLength];
        int[] selectsValues = new int[selectsLength];
        int continuationIndex = -1;
        String comparator = null;
        String comparator2 = null;
        temp = selectsLength;
        i = 0;
        while (i < temp) {
            MetaDataSelect[] tempSelects;
            fieldID = SRBMetaDataSet.getSRBID(((MetaDataSelect)selects[i]).getFieldName());
            if (fieldID > 0) {
                selectsIDs[i] = fieldID;
                selectsValues[i] = ((MetaDataSelect)selects[i]).getOperation();
            } else if (fieldID == -1) {
                if ((double)this.commands.versionNumber >= 3.31) {
                    selects[i] = null;
                    tempSelects = new MetaDataSelect[]{MetaDataSet.newSelection("metadata number"), MetaDataSet.newSelection("file name"), MetaDataSet.newSelection("directory name"), MetaDataSet.newSelection("definable metadata file0"), MetaDataSet.newSelection("definable metadata file1"), MetaDataSet.newSelection("definable metadata file2"), MetaDataSet.newSelection("definable metadata file3"), MetaDataSet.newSelection("definable metadata file4"), MetaDataSet.newSelection("definable metadata file5"), MetaDataSet.newSelection("definable metadata file6"), MetaDataSet.newSelection("definable metadata file7"), MetaDataSet.newSelection("definable metadata file8"), MetaDataSet.newSelection("definable metadata file9")};
                    selects = MetaDataSet.mergeSelects((MetaDataSelect[])selects, tempSelects);
                    if ((selects = (MetaDataSelect[])SRBMetaDataCommands.cleanNulls(selects)) == null) {
                        return null;
                    }
                    i = -1;
                    temp = selectsLength = selects.length;
                    selectsIDs = new int[selectsLength];
                    selectsValues = new int[selectsLength];
                } else {
                    selects[i] = MetaDataSet.newSelection("file name");
                    selects = MetaDataSet.mergeSelects(MetaDataSet.newSelection("directory name"), (MetaDataSelect[])selects);
                    secondRecordList = this.getRecordsForDefinableQueries(catType, (MetaDataCondition[])conditions, (MetaDataSelect[])selects, rowsWanted, firstRecordList, orderBy, nonDistinct);
                    selectsLength = 12;
                    selectsIDs = new int[selectsLength];
                    selectsValues = new int[selectsLength];
                    selectsIDs[0] = SRBMetaDataSet.getSRBID("file name");
                    selectsIDs[1] = SRBMetaDataSet.getSRBID("directory name");
                    selectsIDs[2] = SRBMetaDataSet.getSRBID("definable metadata file0");
                    selectsIDs[3] = SRBMetaDataSet.getSRBID("definable metadata file1");
                    selectsIDs[4] = SRBMetaDataSet.getSRBID("definable metadata file2");
                    selectsIDs[5] = SRBMetaDataSet.getSRBID("definable metadata file3");
                    selectsIDs[6] = SRBMetaDataSet.getSRBID("definable metadata file4");
                    selectsIDs[7] = SRBMetaDataSet.getSRBID("definable metadata file5");
                    selectsIDs[8] = SRBMetaDataSet.getSRBID("definable metadata file6");
                    selectsIDs[9] = SRBMetaDataSet.getSRBID("definable metadata file7");
                    selectsIDs[10] = SRBMetaDataSet.getSRBID("definable metadata file8");
                    selectsIDs[11] = SRBMetaDataSet.getSRBID("definable metadata file9");
                    selectsValues[0] = 1;
                    selectsValues[1] = 1;
                    selectsValues[2] = 1;
                    selectsValues[3] = 1;
                    selectsValues[4] = 1;
                    selectsValues[5] = 1;
                    selectsValues[6] = 1;
                    selectsValues[7] = 1;
                    selectsValues[8] = 1;
                    selectsValues[9] = 1;
                    selectsValues[10] = 1;
                    selectsValues[11] = 1;
                    comparator = "file name";
                    comparator2 = "directory name";
                    i = temp;
                }
            } else if (fieldID == -2) {
                if ((double)this.commands.versionNumber >= 3.31) {
                    selects[i] = null;
                    tempSelects = new MetaDataSelect[]{MetaDataSet.newSelection("directory name"), MetaDataSet.newSelection("definable metadata directory0"), MetaDataSet.newSelection("definable metadata directory1"), MetaDataSet.newSelection("definable metadata directory2"), MetaDataSet.newSelection("definable metadata directory3"), MetaDataSet.newSelection("definable metadata directory4"), MetaDataSet.newSelection("definable metadata directory5"), MetaDataSet.newSelection("definable metadata directory6"), MetaDataSet.newSelection("definable metadata directory7"), MetaDataSet.newSelection("definable metadata directory8"), MetaDataSet.newSelection("definable metadata directory9"), MetaDataSet.newSelection("metadata number")};
                    selects = MetaDataSet.mergeSelects((MetaDataSelect[])selects, tempSelects);
                    if ((selects = (MetaDataSelect[])SRBMetaDataCommands.cleanNulls(selects)) == null) {
                        return null;
                    }
                    i = -1;
                    temp = selectsLength = selects.length;
                    selectsIDs = new int[selectsLength];
                    selectsValues = new int[selectsLength];
                } else {
                    selects[i] = MetaDataSet.newSelection("directory name");
                    secondRecordList = this.getRecordsForDefinableQueries(catType, (MetaDataCondition[])conditions, (MetaDataSelect[])selects, rowsWanted, firstRecordList, orderBy, nonDistinct);
                    selectsLength = 11;
                    selectsIDs = new int[selectsLength];
                    selectsValues = new int[selectsLength];
                    selectsIDs[0] = SRBMetaDataSet.getSRBID("directory name");
                    selectsIDs[1] = SRBMetaDataSet.getSRBID("definable metadata directory0");
                    selectsIDs[2] = SRBMetaDataSet.getSRBID("definable metadata directory1");
                    selectsIDs[3] = SRBMetaDataSet.getSRBID("definable metadata directory2");
                    selectsIDs[4] = SRBMetaDataSet.getSRBID("definable metadata directory3");
                    selectsIDs[5] = SRBMetaDataSet.getSRBID("definable metadata directory4");
                    selectsIDs[6] = SRBMetaDataSet.getSRBID("definable metadata directory5");
                    selectsIDs[7] = SRBMetaDataSet.getSRBID("definable metadata directory6");
                    selectsIDs[8] = SRBMetaDataSet.getSRBID("definable metadata directory7");
                    selectsIDs[9] = SRBMetaDataSet.getSRBID("definable metadata directory8");
                    selectsIDs[10] = SRBMetaDataSet.getSRBID("definable metadata directory9");
                    selectsValues[0] = 1;
                    selectsValues[1] = 1;
                    selectsValues[2] = 1;
                    selectsValues[3] = 1;
                    selectsValues[4] = 1;
                    selectsValues[5] = 1;
                    selectsValues[6] = 1;
                    selectsValues[7] = 1;
                    selectsValues[8] = 1;
                    selectsValues[9] = 1;
                    selectsValues[10] = 1;
                    i = temp;
                }
            } else if (fieldID == -3) {
                if ((double)this.commands.versionNumber >= 3.31) {
                    selects[i] = null;
                    tempSelects = new MetaDataSelect[]{MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain"), MetaDataSet.newSelection("definable metadata user0"), MetaDataSet.newSelection("definable metadata user1"), MetaDataSet.newSelection("definable metadata user2"), MetaDataSet.newSelection("definable metadata user3"), MetaDataSet.newSelection("definable metadata user4"), MetaDataSet.newSelection("definable metadata user5"), MetaDataSet.newSelection("definable metadata user6"), MetaDataSet.newSelection("definable metadata user7"), MetaDataSet.newSelection("definable metadata user8"), MetaDataSet.newSelection("definable metadata user9")};
                    selects = MetaDataSet.mergeSelects((MetaDataSelect[])selects, tempSelects);
                    if ((selects = (MetaDataSelect[])SRBMetaDataCommands.cleanNulls(selects)) == null) {
                        return null;
                    }
                    i = -1;
                    temp = selectsLength = selects.length;
                    selectsIDs = new int[selectsLength];
                    selectsValues = new int[selectsLength];
                } else {
                    selects[i] = MetaDataSet.newSelection("user name");
                    selects = MetaDataSet.mergeSelects(MetaDataSet.newSelection("user domain"), (MetaDataSelect[])selects);
                    secondRecordList = this.getRecordsForDefinableQueries(catType, (MetaDataCondition[])conditions, (MetaDataSelect[])selects, rowsWanted, firstRecordList, orderBy, nonDistinct);
                    selectsLength = 12;
                    selectsIDs = new int[selectsLength];
                    selectsValues = new int[selectsLength];
                    selectsIDs[0] = SRBMetaDataSet.getSRBID("user name");
                    selectsIDs[1] = SRBMetaDataSet.getSRBID("user domain");
                    selectsIDs[2] = SRBMetaDataSet.getSRBID("definable metadata user0");
                    selectsIDs[3] = SRBMetaDataSet.getSRBID("definable metadata user1");
                    selectsIDs[4] = SRBMetaDataSet.getSRBID("definable metadata user2");
                    selectsIDs[5] = SRBMetaDataSet.getSRBID("definable metadata user3");
                    selectsIDs[6] = SRBMetaDataSet.getSRBID("definable metadata user4");
                    selectsIDs[7] = SRBMetaDataSet.getSRBID("definable metadata user5");
                    selectsIDs[8] = SRBMetaDataSet.getSRBID("definable metadata user6");
                    selectsIDs[9] = SRBMetaDataSet.getSRBID("definable metadata user7");
                    selectsIDs[10] = SRBMetaDataSet.getSRBID("definable metadata user8");
                    selectsIDs[11] = SRBMetaDataSet.getSRBID("definable metadata user9");
                    selectsValues[0] = 1;
                    selectsValues[1] = 1;
                    selectsValues[2] = 1;
                    selectsValues[3] = 1;
                    selectsValues[4] = 1;
                    selectsValues[5] = 1;
                    selectsValues[6] = 1;
                    selectsValues[7] = 1;
                    selectsValues[8] = 1;
                    selectsValues[9] = 1;
                    selectsValues[10] = 1;
                    selectsValues[11] = 1;
                    i = temp;
                }
            } else if (fieldID == -4) {
                if ((double)this.commands.versionNumber >= 3.31) {
                    selects[i] = null;
                    tempSelects = new MetaDataSelect[]{MetaDataSet.newSelection("resource name"), MetaDataSet.newSelection("definable metadata resource0"), MetaDataSet.newSelection("definable metadata resource1"), MetaDataSet.newSelection("definable metadata resource2"), MetaDataSet.newSelection("definable metadata resource3"), MetaDataSet.newSelection("definable metadata resource4"), MetaDataSet.newSelection("definable metadata resource5"), MetaDataSet.newSelection("definable metadata resource6"), MetaDataSet.newSelection("definable metadata resource7"), MetaDataSet.newSelection("definable metadata resource8"), MetaDataSet.newSelection("definable metadata resource9")};
                    selects = MetaDataSet.mergeSelects((MetaDataSelect[])selects, tempSelects);
                    if ((selects = (MetaDataSelect[])SRBMetaDataCommands.cleanNulls(selects)) == null) {
                        return null;
                    }
                    i = -1;
                    temp = selectsLength = selects.length;
                    selectsIDs = new int[selectsLength];
                    selectsValues = new int[selectsLength];
                } else {
                    selects[i] = MetaDataSet.newSelection("resource name");
                    secondRecordList = this.getRecordsForDefinableQueries(catType, (MetaDataCondition[])conditions, (MetaDataSelect[])selects, rowsWanted, firstRecordList, orderBy, nonDistinct);
                    selectsLength = 11;
                    selectsIDs = new int[selectsLength];
                    selectsValues = new int[selectsLength];
                    selectsIDs[0] = SRBMetaDataSet.getSRBID("resource name");
                    selectsIDs[1] = SRBMetaDataSet.getSRBID("definable metadata resource0");
                    selectsIDs[2] = SRBMetaDataSet.getSRBID("definable metadata resource1");
                    selectsIDs[3] = SRBMetaDataSet.getSRBID("definable metadata resource2");
                    selectsIDs[4] = SRBMetaDataSet.getSRBID("definable metadata resource3");
                    selectsIDs[5] = SRBMetaDataSet.getSRBID("definable metadata resource4");
                    selectsIDs[6] = SRBMetaDataSet.getSRBID("definable metadata resource5");
                    selectsIDs[7] = SRBMetaDataSet.getSRBID("definable metadata resource6");
                    selectsIDs[8] = SRBMetaDataSet.getSRBID("definable metadata resource7");
                    selectsIDs[9] = SRBMetaDataSet.getSRBID("definable metadata resource8");
                    selectsIDs[10] = SRBMetaDataSet.getSRBID("definable metadata resource9");
                    selectsValues[0] = 1;
                    selectsValues[1] = 1;
                    selectsValues[2] = 1;
                    selectsValues[3] = 1;
                    selectsValues[4] = 1;
                    selectsValues[5] = 1;
                    selectsValues[6] = 1;
                    selectsValues[7] = 1;
                    selectsValues[8] = 1;
                    selectsValues[9] = 1;
                    selectsValues[10] = 1;
                    i = temp;
                }
            } else {
                if (fieldID != -5) throw new NullPointerException("Extensible metadata or invalid metadata attribute: " + ((MetaDataSelect)selects[i]).getFieldName() + " not support in this version");
                if (!((double)this.commands.versionNumber >= 3.3)) throw new NullPointerException("Extensible metadata or invalid metadata attribute: " + ((MetaDataSelect)selects[i]).getFieldName() + " not support in this version");
                selectsIDs[i] = fieldID;
                selectsValues[i] = ((MetaDataSelect)selects[i]).getOperation();
                extensible = true;
            }
            ++i;
        }
        if (extensible) {
            String schemaName = "";
            String attributeName = "";
            SRBProtocol protocol = new SRBProtocol();
            i = 0;
            j = 0;
            while (i < selectsLength) {
                if (selectsIDs[i] == -5) {
                    attributeName = String.valueOf(attributeName) + ((MetaDataSelect)selects[i]).getFieldName() + ",";
                    schemaName = String.valueOf(schemaName) + ((MetaDataSelect)selects[i]).getField().getExtensibleName(protocol) + ",";
                    selectsIDs[i] = 420 + j;
                    ++j;
                }
                ++i;
            }
            if (j > 0) {
                attributeName = attributeName.substring(0, attributeName.length() - 1);
                schemaName = schemaName.substring(0, schemaName.length() - 1);
            }
            MetaDataCondition[] extensibleConditions = new MetaDataCondition[]{MetaDataSet.newCondition("extensible table name", 6, schemaName), MetaDataSet.newCondition("extensible attribute outside name", 6, attributeName)};
            String[] selectFieldNames = new String[]{"extensible schema name", "extensible table name", "extensible attribute name", "extensible attribute outside name"};
            SRBMetaDataRecordList[] sRBMetaDataRecordListArray = this.srbGenQuery(0, myMcatZone, extensibleConditions, MetaDataSet.newSelection(selectFieldNames), 80, false, false);
        }
        byte[] correctSizeQuery = null;
        temp = 0;
        if (nonDistinct) {
            Host.copyInt(selectsLength + 1, packedQuery, temp);
            temp += 4;
        } else {
            Host.copyInt(selectsLength, packedQuery, temp);
            temp += 4;
        }
        if (orderBy) {
            Host.copyInt(conditionsLength + 1, packedQuery, temp);
            temp += 4;
        } else {
            Host.copyInt(conditionsLength, packedQuery, temp);
            temp += 4;
        }
        i = 0;
        while (i < selectsLength) {
            Host.copyInt(selectsIDs[i], packedQuery, temp);
            temp += 4;
            ++i;
        }
        if (nonDistinct) {
            Host.copyInt(SRBMetaDataSet.getSRBID("nondistinct"), packedQuery, temp);
            temp += 4;
        }
        i = 0;
        while (i < selectsLength) {
            Host.copyInt(selectsValues[i], packedQuery, temp);
            temp += 4;
            ++i;
        }
        if (nonDistinct) {
            Host.copyInt(1, packedQuery, temp);
            temp += 4;
        }
        if (conditionsLength > 0) {
            i = 0;
            while (i < conditionIDs.length) {
                Host.copyInt(conditionIDs[i], packedQuery, temp);
                temp += 4;
                ++i;
            }
        }
        if (orderBy) {
            Host.copyInt(SRBMetaDataSet.getSRBID("order by"), packedQuery, temp);
            temp += 4;
        }
        if (conditionsLength > 0) {
            i = 0;
            while (i < conditions.length) {
                if (conditions[i] != null) {
                    int style = ((MetaDataCondition)conditions[i]).getStyle();
                    banana = " " + SRBMetaDataCommands.getOperator((MetaDataCondition)conditions[i]) + " " + this.addValueByStyle(style, (MetaDataCondition)conditions[i], null);
                    System.arraycopy(banana.getBytes(), 0, packedQuery, temp, banana.length());
                    temp = style == 14 ? (temp += banana.length()) : (temp += banana.length() + 1);
                }
                ++i;
            }
        }
        if (SRBCommands.DEBUG > 1) {
            System.out.print("\nselects[j].getFieldName() " + selectsLength);
            j = 0;
            while (j < selectsLength) {
                System.out.print("\n" + selectsIDs[j]);
                System.out.print(" " + selectsValues[j]);
                ++j;
            }
        }
        if (orderBy) {
            banana = SRBMetaDataSet.getSRBName(((MetaDataSelect)selects[0]).getFieldName());
            j = 1;
            while (j < selects.length) {
                banana = String.valueOf(banana) + ", " + SRBMetaDataSet.getSRBName(((MetaDataSelect)selects[j]).getFieldName());
                ++j;
            }
            System.arraycopy(banana.getBytes(), 0, packedQuery, temp, banana.length());
            temp += banana.length() + 1;
        }
        correctSizeQuery = new byte[temp + 4];
        System.arraycopy(packedQuery, 0, correctSizeQuery, 4, temp);
        Host.copyInt(temp, correctSizeQuery, 0);
        this.commands.startSRBCommand(2155, 4);
        this.commands.sendArg(catType);
        this.commands.sendArg(myMcatZone);
        this.commands.sendArg(correctSizeQuery);
        this.commands.sendArg(rowsWanted);
        this.commands.flush();
        try {
            this.commands.commandStatus();
        }
        catch (SRBException e) {
            if (e.getType() != -3005) throw e;
            return null;
        }
        firstRecordList = this.commands.returnSRBMetaDataRecordList(true);
        if (secondRecordList == null) return firstRecordList;
        if (firstRecordList == null) return this.joinRecordLists(secondRecordList, firstRecordList, comparator, comparator2);
        j = 0;
        while (j < firstRecordList.length) {
            if (continuationIndex < firstRecordList[j].getContinuationIndex()) {
                continuationIndex = firstRecordList[j].getContinuationIndex();
                firstRecordList = this.joinRecordLists(firstRecordList, this.commands.srbGetMoreRows(catType, continuationIndex, rowsWanted), comparator, comparator2);
            }
            ++j;
        }
        j = 0;
        while (j < firstRecordList.length) {
            firstRecordList[j].setContinuationIndex(-1);
            ++j;
        }
        return this.joinRecordLists(secondRecordList, firstRecordList, comparator, comparator2);
    }
}

