/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.local;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.local.LocalFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class LocalRandomAccessFile
extends GeneralRandomAccessFile {
    private RandomAccessFile wrapper;

    public LocalRandomAccessFile(String name, String mode) throws IOException {
        this(new LocalFile(name), mode);
    }

    public LocalRandomAccessFile(File file, String mode) throws IOException {
        this(new LocalFile(file), mode);
    }

    public LocalRandomAccessFile(LocalFile file, String mode) throws IOException {
        super(file, mode);
        this.wrapper = new RandomAccessFile(file.getAbsolutePath(), mode);
    }

    public RandomAccessFile getRandomAccessFile() throws IOException {
        return this.wrapper;
    }

    protected void open(GeneralFile file) throws FileNotFoundException {
    }

    public int read() throws IOException {
        return this.wrapper.read();
    }

    protected int readBytes(byte[] b, int offset, int len) throws IOException {
        return this.wrapper.read(b, offset, len);
    }

    public int skipBytes(int n) throws IOException {
        return this.wrapper.skipBytes(n);
    }

    public void write(int b) throws IOException {
        this.wrapper.write(b);
    }

    protected void writeBytes(byte[] b, int offset, int len) throws IOException {
        this.wrapper.write(b, offset, len);
    }

    public long getFilePointer() throws IOException {
        return this.wrapper.getFilePointer();
    }

    public void seek(long position) throws IOException {
        this.wrapper.seek(position);
    }

    public void seek(long position, int origin) throws IOException {
        switch (origin) {
            case 1: {
                this.seek(position + this.getFilePointer());
                break;
            }
            case 2: {
                this.seek(position + this.length());
                break;
            }
            default: {
                this.seek(position);
            }
        }
    }

    public long length() throws IOException {
        return this.wrapper.length();
    }

    public void setLength(long newLength) throws IOException {
        this.wrapper.setLength(newLength);
    }

    public void close() throws IOException {
        this.wrapper.close();
    }
}

