/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.local;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.local.LocalFileSystem;
import edu.sdsc.grid.io.srb.SRBFile;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;

public class LocalFile
extends GeneralFile {
    private static final String PATH_SEPARATOR = System.getProperty("file.separator");
    private static final char PATH_SEPARATOR_CHAR = PATH_SEPARATOR.charAt(0);
    private File wrapper;

    public LocalFile(String filePath) {
        this(filePath, "");
    }

    public LocalFile(String directory, String child) {
        super(new LocalFileSystem(), directory, child);
        this.wrapper = new File(directory, child);
    }

    public LocalFile(LocalFile directory, String child) {
        this(directory.getAbsolutePath(), child);
        this.wrapper = new File(directory.getAbsolutePath(), child);
    }

    public LocalFile(File file) {
        this(file.getAbsolutePath(), "");
        this.wrapper = file;
    }

    public LocalFile(File file, String child) {
        this(file.getAbsolutePath(), child);
        this.wrapper = new File(file, child);
    }

    public LocalFile(URI uri) {
        this(uri.getPath(), "");
        this.wrapper = new File(uri);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.wrapper = null;
    }

    public Iterator listIterator() throws IOException {
        return null;
    }

    protected void setDirectory(String dir) {
    }

    protected void setFileName(String fileName) {
    }

    public File getFile() {
        return this.wrapper;
    }

    public Properties getMetaData() {
        return null;
    }

    public String getPathSeparator() {
        return PATH_SEPARATOR;
    }

    public char getPathSeparatorChar() {
        return PATH_SEPARATOR_CHAR;
    }

    protected String getHomeDirectory() {
        return System.getProperty("user.home");
    }

    public void copyTo(GeneralFile file) throws IOException {
        if (file instanceof SRBFile) {
            file.copyFrom(this, false);
        } else {
            super.copyTo(file, false);
        }
    }

    public void copyTo(GeneralFile file, boolean forceOverwrite) throws IOException {
        if (file instanceof SRBFile) {
            file.copyFrom(this, forceOverwrite);
        } else {
            super.copyTo(file, forceOverwrite);
        }
    }

    public void copyFrom(GeneralFile file) throws IOException {
        if (file instanceof SRBFile) {
            file.copyTo(this, false);
        } else {
            super.copyFrom(file, false);
        }
    }

    public void copyFrom(GeneralFile file, boolean forceOverwrite) throws IOException {
        if (file instanceof SRBFile) {
            file.copyTo(this, forceOverwrite);
        } else {
            super.copyFrom(file, forceOverwrite);
        }
    }

    public boolean canRead() {
        return this.wrapper.canRead();
    }

    public boolean canWrite() {
        return this.wrapper.canWrite();
    }

    public int compareTo(GeneralFile pathName) {
        return this.wrapper.compareTo(((LocalFile)pathName).getFile());
    }

    public int compareTo(Object o) {
        return this.wrapper.compareTo(((LocalFile)o).getFile());
    }

    public boolean createNewFile() throws IOException {
        return this.wrapper.createNewFile();
    }

    public static GeneralFile createTempFile(String prefix, String suffix) throws IOException {
        return new LocalFile(File.createTempFile(prefix, suffix));
    }

    public static GeneralFile createTempFile(String prefix, String suffix, GeneralFile directory) throws IOException {
        return new LocalFile(File.createTempFile(prefix, suffix, new File(directory.getAbsolutePath())));
    }

    public boolean delete() {
        return this.wrapper.delete();
    }

    public void deleteOnExit() {
        this.wrapper.deleteOnExit();
    }

    public boolean equals(Object obj) {
        return this.wrapper.equals(obj);
    }

    public boolean exists() {
        return this.wrapper.exists();
    }

    public GeneralFile getAbsoluteFile() {
        return new LocalFile(this.wrapper.getAbsoluteFile());
    }

    public String getAbsolutePath() {
        return this.wrapper.getAbsolutePath();
    }

    public GeneralFile getCanonicalFile() throws IOException {
        return new LocalFile(this.wrapper.getCanonicalFile());
    }

    public String getCanonicalPath() throws IOException {
        return this.wrapper.getCanonicalPath();
    }

    public String getName() {
        return this.wrapper.getName();
    }

    public String getParent() {
        String path = null;
        int index = -1;
        try {
            path = this.wrapper.getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (path == null) {
            path = this.wrapper.getPath();
        }
        if ((index = path.lastIndexOf(PATH_SEPARATOR)) == path.length() - 1) {
            index = path.lastIndexOf(PATH_SEPARATOR, index);
        }
        path = path.substring(0, index);
        return path;
    }

    public GeneralFile getParentFile() {
        return new LocalFile(this.getParent());
    }

    public String getPath() {
        return this.wrapper.getPath();
    }

    public int hashCode() {
        return this.wrapper.hashCode();
    }

    public boolean isAbsolute() {
        return this.wrapper.isAbsolute();
    }

    public boolean isDirectory() {
        return this.wrapper.isDirectory();
    }

    public boolean isFile() {
        return this.wrapper.isFile();
    }

    public boolean isHidden() {
        return this.wrapper.isHidden();
    }

    public long lastModified() {
        return this.wrapper.lastModified();
    }

    public long length() {
        if (this.exists()) {
            return this.wrapper.length();
        }
        return 0L;
    }

    public String[] list() {
        return this.wrapper.list();
    }

    public String[] list(FilenameFilter filter) {
        return this.wrapper.list(filter);
    }

    public GeneralFile[] listFiles() {
        File[] fileList = this.wrapper.listFiles();
        if (fileList == null) {
            return null;
        }
        GeneralFile[] localFileList = new LocalFile[fileList.length];
        int i = 0;
        while (i < fileList.length) {
            localFileList[i] = new LocalFile(fileList[i]);
            ++i;
        }
        return localFileList;
    }

    public GeneralFile[] listFiles(FileFilter filter) {
        File[] fileList = this.wrapper.listFiles(filter);
        GeneralFile[] localFileList = new LocalFile[fileList.length];
        int i = 0;
        while (i < fileList.length) {
            localFileList[i] = new LocalFile(fileList[i]);
            ++i;
        }
        return localFileList;
    }

    public GeneralFile[] listFiles(FilenameFilter filter) {
        File[] fileList = this.wrapper.listFiles(filter);
        GeneralFile[] localFileList = new LocalFile[fileList.length];
        int i = 0;
        while (i < fileList.length) {
            localFileList[i] = new LocalFile(fileList[i]);
            ++i;
        }
        return localFileList;
    }

    public static GeneralFile[] listRoots() {
        File[] fileRoots = File.listRoots();
        GeneralFile[] localFileRoots = new LocalFile[fileRoots.length];
        int i = 0;
        while (i < fileRoots.length) {
            localFileRoots[i] = new LocalFile(fileRoots[i]);
            ++i;
        }
        return localFileRoots;
    }

    public boolean mkdir() {
        return this.wrapper.mkdir();
    }

    public boolean mkdirs() {
        return this.wrapper.mkdirs();
    }

    public boolean renameTo(GeneralFile dest) {
        return this.wrapper.renameTo(new File(dest.getAbsolutePath()));
    }

    public boolean setLastModified(long time) {
        return this.wrapper.setLastModified(time);
    }

    public boolean setReadOnly() {
        return this.wrapper.setReadOnly();
    }

    public String toString() {
        return this.wrapper.toURI().toString();
    }

    public URI toURI() {
        return this.wrapper.toURI();
    }

    public URL toURL() throws MalformedURLException {
        return this.wrapper.toURL();
    }
}

