/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.GeneralAccount;

public abstract class RemoteAccount
extends GeneralAccount {
    protected String host;
    protected int port;
    protected String userName;
    protected String password;

    public RemoteAccount(String host, int port, String userName, String password, String homeDir) {
        super(homeDir);
        this.setHost(host);
        this.setPort(port);
        this.setUserName(userName);
        this.setPassword(password);
    }

    protected void finalize() {
        super.finalize();
        this.host = null;
        this.userName = null;
        this.password = null;
    }

    public void setHost(String host) {
        if (host == null) {
            throw new NullPointerException("The host string cannot be null");
        }
        this.host = host;
    }

    public void setPort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port number");
        }
        this.port = port;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() throws IllegalArgumentException {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }
}

