/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataTable;

public final class MetaDataCondition {
    public static final int EQUAL = 0;
    public static final int NOT_EQUAL = 1;
    public static final int LESS_THAN = 2;
    public static final int GREATER_THAN = 3;
    public static final int LESS_OR_EQUAL = 4;
    public static final int GREATER_OR_EQUAL = 5;
    public static final int IN = 6;
    public static final int NOT_IN = 7;
    public static final int BETWEEN = 8;
    public static final int NOT_BETWEEN = 9;
    public static final int LIKE = 10;
    public static final int NOT_LIKE = 11;
    public static final int SOUNDS_LIKE = 12;
    public static final int SOUNDS_NOT_LIKE = 13;
    public static final int SCALAR = 0;
    public static final int RANGEPAIR = 1;
    public static final int ENUM = 2;
    public static final int TABLE = 14;
    MetaDataField field;
    int operator;
    Object[] values;
    int style;
    int type;
    private static String[] operatorStrings = new String[15];

    static {
        MetaDataCondition.operatorStrings[0] = "=";
        MetaDataCondition.operatorStrings[1] = "<>";
        MetaDataCondition.operatorStrings[2] = "<";
        MetaDataCondition.operatorStrings[3] = ">";
        MetaDataCondition.operatorStrings[4] = ">=";
        MetaDataCondition.operatorStrings[5] = "<=";
        MetaDataCondition.operatorStrings[6] = "in";
        MetaDataCondition.operatorStrings[7] = "not in";
        MetaDataCondition.operatorStrings[8] = "between";
        MetaDataCondition.operatorStrings[9] = "not between";
        MetaDataCondition.operatorStrings[10] = "like";
        MetaDataCondition.operatorStrings[11] = "not like";
        MetaDataCondition.operatorStrings[12] = "sounds like";
        MetaDataCondition.operatorStrings[13] = "sounds not like";
        MetaDataCondition.operatorStrings[14] = "TABLE";
    }

    MetaDataCondition(MetaDataField field, int operator, int value) {
        if (field == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = field;
        this.values = new Object[1];
        this.values[0] = new Integer(value);
        this.type = 0;
        this.style = 0;
        this.operator = operator;
    }

    MetaDataCondition(MetaDataField field, int operator, float value) {
        if (field == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = field;
        this.values = new Object[1];
        this.values[0] = new Float(value);
        this.type = 2;
        this.style = 0;
        this.operator = operator;
    }

    MetaDataCondition(MetaDataField field, int operator, String value) {
        if (field == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = field;
        this.values = new Object[1];
        this.values[0] = value;
        this.type = 3;
        this.style = 0;
        this.operator = operator;
    }

    MetaDataCondition(MetaDataField field, int operator, int value1, int value2) {
        if (field == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = field;
        this.values = new Object[2];
        this.values[0] = new Integer(value1);
        this.values[1] = new Integer(value2);
        this.type = 0;
        this.style = 1;
        if (operator != 8 && operator != 9) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = operator;
    }

    MetaDataCondition(MetaDataField field, int operator, float value1, float value2) {
        if (field == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = field;
        this.values = new Object[2];
        this.values[0] = new Float(value1);
        this.values[1] = new Float(value2);
        this.type = 2;
        this.style = 1;
        if (operator != 8 && operator != 9) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = operator;
    }

    MetaDataCondition(MetaDataField field, int operator, String value1, String value2) {
        if (field == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = field;
        this.values = new Object[2];
        this.values[0] = value1;
        this.values[1] = value2;
        this.type = 3;
        this.style = 1;
        if (operator != 8 && operator != 9) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = operator;
    }

    MetaDataCondition(MetaDataField field, int operator, int[] values) {
        if (field == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = field;
        this.values = new Object[values.length];
        int i = 0;
        while (i < values.length) {
            this.values[i] = new Integer(values[i]);
            ++i;
        }
        this.type = 0;
        this.style = 2;
        if (operator != 6 && operator != 7) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = operator;
    }

    MetaDataCondition(MetaDataField field, int operator, float[] values) {
        if (field == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = field;
        this.values = new Object[values.length];
        int i = 0;
        while (i < values.length) {
            this.values[i] = new Float(values[i]);
            ++i;
        }
        this.type = 2;
        this.style = 2;
        if (operator != 6 && operator != 7) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = operator;
    }

    MetaDataCondition(MetaDataField field, int operator, String[] values) {
        if (field == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = field;
        this.values = new Object[values.length];
        this.values = values;
        this.type = 3;
        this.style = 2;
        if (operator != 6 && operator != 7) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = operator;
    }

    MetaDataCondition(MetaDataField field, MetaDataTable table) {
        if (field == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = field;
        this.values = new Object[1];
        this.values[0] = table;
        this.type = 14;
        this.style = 14;
        this.operator = 0;
    }

    MetaDataCondition(MetaDataField field, int operator, MetaDataTable table) {
        if (field == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = field;
        this.values = new Object[1];
        this.values[0] = table;
        this.type = 14;
        this.style = 14;
        this.operator = operator;
    }

    protected void finalize() {
        if (this.field != null) {
            this.field = null;
        }
        if (this.values != null) {
            this.values = null;
        }
    }

    public MetaDataField getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public int getFieldType() {
        return this.field.getType();
    }

    public int getOperator() {
        return this.operator;
    }

    public int getStyle() {
        return this.style;
    }

    public int getCount() {
        return this.values.length;
    }

    public int getIntValue(int index) {
        if (index < this.values.length && index >= 0) {
            if (this.style == 14) {
                throw new UnsupportedOperationException();
            }
            if (this.type == 0) {
                return (Integer)this.values[index];
            }
            if (this.type == 2) {
                return ((Float)this.values[index]).intValue();
            }
            if (this.type == 3) {
                return new Integer(this.values[index].toString());
            }
        }
        throw new IllegalArgumentException();
    }

    public float getFloatValue(int index) {
        if (index < this.values.length && index >= 0) {
            if (this.style == 14) {
                throw new UnsupportedOperationException();
            }
            if (this.type == 0) {
                return ((Integer)this.values[index]).floatValue();
            }
            if (this.type == 2) {
                return ((Float)this.values[index]).floatValue();
            }
            if (this.type == 3) {
                return new Float(this.values[index].toString()).floatValue();
            }
        }
        throw new IllegalArgumentException();
    }

    public String getStringValue(int index) {
        if (index < this.values.length && index >= 0) {
            if (this.style == 14) {
                return "TABLE";
            }
            if (this.type == 0) {
                return ((Integer)this.values[index]).toString();
            }
            if (this.type == 2) {
                return ((Float)this.values[index]).toString();
            }
            if (this.type == 3) {
                if (this.values[index] == null) {
                    return "";
                }
                return this.values[index].toString();
            }
        }
        throw new IllegalArgumentException();
    }

    public int getIntValue() {
        return this.getIntValue(0);
    }

    public float getFloatValue() {
        return this.getFloatValue(0);
    }

    public String getStringValue() {
        return this.getStringValue(0);
    }

    public MetaDataTable getTableValue() {
        if (this.style != 14) {
            return null;
        }
        return (MetaDataTable)this.values[0];
    }

    public String toString() {
        String toString = new String(this.field.getName());
        toString = String.valueOf(toString) + " " + MetaDataCondition.getOperatorString(this.operator);
        int i = 0;
        while (i < this.values.length) {
            toString = String.valueOf(toString) + " " + this.values[i];
            ++i;
        }
        return toString;
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            MetaDataCondition temp = (MetaDataCondition)obj;
            if (this.getField().equals(temp.getField()) && this.getOperator() == temp.getOperator()) {
                int i = 0;
                while (i < this.values.length) {
                    if (!this.values[i].equals(temp.values[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return false;
    }

    public static String getOperatorString(int operator) {
        if (operator < 0 || operator >= operatorStrings.length) {
            throw new IllegalArgumentException();
        }
        return operatorStrings[operator];
    }

    public static String[] getOperatorStrings() {
        return operatorStrings;
    }
}

