/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import java.io.IOException;
import java.io.OutputStream;

public abstract class GeneralFileOutputStream
extends OutputStream {
    protected int fd = -1;

    public GeneralFileOutputStream(GeneralFileSystem fileSystem, String name) throws IOException {
        this(FileFactory.newFile(fileSystem, name));
    }

    public GeneralFileOutputStream(GeneralFile file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File cannot be null.");
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        this.open(file);
    }

    protected void finalize() throws IOException {
        this.close();
    }

    protected abstract void open(GeneralFile var1) throws IOException;

    public void write(int b) throws IOException {
        byte[] buffer = new byte[]{(byte)b};
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public abstract void close() throws IOException;
}

