/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBFile;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JargonTreeModel
implements TreeModel {
    public static String TOP_LEVEL = "DataGrid";
    private Object root;
    private Object[] subRoots;
    protected EventListenerList listenerList = new EventListenerList();
    private boolean showMetaData = false;
    private MetaDataCondition[] conditions;
    private MetaDataSelect[] selects;
    private MetaDataField[] fields;
    private int fieldsLength;
    private Hashtable table = new Hashtable();
    private HashSet nodeSet = new HashSet();
    private HashSet leafSet = new HashSet();
    private Hashtable resultTable = new Hashtable();
    public static Icon FOLDER_ICON = new MetalIconFactory.FolderIcon16();
    public static Icon FILE_ICON = new MetalIconFactory.FileIcon16();
    static /* synthetic */ Class class$0;

    public JargonTreeModel(GeneralFile root) {
        this.root = root;
        this.selects = new MetaDataSelect[2];
        this.selects[0] = MetaDataSet.newSelection("file name");
        this.selects[1] = MetaDataSet.newSelection("directory name");
    }

    public JargonTreeModel(GeneralFile[] roots) {
        this.root = TOP_LEVEL;
        this.subRoots = roots;
        this.selects = new MetaDataSelect[2];
        this.selects[0] = MetaDataSet.newSelection("file name");
        this.selects[1] = MetaDataSet.newSelection("directory name");
    }

    public JargonTreeModel(GeneralFile root, MetaDataCondition[] conditions) throws IOException {
        this.root = root;
        this.selects = new MetaDataSelect[2];
        this.selects[0] = MetaDataSet.newSelection("file name");
        this.selects[1] = MetaDataSet.newSelection("directory name");
        this.conditions = conditions;
    }

    public JargonTreeModel(GeneralFile[] roots, MetaDataCondition[] conditions) throws IOException {
        this.root = TOP_LEVEL;
        this.subRoots = roots;
        this.selects = new MetaDataSelect[2];
        this.selects[0] = MetaDataSet.newSelection("file name");
        this.selects[1] = MetaDataSet.newSelection("directory name");
        this.conditions = conditions;
    }

    public JargonTreeModel(GeneralFile root, MetaDataSelect[] selects) throws IOException {
        this.root = root;
        if (selects == null) {
            this.selects = new MetaDataSelect[2];
            this.selects[0] = MetaDataSet.newSelection("file name");
            this.selects[1] = MetaDataSet.newSelection("directory name");
        } else {
            this.showMetaData = this.loadFields(root, null, selects);
        }
    }

    public JargonTreeModel(GeneralFile[] roots, MetaDataSelect[] selects) throws IOException {
        this.root = TOP_LEVEL;
        this.subRoots = roots;
        if (selects == null) {
            this.selects = new MetaDataSelect[2];
            this.selects[0] = MetaDataSet.newSelection("file name");
            this.selects[1] = MetaDataSet.newSelection("directory name");
        } else {
            int i = 0;
            while (i < roots.length) {
                this.showMetaData = this.showMetaData || this.loadFields(roots[i], null, selects);
                ++i;
            }
        }
    }

    public JargonTreeModel(GeneralFile root, MetaDataCondition[] conditions, MetaDataSelect[] selects) throws IOException {
        this.root = root;
        this.conditions = conditions;
        if (selects == null) {
            this.selects = new MetaDataSelect[2];
            this.selects[0] = MetaDataSet.newSelection("file name");
            this.selects[1] = MetaDataSet.newSelection("directory name");
        } else {
            this.showMetaData = this.loadFields(root, conditions, selects);
        }
    }

    public JargonTreeModel(GeneralFile[] roots, MetaDataCondition[] conditions, MetaDataSelect[] selects) throws IOException {
        this.root = TOP_LEVEL;
        this.subRoots = roots;
        this.conditions = conditions;
        if (selects == null) {
            this.selects = new MetaDataSelect[2];
            this.selects[0] = MetaDataSet.newSelection("file name");
            this.selects[1] = MetaDataSet.newSelection("directory name");
        } else {
            int i = 0;
            while (i < roots.length) {
                this.showMetaData = this.showMetaData || this.loadFields(roots[i], conditions, selects);
                ++i;
            }
        }
    }

    public void addTreeModelListener(TreeModelListener listener) {
        this.listenerList.add(TreeModelListener.class, listener);
    }

    protected void fireTreeStructureChanged(Object oldRoot) {
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{oldRoot});
        EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
        int i = 0;
        while (i < listeners.length) {
            ((TreeModelListener)listeners[i]).treeStructureChanged(event);
            ++i;
        }
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public void setRoot(Object newRoot) {
        Object oldRoot = this.root;
        if (newRoot != null) {
            if (!(newRoot instanceof GeneralFile)) {
                throw new ClassCastException("Root must be an instance of GeneralFile");
            }
        } else {
            throw new NullPointerException("Root cannot be null");
        }
        this.root = newRoot;
        this.fireTreeStructureChanged(oldRoot);
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        String[] list;
        if (parent instanceof String) {
            if (parent.equals(TOP_LEVEL)) {
                return this.subRoots[index];
            }
        } else if (parent instanceof LocalFile) {
            String[] children = ((LocalFile)parent).list();
            if (children == null || index >= children.length) {
                return null;
            }
            return new LocalFile((LocalFile)parent, children[index]);
        }
        if ((list = (String[])this.table.get(parent)) == null) {
            list = ((GeneralFile)parent).list(this.conditions);
            this.table.put(parent, list);
        }
        return FileFactory.newFile((GeneralFile)parent, list[index]);
    }

    public int getChildCount(Object parent) {
        String[] list;
        if (parent instanceof String) {
            if (parent.equals(TOP_LEVEL)) {
                return this.subRoots.length;
            }
        } else if (parent instanceof LocalFile) {
            String[] children = ((LocalFile)parent).list();
            if (children == null) {
                return 0;
            }
            return children.length;
        }
        if ((list = (String[])this.table.get(parent)) == null) {
            this.store(parent);
            list = ((GeneralFile)parent).list(this.conditions);
            if (list != null) {
                this.table.put(parent, list);
            }
        }
        if (list != null) {
            return list.length;
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof String) {
            if (parent.equals(TOP_LEVEL)) {
                int i = 0;
                while (i < this.subRoots.length) {
                    if (child.equals(this.subRoots[i])) {
                        return i;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.subRoots.length) {
                    if (this.subRoots[i].getClass().equals(child.getClass())) {
                        parent = this.subRoots[i];
                    }
                    ++i;
                }
            }
        } else if (parent instanceof LocalFile) {
            String[] children = ((LocalFile)parent).list();
            if (children == null) {
                return -1;
            }
            String childname = ((LocalFile)child).getName();
            int i = 0;
            while (i < children.length) {
                if (childname.equals(children[i])) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        String kid = ((GeneralFile)child).getName();
        String[] list = (String[])this.table.get(parent);
        if (list == null) {
            list = ((GeneralFile)parent).list(this.conditions);
            this.table.put(parent, list);
        }
        int i = 0;
        while (i < list.length) {
            if (list[i].equals(kid)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isLeaf(Object node) {
        if (node instanceof String) {
            if (node.equals(TOP_LEVEL)) {
                return false;
            }
        } else if (node instanceof LocalFile) {
            return ((LocalFile)node).isFile();
        }
        if (this.leafSet.contains(node)) {
            return true;
        }
        if (this.nodeSet.contains(node)) {
            return false;
        }
        GeneralFile file = (GeneralFile)node;
        if (file.isDirectory()) {
            this.nodeSet.add(node);
            return false;
        }
        this.leafSet.add(node);
        return true;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        System.out.println("valueForPathChanged : " + path + " --> " + newValue);
    }

    private void store(Object obj) {
        if (obj instanceof SRBFile) {
            GeneralFileSystem fileSystem = ((GeneralFile)obj).getFileSystem();
            GeneralFile tempFile = null;
            String path = ((GeneralFile)obj).getAbsolutePath();
            MetaDataRecordList[] rl1 = null;
            MetaDataRecordList[] rl2 = null;
            MetaDataCondition[] tempConditions = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, path)};
            MetaDataSelect[] dirOnlySelects = new MetaDataSelect[]{MetaDataSet.newSelection("directory name")};
            try {
                int i;
                tempConditions = MetaDataSet.mergeConditions(this.conditions, tempConditions);
                rl1 = fileSystem.query(tempConditions, this.selects);
                rl1 = MetaDataRecordList.getAllResults(rl1);
                if (rl1 != null) {
                    i = 0;
                    while (i < rl1.length) {
                        tempFile = FileFactory.newFile(fileSystem, rl1[i].getValue("directory name").toString(), rl1[i].getValue("file name").toString());
                        this.leafSet.add(tempFile);
                        if (this.showMetaData) {
                            this.resultTable.put(tempFile, rl1[i]);
                        }
                        ++i;
                    }
                }
                tempConditions = new MetaDataCondition[]{MetaDataSet.newCondition("parent directory name", 0, path)};
                rl2 = fileSystem.query(tempConditions, dirOnlySelects);
                if ((rl2 = MetaDataRecordList.getAllResults(rl2)) != null) {
                    i = 0;
                    while (i < rl2.length) {
                        tempFile = FileFactory.newFile(fileSystem, rl2[i].getValue("directory name").toString());
                        this.nodeSet.add(tempFile);
                        if (this.showMetaData) {
                            this.resultTable.put(tempFile, rl2[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean loadFields(GeneralFile root, MetaDataCondition[] conditions, MetaDataSelect[] selects) throws IOException {
        if (root instanceof LocalFile) {
            return false;
        }
        GeneralFileSystem fileSystem = root.getFileSystem();
        MetaDataRecordList[] rl = null;
        MetaDataSelect[] tempSelects = new MetaDataSelect[]{MetaDataSet.newSelection("file name"), MetaDataSet.newSelection("directory name")};
        selects = MetaDataSet.mergeSelects(selects, tempSelects);
        if ((selects = (MetaDataSelect[])JargonTreeModel.cleanNulls(selects)) == null) {
            throw new NullPointerException("No valid Selects");
        }
        this.selects = selects;
        if (conditions == null) {
            conditions = new MetaDataCondition[]{MetaDataSet.newCondition("size", 0, "0")};
            rl = fileSystem.query(conditions, selects, 1);
            if (rl == null) {
                conditions[0] = MetaDataSet.newCondition("size", 1, "0");
                rl = fileSystem.query(conditions, selects, 1);
            }
        } else {
            rl = fileSystem.query(conditions, selects, 1);
        }
        if (rl != null) {
            int length = rl[0].getFieldCount();
            this.fields = new MetaDataField[length];
            int i = 0;
            while (i < length) {
                this.fields[i] = rl[0].getField(i);
                ++i;
            }
            this.fieldsLength = this.fields.length;
            return true;
        }
        return false;
    }

    JTable getMetaData(GeneralFile node) {
        GeneralFile file = node;
        MetaDataRecordList rl = (MetaDataRecordList)this.resultTable.get(file);
        if (rl == null) {
            return null;
        }
        int fieldCount = rl.getFieldCount();
        Object[][] tableData = new Object[1][fieldCount];
        Object[] tableNames = new String[fieldCount];
        int i = 0;
        while (i < fieldCount) {
            tableNames[i] = rl.getFieldName(i);
            tableData[0][i] = rl.getValue(i);
            ++i;
        }
        return new JTable(tableData, tableNames);
    }

    public MetaDataRecordList getMetaDataRecordList(Object node) {
        return (MetaDataRecordList)this.resultTable.get(node);
    }

    public boolean showMetaData() {
        return this.showMetaData;
    }

    static final Object[] cleanNulls(Object[] obj) {
        Vector<Object> temp = new Vector<Object>(obj.length);
        boolean add = true;
        int i = 0;
        int j = 0;
        i = 0;
        while (i < obj.length) {
            if (obj[i] != null) {
                j = i + 1;
                while (j < obj.length) {
                    if (obj[i].equals(obj[j])) {
                        add = false;
                        j = obj.length;
                    }
                    ++j;
                }
                if (add) {
                    temp.add(obj[i]);
                }
                add = true;
            }
            ++i;
        }
        i = 0;
        while (i < obj.length) {
            if (obj[i] != null) {
                return temp.toArray((Object[])Array.newInstance(obj[i].getClass(), 0));
            }
            ++i;
        }
        return null;
    }
}

