/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.gui.JargonTreeCellEditor;
import edu.sdsc.grid.gui.JargonTreeCellRenderer;
import edu.sdsc.grid.gui.JargonTreeModel;
import edu.sdsc.grid.gui.QueryPanel;
import edu.sdsc.grid.gui.TransferStatusPanel;
import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class JargonTree
extends JTree
implements ActionListener {
    private JPopupMenu popup = null;
    private MouseListener popupListener;
    private GeneralFile copyBuffer = null;
    private GeneralFile[] roots;
    private MetaDataCondition[] conditions;
    private MetaDataSelect[] selects;

    public JargonTree(GeneralFile root) throws IOException {
        this(root, null, null);
    }

    public JargonTree(GeneralFile[] roots) throws IOException {
        this(roots, null, null);
    }

    public JargonTree(GeneralFile root, MetaDataSelect[] selects) throws IOException {
        this(root, null, selects);
    }

    public JargonTree(GeneralFile[] roots, MetaDataSelect[] selects) throws IOException {
        this(roots, null, selects);
    }

    public JargonTree(GeneralFile root, MetaDataCondition[] conditions, MetaDataSelect[] selects) throws IOException {
        GeneralFile[] roots = new GeneralFile[]{root};
        this.createJargonTree(roots, conditions, selects);
    }

    public JargonTree(GeneralFile[] roots, MetaDataCondition[] conditions, MetaDataSelect[] selects) throws IOException {
        this.createJargonTree(roots, conditions, selects);
    }

    protected void finalize() throws Throwable {
        if (this.popup != null) {
            this.popup = null;
        }
        if (this.popupListener != null) {
            this.popupListener = null;
        }
        if (this.copyBuffer != null) {
            this.copyBuffer = null;
        }
        if (this.roots != null) {
            this.roots = null;
        }
        if (this.selects != null) {
            this.selects = null;
        }
        super.finalize();
    }

    public GeneralFile getRoot(int index) {
        return this.roots[index];
    }

    public GeneralFile[] getRoots() {
        return this.roots;
    }

    public MetaDataSelect[] getSelects() {
        return this.selects;
    }

    private void createJargonTree(GeneralFile[] roots, MetaDataCondition[] conditions, MetaDataSelect[] selects) throws IOException {
        this.roots = roots;
        this.conditions = conditions;
        this.selects = selects;
        this.setModel(new JargonTreeModel(roots, conditions, selects));
        JargonTreeCellRenderer renderer = new JargonTreeCellRenderer();
        this.setCellRenderer(renderer);
        this.setEditable(true);
        this.setCellEditor(new JargonTreeCellEditor());
    }

    public void useDefaultPopupMenu(boolean useDefault) {
        if (!useDefault) {
            this.popup = null;
            if (this.popupListener != null) {
                this.removeMouseListener(this.popupListener);
            }
            return;
        }
        this.popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Refresh");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        this.popup.addSeparator();
        menuItem = new JMenuItem("Query");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        this.popup.addSeparator();
        menuItem = new JMenuItem("Copy");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        menuItem = new JMenuItem("Paste");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        menuItem = new JMenuItem("Delete");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        this.popupListener = new PopupListener();
        this.addMouseListener(this.popupListener);
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        try {
            GeneralFile target = (GeneralFile)this.getLastSelectedPathComponent();
            if (actionCommand.equals("Refresh")) {
                this.refresh(this.getSelectionPath());
            } else if (actionCommand.equals("Query")) {
                if (target == null) {
                    JFrame queryFrame = new JFrame("Query");
                    queryFrame.getContentPane().add(new QueryPanel(this.roots[0].getFileSystem()));
                    queryFrame.pack();
                    queryFrame.show();
                    queryFrame.validate();
                } else {
                    JFrame queryFrame = new JFrame("Query");
                    queryFrame.getContentPane().add(new QueryPanel(target));
                    queryFrame.pack();
                    queryFrame.show();
                    queryFrame.validate();
                }
            } else if (actionCommand.equals("Copy")) {
                if (target != null) {
                    this.copyBuffer = target;
                }
            } else if (actionCommand.equals("Paste")) {
                if (this.copyBuffer == null || target == null) {
                    return;
                }
                TransferStatusPanel transfer = null;
                if (target.isDirectory() && this.copyBuffer.isFile()) {
                    transfer = new TransferStatusPanel(this.copyBuffer, FileFactory.newFile(target, this.copyBuffer.getName()));
                    transfer.setOverwrite(2);
                    JFrame frame = new JFrame();
                    frame.getContentPane().add(transfer);
                    frame.pack();
                    frame.show();
                    transfer.start();
                } else {
                    transfer = new TransferStatusPanel(this.copyBuffer, target);
                    transfer.setOverwrite(2);
                    JFrame frame = new JFrame();
                    frame.getContentPane().add(transfer);
                    frame.pack();
                    frame.show();
                    transfer.start();
                }
                this.refresh(this.getSelectionPath());
            } else if (actionCommand.equals("Delete") && target != null) {
                target.delete();
                this.refresh(this.getSelectionPath().getParentPath());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void refresh(TreePath path) throws IOException {
        if (path == null) {
            this.setSelectionRow(0);
            this.setModel(new JargonTreeModel(this.roots, this.selects));
            return;
        }
        if (((GeneralFile)path.getLastPathComponent()).isFile()) {
            path = path.getParentPath();
        }
        this.setSelectionRow(0);
        this.setModel(new JargonTreeModel(this.roots, this.selects));
        this.expandPath(path);
    }

    private JargonTree(String[] args, MetaDataSelect[] selects) throws URISyntaxException, IOException {
        MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("size", 2, 2000)};
        if (selects == null) {
            String[] selectFieldNames = new String[]{"file comments", "size", "access constraint", "user name", "definable metadata for files"};
            selects = MetaDataSet.newSelection(selectFieldNames);
        }
        if (args.length < 1) {
            SRBFileSystem fs = new SRBFileSystem();
            GeneralFile[] roots = new GeneralFile[]{FileFactory.newFile(new URI("file:///")), FileFactory.newFile(fs, "/"), FileFactory.newFile(fs, fs.getHomeDirectory())};
            this.createJargonTree(roots, null, selects);
        } else {
            GeneralFile[] roots = new GeneralFile[args.length];
            int i = 0;
            while (i < args.length) {
                roots[i] = FileFactory.newFile(new URI(args[i]));
                ++i;
            }
            this.createJargonTree(roots, null, selects);
        }
        this.useDefaultPopupMenu(true);
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame("JargonTree");
            JargonTree tree = new JargonTree(args, null);
            JScrollPane pane = new JScrollPane(tree);
            pane.setPreferredSize(new Dimension(800, 600));
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            frame.getContentPane().add((Component)pane, "North");
            frame.pack();
            frame.show();
            frame.validate();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println(((SRBException)e).getStandardMessage());
        }
    }

    private class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.triggerPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.triggerPopup(e);
        }

        private void triggerPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (JargonTree.this.getLastSelectedPathComponent() == null) {
                    return;
                }
                JargonTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

