/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.gui.SelectionChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

class ClausesPanel
extends JPanel
implements ActionListener {
    public static String ADD_BUTTON_TEXT = "+";
    public static String REMOVE_BUTTON_TEXT = "-";
    private Vector clauses;
    private JLabel queryLabel;
    private JButton addButton;
    private JButton removeButton;
    private JPanel labelPanel;
    private JPanel finishedComponents;
    private JScrollPane pane;
    private JScrollBar horizontalBar;
    private JScrollBar verticalBar;
    private SelectionChooser display;
    private GridBagConstraints gridBagConstraints;
    private int itemsInRow = 0;
    private int widthOfRow = 3;
    JComponent component = null;

    public ClausesPanel(SelectionChooser display, String label) {
        this.display = display;
        this.queryLabel = new JLabel(label);
        this.addButton = new JButton(ADD_BUTTON_TEXT);
        this.removeButton = new JButton(REMOVE_BUTTON_TEXT);
        this.init();
    }

    protected void finalize() throws Throwable {
        if (this.clauses != null) {
            this.clauses = null;
        }
        if (this.queryLabel != null) {
            this.queryLabel = null;
        }
        if (this.addButton != null) {
            this.addButton = null;
        }
        if (this.removeButton != null) {
            this.removeButton = null;
        }
        if (this.finishedComponents != null) {
            this.finishedComponents = null;
        }
        if (this.display != null) {
            this.display = null;
        }
        super.finalize();
    }

    protected void init() {
        this.clauses = new Vector();
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridwidth = 0;
        this.gridBagConstraints.anchor = 17;
        this.setBackground(new Color(0, 0, 0, 0));
        this.setLayout(new GridBagLayout());
        this.queryLabel.setHorizontalAlignment(2);
        this.queryLabel.setToolTipText("Search conditions of the query should be based on the following items");
        this.queryLabel.setVerticalAlignment(1);
        this.display.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.finishedComponents = new JPanel();
        this.finishedComponents.setBackground(Color.WHITE);
        this.finishedComponents.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.finishedComponents.setLayout(new GridBagLayout());
        this.finishedComponents.setMinimumSize(new Dimension(100, 25));
        this.removeButton.setVerticalAlignment(1);
        this.removeButton.setMargin(new Insets(0, 0, 0, 0));
        this.removeButton.setMaximumSize(new Dimension(20, 20));
        this.removeButton.setMinimumSize(new Dimension(20, 20));
        this.removeButton.setPreferredSize(new Dimension(20, 20));
        this.removeButton.addActionListener(this);
        this.labelPanel = new JPanel();
        this.labelPanel.setBackground(Color.WHITE);
        this.labelPanel.setMinimumSize(new Dimension(100, 1));
        this.labelPanel.add(this.queryLabel);
        this.labelPanel.add(this.finishedComponents);
        this.labelPanel.add((Component)this.removeButton, this.gridBagConstraints);
        this.add((Component)this.labelPanel, this.gridBagConstraints);
        this.add(this.display);
        this.addButton.setVerticalAlignment(1);
        this.addButton.setMargin(new Insets(0, 0, 0, 0));
        this.addButton.setMaximumSize(new Dimension(20, 20));
        this.addButton.setMinimumSize(new Dimension(20, 20));
        this.addButton.setPreferredSize(new Dimension(20, 20));
        this.addButton.addActionListener(this);
        this.add((Component)this.addButton, this.gridBagConstraints);
        JPanel spacer = new JPanel();
        spacer.setMinimumSize(new Dimension(1, 24));
        spacer.setBorder(new EmptyBorder(0, 0, 0, 0));
        spacer.setBackground(new Color(0, 0, 0, 0));
        this.add((Component)spacer, this.gridBagConstraints);
    }

    Object[] getClauses() {
        if (this.clauses != null) {
            return this.clauses.toArray();
        }
        return null;
    }

    Object[] getClauses(Object[] type) {
        if (this.clauses != null) {
            return this.clauses.toArray(type);
        }
        return null;
    }

    private void addClause() {
        this.clauses.add(this.display.getClause());
        if (this.itemsInRow % this.widthOfRow == 2) {
            this.finishedComponents.add((Component)new JLabel(String.valueOf(this.display.getClause().toString()) + ","), this.gridBagConstraints);
        } else {
            this.finishedComponents.add(new JLabel(String.valueOf(this.display.getClause().toString()) + ", "));
        }
        ++this.itemsInRow;
        this.component.validate();
        this.component.repaint();
    }

    void addClauses(Object[] addClauses) {
        int i = 0;
        while (i < addClauses.length) {
            if (addClauses[i] != null) {
                this.clauses.add(addClauses[i]);
                if (this.itemsInRow % this.widthOfRow == 2) {
                    this.finishedComponents.add((Component)new JLabel(String.valueOf(addClauses[i].toString()) + ","), this.gridBagConstraints);
                } else {
                    this.finishedComponents.add(new JLabel(String.valueOf(addClauses[i].toString()) + ", "));
                }
                ++this.itemsInRow;
            }
            ++i;
        }
        this.display.validate();
        this.display.repaint();
        this.finishedComponents.validate();
        this.finishedComponents.repaint();
        this.validate();
        this.repaint();
    }

    private void removeClause() {
        int lastIndex = this.finishedComponents.getComponentCount() - 1;
        if (lastIndex >= 0) {
            this.finishedComponents.remove(lastIndex);
            this.clauses.remove(this.clauses.size() - 1);
            this.component.validate();
            this.component.repaint();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.addButton.getText().equals(e.getActionCommand())) {
            this.addClause();
        }
        if (this.removeButton.getText().equals(e.getActionCommand())) {
            this.removeClause();
        }
    }

    void setContainer(JComponent component) {
        this.component = component;
    }
}

