/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util.beans.xml;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.XMLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import uk.ac.gda.util.beans.xml.URLResolver;
import uk.ac.gda.util.beans.xml.XMLHelpersException;
import uk.ac.gda.util.beans.xml.XMLHelpersXMLValidationError;
import uk.ac.gda.util.beans.xml.XMLObjectConfigFileValidator;

public class XMLHelpers {
    private static final Logger logger = LoggerFactory.getLogger(XMLHelpers.class);
    private static URLResolver urlResolver;
    private static Map<UrlClassLoaderPair, XMLContext> xmlContextCache;

    static {
        xmlContextCache = new HashMap<UrlClassLoaderPair, XMLContext>();
    }

    private static XMLContext createXMLContext(URL uRL, ClassLoader classLoader) throws MappingException, IOException {
        XMLContext xMLContext;
        if (uRL == null || classLoader == null) {
            throw new NullPointerException();
        }
        UrlClassLoaderPair urlClassLoaderPair = new UrlClassLoaderPair(uRL, classLoader);
        if (xmlContextCache.containsKey(urlClassLoaderPair)) {
            xMLContext = xmlContextCache.get(urlClassLoaderPair);
        } else {
            Mapping mapping = new Mapping(classLoader);
            mapping.loadMapping(uRL);
            xMLContext = new XMLContext();
            xMLContext.addMapping(mapping);
            xMLContext.setProperty("org.exolab.castor.indent", (Object)"true");
            xmlContextCache.put(urlClassLoaderPair, xMLContext);
        }
        return xMLContext;
    }

    public static Object createFromXML(URL uRL, Class<? extends Object> clazz, URL uRL2, InputStream inputStream) throws Exception {
        return XMLHelpers.createFromXML(uRL, clazz, uRL2, new InputSource(inputStream));
    }

    public static Object createFromXML(URL uRL, Class<? extends Object> clazz, URL uRL2, String string) throws Exception {
        return XMLHelpers.createFromXML(uRL, clazz, uRL2, string, true);
    }

    public static Object createFromXML(URL uRL, Class<? extends Object> clazz, URL uRL2, InputSource inputSource) throws Exception {
        return XMLHelpers.createFromXMLInternal(uRL, clazz, uRL2, inputSource, true);
    }

    public static Object createFromXML(URL uRL, Class<? extends Object> clazz, URL uRL2, InputSource inputSource, boolean bl) throws Exception {
        return XMLHelpers.createFromXMLInternal(uRL, clazz, uRL2, inputSource, bl);
    }

    public static Object createFromXML(URL uRL, Class<? extends Object> clazz, URL uRL2, File file) throws Exception {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            Object object = XMLHelpers.createFromXMLInternal(uRL, clazz, uRL2, new InputSource(fileReader), true);
            return object;
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
        }
    }

    public static Object createFromXML(URL uRL, Class<? extends Object> clazz, URL uRL2, String string, boolean bl) throws Exception {
        URI uRI = new URI(string);
        InputSource inputSource = uRI.getScheme() != null && (uRI.getScheme().equals("http") || uRI.getScheme().equals("file")) ? new InputSource(uRI.toURL().openStream()) : new InputSource(new FileReader(string));
        return XMLHelpers.createFromXMLInternal(uRL, clazz, uRL2, inputSource, bl);
    }

    public static void setFromXML(Object object, URL uRL, URL uRL2, String string) throws Exception {
        Object object2;
        if (urlResolver != null) {
            uRL = urlResolver.resolve(uRL);
            uRL2 = urlResolver.resolve(uRL2);
        }
        InputSource inputSource = null;
        if (uRL2 != null && (inputSource = ((XMLObjectConfigFileValidator)(object2 = new XMLObjectConfigFileValidator())).validateSource(uRL2.toString(), string.toCharArray(), true)) == null) {
            throw new XMLHelpersXMLValidationError();
        }
        try {
            object2 = object.getClass().getMethod("clear", new Class[0]);
            ((Method)object2).invoke(object, new Object[0]);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new XMLHelpersException("Internal Error: All beans used with XMLHelpers must define a clear() method to release resources - " + object.getClass().getName());
        }
        object2 = XMLHelpers.createXMLContext(uRL, object.getClass().getClassLoader()).createUnmarshaller();
        object2.setClass(object.getClass());
        object2.setObject(object);
        object2.unmarshal(inputSource);
    }

    private static Object createFromXMLInternal(URL uRL, Class<? extends Object> clazz, URL uRL2, InputSource inputSource, boolean bl) throws Exception {
        Object object;
        if (urlResolver != null) {
            uRL = urlResolver.resolve(uRL);
            uRL2 = urlResolver.resolve(uRL2);
        }
        if (bl && uRL2 != null && (inputSource = ((XMLObjectConfigFileValidator)(object = new XMLObjectConfigFileValidator())).validateSource(uRL2.toString(), inputSource, true)) == null) {
            throw new XMLHelpersXMLValidationError();
        }
        object = null;
        if (uRL != null) {
            Unmarshaller unmarshaller = XMLHelpers.createXMLContext(uRL, clazz.getClassLoader()).createUnmarshaller();
            unmarshaller.setClass(clazz);
            object = unmarshaller.unmarshal(inputSource);
        } else {
            object = Unmarshaller.unmarshal(clazz, (InputSource)inputSource);
        }
        if (!object.getClass().equals(clazz)) {
            throw new XMLHelpersException("Class created is incorrect = " + object.getClass().getName());
        }
        return object;
    }

    public static void writeToXML(URL uRL, Object object, File file) throws Exception {
        FileWriter fileWriter = new FileWriter(file);
        XMLHelpers.writeToXMLInternal(uRL, object, fileWriter);
    }

    public static void writeToXML(URL uRL, Object object, String string) throws Exception {
        if (string.startsWith("file:")) {
            string = string.substring(5);
        }
        FileWriter fileWriter = new FileWriter(string);
        XMLHelpers.writeToXMLInternal(uRL, object, fileWriter);
    }

    public static void writeToXML(URL uRL, Object object, StringWriter stringWriter) throws Exception {
        XMLHelpers.writeToXMLInternal(uRL, object, stringWriter);
    }

    private static void writeToXMLInternal(URL uRL, Object object, Writer writer) throws Exception {
        try {
            if (urlResolver != null) {
                uRL = urlResolver.resolve(uRL);
            }
            if (uRL != null) {
                XMLContext xMLContext = XMLHelpers.createXMLContext(uRL, object.getClass().getClassLoader());
                Marshaller marshaller = xMLContext.createMarshaller();
                marshaller.setWriter(writer);
                marshaller.marshal(object);
            } else {
                Marshaller.marshal((Object)object, (Writer)writer);
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static Object readBean(File file, Class<?> clazz) throws Exception {
        URL uRL = null;
        URL uRL2 = null;
        Field[] fieldArray = clazz.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            if (fieldArray[n].getName().equalsIgnoreCase("mappingurl")) {
                uRL = (URL)fieldArray[n].get(null);
            } else if (fieldArray[n].getName().equalsIgnoreCase("schemaurl")) {
                uRL2 = (URL)fieldArray[n].get(null);
            }
            ++n;
        }
        return XMLHelpers.createFromXML(uRL, clazz, uRL2, file);
    }

    public static URLResolver getUrlResolver() {
        return urlResolver;
    }

    public static void setUrlResolver(URLResolver uRLResolver) {
        urlResolver = uRLResolver;
    }

    private static class UrlClassLoaderPair {
        private URL mappingURL;
        private ClassLoader cl;

        public UrlClassLoaderPair(URL uRL, ClassLoader classLoader) {
            this.mappingURL = uRL;
            this.cl = classLoader;
        }

        private boolean equalsHelper(Object object, Object object2) {
            if (object == object2) {
                return true;
            }
            if (object == null || object2 == null) {
                return false;
            }
            return object.equals(object2);
        }

        public boolean equals(Object object) {
            if (!(object instanceof UrlClassLoaderPair)) {
                return false;
            }
            UrlClassLoaderPair urlClassLoaderPair = (UrlClassLoaderPair)object;
            if (!this.equalsHelper(this.mappingURL, urlClassLoaderPair.mappingURL)) {
                return false;
            }
            return this.equalsHelper(this.cl, urlClassLoaderPair.cl);
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.mappingURL == null ? 0 : this.mappingURL.hashCode());
            n = 31 * n + (this.cl == null ? 0 : this.cl.hashCode());
            return n;
        }
    }
}

