/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.jython;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.ac.gda.jython.AbstractExtendedCommand;
import uk.ac.gda.jython.ExtendedCommand;
import uk.ac.gda.jython.commands.AliasCommand;
import uk.ac.gda.jython.commands.GenericExtendedCommand;
import uk.ac.gda.jython.commands.PosCommand;
import uk.ac.gda.jython.commands.ScanCommand;

public class ExtendedJythonSyntax {
    public static final List<ExtendedCommand> COMMANDS;

    static {
        ArrayList<AbstractExtendedCommand> arrayList = new ArrayList<AbstractExtendedCommand>(3);
        arrayList.add(new PosCommand());
        arrayList.add(new AliasCommand());
        arrayList.add(new ScanCommand());
        COMMANDS = Collections.unmodifiableList(arrayList);
    }

    public static boolean isCommand(String string, List<String> list) {
        for (ExtendedCommand extendedCommand : COMMANDS) {
            if (!extendedCommand.matches(string)) continue;
            return true;
        }
        return GenericExtendedCommand.matches(string, list);
    }

    public static String getCorrectionMessage(String string, List<String> list) {
        String string2 = null;
        for (ExtendedCommand extendedCommand : COMMANDS) {
            if (!extendedCommand.matches(string)) continue;
            string2 = extendedCommand.getCorrectionMessage();
        }
        if (GenericExtendedCommand.matches(string, list)) {
            string2 = GenericExtendedCommand.getCorrectionMessage(string, list);
        }
        if (string2 == null) {
            return null;
        }
        return String.valueOf(string2) + " Please right click and choose quick fix (in Problems view).";
    }

    public static String getResolution(String string, List<String> list) {
        for (ExtendedCommand extendedCommand : COMMANDS) {
            if (!extendedCommand.matches(string)) continue;
            return extendedCommand.getResolution();
        }
        if (GenericExtendedCommand.matches(string, list)) {
            return GenericExtendedCommand.getResolution(string, list);
        }
        return null;
    }
}

