/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.doe;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.ac.gda.doe.FieldValue;

public class RangeInfo
implements Serializable {
    private List<FieldValue> experiments = new ArrayList<FieldValue>(7);

    public void clear() {
        this.experiments.clear();
    }

    public List<FieldValue> getExperiments() {
        return this.experiments;
    }

    public void setExperiments(List<FieldValue> list) {
        if (list == null) {
            this.experiments.clear();
            return;
        }
        this.experiments = list;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.experiments == null ? 0 : this.experiments.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RangeInfo rangeInfo = (RangeInfo)object;
        return !(this.experiments == null ? rangeInfo.experiments != null : !this.experiments.equals(rangeInfo.experiments));
    }

    public void set(FieldValue fieldValue) {
        int n = this.experiments.indexOf(fieldValue);
        if (n > -1) {
            this.experiments.set(n, fieldValue);
            return;
        }
        this.experiments.add(fieldValue);
    }

    public static String format(List<RangeInfo> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(list.get(0).getHeader());
        stringBuilder.append("\n");
        for (RangeInfo rangeInfo : list) {
            stringBuilder.append(rangeInfo.getValues());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String getHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        for (FieldValue fieldValue : this.getExperiments()) {
            stringBuilder.append(fieldValue.getName());
            stringBuilder.append("\t");
        }
        return stringBuilder.toString();
    }

    public String getValues() {
        StringBuilder stringBuilder = new StringBuilder();
        for (FieldValue fieldValue : this.getExperiments()) {
            stringBuilder.append(fieldValue.getValue());
            stringBuilder.append("\t");
        }
        return stringBuilder.toString();
    }

    public boolean isEmpty() {
        return this.experiments.isEmpty();
    }

    public Map<String, Class<?>> getColumnClasses() {
        LinkedHashMap linkedHashMap = new LinkedHashMap(31);
        for (FieldValue fieldValue : this.experiments) {
            linkedHashMap.put(fieldValue.getName(), fieldValue.getOriginalObject().getClass());
        }
        return linkedHashMap;
    }

    public String getColumnValue(String string) {
        if (this.experiments.isEmpty()) {
            return null;
        }
        if (string == null) {
            return null;
        }
        for (FieldValue fieldValue : this.experiments) {
            if (!string.equals(fieldValue.getName())) continue;
            return fieldValue.getValue();
        }
        return null;
    }
}

