/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.beans.validation;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.nfunk.jep.JEP;
import uk.ac.gda.beans.validation.InvalidBeanException;
import uk.ac.gda.beans.validation.InvalidBeanMessage;
import uk.ac.gda.beans.validation.ValidationBean;
import uk.ac.gda.doe.DOEUtils;

public abstract class AbstractValidator {
    protected ValidationBean bean;
    protected JEP jepParser;

    public static AbstractValidator getDefaultValidator() {
        return new AbstractValidator(){

            @Override
            public void validate(ValidationBean validationBean) throws InvalidBeanException {
            }
        };
    }

    public abstract void validate(ValidationBean var1) throws InvalidBeanException;

    public void validate(Object object) throws Exception {
        String string = object.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        Method method = this.getClass().getDeclaredMethod("validate" + string2, object.getClass());
        method.setAccessible(true);
        List list = (List)method.invoke((Object)this, object);
        if (!list.isEmpty()) {
            throw new InvalidBeanException(list);
        }
    }

    protected InvalidBeanMessage checkBounds(String string, Number number, Number number2, Number number3, List<InvalidBeanMessage> list, String ... stringArray) {
        if (number == null) {
            return null;
        }
        if (number2 != null && !Double.isNaN(number2.doubleValue()) && number.doubleValue() < number2.doubleValue()) {
            InvalidBeanMessage invalidBeanMessage = new InvalidBeanMessage("'" + string + "' is smaller than the lower bound of '" + number2 + "'", stringArray);
            invalidBeanMessage.setLabel(string);
            list.add(invalidBeanMessage);
            return invalidBeanMessage;
        }
        if (number3 != null && !Double.isNaN(number3.doubleValue()) && number.doubleValue() > number3.doubleValue()) {
            InvalidBeanMessage invalidBeanMessage = new InvalidBeanMessage("'" + string + "' is larger than the upper bound of '" + number3 + "'", stringArray);
            invalidBeanMessage.setLabel(string);
            list.add(invalidBeanMessage);
            return invalidBeanMessage;
        }
        return null;
    }

    protected void checkRangeBounds(String string, String string2, double d, double d2, List<InvalidBeanMessage> list, String string3) {
        List<? extends Number> list2 = DOEUtils.expand(string2);
        for (Number number : list2) {
            this.checkBounds(string, number, d, d2, list, string3);
        }
    }

    protected InvalidBeanMessage checkNotNull(String string, String string2, List<InvalidBeanMessage> list, String ... stringArray) {
        if (string2 == null || "".equals(string2)) {
            InvalidBeanMessage invalidBeanMessage = new InvalidBeanMessage("'" + string + "' has not been set", stringArray);
            invalidBeanMessage.setLabel(string);
            list.add(invalidBeanMessage);
            return invalidBeanMessage;
        }
        return null;
    }

    protected InvalidBeanMessage checkValue(String string, String string2, String[] stringArray, List<InvalidBeanMessage> list, String ... stringArray2) {
        if (string2 == null) {
            InvalidBeanMessage invalidBeanMessage = new InvalidBeanMessage("The " + string + " has no value and this is not allowed.", stringArray2);
            invalidBeanMessage.setLabel(string);
            list.add(invalidBeanMessage);
            return invalidBeanMessage;
        }
        if (!Arrays.asList(stringArray).contains(string2)) {
            InvalidBeanMessage invalidBeanMessage = new InvalidBeanMessage("The " + string + " of '" + string2 + "' is not allowed. The valid choices are:\n" + Arrays.asList(stringArray).toString() + ".", stringArray2);
            invalidBeanMessage.setLabel(string);
            list.add(invalidBeanMessage);
            return invalidBeanMessage;
        }
        return null;
    }

    protected InvalidBeanMessage checkFileExists(String string, String string2, String string3, List<InvalidBeanMessage> list, String ... stringArray) {
        if (!new File(String.valueOf(string2) + "/" + string3).exists()) {
            InvalidBeanMessage invalidBeanMessage = new InvalidBeanMessage("The " + string + " of '" + string2 + "' is not existing.", stringArray);
            invalidBeanMessage.setLabel(string);
            list.add(invalidBeanMessage);
            return invalidBeanMessage;
        }
        return null;
    }

    protected InvalidBeanMessage checkRegExp(String string, String string2, String string3, List<InvalidBeanMessage> list, String ... stringArray) {
        if (string2 == null) {
            InvalidBeanMessage invalidBeanMessage = new InvalidBeanMessage("The " + string + " has no value and this is not allowed.", stringArray);
            invalidBeanMessage.setLabel(string);
            list.add(invalidBeanMessage);
            return invalidBeanMessage;
        }
        if (!string2.matches(string3)) {
            InvalidBeanMessage invalidBeanMessage = new InvalidBeanMessage("The " + string + " of '" + string2 + "' is not allowed.", stringArray);
            invalidBeanMessage.setLabel(string);
            list.add(invalidBeanMessage);
            return invalidBeanMessage;
        }
        return null;
    }

    protected InvalidBeanMessage checkExpressionSyntax(String string, String string2, List<InvalidBeanMessage> list, String ... stringArray) {
        if (string2 == null) {
            InvalidBeanMessage invalidBeanMessage = new InvalidBeanMessage("The " + string + " has no value and this is not allowed.", stringArray);
            invalidBeanMessage.setLabel(string);
            list.add(invalidBeanMessage);
            return invalidBeanMessage;
        }
        if (this.jepParser == null) {
            this.jepParser = new JEP();
            this.jepParser.addStandardFunctions();
            this.jepParser.addStandardConstants();
            this.jepParser.setAllowUndeclared(true);
            this.jepParser.setImplicitMul(true);
        }
        try {
            this.jepParser.parse(string2);
        }
        catch (Throwable throwable) {
            InvalidBeanMessage invalidBeanMessage = new InvalidBeanMessage("The " + string + " of '" + string2 + "' is not allowed.", stringArray);
            invalidBeanMessage.setLabel(string);
            list.add(invalidBeanMessage);
            return invalidBeanMessage;
        }
        return null;
    }

    protected void setFileName(List<InvalidBeanMessage> list, String string) {
        if (list == null) {
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        if (string == null) {
            return;
        }
        for (InvalidBeanMessage invalidBeanMessage : list) {
            invalidBeanMessage.setFileName(string);
        }
    }
}

