/*
 * Decompiled with CFR 0.152.
 */
package gda.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import org.junit.Assume;

public class TestUtils {
    public static final String OUTPUT_FOLDER_PREFIX = "test-scratch/";

    public static void skipTestIf(boolean bl, String string) {
        if (bl) {
            System.out.println("JUnit test skipped: " + string);
            Assume.assumeTrue((boolean)false);
        }
    }

    public static void skipTest(String string) {
        System.out.println("JUnit test skipped: " + string);
        Assume.assumeTrue((boolean)false);
    }

    public static String generateDirectorynameFromClassname(String string) {
        return OUTPUT_FOLDER_PREFIX + string.replace('.', '/') + '/';
    }

    static boolean deleteDir(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            String[] stringArray;
            String[] stringArray2 = stringArray = file.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                boolean bl = TestUtils.deleteDir(new File(file, string));
                if (!bl) {
                    System.out.println("1. deleteDir could not delete: " + new File(file, string));
                    return false;
                }
                ++n2;
            }
        }
        if (file.delete()) {
            return true;
        }
        System.out.println("2. deleteDir could not delete: " + file + ". Make sure each test creates a uniquely named folder. Otherwise stale NFS locks may prevent folder deletion.");
        return false;
    }

    public static File createClassScratchDirectory(Class<?> clazz) {
        File file = new File(TestUtils.generateDirectorynameFromClassname(clazz.getCanonicalName()));
        file.mkdirs();
        return file;
    }

    public static void makeScratchDirectory(String string) throws Exception {
        if (!TestUtils.deleteDir(new File(string))) {
            throw new Exception("Unable to delete old test scratch directory " + string);
        }
        if (!new File(string).mkdirs()) {
            throw new Exception("Unable to create new test scratch directory " + string);
        }
    }

    public static File getResourceAsFile(Class<?> clazz, String string) throws FileNotFoundException {
        URL uRL = clazz.getResource(string);
        if (uRL == null) {
            throw new FileNotFoundException(String.valueOf(string) + " (resource not found)");
        }
        return new File(uRL.getFile());
    }

    public static String setUpTest(Class<?> clazz, String string, boolean bl) throws Exception {
        String string2 = clazz.getCanonicalName();
        if (string2 == null) {
            throw new IllegalArgumentException("getCanonicalName failed for class " + clazz.toString());
        }
        String string3 = String.valueOf(TestUtils.generateDirectorynameFromClassname(clazz.getCanonicalName())) + string;
        if (bl) {
            TestUtils.makeScratchDirectory(string3);
        }
        return string3;
    }

    public static String getGDALargeTestFilesLocation() {
        return System.getProperty("GDALargeTestFilesLocation");
    }
}

