/*
 * Decompiled with CFR 0.152.
 */
package gda.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.junit.Test;
import uk.ac.gda.util.CorrectionUtils;
import uk.ac.gda.util.PackageUtils;
import uk.ac.gda.util.number.DoubleUtils;

public class CorrectionTest {
    @Test
    public void testCorrectionFactorCalculation() throws Exception {
        File file = new File(String.valueOf(PackageUtils.getTestPath(this.getClass(), "test")) + "43490.dat");
        File file2 = new File(String.valueOf(PackageUtils.getTestPath(this.getClass(), "test")) + "43490_corr.dat");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        BufferedReader bufferedReader2 = new BufferedReader(new FileReader(file2));
        double[] dArray = new double[]{1.1029752060937018E-7, 1.1407794527246737E-7, 1.1465765791909203E-7, 1.0675602460939456E-7};
        try {
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                double d;
                String[] stringArray = string.split(" ");
                if (stringArray.length != 19) {
                    throw new Exception("Expected 19 columns in the data!");
                }
                double[] dArray2 = new double[4];
                int n = 0;
                while (n < dArray2.length) {
                    double d2 = Double.parseDouble(stringArray[11 + n]);
                    d = Double.parseDouble(stringArray[15 + n]);
                    dArray2[n] = CorrectionUtils.getK(dArray[n], d2, d);
                    ++n;
                }
                String string2 = bufferedReader2.readLine();
                String[] stringArray2 = string2.split(" ");
                int n2 = 0;
                while (n2 < dArray2.length) {
                    d = Double.parseDouble(stringArray[6 + n2]);
                    if (DoubleUtils.equalsWithinTolerance(d * dArray2[n2], Double.parseDouble(stringArray2[6 + n2]), 1.0E-4)) {
                        throw new Exception("The correction factor '" + dArray2[n2] + "' when applied to '" + d + "' gives '" + d * dArray2[n2] + "' not '" + Double.parseDouble(stringArray2[6 + n2]) + "'");
                    }
                    ++n2;
                }
            }
        }
        finally {
            bufferedReader.close();
            bufferedReader2.close();
        }
    }
}

