/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.requestreply;

import com.isencia.message.ChannelException;
import com.isencia.message.IMessageListener;
import com.isencia.message.IReceiverChannel;
import com.isencia.message.NoMoreMessagesException;
import com.isencia.message.ReceiverChannel;
import com.isencia.message.requestreply.IMessage;
import com.isencia.message.requestreply.IRequestReplier;
import com.isencia.message.requestreply.ReceiverSenderChannelPair;
import com.isencia.message.requestreply.RequestMessage;
import com.isencia.util.BlockingReaderQueue;
import com.isencia.util.EmptyQueueException;
import com.isencia.util.FIFOQueue;
import com.isencia.util.IQueue;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestReplier
implements IRequestReplier {
    private static final Logger logger = LoggerFactory.getLogger(RequestReplier.class);
    private boolean autoClose = false;
    private Map channels = null;
    private boolean isClosing = false;
    private boolean open = false;
    private Set openChannels = null;
    private BlockingReaderQueue queue = new BlockingReaderQueue((IQueue)new FIFOQueue());
    private RequestListener listener = null;
    private Map responseChannels = null;

    public RequestReplier() {
        this(false);
    }

    public RequestReplier(boolean bl) {
        this.channels = new HashMap();
        this.openChannels = new HashSet();
        this.responseChannels = new HashMap();
        this.autoClose = bl;
        this.listener = new RequestListener();
    }

    @Override
    public boolean hasMessage() {
        return !this.queue.isEmpty();
    }

    @Override
    public IMessage receiveRequest() throws NoMoreMessagesException {
        if (logger.isTraceEnabled()) {
            logger.trace("receiveRequest() - entry");
        }
        if (this.isOpen() || this.hasMessage()) {
            Object object = null;
            try {
                object = this.queue.get();
                RequestMessage requestMessage = (RequestMessage)object;
                if (logger.isTraceEnabled()) {
                    logger.trace("receiveRequest() - exit");
                }
                return requestMessage;
            }
            catch (EmptyQueueException emptyQueueException) {
                throw new NoMoreMessagesException(emptyQueueException.toString());
            }
            catch (ClassCastException classCastException) {
                logger.error("Invalid message in queue, dropped " + object, (Throwable)classCastException);
                return this.receiveRequest();
            }
        }
        throw new NoMoreMessagesException("No more messages");
    }

    @Override
    public boolean sendResponse(Object object, Object object2) {
        ReceiverSenderChannelPair receiverSenderChannelPair = (ReceiverSenderChannelPair)this.responseChannels.get(object2);
        if (receiverSenderChannelPair != null && receiverSenderChannelPair.getSenderChannel() != null) {
            try {
                receiverSenderChannelPair.getSenderChannel().sendMessage(object);
                this.responseChannels.remove(object2);
                return true;
            }
            catch (Exception exception) {
                logger.error("", (Throwable)exception);
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChannelPair(ReceiverSenderChannelPair receiverSenderChannelPair) {
        if (logger.isTraceEnabled()) {
            logger.trace("addChannelPair() - entry - channel :" + receiverSenderChannelPair);
        }
        receiverSenderChannelPair.addListener(this.listener);
        Map map = this.channels;
        synchronized (map) {
            this.channels.put(receiverSenderChannelPair.getReceiverChannel(), receiverSenderChannelPair);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("addChannelPair() - exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeChannelPair(ReceiverSenderChannelPair receiverSenderChannelPair) {
        if (logger.isTraceEnabled()) {
            logger.trace("removeChannelPair() - entry - channelPair :" + receiverSenderChannelPair);
        }
        Map map = this.channels;
        synchronized (map) {
            try {
                boolean bl;
                ((ReceiverChannel)receiverSenderChannelPair.getReceiverChannel()).interrupt();
                boolean bl2 = bl = this.channels.remove(receiverSenderChannelPair.getReceiverChannel()) != null;
                if (logger.isTraceEnabled()) {
                    logger.trace("removeChannelPair - exit - result :" + bl);
                }
                receiverSenderChannelPair.removeListener(this.listener);
                return bl;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                logger.error("removeChannelPair()", (Throwable)unsupportedOperationException);
                return false;
            }
        }
    }

    @Override
    public Collection getChannelPairs() {
        return this.channels.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        Map map = this.channels;
        synchronized (map) {
            for (ReceiverSenderChannelPair receiverSenderChannelPair : this.channels.values()) {
                try {
                    receiverSenderChannelPair.open();
                }
                catch (ChannelException channelException) {
                    logger.error("open() - Error opening channelPair " + receiverSenderChannelPair, (Throwable)channelException);
                }
            }
        }
        this.open = true;
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Set set = this.openChannels;
        synchronized (set) {
            return this.open;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        Map map = this.channels;
        synchronized (map) {
            if (this.channels.size() > 0) {
                for (ReceiverSenderChannelPair receiverSenderChannelPair : this.channels.values()) {
                    try {
                        receiverSenderChannelPair.close();
                    }
                    catch (ChannelException channelException) {
                        logger.error("open() - Error closing channelPair " + receiverSenderChannelPair, (Throwable)channelException);
                    }
                }
            } else {
                this.open = false;
            }
        }
        this.isClosing = true;
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    class RequestListener
    implements IMessageListener {
        RequestListener() {
        }

        @Override
        public void acceptMessage(Object object, IReceiverChannel iReceiverChannel) throws InterruptedException, Exception {
            Object v;
            if (logger.isTraceEnabled()) {
                logger.trace("acceptMessage() - entry - Message: " + object + " Source: " + iReceiverChannel);
            }
            if ((v = RequestReplier.this.channels.get(iReceiverChannel)) == null) {
                throw new IllegalArgumentException("Unrecognized source " + iReceiverChannel);
            }
            RequestMessage requestMessage = new RequestMessage(object);
            RequestReplier.this.responseChannels.put(requestMessage.getCorrelationID(), v);
            RequestReplier.this.queue.put((Object)requestMessage);
            if (logger.isTraceEnabled()) {
                logger.trace("acceptMessage() - exit");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sourceOpened(Object object) {
            if (logger.isTraceEnabled()) {
                logger.trace("sourceOpened() - entry - source :" + object);
            }
            Set set = RequestReplier.this.openChannels;
            synchronized (set) {
                RequestReplier.this.openChannels.add(object);
                if (!RequestReplier.this.open) {
                    logger.debug("sourceOpened() - RequestReplier opened");
                }
                RequestReplier.this.open = true;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("sourceOpened() - exit");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sourceClosed(Object object) {
            if (logger.isTraceEnabled()) {
                logger.trace("sourceClosed() - entry - source :" + object);
            }
            Set set = RequestReplier.this.openChannels;
            synchronized (set) {
                RequestReplier.this.openChannels.remove(object);
                RequestReplier.this.open = RequestReplier.this.openChannels.size() > 0 || !RequestReplier.this.autoClose && !RequestReplier.this.isClosing;
            }
            if (!RequestReplier.this.isOpen()) {
                RequestReplier.this.isClosing = false;
                RequestReplier.this.queue.trigger();
                logger.debug("sourceClosed() - RequestReplier closed");
            }
            if (logger.isTraceEnabled()) {
                logger.trace("sourceClosed() - exit - Open = " + RequestReplier.this.open);
            }
        }
    }
}

